/* Tale LP4 VGA Graphics Driver Application Header V1.1
 * Copyright (C) 1994 Tale Software
 * All rights reserved.
 */

/* TGDLP4.H already included? */
#ifndef TGDLP4_H
#define TGDLP4_H

/* define common tgdlp4 data types and structures */
#include "tgdconst.h"

/* define bool values as understood by tale software */
#ifndef BOOL
 #define BOOL
 #define TRUE -1
 #define FALSE 0
#endif

/* Tale LP4 Graphics Driver specific defines following */
/* vgalp4() could return these errors */
#define VL4ERR_NOVGA 1	/* error: no VGA card installed */
#define VL4ERR_LT256 2	/* error: VGA card with less than 256 KB installed */

/* these pens are known to pen(), bltpen() */
#define PEN_B 0	/* background pen */
#define PEN_F 1	/* foreground pen */

/* these blitmodes can be selected with bltmode() */
#define BM_SOLID 0	/* blitmode: SOLID */
#define BM_TRANSPARENT 1 /* blitmode: TRANSPARENT */
#define BM_COLREPLACE 2	/* blitmode: COLOR REPLACE */
/* BM_COLREPLACE|BM_TRANSPARENT is also allowed */

/* these drawmodes can be used with drawmode() */
#define DM_SOLID 0	/* drawmode: SOLID */
#define DM_AND 1	/* drawmode: AND */
#define DM_OR 2		/* drawmode: OR */
#define DM_XOR 3	/* drawmode: XOR */

/* these physical resolutions can be activated with screenmode() */
#define SM_320x200 0
#define SM_320x400 1
#define SM_256x256 2
#define SM_256x512 3

/* these viewmodes can be selected with viewmode() */
#define VM_320x200 0	/*  320x 400 virt. res. */
#define VM_320x400 0	/*  320x 400 virt. res. */
#define VM_256x256 0	/*  256x 512 virt. res. */
#define VM_256x512 0	/*  256x 512 virt. res. */
#define VM_320x800 1	/*  320x 819 virt. res. */
#define VM_256x1024 1	/*  256x1024 virt. res. */
#define VM_640x400 2	/*  648x 404 virt. res. */
#define VM_512x512 2	/*  512x 512 virt. res. */
#define VM_1280x200 3	/* 1304x 200 virt. res. */
#define VM_1024x256 3	/* 1024x 256 virt. res. */

/* maximum number of sprites */
#define MAX_SPRITENO 7

/* tgdsincos returns a pointer to this structure */
typedef struct { word sin,cos; } sincostab;

/* these procedures are currently available */
/* VGA configuration */
ubyte vgalp4(void);
void co80(void);
byte screenmode(ubyte scrnmode);
byte viewmode(ubyte vjumode);
byte uviewmode(uword xsize,uword ysize);
void syncxscroll(byte syncxscr);
byte viewreg(uword x_pos,uword y_pos);
void splitscrn(uword y_pos);
void scrnon(byte screenon);
void drawmode(ubyte drwmode);

/* graphic primitives */
void clearreg(void);
void writepixel(word x_pos,word y_pos);
word readpixel(uword x_pos,uword y_pos);
void line(word x1_pos,word y1_pos,word x2_pos,word y2_pos);
void arc(word x_pos,word y_pos,uword radius_x,uword radius_y,word start_angle,word stop_angle);
void polygrid(uword tab_len,word far *poly_table);
void rectangle(word x1_pos,word y1_pos,word x2_pos,word y2_pos);
void ellipse(word x_pos,word y_pos,uword radius_x,uword radius_y);
void metagon(word x_pos,word y_pos,uword scanlines,word far *meta_table);
void drawpoly(uword tab_len,const word far *poly_table);
void redrawpoly(void);

/* pattern fill */
byte pattern(uword x_pos,uword y_pos,uword x_size,uword y_size);
byte pfill(byte pattenable);

/* bitmaps */
void bltbitmap(word dest_x,word dest_y,uword src_x,uword src_y,uword xsize,uword ysize,bitmap far *yourbitmap);
void getbitmap(word dest_x,word dest_y,uword src_x,uword src_y,uword xsize,uword ysize,bitmap far *yourbitmap);
void bltmode(ubyte blitmode);
void bltpen(ubyte blitpen,ubyte color);
byte vramcopy(uword dest_x,uword dest_y,uword src_x,uword src_y,uword size_x,uword size_y);

/* sprites */
void resetspr(void);
byte addspr(ubyte sprno,uword sprsavex,uword sprsavey,spriteinc far *usersprite);
byte removespr(ubyte sprno);
void onspr(ubyte sprno);
void offspr(ubyte sprno);
void movespr(ubyte sprno,word sprxpos,word sprypos);
void animspr(ubyte sprno,ubyte spranimno);
void refreshspr(void);
udword ucollspr(ubyte sprno);
byte areaoffspr(uword xpos,uword ypos,uword xsize,uword ysize);
void areaonspr(void);

/* text functions */
void txtcrsr(word x_pos,word y_pos);
void prttext(const char far *text);
udword txtwidth(const char far *text);
fontmap far *font(fontmap far *newfont);

/* colors */
void pen(ubyte pen,ubyte color);
void ovscol(ubyte color);
void rgb6(ubyte col_register,ubyte tab_len,const ubyte far *col_table);

/* clipping */
byte drawreg(uword x_pos,uword y_pos,uword x_size,uword y_size);

/* double buffering */
void drawpage(ubyte page);
void viewpage(ubyte page);

/* misc */
void waittof(void);
sincostab far *tgdsincos(word angle);

/* not for public use */
void rawline(word x1_pos,word y1_pos,word x2_pos,word y2_pos);
byte envirq(void (*userproc)(void));
byte disvirq(void);

#endif /* TGDLP4_H */
