{
/**************************************************************************
 *       ESS.PAS                                                          *
 *                                                                        *
 * "ESS" Electronic Scanning Simulator. Uses real-time double-buffered    *
 *  animation for displaying directional radiation patterns for an antenna*
 *  array of equally-spaced elements with uniform amplitude excitation and*
 *  progressive phase. The student could change the progressive phase,    *
 *  speed of phase variation, number of elements in the array, and length *
 *  of the array then observe the effect on the radiation pattern.        *
 *                                                                        *
 *                                                                        *
 *       This program uses the DOUBLE BUFFERING technique for             *
 *       animation. While you are watching the current frame on the       *
 *       VISUAL PAGE, the new frame is actually being drawn on the        *
 *       ACTIVE PAGE. This leads to smoother animations.                  *
 *                                                                        *
 *       You are allowed to use this source code, in part or in whole,    *
 *       But, please, would you kindly remeber to mention me.             *
 *                                                                        *
 *       I hope you benefit from it, and that it opens in front of you a  *
 *       a zillion gates for new creative ideas.                          *
 *                                                                        *
 *       Coded By:                                                        *
 *                  Amr A. Awadallah,            May 1992                 *
 *                  Computer Department,                                  *
 *                  Faculty Of Engineering,                               *
 *                  Cairo University,                                     *
 *                  Egypt.                                                *
 *                  e-mail : "amr@frcu.eun.eg" or "a.awadallah@ieee.org"  *
 *                  phone  : (202) 330-4738                               *
 *                                                                        *
 **************************************************************************/
}

program Radar;

uses
	Crt, Graph;

const
	DEG   = PI/180;
	LEFT  = chr(75);
	UP    = chr(72);
	RIGHT = chr(77);
	DOWN  = chr(80);
	F1    = chr(59);

var
  Gd, Gm                        : Integer;
	MaxX,MaxY                       : integer;
	CenterX,CenterY : integer;
	Xasp, Yasp                      : word;
	Color,BkColor           : word;
	FillColor                               : word;
	page                                            : word;

	ch,cl                           : char;
	t                                               : single;
	x,y                                     : single;
	sx,sy                           : single;
	x1,y1                           : integer;
	i,fs                            : integer;
	N,l,d,speed : single;
	dl, dp                  : single;

function f(x : single) : single;
begin
	if N*sin((2*PI*l*cos(x) - d)/2) = 0 then f := 1
	else f := abs(sin(N*(2*PI*l*cos(x) - d)/2) / (N*sin((2*PI*l*cos(x) - d)/2)));
end;

function Single2Str(L : single) : string;
var
  S : string;
begin
  Str(L, S);
	Single2Str := S;
end;

procedure DrawFrontScreen;
begin
	SetFillStyle(1,RED);
	Bar(0,0,MaxX,MaxY);
	Rectangle(0,0,MaxX,MaxY);
	SetFillStyle(1,GREEN);
	Bar(177,10,470,31);
	Rectangle(177,10,470,31);
	OutTextxy(182,13,'Electronic  Scanning Simulator (ESS)');
	OutTextxy(222,21,'By Amr Awadallah (1992)');

	SetFillStyle(1,BLUE);
	Bar(120,305,510,342);
	Rectangle(120,305,510,342);
	OutTextxy(130,310,'Progressive Phase     = '+Single2Str(d));
	OutTextxy(130,320,'Number of Elements    = '+Single2Str(N));
	OutTextxy(130,330,'Length in WaveLengths = '+Single2Str(l));

	OutTextxy(540,330,'F1 : Help');

end;

procedure Help;
var ch : char;
begin
	page := page xor 1;
	SetActivePage(page);
	SetFillStyle(1,YELLOW);
	SetColor(BLACK);
	Bar(110,120,520,210);
	Rectangle(110,120,520,210);
	OutTextxy(120,130,'Control Pannel :-');
	OutTextxy(120,140,'-----------------');
	OutTextxy(120,150,'  +/- : Change Progressive Phase,');
	OutTextxy(120,160,'  7/8 : Change Speed of Phase Variation,');
	OutTextxy(120,170,'  1/2 : Change Sampling Resolution,');
	OutTextxy(120,180,'  LEFT/RIGHT Arrows : Change Number of Elements,');
	OutTextxy(120,190,'  UP/DOWN Arrows    : Change Length of Array.');
	SetVisualPage(page);
	ch := ReadKey;
	page := page xor 1;
	SetVisualPage(page);
	SetFillStyle(1,RED);
	Bar(110,120,520,210);
	SetColor(WHITE);
end;

begin
	Gd := EGA;
	Gm := EGAHI;
	InitGraph(Gd, Gm,'');
	MaxX := GetMaxX;
	MaxY := GetMaxY;
	GetAspectRatio(Xasp, Yasp);
	CenterX := MaxX shr 1;
	CenterY := MaxY shr 1;

	sx := Xasp/80; sy := Yasp/80;
	page := 0; ch := #0;
	fs := 4;
	N := 5;
	l := 0.5; dl := 0.01;
	d := 0; dp := 2*DEG;
	speed := dp;
	SetVisualPage(1);
	DrawFrontScreen;
	SetVisualPage(0);
	SetActivePage(1);
	DrawFrontScreen;

	repeat
		page := page xor 1;
		SetActivePage(page);
		SetFillStyle(1,0);
		Bar(157,48,481,300);

		SetColor(LIGHTGREEN);
		i := 0;
		x := cos(t)*f(t);
		y := sin(t)*f(t);
		x1 := CenterX + Round(sx * x);
		y1 := CenterY - Round(sy * y);
		MoveTo(x1,y1);
		while i <= 360 do
		begin
			i := i + fs;
			t := i * DEG;
			x := cos(t)*f(t);
			y := sin(t)*f(t);
			x1 := CenterX + Round(sx * x);
			y1 := CenterY - Round(sy * y);
			LineTo(x1,y1);
		end;

		SetColor(WHITE);
		Rectangle(157,48,481,300);
		{Circle(CenterX,CenterY,162);}
		Line(157,172,481,172);
		Line(319,48,319,300);

		SetFillStyle(1,BLUE);
		Bar(322,310,506,337);
		OutTextxy(322,310,Single2Str(d));
		OutTextxy(322,320,Single2Str(N));
		OutTextxy(322,330,Single2Str(l));

		SetVisualPage(page);
		if(keypressed) then
		begin
			ch := ReadKey;
			if( ch = #0) then cl := ReadKey;
			case ch of
				#0 : case cl of
							UP    : l := l + dl;
							DOWN  : l := l - dl;
							RIGHT : N := N + 1;
							LEFT  : N := N - 1;
							F1    : Help;
						end;
				'+' : d := d + dp;
				'-' : d := d - dp;
				'1' : begin fs := fs + 1; if fs > MaxX then fs := MaxX; end;
				'2' : begin fs := fs - 1; if fs < 1 then fs := 1; end;
				'8' : speed := speed + dp;
				'7' : speed := speed - dp;
			end;
		end;
		d := d + speed;
	until ch = chr(27);
	closegraph;
end.
