{
/**************************************************************************
 *       MOVEARC.PAS                                                      *
 *                                                                        *
 *       This program demonstrates the DOUBLE BUFFERING technique for     *
 *       animation. While you are watching the current frame on the       *
 *       VISUAL PAGE, the new frame is actually being drawn on the        *
 *       ACTIVE PAGE. This leads to smoother animations.                  *
 *                                                                        *
 *       Keys Used:                                                       *
 *            ARROW KEYS : ReScale,                                       *
 *            +/-        : Increase/Decrease Frequency,                   *
 *            //*        : Decrease/Increase Number of Sampling points,   *
 *            0/.        : Increase/Decrease Speed of animation.          *
 *                                                                        *
 *       Compile using SMALL MODEL, remember to link to the graphics lib. *
 *       Remeber to put the EGAVGA.BGI driver on the same directory  with *
 *       the .EXE. If you have a math-co, you would better compile with    *
 *       floating point processor library for smoother animations.        *
 *                                                                        *
 *       You are allowed to use this source code, in part or in whole,    *
 *       But, please, would you kindly remeber to mention me.             *
 *                                                                        *
 *       I hope you benefit from it, and that it opens in front of you a  *
 *       a zillion gates for new creative ideas.                          *
 *                                                                        *
 *       Coded By:                                                        *
 *                  Eng. Amr A. Awadallah,       May 1992                 *
 *                  Computer Department,                                  *
 *                  Faculty Of Engineering,                               *
 *                  Cairo University,                                     *
 *                  Egypt.                                                *
 *                  e-mail : "amr@frcu.eun.eg" or "a.awadallah@ieee.org"  *
 *                  phone  : (202) 330-4738                               *
 *                                                                        *
 **************************************************************************/
}

program movearc;

uses
	Crt, Graph;

const
	DEG   = PI/180;
	LEFT  = chr(75);
	UP    = chr(72);
	RIGHT = chr(77);
	DOWN  = chr(80);

var
  Gd, Gm                        : Integer;
	MaxX,MaxY                       : integer;
	CenterX,CenterY : integer;
	Color,BkColor           : word;
	FillColor                               : word;
	page                                            : word;

	ch,cl                           : char;
	t                                               : single;
	x,y                                     : single;
	sx,sy                           : single;
	freq,phase      : single;
	x1,y1                           : integer;
	i,fs                            : integer;
	speed       : single;

function fx(x : single) : single;
begin
	fx := sin(x);
end;

function fy(x : single) : single;
begin
	fy := sin(x);
end;

begin
	Gd := VGA;
	Gm := EGAHI;
	InitGraph(Gd, Gm,'');
	MaxX := GetMaxX;
	MaxY := GetMaxY;
	CenterX := MaxX shr 1;
	CenterY := MaxY shr 1;
	sx := 100; sy := 100;
	freq := 1; phase := 0;
	page := 0; ch := #0;
	fs := 10; speed := 5*DEG;
repeat
	page := page xor 1;
	SetActivePage(page);
	ClearDevice;
	SetColor(LIGHTGREEN);
	i := 0;
	t := i * DEG;
	x := fx(t*freq);
	y := fy(t*freq+phase);
	x1 := CenterX + Round(sx * x);
	y1 := CenterY - Round(sy * y);
	MoveTo(x1,y1);
	while i < 360 do
	begin
		i := i + fs;
		t := i * DEG;
		x := fx(t*freq);
		y := fy(t*freq+phase);
		x1 := CenterX + Round(sx * x);
		y1 := CenterY - Round(sy * y);
		LineTo(x1,y1);
	end;
	SetColor(WHITE);
	Rectangle(0,0,MaxX,MaxY);
	Line(0,CenterY,MaxX,CenterY);
	Line(CenterX,0,CenterX,MaxY);
	Rectangle(332,322,625,343);
	OutTextxy(337,325,'Digital Oscilloscope Simulator (DOS)');
	OutTextxy(377,333,'By Amr Awadallah (1992)');
	SetVisualPage(page);
	if(keypressed) then
	begin
		ch := ReadKey;
		if( ch = #0) then cl := ReadKey;
		case ch of
			#0 : case cl of
						UP    : sy := sy + 5;
						DOWN  : sy := sy - 5;
						RIGHT : sx := sx + 5;
						LEFT  : sx := sx - 5;
					end;
			'+' : freq := freq + 1;
			'-' : begin freq := freq - 1; if freq < 0 then freq := 0; end;
			'/' : begin fs := fs + 1; if fs > MaxX then fs := MaxX; end;
			'*' : begin fs := fs - 1; if fs < 1 then fs := 1; end;
			'0' : speed := speed + 5*DEG;
			'.' : speed := speed - 5*DEG;
		end;
	end;
	phase := phase + speed;
until ch = chr(27);
closegraph;
end.

{ I should try fx(x), fx(x+phase), fx(x*freq) }
