/**************************************************************************
 *       DOS.C                                                            *
 *       Digital Oscilloscope Simulater                                   *
 *                                                                        *
 *       This program demonstrates the DOUBLE BUFFERING technique for     *
 *       animation. While you are watching the current frame on the       *
 *       VISUAL PAGE, the new frame is actually being drawn on the        *
 *       ACTIVE PAGE. This leads to smoother animations.                  *
 *                                                                        *
 *       Keys Used:                                                       *
 *            ARROW KEYS : ReScale,                                       *
 *            +/-        : Increase/Decrease Frequency,                   *
 *            //*        : Decrease/Increase Number of Sampling points,   *
 *            0/.        : Increase/Decrease Speed of animation.          *
 *                                                                        *
 *       Compile using SMALL MODEL, remember to link to the graphics lib. *
 *       Remeber to put the EGAVGA.BGI driver on the same directory  with *
 *       DOS.EXE. If you have a math-co, you would better compile with    *
 *       floating point processor library for smoother animations.        *
 *                                                                        *
 *       You are allowed to use this source code, in part or in whole,    *
 *       But, please, would you kindly remeber to mention me.             *
 *                                                                        *
 *       I hope you benefit from it, and that it opens in front of you a  *
 *       a zillion gates for new creative ideas.                          *
 *                                                                        *
 *       Coded By:                                                        *
 *                  Eng. Amr A. Awadallah,       May 1992                 *
 *                  Computer Department,                                  *
 *                  Faculty Of Engineering,                               *
 *                  Cairo University,                                     *
 *                  Egypt.                                                *
 *                  e-mail : "amr@frcu.eun.eg" or "a.awadallah@ieee.org"  *
 *                  phone  : (202) 330-4738                               *
 *                                                                        *
 **************************************************************************/

#include <math.h>
#include <graphics.h>
#include <conio.h>

#define PI     3.141592654
#define DEG    PI/180
#define LEFT   75
#define UP     72
#define RIGHT  77
#define DOWN   80

inline float fx(float x) // inline used here to cancel Procedure Activation
								 // overhead, to ensure more speed.
{
	return sin(x);  // You could change this to any other function you like.
}

inline float fy(float x)
{
	return sin(x);  // You could change this to any other function you like
}

void main()
{
	int gd,gm;                  // gd = Graphics Driver, gm = Graphics Mode
	int xmax,ymax,cx,cy,x1,y1;  // General Graphics Variables
	unsigned color,bkColor, fillcolor; // General Graphics Variables
	unsigned page;                     // The current page
	int i, fs;                   // Sampling Points varaibles
	double sx,sy;                // Scale
	double freq, phase, speed;   // frequency, phase, speed.
	double t;                    // parametric variable
	double x,y;                  // Floating point co-ordinates
	char ch,cl;                  // User input variables

	// Initializations
	gd = EGA; gm=EGAHI;     // EGA, EGAHI work fine with DOUBLE BUFFERING
	initgraph(&gd,  &gm,"");
	xmax = getmaxx();
	ymax = getmaxy();
	cx = xmax >> 1;
	cy = ymax >> 1;
	sx = 100; sy = 100;
	freq = 1; phase = 0;
	page = 0; ch = 0;
	fs = 10; speed = 5*DEG;

	// MAIN LOOP
	do
	{
		page ^= 1;                  // Flip page ( Page Flipping )
		setactivepage(page);        // Set page to draw in
		cleardevice();              // clear active page
		setcolor(LIGHTGREEN);
		i = 0;
		t = i * DEG;
		x = fx(t);
		y = fy(t*freq+phase);
		x1 = cx + ceil(sx * x);
		y1 = cy - ceil(sy * y);
		moveto(x1,y1);
		while(i < 360)
		{
			i = i + fs;
			t = i * DEG;
			x = fx(t);
			y = fy(t*freq+phase);
			x1 = cx + ceil(sx * x);
			y1 = cy - ceil(sy * y);
			lineto(x1,y1);          // draws a line in the active page
		}

		setcolor(WHITE);
		rectangle(0,0,xmax,ymax);
		line(0,cy,xmax,cy);
		line(cx,0,cx,ymax);

		rectangle(332,322,625,343);
		outtextxy(337,325,"Digital Oscilloscope Simulator (DOS)");
		outtextxy(377,333,"By Amr A. Awadallah (1992)");

		setvisualpage(page);      // show drawn page

		if(kbhit())               // Check if user pressed a key & process
		{
			if( (ch=getch()) == 0) cl = getch();
			switch(ch)
			{
				case 0 : switch(cl)
							{
								case UP    : sy += 5; break;
								case DOWN  : sy -= 5; break;
								case RIGHT : sx += 5; break;
								case LEFT  : sx -= 5; break;
							} break;
				case '+' : freq += 1; break;
				case '-' : if(freq>0) freq -= 1; break;
				case '/' : if(fs <= xmax) fs += 1; break;
				case '*' : if(fs>0) fs -= 1; break;
				case '0' : speed += 5*DEG; break;
				case '.' : speed -= 5*DEG; break;
			}
		}
		phase += speed;
	} while(ch!=27);
	closegraph();
}
