@echo off
goto 00_Start
###############################################################################

TOUR.BAT - demonstrate GREP software with the supplied sample files

To execute this demo, the sample files must be in the current directory.
Usage:
        TOUR
or:
        TOUR filename
If a filename is specified, the tour will run non-interactively and output will
be written to the named file. This is part of the actual regression tests.

The following environment variables get overwritten:
    B32 -- "yes" or "no"
           records whether the 32-bit program is being used in the tour
    G -- name of the program, e.g. "grep16"
    X -- used for scratch work

2001-12-22  author: Stan Brown, Oak Road Systems
2002-01-01  Add /K option demo.
2002-01-21  Add demos for filename globbing and exclusion.
            Change "demo" to "tour" to avoid the misperception that this
            version is "just a demo".
2002-03-27  Add demos for searching by word.

               Copyright 2001-2002   Stan Brown, Oak Road Systems
                           http://oakroadsystems.com
###############################################################################
:00_Start
rem Check whether sufficient environment space is available.
set X=0123456789012345678901234567890123456789012345678901234567890123456789
if "%X%" == "0123456789012345678901234567890123456789012345678901234567890123456789" goto 01_EnvOK
set X=
echo.
echo This tour needs about 70 bytes of free environment space, but less than
echo that is available. Try running it in a secondary shell and specifying
echo environment space, like this:
echo           %%comspec%% /e:8192 /c %0
echo The figure of 8192 is just an example. Use a large enough number, which
echo depends on how much environment space you are already using. If you have a
echo SHELL statement in C:\CONFIG.SYS use that number plus 70 or so; otherwise
echo try /e:1024.
echo.
goto 99_Exit

:01_EnvOK
if "%2" == "" goto 02_ParamsOK
echo.
echo You invoked this batch file with two or more parameters. In normal use it
echo takes no parameters; the only optional parameter is a file name for output.
echo.
goto 99_Exit
:02_ParamsOK

if not "%1" == "" goto 04_32or16
cls
echo Copyright 2001-2002 Stan Brown, Oak Road Systems       http://oakroadsystems.com
echo.
echo                      +============================+
echo                      !  Tour of GREP Release 7.0  !
echo                      +============================+
echo.
echo To run this tour successfully, your current directory should be the directory
echo where you unzipped the GREP download file. For best results, all the unzipped
echo files should be in that directory, and no others.
echo.
echo The DOS program MORE.COM needs to be somewhere in your PATH. If you have a
echo normal DOS or WINDOWS installation, the MORE program is already present in the
echo right place.
echo.
echo The tour can be run with 16-bit or 32-bit GREP. Some features are available in
echo 32-bit GREP but not 16-bit GREP. However, 32-bit GREP requires a command prompt
echo under a version of Windows 95/98/ME/NT/2000/XP while 16-bit GREP will run in
echo any DOS session.
echo.
:04_32or16
set B32=no
choice /cny /n "Do you prefer the 32-bit tour? "
if errorlevel 2 set B32=yes
rem Now check that the executable program is actually available.
set G=grep16
if "%B32%" == "yes" set G=grep32
if exist %G%.exe goto 05_ExeFound
echo.
echo Please run this batch file from the same directory where the '%G%.exe' program
echo exists.
echo.
goto 99_Exit
:05_ExeFound
if "%1" == "" goto 90_Welcome
echo Output of "%0 %1" >%1
echo ====================================================================== >>%1
echo.>>%1
echo. | date >>%1
echo.>>%1
CTTY nul:
%G% -d- >>%1
CTTY con:
echo.>>%1
echo.>>%1
goto 99_BeginDemo
:90_Welcome
cls
echo Welcome to this tour of the GREP shareware program.
echo.
echo Please note: at present this tour focuses on recently added features. Future
echo versions of the tour may be more comprehensive.
echo.
echo NOTE: Every GREP command in this tour uses the /Z option. That's always a good
rem (because TOURSUB.BAT inserts it)
echo idea in a batch file, so that any setting of the environment variable is
echo disregarded and the options in effect are only those on the command line.
echo.
echo Registered users can use the /Q1 option to suppress the program logo. This is
echo especially handy in reducing the volume of output from batch files.
set REG=
choice /n /cny "Are you running a registered copy? "
if errorlevel 2 set REG=/Q1
echo.
:99_BeginDemo
rem Prevent unwanted piping in TOURSUB.BAT
set Y=

rem ============================================================================

if not "%1" == "" goto 501_WordonlyOne
echo.
echo A frequent request is for searching by word. For instance, you want to find
echo all instances of "plain" but not "explain", "plainsong", and so on. This
echo part of the demo shows you how to do it in GREP, and illustrates the new
echo feature of GREP32 release 7.1 that makes it much easier.
echo.
choice /cyn /n "Would you like to see a demo of grepping by word? "
if errorlevel 2 goto 599_WordonlyDone
cls
echo First look at the occurrences of "plain" in GREPUSER.HTM:
:501_WordonlyOne
set X=plain grepu*htm
call toursub long %1
if not "%1" == "" goto 502_WordonlyTwo
echo.
echo As you see, the word "plain" occurs alone and as part of larger words.
echo (Make note of the pseudo-word "plain55", which will be important later.)
echo To find it alone, there are two main methods. The first method is very
echo easy but will work only with 32-bit GREP: use the /E4 option.
if "%B32%" == "no" echo That part of the demo will be skipped because you're running
if "%B32%" == "no" echo 16-bit GREP.
if "%B32%" == "no" pause
if "%B32%" == "no" cls
:502_WordonlyTwo
if "%B32%" == "no" goto 520_Wordonly_FourRegex
set X=%X% /e4
call toursub long %1
if not "%1" == "" goto 503_WordonlyThree
echo.
echo Words like "explain" and "plains" are no longer found. You might be
echo surprised that "plain55" is no longer found. The reason is that not only
echo letters but digits (and the underscore) are considered "word" characters by
echo default. (This matches behavior of the UNIX grep -w option.) You can
echo control this with the /M option. Full details are in the reference manual,
echo but here's an example: use /Mfr,alpha to say that a "word" is any sequence
echo of letters. Then "plain55" will not be a "word" any more:
:503_WordonlyThree
set X=%X% /Mfr,alpha
call toursub long %1
if not "%1" == "" goto 521_WordonlyFour
echo.
echo Now "plain55" is treated as the word "plain" followed by the non-"word"
echo characters "55", so it is reported. You can control the meaning of "word"
echo in 32-bit GREP by using the /M option in this way.
pause
cls
:520_Wordonly_FourRegex
if not "%1" == "" goto 521_WordonlyFour
echo So what if you are running GREP16? In this case you can't use the /E4
echo option, but you can still get the job done. (The following technique works
echo in any current version of GREP.)
echo.
echo Think it out logically: If a word is a sequence of letters, then looking
echo for "plain" as a word means looking for "plain" preceded and followed by a
echo non-letter. In regexes, the character class [^a-zA-Z] represents the non-
echo letters, so our regex for "plain" as a word might be
echo                             [^a-zA-Z]plain[^a-zA-Z]
echo But we have to think a little more. Suppose "plain" is at the start of a
echo line? Then that regex would not make a match, because it calls for a non-
echo letter character before the "p" of "plain". So there is a special case,
echo ^plain[^a-zA-Z]. In the same way, "plain" might occur at the end of a
echo line, so we need to search for [^a-zA-Z]plain$. Finally, "plain" might
echo occur alone on a line, so we also need to search for ^plain$. These four
echo basic regexes together will find all occurrences of "plain" as a word.
echo.
pause
echo.
echo Fortunately, GREP can search for multiple regexes in one pass. So we hand
echo these four regexes to GREP via the /F option:
:521_WordonlyFour
if "%TEMP%" == "" set TEMP=c:
echo [^a-zA-Z]plain[^a-zA-Z]>%TEMP%\greptour
echo ^plain[^a-zA-Z]>>%TEMP%\greptour
echo [^a-zA-Z]plain$>>%TEMP%\greptour
echo ^plain$>>%TEMP%\greptour
set X=/Z%REG% /F- grepu*htm
if "%1" == "" goto 522_WordonlyFive
echo. >>%1
type %TEMP%\greptour >>%1
echo ================================================================== >>%1
echo executing: %G% %X% >>%1
echo ================================================================== >>%1
%G% %X% <%TEMP%\greptour >>%1
del %TEMP%\greptour >nul
goto 598_WordonlyCleanup
:522_WordonlyFive
type %TEMP%\greptour
echo ==================================================================
echo about to execute: %G% %X%
pause
%G% %X% <%TEMP%\greptour
echo ==================================================================
del %TEMP%\greptour >nul
:598_WordonlyCleanup
if "%1" == "" echo.
if "%1" == "" echo This concludes the demo of grepping by word.
if "%1" == "" echo.
:599_WordonlyDone

rem ============================================================================

if not "%1" == "" goto 201_BinaryOne
echo.
echo GREP can handle both text and binary files.
echo The /R option, rewritten for GREP release 6.9, specifies file format.
echo.
choice /cyn /n "Would you like to see a demo of binary file searching? "
if errorlevel 2 goto 299_BinaryDone
cls
echo Suppose you want to find the word "warning" in the GREP executable, just to see
echo the warning messages. Use the regular expression [Ww]arning to get both
echo "warning" and "Warning". With a search in text mode, the special characters in
echo %G%.exe cause GREP to miss some or all occurrences:
:201_BinaryOne
set X=[Ww]arning %G%.exe /BN
call toursub short %1
if not "%1" == "" goto 202_BinaryTwo
echo.
echo As you see, GREP didn't find any occurrences of "Warning" or "warning" in the
echo file. A byte value of 26 (Ctrl-Z) happens to come early in that executable
echo file.
echo.
pause
cls
echo But in binary mode, GREP will find all occurrences of the sought-after string.
echo Use /R3, not R2, because %G%.exe is a free-format binary file. And use /W40
echo to limit the buffers to 40 characters. (The sought-after string is 7 characters
echo long, so /W40 meets the requirement for /R3 that the buffer should be at least
echo double the string size.)
:202_BinaryTwo
set X=%X% /R3 /W40
call toursub long %1
if not "%1" == "" goto 203_BinaryThree
echo.
echo Note that the text characters are shown normally, and the binary characters are
echo shown as hexadecimal values.
echo.
echo (Though this test does find all occurrences of "warning" and "Warning" in the
echo executable program, it obviously doesn't find all of GREP's warning messages.
echo The reason is that the word "warning" is not coded with each message in the
echo program, but is inserted at run time by a subroutine. All warnings are listed
echo in the reference manual.)
echo.
echo The registered version of GREP can sense the file type.
if "%REG%" == "" echo That part of the tour will be skipped, since you said your copy isn't registered.
if "%REG%" == "" goto 298_BinaryCleanup
cls
echo The /R-1 option tells GREP to look at each file and figure out whether it's
echo text or binary. When you show filename headers -- i.e., when you don't use the
echo /H or /L or /U option -- GREP will tell you the type of each file.
echo.
echo Notice how the /W option lets you specify different widths for text and binary
echo files. I recommend you allow a full line width for text files, but keep the
echo buffer fairly small for binary files.
echo.
:203_BinaryThree
set X=[Ww]arning /R-1 /W255,40 /N %G%.exe grepuser.htm
call toursub long %1
:298_BinaryCleanup
if "%1" == "" echo.
if "%1" == "" echo This concludes the demo of binary file features.
if "%1" == "" echo.
:299_BinaryDone

rem ============================================================================

if not "%1" == "" goto 401_GlobExclude
echo.
echo Filename globbing, input file lists, and exclusion lists were all added in GREP
echo release 7.0.
echo.
choice /cyn /n "Would you like to see a demo of these features? "
if errorlevel 2 goto 499_GlobDone
cls
echo You can tell GREP to exclude files from consideration. For instance, let's
echo search for "Copyright" and "copyright" in every file, _except_ EXE files and
echo the license:
:401_GlobExclude
set X=[Cc]opyright /c /x*exe /xlice* *
call toursub long %1
if not "%1" == "" goto 402_GlobSimple
cls
echo Filename "globbing" includes DOS wildcarding with * and ?, but is more
echo flexible. For example, you can select only HTML files that begin with GREPR and
echo GREPU, using the construct GREP[RU]*.HTM, like this:
:402_GlobSimple
set X=Copyright grep[ur]*.htm
call toursub short %1
if not "%1" == "" goto 403_GlobMixed
echo GREP16 users, please note a change in the meaning of "*" between releases 6.9
echo and 7.0. GREP16 now expands wildcards exactly like GREP32. So "ABC*" means all
echo files starting with ABC, including files with extensions like ABCD.XYZ. If you
echo want files without extensions, "ABCD*." will get them. "ABC*.*" still means all
echo files beginning with ABC, whether or not they have an extension.
pause
cls
echo.
echo The last demo selected GREPUSER.HTM and GREPREF.HTM with the filespec
echo GREP[RU]*.HTM. This one will illustrate "all HTM files except GREPHIST.HTM and
echo PCRE.HTM". The /X option lets you exclude files. Unlike other options, /X can
echo be used multiple times for multiple exclusions. It doesn't matter where they
echo occur on the command line; all /X exclusions will be checked against all input
echo filespecs.
:403_GlobMixed
set X=Copyright *htm /Xgrephist* /Xpcre*
call toursub short %1
if not "%1" == "" goto 404_GlobFilelist
pause
cls
echo Flexible though globbing can be, sometimes you need to specify a more
echo complicated selection of files. For this, you can use the /@ option to specify
echo a list of input files. (Each filespec in the list may contain wildcards.)
echo.
echo /@file takes the list from a named file; /@- takes it from standard input. This
echo opens up the posibility to have some other program generate a list of input
echo files for GREP, which can then be passed to GREP via piping. For example, to
echo find the files that contain both the string "Copyright" and the string
echo "reserved", not necessarily on the same line, construct a command this way:
echo.
echo    - Run GREP once, with the /L option, to get a list of files that contain the
echo      string "Copyright".
echo    - Run GREP a second time, using only those files as input, to see which of
echo      them contain the string "reserved".
echo.
pause
cls
echo In a production run, you wouldn't do those two steps as separate commands.
echo Instead you'd pipe the output of the first GREP (the list of files containing
echo "Copyright") to the second GREP. But to show the mechanism, let's look at the
echo output of just the first command:
:404_GlobFilelist
set X=Copyright /L *
call toursub short %1
if not "%1" == "" goto 404A_GlobPipe
pause
cls
echo You saw the first GREP command produce the list of files that contain
echo "Copyright". Now for do a production run, piping that output directly into the
echo second GREP. The /@- on the second GREP says to take a list of input files from
echo standard input, which in this case is piped from the first GREP command.
echo.
echo Here's the command, with the results. These are the files that contain both
echo strings, but not necessarily on the same line. As you'll see, it's a shorter
echo list.
:404A_GlobPipe
set Y=reserved /@- /L
call toursub short %1
set Y=
if not "%1" == "" goto 499_GlobDone
pause
echo.
echo This concludes the tour of the /X /@ and filename globbing.
echo.
:499_GlobDone
if "%1" == "" cls

rem ============================================================================

if not "%1" == "" goto 301_KunOne
echo.
echo The /K option -- report only so many hits in each file -- was added in GREP
echo release 7.0.
echo.
choice /cyn /n "Would you like to see a demo of the /K option? "
if errorlevel 2 goto 399_KunDone
cls
echo Let's find the word "warning" in the GREP manuals. Use the regex [Ww]arning to
echo get both "warning" and "Warning". (The /N option displays line numbers.)
:301_KunOne
set X=[Ww]arning grep*.htm /N
call toursub long %1
if not "%1" == "" goto 302_KunTwo
echo.
echo As you see, the output is quite lengthy. You can limit the output to just the
echo first few occurrences per file, for example 3. The /K3 option gives only the
echo first 3 hits from each file.
:302_KunTwo
set X=%X% /K3
call toursub long %1
if not "%1" == "" goto 303_KunThree
cls
echo When limiting hits with the /K option, you can still use the /P option to
echo display context lines. For instance, you can use /P0,2 in case a warning
echo message is continued on the next line or two:
:303_KunThree
set X=%X% /P0,2
call toursub long %1
:398_KunCleanup
if "%1" == "" echo.
if "%1" == "" echo This concludes the tour of the /K option (display a few hits per file).
if "%1" == "" echo.
:399_KunDone
if "%1" == "" cls

rem ============================================================================

if "%1" == "" echo.
if "%1" == "" echo Locale support (/M option) was added to GREP32 release 6.9.
if "%B32%" == "yes" goto 100_LocaleMaybe
if "%1" == "" echo.
if "%1" == "" echo Note: Locale demos are being skipped because they need 32-bit GREP.
if "%1" == "" echo.
if "%1" == "" goto 199_LocaleDone
echo. >>%1
echo Note: Locale demos are being skipped because they need 32-bit GREP. >>%1
echo. >>%1
goto 199_LocaleDone

:100_LocaleMaybe
if not "%1" == "" goto 101_Locale
echo.
choice /cny /n "Would you like to see the locale demos? "
if not errorlevel 2 goto 199_LocaleDone
cls
:101_Locale

if not "%1" == "" goto 110_DefaultLocaleB
echo.
echo The locale demos use supplied file TEST255, which contains 256 records of 21
echo characters each. Each record has the form
echo         X (code point  88)
echo         123456789012345678901
echo where X is the character as a character, " 88" is its ASCII value in decimal,
echo and CRLF is a carriage return/line feed. This is a binary file and must be
echo processed with the /R2 option.
echo.
echo By default, GREP operates in the "C" locale, in which characters 128-255 don't
echo have any meaning. For example, in the ISO-8859-1 character set, character 233
echo is the letter e with acute accent. But in the default locale, it's not treated
echo as a letter. Consider the result of a case-blind search for that character:
:110_DefaultLocaleB
set X=/r2w21 \233 test255 /i
call toursub short %1

if not "%1" == "" goto 112_FrenchLocaleC
pause
cls
echo Now try the same thing with the "fr" locale, which is suitable for Western
echo European languages. Now you also get character 201, which in ISO-8859-1 is the
echo capital E with acute accent. (The characters may not look right, depending on
echo how you have your DOS set up. Type "HELP CHCP" at the DOS prompt for more
echo information.)
:112_FrenchLocaleC
set X=%X% /Mfr
call toursub short %1
if not "%1" == "" goto 114_ExtLocaleD
echo Note a side effect of setting the locale. In the previous test, character 233
echo is treated as unprintable. But the locale determines which characters are
echo treated as printable.
pause
cls
echo Extended regexes (/E2 option) have character types and named character classes,
echo and these are sensitive to the locale setting. For example, in the default "C"
echo locale, only 32 characters are considered punctuations. Let's display them by
echo using the extended regex ^[[:punct:]], which asks for the beginning of line (^)
echo followed by a punctuation character:
:114_ExtLocaleE
set X=/r2 /w21 ^[[:punct:]] /e2 test255
call toursub long %1

if not "%1" == "" goto 115_ExtLocaleF
echo.
echo Now try that again with the "fr" locale. This time we get 85 punctuation
echo characters:
:115_ExtLocaleF
set X=%X% /mfr
call toursub long %1

if not "%1" == "" goto 116_ExtLocaleG
echo.
echo To make things clearer, use the /C option to count hits, instead of actually
echo displaying them. This time let's count lower-case letters with ^[[:lower:]],
echo first in the default "C" locale and then in the Western European "fr" locale:
:116_ExtLocaleG
set X=/r2 /w21 ^[[:lower:]] /e2 test255 /c
call toursub short %1
set X=%X% /mfr
call toursub short %1

if not "%1" == "" goto 199_LocaleDone
pause
cls
echo This concludes the tour of locale features.
echo.
rem We need to pause here because preceding output is more than half a screen,
rem and closing output is almost a full screen.
pause
echo.
:199_LocaleDone

rem ============================================================================

if not "%1" == "" goto 99_Exit
if "%1" == "" cls
echo.
echo Thank you for trying out this tour of the new features in GREP!
echo.
echo Please consult the user guide and reference manual for full description of all
echo the features of GREP. If you find it meets your needs, please register the
echo software, on line at
echo             http://oakroadsystems.com/sharware/
echo or by mailing in the form REGISTER.TXT or SITEREG.TXT with your payment.
echo.
echo The registered version of GREP has more features, including
echo   - sense whether each file is text or binary (/R-1 or /R-2 option)
echo   - search subdirectory trees to any depth (/S option)
echo   - suppress program logo and warning messages (/Q option)
echo   - store frequently-used options in the ORS_GREP environment variable
echo   - store regular expressions in a file (/Ffile option)
echo plus the warm glow of knowing you've supported the development of quality
echo shareware. (Registered users get priority in tech support, too.)
echo.

:99_Exit
set X=
set G=
set B32=
rem :: vim: ic tw=0 comments=n\:\:\:,n\:echo,n\:rem
