{ GarboIDX.pas v2.3  1993-1995 Gongquan Chen and Marko Bohanec }

{ Tested with Borland Pascal v7.0 }

{$R-,B-,V-}
{$M 4096,40000,120000}

program GarboIDX;
 uses Dos;

 const
  Ifn = 'INDEX';                       { fixed file names }
  Dfn = '_dir.lst';
  Xfn = 'GARBO.IDX';
  Imsg= 'INDEX:     ';                 { file names used in messages }
  Dmsg= '_DIR.LST:  ';
  Last: string[1] = #255;              { to simulate directory name after eof }
  month: array [1..12] of string[3] =
   ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
  month_code: array [1..12] of string[2] =
   ('01','02','03','04','05','06','07','08','09','10','11','12');

 type
  LineType = string[128];
  DescType = string[80];
  DirNameType = string[64];
  FileNameType = string[32];
  pIRec = ^IRec;                       { pointer to a list of INDEX extries }
  IRec = record                        { an INDEX entry }
          match: boolean;              { does the entry match one in _dir.lst? }
          next: pIRec;                 { next entry }
          name: FileNameType;          { file name }
          desc: DescType;              { description }
         end;

 var
  Index,Dir: text;                     { input files }
  Idx,Log: text;                       { output files }
  ILine,DLine: LineType;               { INDEX and _dir.lst input lines }
  MainDir: DirNameType;                { main directory }
  IDirName,DDirName: DirNameType;      { current INDEX and _dir.lst directory }
  FileName: FileNameType;              { current _dir.lst file name }
  Size: longint;                       { other data about this file }
  Date: string[6];
  Desc: DescType;
  Flag: char;
  ThisMonth,FileMonth: word;           { to handle recent file dates }
  ThisYear,LastYear: string[2];
  Lfn: string;                         { Log file name }
  LogMode: boolean;                    { true when Log is being written }
  First: pIRec;                        { pointer to the list of INDEX entries }
  Mrk: pointer;                        { heap marker }
  PrevDirL,i: integer;
  s: string;
  p: pIRec;

{- Convert a string to upper case -}
 procedure UpCaseStr(var s:string);
  var i: byte;
  begin
   for i:=1 to Length(s) do s[i]:=UpCase(s[i]);
  end;

{- Trim leading and tailing spaces -}
 procedure TrimStr(var s:string);
  begin
   while (Length(s)>0) and (s[1]=' ') do Delete(s,1,1);
   while (Length(s)>0) and (s[Length(s)]=' ') do Dec(s[0]);
  end;

{- Convert a string representing month to Date[3:4] and FileMonth -}
 procedure DecodeMonth(s:string);
  var i: byte;
  begin
   FileMonth:=0;
   for i:=1 to 12 do
    if s=month[i] then
     begin
      FileMonth:=i;
      Date[3]:=month_code[i][1]; Date[4]:=month_code[i][2];
      Exit;
     end;
  end;

{- Get current system date and set ThisMonth, ThisYear and LastYear -}
 procedure InitDate;
  var Y,D,W: word;
  begin
   GetDate(Y,ThisMonth,D,W); Y:=Y mod 100;
   if Y=0 then
    begin ThisYear:='00'; LastYear:='99'; end
   else
    begin
     Str(Y:2,ThisYear);   if ThisYear[1]=' ' then ThisYear[1]:='0';
     Str(Y-1:2,LastYear); if LastYear[1]=' ' then LastYear[1]:='0';
    end;
  end;

{- Open text file f named fn for input (fm=0) or output (fm=1) -}
 procedure OpenFile(var f: text; fn: string; fm: byte);
  begin
   FileMode:=fm; UpCaseStr(fn);
   {$I-}
   Assign(f,fn); if fm=0 then Reset(f) else Rewrite(f);
   {$I+}
   if IOResult<>0 then
    begin
     write('Unable to open ',fn,' for ');
     if fm=0 then writeln('input') else writeln('output');
     Halt(1);
    end;
  end;

{- Write a record to GARBO.IDX -}
procedure WriteRec;
  begin
   writeln(Idx,'"',MainDir,'","',DDirName,'/","',FileName,'",',
               Flag,',',Size,',8,',Date,',"',Desc,'"');
  end;

{- Display string and optionally write it to Log -}
 procedure Message(s: string);
  begin
   PrevDirL:=0;
   writeln(s);
   if LogMode then writeln(Log,s);
  end;

{- Find main directory in the first line of INDEX and set MainDir -}
 procedure FindRDir;
  var p: byte;
  begin MainDir:='';
   readln(Index,MainDir);
   p:=Pos('/',MainDir);
   if p=0 then begin writeln('Irregular INDEX file'); Halt(1); end;
   MainDir:=Copy(MainDir,p+1,255);
   p:=Pos('/',MainDir);
   if p>0 then Delete(MainDir,p+1,255) else MainDir:=MainDir+'/';
   MainDir:='/'+MainDir; Message('Directory: '+MainDir);
   Message('');
  end;

{- Find next directory in _dir.lst and set DDirName -}
 procedure FindDDir;
  var s: LineType; p: integer;
  begin
   DDirName:=Last;                     { when nothing is found below }
   while not Eof(Dir) do
    begin
     readln(Dir,s);
     TrimStr(s); p:=Pos(':',s);
     if (p>0) and (p=Length(s)) then   { this is the directory line }
      begin
       if Pos('./',s)=1 then Delete(s,1,2);
       s:=Copy(s,1,Pos(':',s)-1);      { extract directory name }
       TrimStr(s);
       DDirName:=s;
       if not Eof(Dir) then
        readln(Dir);                   { skip next line }
       Exit;                           { ok, get out }
      end;
    end;
  end;

{- Find next directory in INDEX and set IDirName -}
 procedure FindIDir;
  var s: LineType; p: byte;
  begin
   IDirName:=Last;
   while not Eof(Index) do
    begin
     readln(Index,s); Inc(s[0]); s[Length(s)]:=' ';
     p:=Pos(' : ',s);
     if p>0 then
      begin
       s:=Copy(s,1,p-1);
       TrimStr(s);
       IDirName:=s;
       if not Eof(Index) then
        readln(Index);
       Exit;
      end;
    end;
  end;

{- Make the list of entries found in the current INDEX directory -}
 procedure GetIDir;
  var p: pIRec;
  begin
   Mark(Mrk);
   First:=nil;
   while not Eof(Index) do
    begin
     readln(Index,ILine);              { read next entry }
     if ILine='' then Exit;            { end of directory }
     if ILine[1]=' ' then Continue;    { skip comment line }
     New(p);
     with p^ do
      begin
       name:=Copy(ILine,1,14);         { extract file name }
       TrimStr(name);
       Delete(ILine,1,14);             { extract description }
       TrimStr(ILine); desc:=ILine;
       next:=First; First:=p;          { insert }
       match:=false;
      end;
    end;
  end;

{- Display all unmatched entries in the list -}
 procedure PutIDir;
  var p: pIRec;
  begin
   p:=First;
   while p<>nil do
    with p^ do
     begin
      if not match then Message(Dmsg+'Missing file '+DDirName+'/'+name);
      p:=next;
     end;
   First:=nil; Release(Mrk);           { erase the list }
  end;

{- Skip directories in INDEX or _dir.lst     }
{  until DDirName=IDirName (return true)     }
{  or there are no more directories (false) -}
 function SyncDir: boolean;
  begin
   while DDirName<>IDirName do
    if DDirName<IDirName then { relying on alphabetical order of directories }
     begin
      if DDirName<>'incoming' then     { ./incoming never appears in INDEX }
       Message(Imsg+'Missing directory '+DDirName);
      FindDDir;                        { find next directory in _dir.lst }
     end
    else
     begin
      Message(Dmsg+'Missing directory '+IDirName);
      First:=nil; Release(Mrk);
      FindIDir; GetIDir;               { find next directory in INDEX }
     end;
   SyncDir:=DDirName<>Last;
  end;

 begin
  writeln('GarboIDX v2.3    1993-1995 Gongquan Chen, Marko Bohanec');
  writeln('Create ',Xfn,', a SimTel-compatible index file '+
          'for Garbo''s MsDos archive');
  writeln;
  LogMode:=false; Date:='YYMMDD'; InitDate; PrevDirL:=0;
  OpenFile(Index,Ifn,0);
  OpenFile(Dir,Dfn,0);
  OpenFile(Idx,Xfn,1);
  if ParamCount>0 then                 { optional file-name argument found }
   begin
    LogMode:=true;
    Lfn:=ParamStr(1); UpCaseStr(Lfn);
    OpenFile(Log,Lfn,1);
   end;
  FindRDir;                            { get the main directory from INDEX }
  FindIDir; GetIDir;                   { find and read 1st directory of INDEX }
  DDirName:='.';                       { '.' is always 1st in _dir.lst }
  while SyncDir do                     { for each pair of matching directories }
   begin
    write(DDirName);                   { display current directory ... }
    while PrevDirL>Length(DDirName) do { ... rewrite the last one ... }
     begin write(' '); Dec(PrevDirL); end;
    write(^M);
    PrevDirL:=Length(DDirName);        { ... and remember new length }
    while not Eof(Dir) do              { for entries from _dir.lst }
     begin
      readln(Dir,DLine);               { read the entry }
      TrimStr(DLine);
      if Pos(' ->',DLine)>0 then Delete(Dline,Pos(' ->',DLine),255);
      if DLine='' then Break           { end of directory; terminate this loop }
      else
       begin                           { decode the entry and prepare: }
        i:=Length(DLine);              { file name }
        while DLine[i]<>' ' do Dec(i);
        FileName:=Copy(DLine,i+1,256);
        TrimStr(FileName);
        if Pos('./',FileName)=1 then
         Delete(FileName,1,2);
        p:=First;                      { find this file in the INDEX list }
        while (p<>nil) and (p^.name<>FileName) do p:=p^.next;
        if p<>nil then
         begin                         { found }
          Desc:=p^.desc;               { get description }
          p^.match:=true;
         end
        else
         begin                         { not found }
          Desc:='*** No description ***';
          Message(Imsg+'Missing file '+DDirName+'/'+FileName);
         end;
        Flag:=DLine[14];               { file flag }
        s:=Copy(DLine,30,13);          { file size }
        TrimStr(s); Val(s,Size,i);
        s:=Copy(DLine,43,3);           { file date }
        DecodeMonth(s);
        Date[5]:=DLine[47];
        if Date[5]=' ' then date[5]:='0';
        Date[6]:=DLine[48];
        if DLine[52]<>':' then
         begin Date[1]:=DLine[53]; Date[2]:=DLine[54]; end
        else                           { recent file }
         if FileMonth>ThisMonth then
          begin
           Date[1]:=LastYear[1];
           Date[2]:=LastYear[2];
          end
         else
          begin
           Date[1]:=ThisYear[1];
           Date[2]:=ThisYear[2];
          end;
        WriteRec;                      { write to GARBO.IDX }
       end;
     end;
    PutIDir; FindIDir; GetIDir;        { find next directory in INDEX ... }
    FindDDir;                          { ... and in _dir.lst }
   end;
  PutIDir;
  Close(Index);
  Close(Dir);
  Close(Idx);
  if LogMode then Close(Log);
  write(Xfn,' created');
  if LogMode then write('; Log written to ',Lfn);
  writeln;
end.
