{ garboidx.pas (c)1993 Copyright by Gongquan Chen

  Generate an index file for garbo ftp site's MsDos archive
  in a format compatible to Simtel's SIMIBM.IDX, so that
  it can be used by other programs to process, such as
  Schmidt's SIMDIR.

  --
  author's e-mail address:
  gchen@geohub.gcn.uoknor.edu or gchen@essex.ecn.uoknor.edu

  --
  *Disclaimer*
  This program is released to the public domain.
  Use this program at your own risk.  The author disclaims any
  responsibility for any consequences from using this program.

  --
  Ascii Input Files:  INDEX     - for filename and its description
                      _dir.lst  - for file size, date
  Ascii Output File:  GARBO.IDX - SIMIBM.IDX format-compatible file

  Note:
  This program was tested on March 24's files: 'index' and '_dir.lst'.
  Directory \pc\ts was not processed because the inconsistency between
  'index' and '_dir.lst' for this directory entry.

  --
  Gongquan Chen
  Norman, Oklahoma, USA
  1993-3-26
}

{$M 4096,0,0}
{$R-,V-,B-}
uses
  crt;

const
  YES=TRUE;
  NO=FALSE;

  index_fn='INDEX';
  _dir_lst_fn='_dir.lst';
  output_fn='GARBO.IDX';

  month:array[1..12] of string[3]=(
        'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
  month_code:array[1..12] of string[2]=(
        '01','02','03','04','05','06','07','08','09','10','11','12');

var
  index_line,                   {input line from file INDEX}
  _dir_lst_line : string[128];  {input line from file _dir.lst}

  dirName,fileName:string[20];
  flag:char;
  fileSize:longint;
  date:string[6];
  fileDesc:string[80];

  index_fp,
  _dir_lst_fp,
  output_fp     : text;

  s:string[80];
  err:integer;

{-convert a string to upper case-}
procedure UpCaseStr(var s:string);
var i,n:byte;
begin
  n:=ord(s[0]);
  for i:=1 to n do s[i]:=Upcase(s[i])
end;

{-trime leading and tailing spaces of a string-}
procedure TrimStr(var s:string);
var n:byte;
begin
  while (s[0]>#0) and (s[1]=' ') do delete(s,1,1);
  n:=ord(s[0]);
  while (n>0) and (s[n]=' ') do begin delete(s,n,1); n:=n-1 end
end;


{}
procedure OpenFile(var fp:text; fn:string; justRead:boolean);
begin
  filemode:=0;
  {$I-}assign(fp,fn);
  if justRead then reset(fp) else rewrite(fp);
  {$I+}
  if IOResult<>0 then
  begin
     write('Error: can''t open file "', fn, '" for ');
     if justRead then writeln('input') else writeln('output');
     halt(1)
  end
end;

{}
procedure WriteRec;
begin
   writeln(output_fp,
           '"PC/","', dirName,'","',fileName,'",',flag,',',
           fileSize,',8,',date,',"',fileDesc,'"')
end;

{}
procedure RollToNewDir(var fp:text; setDir:boolean);
var s:string[80]; token:string[2];
    p:byte;
begin
  if setDir then token:=' : ' else token:=':';
  while not eof(fp) do
  begin
    readln(fp, s);
    p:=Pos(token, s);
    if p>0 then  {this is the directory name line}
    begin
      if setDir then
      begin
        s:=copy(s,1,p-1);
        trimStr(s);
        UpcaseStr(s);
        dirName:=s;  
        gotoxy(1,4); write('Processing directory: ', s); clreol
      end;
      readln(fp);         {skip next line}
      exit                {get out}
    end
  end
end;

{}
procedure DecodeMonth(s:string);
var i:byte;
begin
  for i:=1 to 12 do
  if s=month[i] then
  begin
    Date[3]:=month_code[i][1];
    Date[4]:=month_code[i][2];
    exit
  end
end;


{-main-}
begin
  clrscr;
  writeln('GarboIdx v1.0 (c)1993 Gongquan Chen'#13#10,
          'Create Simtel''s SIMIBM.IDX-compatible index file '+
          'for Garbo''s MsDos archive');

  OpenFile(index_fp, index_fn, YES);
  OpenFile(_dir_lst_fp,_dir_lst_fn, YES);
  OpenFile(output_fp,output_fn, NO);

  Date[0]:=#6;
  RollToNewDir(index_fp,Yes);

  repeat
    readln(index_fp,index_line);
    if (index_line[1]<>' ') and (index_line[0]>#0) then
    begin
      readln(_dir_lst_fp,_dir_lst_line);

      fileName:=copy(index_line,1,14);
      trimStr(fileName);
      delete(index_line,1,14);
      trimStr(index_line);
      fileDesc:=index_line;

      flag:=_dir_lst_line[13];

      {file size}
      s:=copy(_dir_lst_line,17,16);
      trimStr(s);
      val(s,fileSize,err);

      {month}
      s:=copy(_dir_lst_line,33,3);
      DecodeMonth(s);

      {date}
      Date[5]:=_dir_lst_line[37];
      if date[5]=' ' then date[5]:='0';
      Date[6]:=_dir_lst_line[38];

      {year}
      if _dir_lst_line[42]=':' then begin Date[1]:='-'; Date[2]:='-' end
      else begin Date[1]:=_dir_lst_line[43]; Date[2]:=_dir_lst_line[44] end;
      WriteRec
    end
    else
    begin
      RollToNewDir(index_fp,Yes);
      RollToNewDir(_dir_lst_fp,No)
    end
  until eof(index_fp) or eof(_dir_lst_fp);
  close(index_fp);
  close(_dir_lst_fp);
  close(output_fp);

  gotoxy(1,6);
  writeln(output_fn,' has been created.')
end.
