@echo off
::
::  This batch file uses FFG to for existence of a specified directory.  If it
::  exists a message saying so is displayed.  Similarly, a message
::  states that the directory does not exist if it is not found.  It will
::  find hidden directories too.
::
::
:: Notes on FFG parameters:
:: 1. /q suppresses normal FFG output
:: 2. /r prevents searching beyond the specified directory
:: 3. /1 stops after first find to avoid unnecessary searching
::
:: %1 holds the directory to find, which must have a terminating backslash
::
if %1.==. goto USAGE
  ffg /q /r /1 %1
if errorlevel 1 if not errorlevel 2 goto FOUND
  echo Directory "%1" doesn't exist.
  goto END
:FOUND
  echo Directory "%1" exists.
  goto END
:USAGE
  echo USAGE:  %0 FullDirSpec\
  echo.
  echo         Note: You must use a trailing backslash '\'
:END
