#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<stdarg.h>
#include <dos.h>
#include <io.h>


/* Compiled by Borland C++ 3.1 in compact mode.

   Written by
       Zhuhan Jiang
       University of New England
       Armidale NSW 2351
       Australia

       Email: zjiang@metz.une.edu.au

*/


#define FREE(a)    free(a)
#define MALLOC(a)  malloc(a)


#define upcase(ch)  ( (((ch)>='a')&&((ch)<='z'))? ((ch)-'a'+'A'):(ch) )
#define lowcase(ch)  ( (((ch)>='A')&&((ch)<='Z'))? ((ch)-'A'+'a'):(ch) )
#define chkdigit(ch) ( (((ch)>='0')&&((ch)<='9'))? 1:0 )


#define VERSION_TOTAL 100
#define PSWD_WIDTH 4

char ADDRESSES[VERSION_TOTAL*4 + PSWD_WIDTH +2 ]=
     { 'P', 's', 'W', 'd', 5,0,  /* total valid ones */
       3,0x1e,  0xea,0x0b,
       4,0,     0x2b,0x0f,
       5,0,     0xA3,2,
       6,0,     0x66,3,
       6,0x14,  0x6b,3
     };



int Getch(void)
/* =getch() with small object code
*/
{ int retval;
asm {  mov ah,0x08;
       int 0x21;
       mov ah,0;
       mov retval, ax
    }
  return(retval);
}



void chkmemory(void *ptr)
{ if(ptr==NULL) { fputs("\nLack of memory.",stderr); exit(1); }
}


char *fmalloc(size_t total)
{ char *oneline=(char *) MALLOC(total);
  chkmemory(oneline);
  return(oneline);
}


void movebytes(char *source, char *newaddress,
	      unsigned length, unsigned zeros)
/* no checking for source=NULL or newaddress=NULL
*/
{  unsigned i;
   char *ptr;
   for(i=0;i<length;i++) newaddress[i]=source[i];
   ptr=newaddress+length;
   for(i=0;i<zeros;i++) ptr[i]=0;
}



char *locatepos(char *mainstr, unsigned mainlength,
		char *substr,  unsigned sublength)
/*  locate the first position of a list of bytes
*/
{ int ch, matched=0, matching=0;
  char *ptr=mainstr, *str=substr;
  unsigned maincount=0, subcount=0;
  if(!mainlength || !sublength) return(NULL);
  while (1)
   { ch= *ptr; ptr++;
     if (++maincount>mainlength) break;
     if (matching)
       if (*str==ch) {str++; subcount++;}
       else {matching=subcount=0; str=substr;}
     if (!matching)
       if (*str==ch) {matching=1; str++; subcount++;}
     if (matching && subcount>=sublength) {matched=1; break;}
   }
   return(matched? ptr-sublength:NULL);
}



int foundstr(char *oneline, char *onestr)
/*  check if oneline contains substring onestr.
    nocase: case insensitive.
    Return:
      0     =not found, under whatever circumstance
      i<>0  =i-th element is the element immediately after the found string

      e.g  5=5th elment is the element immediately after the found string
*/
{
  int m,n;
  char *ptr;
  m=strlen(oneline);
  n=strlen(onestr);
  if (!m || !n) return(0);
  ptr=locatepos(oneline,m,onestr,n);
  return(ptr==NULL? 0:ptr-oneline+n);
}



int geterrlevel(unsigned *segment)
/* return: -1=fail
   *segment returns the PSP segement of the oldest parent
*/
{ unsigned current,i;
  int level;
  current=_psp;
  while(1)
  { i= * ( (unsigned int *) MK_FP(current,0x16));
    if(i==current) break; else current=i;
  }
  *segment=current;
  current=*((unsigned int *) (ADDRESSES+PSWD_WIDTH));
  for(i=0; i<current; i++)
  { if(*((unsigned int *) (ADDRESSES+PSWD_WIDTH+2+4*i)) ==_version)
    { level= * ( (unsigned char *) MK_FP(*segment,
		   *((unsigned int *) (ADDRESSES+PSWD_WIDTH+4+4*i))
	       ));
      return(level);
    }
  }
  return(-1);
}



void printversions(void)
{ unsigned i,total,lowbyte,highbyte;
  total=*((unsigned int *) (ADDRESSES+PSWD_WIDTH));
  for(i=0; i<total; i++)
  { lowbyte=*((unsigned char *) (ADDRESSES+PSWD_WIDTH+2+4*i));
    highbyte=*((unsigned char *) (ADDRESSES+PSWD_WIDTH+3+4*i));
    printf(" %d.%d", lowbyte,highbyte);
  }
}



long fseekstr(FILE *fptr, char *password, unsigned width)
/* return:   -1=not found
	  otherwise=position from file's beginning
   aim:  locate the available position immediately after
	 the password (of "width" long)
*/
{ long current,position;
  int ch, matched=0, matching=0;
  char *str=password;
  unsigned subcount=0;
  if(fptr==NULL) return(-1);
  current=ftell(fptr);
  while(1)
  { ch=fgetc(fptr);
    if(ch==-1) break;
    if (matching)
       if(*str==ch){str++; subcount++;}
       else {matching=subcount=0; str=password;}
    if (!matching)
       if(*str==ch){matching=1; str++; subcount++;}
    if (matching && subcount>=width) {matched=1; break;}
  }
  position=ftell(fptr);
  fseek(fptr,current,SEEK_SET);
  if(matched) return(position);
  return(-1);
}




int updatefile(char *filename, int clrversions,
	       unsigned version, unsigned address)
/*  locate str given by first PSWD_WIDTH chars of ADDRESSES
    from file filename, then update it with new version/address

    filename should essentially be argv[0]

    return: 0=fail
	    1=success
*/
{ FILE *fptr;
  long filelen,position;
  int i;
  unsigned char lowbyte, highbyte;
  unsigned total;
  struct ftime *ftptr;

  if((fptr=fopen(filename,"rb+"))==NULL)
  { fprintf(stderr, "Fail to update file %s\n", filename);
    return(0);
  }
  i=fseek(fptr,0L, SEEK_END);
  filelen=ftell(fptr);
  rewind(fptr);
  if(i || (position=fseekstr(fptr,ADDRESSES,PSWD_WIDTH))== -1)
  { fclose(fptr); return(0); }

  fseek(fptr,position, SEEK_SET);
  lowbyte=fgetc(fptr);  highbyte=fgetc(fptr);
  total=lowbyte+highbyte*256;
  lowbyte++;
  if(!lowbyte) highbyte++;

  if(total>=VERSION_TOTAL && !clrversions)
  { fprintf(stderr,"No space to store new address to file %s\n", filename);
    fclose(fptr);
    return(0);
  }

  ftptr=MALLOC(sizeof(struct ftime));
  chkmemory(ftptr);
  getftime(fileno(fptr), ftptr);
  fseek(fptr, -2L, SEEK_CUR);
  if(clrversions) fprintf(fptr,"%c%c", 0,0);
  else
  { fprintf(fptr,"%c%c", lowbyte,highbyte);
    i=fseek(fptr,total*4, SEEK_CUR);
    highbyte=version/256;
    lowbyte=version -highbyte*256;
    fprintf(fptr,"%c%c", lowbyte,highbyte);
    highbyte=address/256;
    lowbyte=address -highbyte*256;
    fprintf(fptr,"%c%c", lowbyte,highbyte);
  }
  i=fseek(fptr,filelen,SEEK_SET);
  setftime(fileno(fptr),ftptr);
  fclose(fptr);
  FREE(ftptr);
  return(i? 0:1);
}




int setenv(unsigned psp, char *setcmd)
/* aim:     set DOS environment parameter of its parent processes
	    directly

   return:  0=failed attempt
	    1=done successfully
	   -1=nothing needs done

  env->COMSPEC=...0PATH=.... 0 0 1 0 C:\BC\ng.exe   0
       |<-- firstwidth ------->| |<-- 2ndwidth    ->|
			env+firstwidth+secondwidth ->|

*/
{ int i,j,found;
  char ch, *env,buff[2]={0,0};
  char *matchptr, *zerosptr, *ptr;
  unsigned envseg,k,extrawidth,delwidth,firstwidth,mainwidth ;

  if( !( (setcmd==NULL)? 0:strlen(setcmd) ) ) return(-1);
  found=foundstr(setcmd,"=");
  if(!found || found==1) return(-1);
  if(foundstr(setcmd+found,"=")) return(-1);
  for(i=0;i<found;i++) { ch=setcmd[i]; setcmd[i]=upcase(ch); }

  envseg=*( (unsigned int *) MK_FP(psp,0x2c) );
  env=(char *) MK_FP(envseg,0);
  mainwidth=*( (unsigned int *) MK_FP(envseg-1,3) ) *16;
  extrawidth=strlen(setcmd)+1;
  zerosptr=locatepos(env,mainwidth,buff,2);
  if(zerosptr==NULL) return(0);
  firstwidth=zerosptr-env+2;

  envseg=0;
  ch=setcmd[found];
  setcmd[found]=0;
  while(1)
  { matchptr=locatepos(env+envseg, firstwidth-envseg,
	       setcmd, strlen(setcmd));
    ptr=matchptr; ptr--;
    if(matchptr==NULL || matchptr==env || *(ptr)==0) break;
    envseg=matchptr-env+1;
  }
  setcmd[found]=ch;

  if(matchptr!=NULL) delwidth=strlen(matchptr)+1; else delwidth=0;
  envseg= *(  (unsigned int *) (zerosptr+2) );

  if(!strlen(setcmd+found))
  { if(delwidth)
    { movebytes(matchptr+delwidth,matchptr,
		firstwidth-delwidth-(matchptr-env),0);
      envseg=firstwidth-delwidth-1;
      if(envseg) envseg--;
      movebytes(zerosptr,env+envseg,2,0);
      return(1);
    }
    else return(-1);
  }

  if( !(firstwidth+extrawidth-delwidth<=mainwidth) ) return(0);
  if(delwidth) movebytes(matchptr+delwidth,matchptr,
		 firstwidth-delwidth-(matchptr-env),0);
  if(delwidth<extrawidth)
  { envseg=extrawidth-delwidth;
    for(k=firstwidth-1;k>=firstwidth;k--) *(env+k+envseg)=*(env+k);
  }
  else
  { envseg=firstwidth+extrawidth-delwidth-2;
    movebytes(zerosptr,env+envseg,2,0);
  }

  envseg=firstwidth-delwidth-1;
  if(envseg==1) envseg=0;
  movebytes(setcmd,env+envseg,extrawidth,1);
  return(1);
}




int writeaddress(unsigned segment, char value, char *filename)
/* return 0=failed
	  1=done
*/
{ unsigned i;
  unsigned char lowbyte,highbyte;
  FILE *fptr;
  if((fptr=fopen(filename,"wb"))==NULL)
  { fprintf(stderr,"Fail to write file %s\n", filename);
    return(0);
  }
  for(i=1;i; i++)
  { if( *((char *) MK_FP(segment,i))==value)
    { lowbyte=i -i/256*256;
      highbyte=i/256;
      fprintf(fptr,"%c%c", lowbyte,highbyte);
    }
  }
  fclose(fptr);
  return(1);
}




unsigned int updateaddress(unsigned segment, char value,
	      int no_outfile, char *infile, char *outfile)
/* return 0=fail to process
	  1=incomplete
      other=segment address of errorlevel

   NOTE:  first 2 bytes can not be for errorlevel because
	  they have to be CD 20
*/
{ unsigned offset;
  FILE *inptr, *outptr;
  unsigned char lowbyte,highbyte;
  int i,j,k;

  inptr=fopen(infile,"rb");
  if(no_outfile) outfile="NUL";
  outptr=fopen(outfile,"wb");
  if(inptr==NULL)
  { fprintf(stderr,"Fail to read file %s\n", infile);
    return(0);
  }
  if(outptr==NULL)
  { fprintf(stderr,"Fail to write file %s\n", outfile);
    return(0);
  }

  k=0;
  while(1)
  { i=fgetc(inptr);
    j=fgetc(inptr);
    if(i==-1) break;
    if(j==-1) fprintf(stderr,"File %s corrupted\n", infile);
    lowbyte=i; highbyte=j;
    offset=highbyte*256+lowbyte;
    if( *((char *) MK_FP(segment,offset))==value)
       fprintf(outptr,"%c%c",lowbyte,highbyte);
    if(k<2) k++;
  }
  fclose(inptr);
  fclose(outptr);
  return(k==1? offset:1);
}




int main(int argn, char *argv[])
/*
    /<> enables outfile-infile interpretation
	if infile does not exist, output to outfile only,
	otherwise read from infile and write back to outfile

    /q  quiet print: no non-critical messages
    /n  no setting for envrionment parameter
    /,* set errorlevel to new env parameter *, instead of ERR_LEVEL
    /  del addresses
    /x# exit with errorlevel #, priority over +# and -#
    +#  increase entry errorlevel by #, when exit
    -#  decrease entry errorlevel by #, when exit
	(when run with /@, the test errorlevel will be
	 regarded as the entry errorlevel)

    /t# test errorlevel value #, default to 0
	meaningful to /<> and non-trivial infile

    invalid options
	ignore everything, prints help line

*/
{ int i,j,m, exitcode;
  unsigned offset=0, segment=0;
  char ch,*cmd,*buffline,*infile,*outfile,*fileone="",*filetwo="",
       *envname=NULL;
  int quiet_print, no_setenv, need_help, sub_shell,
      test_level, exit_level, add_level, force_exit,
      find_address,err_level,clr_versions;


  buffline=(argn>1)? argv[1]:"";
  quiet_print=no_setenv=need_help=sub_shell=add_level
	     =test_level=exit_level=force_exit=clr_versions=0;
  strupr(buffline);
  if(*buffline=='/' && buffline[1]=='<' && buffline[2]=='>')
  { sub_shell=1; buffline[2]='/'; buffline+=2; }

  m=strlen(buffline);
  if(*buffline=='/')
  for(i=1;i<m;i++)
  { ch=buffline[i];
    j=(*(buffline+i+1)!='-')? atoi(buffline+i+1):0;
    while(chkdigit(buffline[i+1])) i++;
    switch(ch)
    { case 'Q': quiet_print=1; break;
      case 'N': no_setenv=1; break;
      case 'T': test_level=j; break;
      case 'X': exit_level=j; force_exit=1; break;
      case '+': add_level+=j; break;
      case '-': add_level-=j; break;
      case '': clr_versions=1; break;
      case ',': envname=buffline+i+1; break;
       default: need_help=1; break;
    }
    if(envname!=NULL) break;
  }
  else if(m) need_help=1;
  if(!sub_shell && argn>2) need_help=1;

  if(need_help)
  { cmd=strrchr(argv[0],'\\');
    if(cmd!=NULL) fileone=strrchr(cmd,'.');
    if(cmd!=NULL && fileone!=NULL) {*fileone=0; cmd++;}
    printf("\
%s  [/qnx#+#-#[,envpara]]   - set errorlevel to environment parameter\n\
 q=quiet, n=no setenv, =clr addresses, x#=exitcode, +|-#=add exitcode\n\
 DOS versions learnt: ", cmd);
    printversions();
    exit(0);
  }

  if(clr_versions)
  { fprintf(stderr,"WARNING: delete errorlevel addresses from %s? %c",
	     argv[0],0x7);
    i=Getch();   /* smaller code than using getch() */
    if(i=='y' || i=='Y')
    { fprintf(stderr,"(yes)\n"); updatefile(argv[0],1,0,0); }
    else fprintf(stderr,"(no)");
    exit(0);
  }

  if(argn>2) fileone=argv[2];
  if(argn>3) filetwo=argv[3];

  find_address=((err_level=geterrlevel(&segment))==-1)?1:0;
  if(sub_shell) find_address=0;


ONCEAGAIN: ;

  if(find_address)
  { infile=tempnam("\\","@A");
    outfile=tempnam("\\","@B");

    if(infile==NULL || outfile==NULL)
    { fprintf(stderr,"(abort)"); exit(1); }

    cmd=argv[0];
    m=strlen(argv[0]);
    buffline=(char *) fmalloc(3*(m+strlen(infile)+strlen(outfile))+100);

    i=145; /* a good initial choice of errorlevel */
    sprintf(buffline,"%s %c/<>qnx%d%c |%s %c/<>qnt%d%c %s",
	    cmd,'"',i,'"',cmd,'"',i,'"',infile);
    j=system(buffline);

    i=0;
    while(1)
    { offset=updateaddress(segment,test_level,1,infile,"NUL");
      if(offset>1)
      {	err_level=* ( (unsigned char *) MK_FP(segment,offset));
	exitcode=force_exit? exit_level:err_level+add_level;
	sub_shell=find_address=0;
	remove(infile); remove(outfile);
	fprintf(stderr,"Self upgrade with offset 0x%04X for DOS %d.%d\n",
	 offset,_osmajor,_osminor);
	updatefile(cmd,0,_version,offset);
	goto ONCEAGAIN;
      }

      sprintf(buffline,"%s %c/<>qnx%d%c |%s %c/<>qnt%d%c %s %s",
	      cmd,'"',i,'"',cmd,'"',i,'"',outfile,infile);
      j=system(buffline);
      if(!j)
      {  sprintf(buffline,"%s %c/<>qnx%d%c |%s %c/<>qnt%d%c %s %s",
	 cmd,'"',i+1,'"',cmd,'"',i+1,'"',infile,outfile);
	 j=system(buffline);
      }
      if(j)
      { fprintf(stderr,"Recursive shell failure (path of %s too long?)\n",argv[0]); break; }
      if(++i>256)
      { fprintf(stderr,"Unable to locate errorlevel address\n"); break; }
    }
    /* failure exit */
    remove(infile); remove(outfile);  exit(1);
  }
  else
  { if(sub_shell)
    { if(strlen(fileone))
      { if(!strlen(filetwo))
	writeaddress(segment,test_level,fileone);
	else
	updateaddress(segment,test_level,0,filetwo,fileone);
      }
      exitcode=force_exit? exit_level:test_level+add_level;
    }
    else
    { exitcode=force_exit? exit_level:err_level+add_level;
      if(!no_setenv)
      { if(envname==NULL) envname="err_level";
	while(*envname==' ' || *envname==0x9) envname++;
	i=strlen(envname);
	buffline=fmalloc(i+10);
	movebytes(envname,buffline,i,0);
	buffline[i]='=';
	itoa(err_level, buffline+i+1,10);
	i=setenv(segment,buffline);
	if(!i) fprintf(stderr,"No space to set %s\n",envname);
      }
      if(!quiet_print)
	printf("errorlevel=(%u->%u)",
	  (unsigned) (unsigned char) err_level,
	  (unsigned ) (unsigned char) exitcode);
    }
  }
  return(exitcode);
}
