/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DOS-Utilities. Ver 1.00, last modifyed 94-01-04           *
 * All functions Copyright (c) 1994 by: Guunar Dahlstrm     *
 *                                      Pinnharvsgatan 4A    *
 *                                      S-4129 96 Gothenburg *
 *                                      Sweden               *
 *                  All rights reserved                      *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdlib.h>
#include <ctype.h>
#include "util.h"

static unsigned int Offs;

/* GetEnvSegment finds the master environment block owned and maintained
 *               by COMMAND.COM.
 *
 * Input:   Nothing
 * Returns: Segment address of master environment block
 */
unsigned int GetEnvSegment(void) {
    __asm {
        mov es,_psp         ; Get PSP address in ES
    GES1:
        mov ax,es           ; Copy segment address to AX
        cmp ax,es:[16h]     ; Branch if this program is
        je  GES2            ; its own parent
        mov es,es:[16h]      ; Get parent's PSP address
        jmp GES1            ; Loop back for another try
    GES2:
        mov ax,es:[2Ch]     ; Get environment address
    }
}

/* GetEnvSize: Get's the size if environment.
 *
 * Input:   Segment of environment
 * Returns: Size of environment in bytes
 */
unsigned short GetEnvSize(unsigned int Env) {
    return(*((unsigned short far *)((Env-1)*0x10000L+0x03L))*16);
}

/* GetEnvOffset: Returns the offset adddress of the first free byte (the
 *               terminating zero byte) in an environment block.
 *
 * Input:   Segment of environment
 * Returns: Offset of first free byte
 */
unsigned short GetEnvOffset(unsigned int Env) {
    unsigned short RetVal;

    __asm {
        mov     es,Env              ; Put segment into ES
        cld                         ; Clear direction flag
        xor     al,al               ; Zero AL for SCASB
        xor     di,di               ; Point DI to base of block
        mov     cx,0FFFFh           ; Initialize CX
    GEOLoop:
        repne   scasb               ; Search for a zero byte
        cmp     byte ptr es:[di],0  ; Is the next byte zero, too?
        jne     GEOLoop             ; No, then loop back for more
        mov     RetVal,di           ; Put DI into RetVal
    }
    return RetVal;
}

/* PutEnvVar:   Writes a string to environment.
 * Input:   Buffer - String to write, format "VAR=VALUE"
 *          len - Length to string to write
 * Returns: PEV_OK - if everything is OK!
 *          PEV_NOMEMORY - if there is no memory left for string
 *          PEV_NOVALID - if Buffer is not correct formated
 */
short PutEnvVar(char *Buffer, int len) {
    unsigned short SegEnv, Dest, TotSize;
    int i;
    char Var[256], Value[256], *cp1;

    for(i=0;i<len;i++)
        *(Buffer+i)=toupper(*(Buffer+i));
    len++; // To include the trailing Zero!
    strcpy(Var, Buffer);
    cp1=(char *)strchr(Var, '=');
    if(cp1==NULL)
        return PEV_NOVALID;
    if(*(cp1+1)=='\0')
        return PEV_NOVALID;
    *cp1++='\0';
    strcpy(Value, cp1);
    cp1=FindEnvVar(Var);
    if(*cp1!='\0') {
        DelEnvVar(Var);
    }
    SegEnv=GetEnvSegment();
    TotSize=GetEnvSize(SegEnv);
    Dest=GetEnvOffset(SegEnv);
    if((len+2)>(TotSize-Dest))
        return PEV_NOMEMORY;
    __asm {
        mov es,SegEnv               ; Point ES to segment of environment
        mov si,Buffer               ; Point SI to string
        mov di,Dest                 ; Point DI to destination
        mov cx,len                  ; Load CX whith byte count
        rep movsb                   ; Copy the string
        mov byte ptr es:[di],0      ; Add terminating zero
    }
    return PEV_OK;
}

/* GetFirstString:  Get first string in Master Environment, and initialize
 *                  everything for GetNextString
 * Input:   Segment of Environment
 * Returns: Far pointer to string
 */
char far *GetFirstString(unsigned int Env) {
    char far *cp1;

    Offs=0;
    return (char far *)(Env*0x10000L+(long)Offs);
}

/* GetNextString:   Gets next string in Master Environment, GetFirstString
 *                  must have been executed first!
 * Input:   Segment of Environment
 * Returns: Far pointer to string
 */
char far *GetNextString(unsigned int Env) {
    char far *cp1;

    _asm {
        mov     es,Env              ; Put segment into ES
        cld                         ; Clear direction flag
        xor     al,al               ; Zero AL for SCASB
        mov     di,Offs             ; Point DI to first byte
        mov     cx,0FFFFh           ; Initialize CX
        repne   scasb               ; Search for a zero byte
        mov     Offs,di;
    }
    return (char far *)(Env*0x10000L+(long)Offs);
}

/* FindEnvVar:  Finds a variable in environment
 * Input:   Variable to find
 * Returns: A pointer to a string, points to a empty string if variable can't
 *          be found.
 */
char *FindEnvVar(char *Var) {
    static char Buffer1[256]="";
    char far *cp1;
    unsigned int Env, Offs=0;
    char  Buffer2[256], *cp2;

    Env=GetEnvSegment();
    cp1=(char far *)(Env*0x10000L+(long)Offs);
    sprintf(Buffer2, "%Fs", cp1);
    while(*cp1!=0) {
        if(strnicmp(Buffer2, Var, strlen(Var))==0)
            break;
        _asm {
            mov     es,Env              ; Put segment into ES
            cld                         ; Clear direction flag
            xor     al,al               ; Zero AL for SCASB
            mov     di,Offs             ; Point DI to first byte
            mov     cx,0FFFFh           ; Initialize CX
            repne   scasb               ; Search for a zero byte
            mov     Offs,di;
        }
        cp1=(char far *)(Env*0x10000L+(long)Offs);
        sprintf(Buffer2, "%Fs", cp1);
    }
    if(*cp1!=0) {
        sprintf(Buffer1, "%Fs", cp1);
        cp2=(char *)strchr(Buffer1, '=');
        sprintf(Buffer1, "%s", (cp2+1));
    } else
        Buffer1[0]=0;
    return Buffer1;
}

/* DelEnvVar:   Deletes variable in environment, if it exist
 * Input:   Variable to delete
 * Returns: Nothing
 */
void DelEnvVar(char *Var) {
    unsigned int Env, Offs=0;
    char far *Source, far *Dest;
    unsigned int Antal=0, i;
    char Buffer1[256], Buffer2[256];

    Env=GetEnvSegment();
    Source=(char far *)(Env*0x10000L+(long)Offs);
    sprintf(Buffer2, "%Fs", Source);
    while(*Source!=0) {
        if(strnicmp(Buffer2, Var, strlen(Var))==0)
            break;
        _asm {
            mov     es,Env              ; Put segment into ES
            cld                         ; Clear direction flag
            xor     al,al               ; Zero AL for SCASB
            mov     di,Offs             ; Point DI to first byte
            mov     cx,0FFFFh           ; Initialize CX
            repne   scasb               ; Search for a zero byte
            mov     Offs,di;
        }
        Source=(char far *)(Env*0x10000L+(long)Offs);
        sprintf(Buffer2, "%Fs", Source);
    }
    if(*Source!=0) {
        _asm {
            mov     es,Env              ; Put segment into ES
            cld                         ; Clear direction flag
            xor     al,al               ; Zero AL for SCASB
            mov     di,Offs             ; Point DI to first byte
            mov     cx,0FFFFh           ; Initialize CX
            repne   scasb               ; Search for a zero byte
            mov     Offs,di;
        }
        Dest=(char far *)(Env*0x10000L+(long)Offs);
        Antal=GetEnvSize(Env)-GetEnvOffset(Env);
        for(i=0;i<Antal;i++)
            *(Source+i)=*(Dest+i);
    }
}
