/* =======================================================================
    C25LIB.H - Library of routines for building TMS320C25 simulators
    Copyright (C) 1995 Will Ware

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ======================================================================= */

typedef struct sGLOB
    {
    char name[40];
    int value;
    struct sGLOB *next;
    } symbol;

typedef int (*iufunc) (unsigned int);
extern iufunc pwaitf, dwaitf, iwaitf;

/* Interrupt types */
enum int_type { RS, INT0, INT1, INT2, TINT, RINT, XINT, TRAP };

extern int arp, ov, ovm, intm, dp;
extern int arb, cnf, tc, sxm, c, hm, fsm, xf, fo, txm, pm;
extern long int accumulator, p_register;
extern unsigned int pc;
extern int t_register, _stack[8], _sp, ar[8];
extern int mp_mc_mode;
extern int ports[16], bio;
extern int drr, dxr, tim, prd, imr, greg;

extern unsigned long int steps_taken, cycles;
extern int warn_progmem_writes;

extern int *program_memory_address(int a);
extern void write_program_memory(int a, int d);
extern int read_program_memory(int a);
extern int *data_memory_address(int a);
extern void write_data_memory(int a, int d);
extern int read_data_memory(int a);
extern void advance(void);
extern void initialize_simulator(void);
extern void c25_reset(void);
extern void c25_interrupt(enum int_type n);

extern void load_hex_files(char *word);
extern int lookup_symbol(char *name);
extern char * disassemble(int instruc);
extern int print_matching_symbols(int a);
extern int print_all_symbols(void);
extern void short_report(void);
extern void long_report(void);
extern void add_breakpoint(int a);
extern void delete_breakpoint(int a);
extern void clear_all_breakpoints(void);
extern int go_til_breakpoint(long int n);
