/******************************************************************************
 * NOTE: This file has been modified for use with MSDOS and the WATCOM C/386
 * compiler.  Darryl Okahata, March 1993.
 *****************************************************************************/

/* 90.1.31  modified for Nemacs Ver.3.3.1 by K.Handa
 	LPASS8 is set in child process for 8 bit transmission. */
/* Demacs 1.1.1 91/10/16 HIRANO Satoshi  	*/
/* Demacs 1.1.2 91/10/20 Manabu Higashida	*/
/* Demacs 1.1.3 91/10/23 Manabu Higashida	*/

/* Interfaces to system-dependent kernel and library entries.
   Copyright (C) 1985, 1986, 1987, 1988, 1990 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* This must precede sys/signal.h on certain machines.  */
#include <stdio.h>
#include <sys/stat.h>
#include <errno.h>

#include <sys/types.h>
#include <signal.h>
#include <setjmp.h>

#include "config.h"
#include "lisp.h"
#undef NULL

#define min(x,y) ((x) > (y) ? (y) : (x))

/* In this file, open, read and write refer to the system calls,
   not our sugared interfaces  sys_open, sys_read and sys_write.
   Contrariwise, for systems where we use the system calls directly,
   define sys_read, etc. here as aliases for them.  */
#ifndef read
#define sys_read read
#define sys_write write
#endif /* `read' is not a macro */

#undef read
#undef write

#ifndef close
#define sys_close close
#else 
#undef close
#endif

#ifndef open
#define sys_open open
#else /* `open' is a macro */
#undef open
#endif /* `open' is a macro */

#ifndef __WATCOMC__
extern int errno;
#endif
#ifndef VMS
extern char *sys_errlist[];
#endif


#ifndef BSD4_1
#ifdef BSD /* this is done this way to avoid defined (BSD) || defined (USG)
	      because the vms compiler doesn't grok `defined' */
#include <fcntl.h>
#endif
#ifdef USG
#include <fcntl.h>
#endif
#endif /* not 4.1 bsd */

/* Get DGUX definition for FASYNC - DJB */
#ifdef DGUX
#include <sys/file.h>
#endif /* DGUX */

#ifdef BSD
#include <sys/ioctl.h>
#ifdef BSD4_1
#include <wait.h>
#else /* not 4.1 */
#include <sys/wait.h>
#endif /* not 4.1 */
#endif /* BSD */

#ifdef STRIDE
#include <sys/ioctl.h>
#endif 

#ifdef NEED_TERMIOS
#include <sys/termios.h>
#endif

#ifdef mips
#include <sys/ioctl.h>
#endif 

#ifdef _SEQUENT_
#include <sys/stropts.h>
#endif /* _SEQUENT_ */

#ifdef AIX
/* Get files for keyboard remapping */
#define HFNKEYS 2
#include <sys/hft.h>
#include <sys/devinfo.h>
#endif

/* Get rid of LLITOUT in 4.1, since it is said to stimulate kernel bugs.  */
#ifdef BSD4_1
#undef LLITOUT
#define LLITOUT 0
#endif /* 4.1 */

#ifdef HAVE_TERMIO
#if defined(AIX) && defined(i386)
#include <termios.h>		/* needs to be before termio.h for aix ps/2  */
#endif
#ifndef NO_TERMIO
#include <termio.h>
#endif
#ifdef HAVE_TCATTR
#define TERMINAL struct termios
#else /* not HAVE_TCATTR */
#define TERMINAL struct termio
#endif /* not HAVE_TCATTR */

#ifdef IBMR2AIX
#include <termios.h>
#ifdef TIOCGETP
#undef TIOCGETP
#endif /* no TIOCGETP */
#define TIOCGETP TCGETS
#undef TIOCSETN
#define TIOCSETN TCSETSW
#undef TIOCSETP
#define TIOCSETP TCSETSF
#undef TCSETAW
#define TCSETAW TCSETS
#else /* not IBMR2AIX */
#ifdef HAVE_TCATTR
#include <termios.h>
#endif /* HAVE_TCATTR */
#undef TIOCGETP
#define TIOCGETP TCGETA
#undef TIOCSETN
#define TIOCSETN TCSETAW
#undef TIOCSETP
#define TIOCSETP TCSETAF
#endif /* not IBMR2AIX */

/* Try to establish the correct character to disable terminal functions
   in a system-independent manner.  Note that USG (at least) define
   _POSIX_VDISABLE as 0!  */
#ifdef _POSIX_VDISABLE
#define CDISABLE _POSIX_VDISABLE
#else /* not _POSIX_VDISABLE */
#ifdef CDEL
#define CDISABLE CDEL
#else /* not CDEL */
#define CDISABLE 255
#endif /* not CDEL */
#endif /* not _POSIX_VDISABLE */

#ifndef OSPEED
#define OSPEED(str) (str.c_cflag & CBAUD)
#endif
#ifndef SETOSPEED
#define SETOSPEED(str,new) (str.c_cflag = (str.c_cflag & ~CBAUD) | (new))
#endif
#define TABS_OK(str) ((str.c_oflag & TABDLY) != TAB3)
#endif /* HAVE_TERMIO */

#ifndef HAVE_TCATTR /* If HAVE_TCATTR, this is a primitive.  */
#define tcgetattr(fd, addr) ioctl (fd, TIOCGETP, addr)
#endif

#ifdef XENIX
#undef TIOCGETC  /* Avoid confusing some conditionals that test this.  */
#endif

#ifdef BROKEN_TIOCGETC
#undef TIOCGETC
#endif

#ifdef BROKEN_TIOCGWINSZ
#undef TIOCGWINSZ
#endif

#ifndef HAVE_TERMIO
#ifndef VMS
#if !defined(MSDOS)
#if defined(DGUX) && defined(_BSD_TTY_FLAVOR)
#undef _BSD_TTY_FLAVOR
    /* DGUX 4.3 has it's own definition in sgtty.h, and it's different
       than the one in s-dgux.h */
#endif
#include <sgtty.h>
#define TERMINAL struct sgttyb
#ifndef OSPEED
#define OSPEED(str) str.sg_ospeed
#endif
#ifndef SETOSPEED
#define SETOSPEED(str,new) (str.sg_ospeed = (new))
#endif
#define TABS_OK(str) ((str.sg_flags & XTABS) != XTABS)
#undef TCSETAW
#define TCSETAW TIOCSETN
#endif /* not VMS */
#endif /* not MSDOS */
#endif /* not HAVE_TERMIO */

#ifdef USG
#include <sys/utsname.h>
#include <string.h>
#ifndef MEMORY_IN_STRING_H
#include <memory.h>
#endif
#ifdef TIOCGWINSZ
#ifndef IRIS_4D
#ifndef mips
#ifndef aix386
#ifndef NO_SIOCTL_H
/* Some USG systems with TIOCGWINSZ need this file; some don't have it.
   We don't know how to distinguish them.
   If this #include gets an error, just delete it.  */
#include <sys/sioctl.h>
#endif
#ifdef NEED_PTEM_H
#include <sys/stream.h>
#include <sys/ptem.h>
#endif
#endif /* not aix386 */
#endif /* not mips */
#endif /* not IRIS_4D */
#endif /* TIOCGWINSZ */
#ifdef HAVE_TIMEVAL
#ifdef HPUX
#include <time.h>
#else
#include <sys/time.h>
#endif
#endif /* HAVE_TIMEVAL */
#endif /* USG */
  
#ifdef NEED_BSDTTY
#include <sys/bsdtty.h>
#endif 

#if defined (HPUX) && defined (HAVE_PTYS)
#include <sys/ptyio.h>
#endif
  
#ifdef AIX
#include <sys/pty.h>
#include <unistd.h>
#endif /* AIX */

#ifdef SYSV_PTYS
#include <sys/tty.h>
#include <sys/pty.h>
#endif

#include "filetypes.h"

/* FASYNC defined in this file. But, FASYNC don't working.
   so no problem, because unrequest_sigio only need. */
#if defined (pfa)
#include <sys/file.h>
#endif

#ifdef BROKEN_FIONREAD
#undef FIONREAD
#undef FASYNC
#endif

extern int quit_char;

#include "termhooks.h"
#include "termchar.h"
#include "termopts.h"
#include "dispextern.h"

#ifdef NONSYSTEM_DIR_LIBRARY
#include "ndir.h"
#endif /* NONSYSTEM_DIR_LIBRARY */

#include "emacssignal.h"

/* Define SIGCHLD as an alias for SIGCLD.  There are many conditionals
   testing SIGCHLD.  */

#ifndef VMS
#ifdef SIGCLD
#ifndef SIGCHLD
#define SIGCHLD SIGCLD
#endif /* not SIGCHLD */
#endif /* SIGCLD */
#endif /* not VMS */

#ifdef MSDOS	/* Demacs 1.1.1 91/10/16 HIRANO Satoshi */
struct dostmode {
    int ctrlc;
    int flags;
    unsigned char baud;
};
#define TERMINAL struct dostmode
#define OSPEED(str) (str.baud)
#define TABS_OK(str) 0
#endif /* MSDOS */

static int baud_convert[] =
#ifdef BAUD_CONVERT
  BAUD_CONVERT;
#else
  {
    0, 50, 75, 110, 135, 150, 200, 300, 600, 1200,
    1800, 2400, 4800, 9600, 19200, 38400
  };
#endif

extern short ospeed;


discard_tty_input ()
{
  TERMINAL buf;

  if (noninteractive)
    return;

  /* Discarding input is not safe when the input could contain
     replies from the X server.  So don't do it.  */
  if (read_socket_hook)
    return;

#ifdef MSDOS
  while (dos_keyread() != -1)
  	;
#else	/* not MSDOS */
#ifdef APOLLO
  {
    int zero = 0;
    ioctl (0, TIOCFLUSH, &zero);
  }
#else /* not Apollo */
  tcgetattr (0, &buf);
#ifndef HAVE_TCATTR
  ioctl (0, TIOCSETP, &buf);
#else
  tcsetattr (0, TCSAFLUSH, &buf);
#endif
#endif /* not Apollo */
#endif /* not MSDOS */
}

#ifdef SIGTSTP

stuff_char (c)
     char c;
{
/* Should perhaps error if in batch mode */
#ifdef TIOCSTI
  ioctl (0, TIOCSTI, &c);
#else /* no TIOCSTI */
  error ("Cannot stuff terminal input characters in this version of Unix.");
#endif /* no TIOCSTI */
}

#endif /* SIGTSTP */

init_baud_rate ()
{
  TERMINAL sg;

  if (noninteractive)
    ospeed = 0;
  else
    {
#ifdef MSDOS	/* Demacs 1.1.1 91/10/16 HIRANO Satoshi */
      sg.baud = 15; /* 38400 baud since we use console */
#else	/* not MSDOS */
      SETOSPEED (sg, B9600);
      tcgetattr (0, &sg);
#endif	/* not MSDOS */
      ospeed = OSPEED (sg);
    }
  
  baud_rate = (ospeed < sizeof baud_convert / sizeof baud_convert[0]
	       ? baud_convert[ospeed] : 9600);
  if (baud_rate == 0)
    baud_rate = 1200;
}

/*ARGSUSED*/
set_exclusive_use (fd)
     int fd;
{
#ifdef FIOCLEX
  ioctl (fd, FIOCLEX, 0);
#endif
  /* Ok to do nothing if this feature does not exist */
}

#ifndef subprocesses

wait_without_blocking ()
{
#ifdef BSD
  wait3 (0, WNOHANG | WUNTRACED, 0);
#else
  croak ("wait_without_blocking");
#endif
}

#endif /* not subprocesses */

int wait_debugging;   /* Set nonzero to make following function work under dbx
		         (at least for bsd).  */

/* Wait for subprocess with process id `pid' to terminate and
   make sure it will get eliminated (not remain forever as a zombie) */

wait_for_termination (pid)
     int pid;
{
  while (1)
    {
#ifdef subprocesses
#if defined (BSD) || (defined (HPUX) && !defined (HPUX_5))
      /* Note that kill returns -1 even if the process is just a zombie now.
	 But inevitably a SIGCHLD interrupt should be generated
	 and child_sig will do wait3 and make the process go away. */
      /* There is some indication that there is a bug involved with
	 termination of subprocesses, perhaps involving a kernel bug too,
	 but no idea what it is.  Just as a hunch we signal SIGCHLD to see
	 if that causes the problem to go away or get worse.  */
#ifdef BSD4_1
      extern int synch_process_pid;
      sighold (SIGCHLD);
      if (synch_process_pid == 0)
	{
          sigrelse (SIGCHLD);
	  break;
	}
      if (wait_debugging)
	sleep (1);
      else
	sigpause (SIGCHLD);
#else /* not BSD4_1 */
      sigsetmask (sigmask (SIGCHLD));
      if (0 > kill (pid, 0))
        {
	  sigsetmask (SIGEMPTYMASK);
	  kill (getpid (), SIGCHLD);
	  break;
	}
      if (wait_debugging)
	sleep (1);
      else
	sigpause (SIGEMPTYMASK);
#endif /* not BSD4_1 */
#else /* not BSD, and not HPUX version >= 6 */
#ifdef UNIPLUS
      if (0 > kill (pid, 0))
	break;
      wait (0);
#else /* neither BSD nor UNIPLUS: random sysV */
#ifdef HAVE_SYSV_SIGPAUSE
      sighold (SIGCHLD);
      if (0 > kill (pid, 0))
	{
	  sigrelse (SIGCHLD);
	  break;
	}
      sigpause (SIGCHLD);
#else /* not HAVE_SYSV_SIGPAUSE */
      if (0 > kill (pid, 0))
	break;
      /* Using sleep instead of pause avoids timing error.
	 If the inferior dies just before the sleep,
	 we lose just one second.  */
      sleep (1);
#endif /* not HAVE_SYSV_SIGPAUSE */
#endif /* not UNIPLUS */
#endif /* not BSD, and not HPUX version >= 6 */
#else /* not subprocesses */
#ifndef BSD4_1
      if (0 > kill (pid, 0))
	break;
      sleep (1);
#else /* BSD4_1 */
      int status;
      status = wait (0);
      if (status == pid || status == -1)
	break;
#endif /* BSD4_1 */
#endif /* not subprocesses */
    }
}

#ifdef subprocesses

/*
 *	flush any pending output
 *      (may flush input as well; it does not matter the way we use it)
 */
 
flush_pending_output (channel)
     int channel;
{
#ifdef TCFLSH
  ioctl (channel, TCFLSH, 1);
#else
#ifdef TIOCFLUSH
  int zero = 0;
  /* 3rd arg should be ignored
     but some 4.2 kernels actually want the address of an int
     and nonzero means something different.  */
  ioctl (channel, TIOCFLUSH, &zero);
#endif
#endif
}

/*  Set up the terminal at the other end of a pseudo-terminal that
    we will be controlling an inferior through.
    It should not echo or do line-editing, since that is done
    in Emacs.  No padding needed for insertion into an Emacs buffer.  */

child_setup_tty (out)
     int out;
{
  TERMINAL s;

  tcgetattr (out, &s);
#ifdef HAVE_TERMIO
  s.c_oflag |= OPOST;		/* Enable output postprocessing */
  s.c_oflag &= ~ONLCR;		/* Disable map of NL to CR-NL on output */
  s.c_oflag &= ~(NLDLY|CRDLY|TABDLY|BSDLY|VTDLY|FFDLY);	/* No output delays */
  s.c_lflag &= ~ECHO;		/* Disable echo */
  s.c_lflag |= ISIG;		/* Enable signals */
  s.c_iflag &= ~IUCLC;		/* Disable map of upper case to lower on input */
  s.c_oflag &= ~OLCUC;		/* Disable map of lower case to upper on output */
/* said to be unnecesary
  s.c_cc[VMIN] = 1;		/* minimum number of characters to accept
  s.c_cc[VTIME] = 0;		/* wait forever for at least 1 character
*/
  s.c_lflag |= ICANON;		/* Enable erase/kill and eof processing */
  s.c_cc[VEOF] = 04;		/* insure that EOF is Control-D */
  s.c_cc[VERASE] = 0377;	/* disable erase processing */
  s.c_cc[VKILL] = 0377;		/* disable kill processing */
#ifdef IRIS_4D /* This is needed for the sake of process_send_signal.
		  Probably a wide class of systems need something like this,
		  but in 18.58, let's be cautious.  */
  s.c_cc[VSWTCH] = 032;
#endif
#ifdef HPUX
  s.c_cflag = (s.c_cflag & ~CBAUD) | B9600; /* baud rate sanity */
#endif /* HPUX */

#ifdef AIX
/* AIX enhanced edit loses NULs, so disable it */
#ifndef IBMR2AIX
  s.c_line = 0;
  s.c_iflag &= ~ASCEDIT;
#endif
  /* Also, PTY overloads NUL and BREAK.
     don't ignore break, but don't signal either, so it looks like NUL.  */
  s.c_iflag &= ~IGNBRK;
  s.c_iflag &= ~BRKINT;
#if defined(TIOCGPGRP) && defined(TIOCGLTC) && defined(TIOCGETC)
  /* the QUIT and INTR character are used in process_send_signal
     so set them here to something useful.  */
  if (s.c_cc[VQUIT] == 0377)
    s.c_cc[VQUIT] = '\\'&037;	/* Control-\ */
  if (s.c_cc[VINTR] == 0377)
    s.c_cc[VINTR] = 'C'&037;	/* Control-C */
#else /* no TIOCGPGRP or no TIOCGLTC or no TIOCGETC */
  /* QUIT and INTR are sent using system calls, so disable character forms.  */
  s.c_cc[VQUIT] = 0377;
  s.c_cc[VINTR] = 0377;
  s.c_lflag &= ~ISIG;
#endif /* no TIOCGPGRP or no TIOCGLTC or no TIOCGETC */
  s.c_cc[VEOL] = 0377;
  s.c_cflag = (s.c_cflag & ~CBAUD) | B9600; /* baud rate sanity */
#endif /* AIX */

#else /* not HAVE_TERMIO */
  s.sg_flags &= ~(ECHO | CRMOD | ANYP | ALLDELAY | RAW | LCASE | CBREAK | TANDEM);
  s.sg_erase = 0377;
  s.sg_kill = 0377;
#endif /* not HAVE_TERMIO */

#ifndef HAVE_TCATTR
  ioctl (out, TIOCSETN, &s);
#else
  tcsetattr (out, TCSADRAIN, &s);
#endif

#ifdef BSD4_1
  if (interrupt_input)
    reset_sigio ();
#endif /* BSD4_1 */
#ifdef RTU
  {
    int zero = 0;
    ioctl (out, FIOASYNC, &zero);
  }
#endif /* RTU */
}

#endif /* subprocesses */

/*ARGSUSED*/
setpgrp_of_tty (pid)
     int pid;
{
#ifdef IBMR2AIX
  tcsetpgrp ( 0, pid);
#else
#ifdef TIOCSPGRP
  ioctl (0, TIOCSPGRP, &pid);
#else
  /* Just ignore this for now and hope for the best */
#endif
#endif
}

/* Record a signal code and the handler for it.  */
struct save_signal
{
  int code;
  int (*handler) ();
};

/* Suspend the Emacs process; give terminal to its superior.  */

sys_suspend ()
{
#ifdef SIGTSTP
#ifdef BSD
  killpg (getpgrp (0), SIGTSTP);
#else
  kill (-getpgrp (0), SIGTSTP);
#endif

#else
#ifdef USG_JOBCTRL /* If you don't know what this is don't mess with it */
  ptrace (0, 0, 0, 0);		/* set for ptrace - caught by csh */
  kill (getpid (), SIGQUIT);

#else

#ifdef MSDOS
  char *sh;
  int st;
  int pid = 0;
  char oldwd[MAXPATHLEN+1];
#else	/* not MSDOS */

/* On a system where suspending is not implemented,
   instead fork a subshell and let it talk directly to the terminal
   while we wait.  */
  int pid = fork ();
  struct save_signal saved_handlers[5];

  saved_handlers[0].code = SIGINT;
  saved_handlers[1].code = SIGQUIT;
  saved_handlers[2].code = SIGTERM;
#ifdef SIGIO
  saved_handlers[3].code = SIGIO;
  saved_handlers[4].code = 0;
#else
  saved_handlers[3].code = 0;
#endif

  if (pid == -1)
    error ("Can't spawn subshell");
#endif	/* not MSDOS */
  if (pid == 0)
    {
      char *sh;

#ifdef MSDOS
      if ((sh = getenv("SHELL")) == 0 || ((sh = getenv("COMSPEC")) == 0))
	sh = "command.com";

      getwd(oldwd);
#else	/* not MSDOS */
      sh = (char *) egetenv ("SHELL");
      if (sh == 0)
	sh = "sh";
#endif	/* not MSDOS */
      /* Use our buffer's default directory for the subshell.  */
      {
	Lisp_Object dir;
	unsigned char *str;
	int len;

	/* mentioning current_buffer->buffer would mean including buffer.h,
	   which somehow wedges the hp compiler.  So instead... */

	dir = intern ("default-directory");
	/* Can't use NULL */
	if (XFASTINT (Fboundp (dir)) == XFASTINT (Qnil))
	  goto xyzzy;
	dir = Fsymbol_value (dir);
	if (XTYPE (dir) != Lisp_String)
	  goto xyzzy;

	str = (unsigned char *) alloca (XSTRING (dir)->size + 2);
	len = XSTRING (dir)->size;
	bcopy (XSTRING (dir)->data, str, len);
	if (str[len - 1] != '/') str[len++] = '/';
	str[len] = 0;
	chdir (str);
      }
    xyzzy:
#ifdef subprocesses
      close_process_descs ();	/* Close Emacs's pipes/ptys */
#endif
#ifdef MSDOS	/* Demacs 1.1.2 91/10/20 Manabu Higashida */
      st = system (sh);
      chdir (oldwd);
      if (st)
        report_file_error ("Can't execute subshell", Fcons (build_string (sh), Qnil));
#else	/* not MSDOS */
      execlp (sh, sh, 0);
      write (1, "Can't execute subshell", 22);
      _exit (1);
#endif	/* not MSDOS */
    }
#ifndef MSDOS
  save_signal_handlers (saved_handlers);
  wait_for_termination (pid);
  restore_signal_handlers (saved_handlers);
#endif /* not MSDOS */
#endif /* no USG_JOBCTRL */
#endif /* no SIGTSTP */
}

save_signal_handlers (saved_handlers)
     struct save_signal *saved_handlers;
{
  while (saved_handlers->code)
    {
      saved_handlers->handler
	= (int (*) ()) signal (saved_handlers->code, SIG_IGN);
      saved_handlers++;
    }
}

restore_signal_handlers (saved_handlers)
     struct save_signal *saved_handlers;
{
  while (saved_handlers->code)
    {
      signal (saved_handlers->code, saved_handlers->handler);
      saved_handlers++;
    }
}

#ifdef F_SETFL

int old_fcntl_flags;

init_sigio ()
{
#ifdef FASYNC
  old_fcntl_flags = fcntl (0, F_GETFL, 0) & ~FASYNC;
#endif
  request_sigio ();
}

reset_sigio ()
{
  unrequest_sigio ();
}

#ifdef FASYNC		/* F_SETFL does not imply existance of FASYNC */

request_sigio ()
{
#ifdef SIGWINCH
  sigunblock (sigmask (SIGWINCH));
#endif
  fcntl (0, F_SETFL, old_fcntl_flags | FASYNC);

  interrupts_deferred = 0;
}

unrequest_sigio ()
{
#ifdef SIGWINCH
  sigblock (sigmask (SIGWINCH));
#endif
  fcntl (0, F_SETFL, old_fcntl_flags);
  interrupts_deferred = 1;
}

#else /* no FASYNC */
#ifdef STRIDE		/* Stride doesn't have FASYNC - use FIOASYNC */

request_sigio ()
{
  int on = 1;
  ioctl (0, FIOASYNC, &on);
  interrupts_deferred = 0;
}

unrequest_sigio ()
{
  int off = 0;

  ioctl (0, FIOASYNC, &off);
  interrupts_deferred = 1;
}

#else /* not FASYNC, not STRIDE */
 
request_sigio ()
{
  croak ("request_sigio");
}
 
unrequest_sigio ()
{
  croak ("unrequest_sigio");
}
 
#endif /* STRIDE */
#endif /* FASYNC */
#endif /* F_SETFL */

TERMINAL old_gtty;		/* The initial tty mode bits */

int term_initted;		/* 1 if outer tty status has been recorded */

#ifdef F_SETOWN
int old_fcntl_owner;
#endif /* F_SETOWN */

#ifdef TIOCGLTC
struct ltchars old_ltchars;
#endif /* TIOCGLTC */

#ifdef TIOCGETC
struct tchars old_tchars;
int old_lmode;

int lmode;			/* Current lmode value. */
				/* Needed as global for 4.1 */
#endif /* TIOCGETC */

/* This may also be defined in stdio,
   but if so, this does no harm,
   and using the same name avoids wasting the other one's space.  */

#if defined (USG) || defined (DGUX)
unsigned char _sobuf[BUFSIZ+8];
#else
char _sobuf[BUFSIZ];
#endif
 
#ifdef TIOCGLTC
static struct ltchars new_ltchars = {-1,-1,-1,-1,-1,-1};
#endif
#ifdef TIOCGETC
  static struct tchars new_tchars = {-1,-1,-1,-1,-1,-1};
#endif 

init_sys_modes ()
{
  TERMINAL tty;
#ifdef TIOCGETC
  struct tchars tchars;
#endif
#ifdef MSDOS	/* Demacs 1.1.2 91/10/20 Manabu Higashida */
  static int dos_ttraw ();
#endif

  if (noninteractive)
    return;

#ifndef MSDOS
  tcgetattr (0, &old_gtty);
#endif /* not MSDOS */
  if (!read_socket_hook)
    {
#ifdef MSDOS
      static int dos_ttraw ();

      dos_ttraw ();
#else	/* not MSDOS */
      tty = old_gtty;

#ifdef HAVE_TERMIO
      tty.c_iflag |= (IGNBRK);	/* Ignore break condition */
      tty.c_iflag &= ~ICRNL;	/* Disable map of CR to NL on input */
#ifdef ISTRIP
      tty.c_iflag &= ~ISTRIP;	/* don't strip 8th bit on input */
#endif
      tty.c_lflag &= ~ECHO;	/* Disable echo */
      tty.c_lflag &= ~ICANON;	/* Disable erase/kill processing */
#ifdef IEXTEN
      tty.c_iflag &= ~IEXTEN;	/* Disable other editing characters.  */
#endif
      tty.c_lflag |= ISIG;	/* Enable signals */
      if (flow_control)
	{
	  tty.c_iflag |= IXON;	/* Enable start/stop output control */
#ifdef IXANY
	  tty.c_iflag &= ~IXANY;
#endif /* IXANY */
	}
      else
	tty.c_iflag &= ~IXON;	/* Disable start/stop output control */
      tty.c_oflag &= ~ONLCR;	/* Disable map of NL to CR-NL on output */
      tty.c_oflag &= ~TAB3;	/* Disable tab expansion */
#ifdef CS8
      tty.c_cflag |= CS8;	/* allow 8th bit on input */
      tty.c_cflag &= ~PARENB;	/* Don't check parity */
#endif
      tty.c_cc[VINTR] = quit_char;	/* ^G gives SIGINT */
      /* Set up C-g (usually) for both SIGQUIT and SIGINT.
	 We don't know which we will get, but we handle both alike
	 so which one it really gives us does not matter.  */
      tty.c_cc[VQUIT] = quit_char;
      tty.c_cc[VMIN] = 1;	/* Input should wait for at least 1 char */
      tty.c_cc[VTIME] = 0;	/* no matter how long that takes.  */
#ifdef VSWTCH
      tty.c_cc[VSWTCH] = CDISABLE;	/* Turn off shell layering use of C-z */
#endif /* VSWTCH */
#if defined (mips) || defined (HAVE_TCATTR)
#ifdef VSUSP
      tty.c_cc[VSUSP] = CDISABLE;	/* Turn off mips handling of C-z.  */
#endif /* VSUSP */
#ifdef V_DSUSP
      tty.c_cc[V_DSUSP] = CDISABLE;	/* Turn off mips handling of C-y.  */
#endif /* V_DSUSP */
#ifdef VDSUSP /* Some systems use VDSUSP instead of VD_SUSP.  */
      tty.c_cc[VDSUSP] = CDISABLE;
#endif /* VDSUSP */
#endif /* mips or HAVE_TCATTR */

#ifdef AIX
#ifndef IBMR2AIX
      /* AIX enhanced edit loses NULs, so disable it */
      tty.c_line = 0;
      tty.c_iflag &= ~ASCEDIT;
#else
      tty.c_cc[VSTRT] = 255;
      tty.c_cc[VSTOP] = 255;
      tty.c_cc[VSUSP] = 255;
      tty.c_cc[VDSUSP] = 255;
#endif /* IBMR2AIX */
      /* Also, PTY overloads NUL and BREAK.
	 don't ignore break, but don't signal either, so it looks like NUL.
	 This really serves a purpose only if running in an XTERM window
	 or via TELNET or the like, but does no harm elsewhere.  */
      tty.c_iflag &= ~IGNBRK;
      tty.c_iflag &= ~BRKINT;
#endif /* AIX */

#else /* if not HAVE_TERMIO */
      tty.sg_flags &= ~(ECHO | CRMOD | XTABS);
      tty.sg_flags |= ANYP;
      tty.sg_flags |= interrupt_input ? RAW : CBREAK;
#endif /* not HAVE_TERMIO */

#ifndef HAVE_TCATTR
      ioctl (0, TIOCSETN, &tty);
#else
      tcsetattr (0, TCSADRAIN, &tty);
#endif

      /* This code added to insure that, if flow-control is not to be used,
	 we have an unlocked screen at the start. */
#ifdef TCXONC
      if (!flow_control) ioctl (0, TCXONC, 1);
#endif
#ifndef APOLLO
#ifdef TIOCSTART
      if (!flow_control) ioctl (0, TIOCSTART, 0);
#endif
#endif

#ifdef AIX
      hft_init ();
#ifdef IBMR2AIX
  {
    /* IBM's HFT device usually thinks a ^J should be LF/CR.  We need it
       to be only LF.  This is the way that is done. */
    struct termio tty;

    if (ioctl (1, HFTGETID, &tty) != -1)
      write (1, "\033[20l", 5);
  }
#endif
#endif

#ifdef F_SETFL
#ifdef F_GETOWN		/* F_SETFL does not imply existance of F_GETOWN */
      if (interrupt_input)
	{
	  old_fcntl_owner = fcntl (0, F_GETOWN, 0);
	  fcntl (0, F_SETOWN, getpid ());
	  init_sigio ();
	}
#endif /* F_GETOWN */
#endif /* F_SETFL */

      /* If going to use CBREAK mode, we must request C-g to interrupt
	   and turn off start and stop chars, etc.
	   If not going to use CBREAK mode, do this anyway
	   so as to turn off local flow control for user coming over
	   network on 4.2; in this case, only t_stopc and t_startc really matter.  */
#ifdef TIOCGLTC
      ioctl (0, TIOCGLTC, &old_ltchars);
#endif /* TIOCGLTC */
#ifndef HAVE_TERMIO
#ifdef TIOCGETC
      ioctl (0, TIOCGETC, &old_tchars);
      ioctl (0, TIOCLGET, &old_lmode);

      /* Note: if not using CBREAK mode, it makes no difference how we set this */
      tchars = new_tchars;
      tchars.t_intrc = quit_char;
      if (flow_control)
	{
	  tchars.t_startc = '\021';
	  tchars.t_stopc = '\023';
	}
/* LPASS8 is new in 4.3, and makes cbreak mode provide all 8 bits.  */
#ifndef LPASS8
#define LPASS8 0
#endif

#ifdef BSD4_1
#define LNOFLSH 0100000
#endif

      lmode = LDECCTQ | LLITOUT | LPASS8 | LNOFLSH | old_lmode;

      ioctl (0, TIOCSETC, &tchars);
      ioctl (0, TIOCLSET, &lmode);
#endif /* TIOCGETC */
#endif /* not HAVE_TERMIO */
#ifdef TIOCGLTC
      ioctl (0, TIOCSLTC, &new_ltchars);
#endif /* TIOCGLTC */

#ifdef BSD4_1
      if (interrupt_input)
	init_sigio ();
#endif
#endif	/* not MSDOS */
    }
#ifdef _IOFBF
  /* This symbol is defined on recent USG systems.
     Someone says without this call USG won't really buffer the file
     even with a call to setbuf. */
  setvbuf (stdout, _sobuf, _IOFBF, sizeof _sobuf);
#else
  setbuf (stdout, _sobuf);
#endif
  set_terminal_modes ();
  if (term_initted && no_redraw_on_reenter)
    {
      if (display_completed)
	direct_output_forward_char (0);
    }
  else
    screen_garbaged = 1;
  term_initted = 1;
}

/* Return nonzero if safe to use tabs in output.
   At the time this is called, init_sys_modes has not been done yet.  */
   
tabs_safe_p ()
{
#ifdef MSDOS
  return (1);
#else
  TERMINAL tty;
  if (noninteractive)
    return 1;
  tcgetattr (0, &tty);
  return (TABS_OK (tty));
#endif	/* not MSDOS */
}

/* Get terminal size from system.
   Store number of lines into *heightp and width into *widthp.
   If zero or a negative number is stored, the value is not valid.  */

get_screen_size (widthp, heightp)
     int *widthp, *heightp;
{
#ifdef MSDOS	/* Demacs 1.1.2 91/10/20 Manabu Higashida */
  char *e;

  e = egetenv("COLUMNS");
  if (!e)
    *widthp = 0;
  else
    *widthp = atoi(e);

  e = egetenv("ROWS");
  if (!e)
    e = getenv("LINES");	/* just like SYSV */
  if (!e)
    *heightp = 0;
  else
    *heightp = atoi(e);
#else	/* not MSDOS */
/* Define the 4.3 names in terms of the Sun names
   if the latter exist and the former do not.  */
#ifdef TIOCGSIZE
#ifndef TIOCGWINSZ
#define TIOCGWINSZ TIOCGSIZE
#define winsize ttysize
#define ws_row ts_lines
#define ws_col ts_cols
#endif
#endif /* Sun */

/* Do it using the 4.3 names if possible.  */
#ifdef TIOCGWINSZ
  struct winsize size;
  *widthp = 0;
  *heightp = 0;
  if (ioctl (0, TIOCGWINSZ, &size) < 0)
    return;
  *widthp = size.ws_col;
  *heightp = size.ws_row;
#else /* not TIOCGWNSIZ */
  *widthp = 0;
  *heightp = 0;
#endif /* system does not know size */
#endif /* not MSDOS */
}

reset_sys_modes ()
{
#ifdef MSDOS	/* Demacs 1.1.2 91/10/20 Manabu Higashida */
  static int dos_ttcooked ();
#endif

  if (noninteractive)
    {
      fflush (stdout);
      return;
    }
  if (!term_initted)
    return;
  if (read_socket_hook)
    return;
  move_cursor (screen_height - 1, 0);
  clear_end_of_line (screen_width);
  /* clear_end_of_line may move the cursor */
  move_cursor (screen_height - 1, 0);
  /* Output raw CR so kernel can track the cursor hpos.  */
  cmputc ('\r');
#ifdef IBMR2AIX
  {
    /* HFT devices normally use ^J as a LF/CR.  We forced it to 
       do the LF only.  Now, we need to reset it. */
    struct termio tty;

    if (ioctl (1, HFTGETID, &tty) != -1)
      write (1, "\033[20h", 5);
  }
#endif

  reset_terminal_modes ();
  fflush (stdout);
#ifdef MSDOS
  dos_ttcooked ();
#else	/* not MSDOS */
#ifdef BSD
#ifndef BSD4_1
  /* Avoid possible loss of output when changing terminal modes.  */
  fsync (fileno (stdout));
#endif
#endif
#ifdef TIOCGLTC
  ioctl (0, TIOCSLTC, &old_ltchars);
#endif /* TIOCGLTC */
#ifndef HAVE_TERMIO
#ifdef TIOCGETC
  ioctl (0, TIOCSETC, &old_tchars);
  ioctl (0, TIOCLSET, &old_lmode);
#endif /* TIOCGETC */
#endif /* not HAVE_TERMIO */
#ifdef F_SETFL
#ifdef F_SETOWN		/* F_SETFL does not imply existance of F_SETOWN */
  if (interrupt_input)
    {
      reset_sigio ();
      fcntl (0, F_SETOWN, old_fcntl_owner);
    }
#endif /* F_SETOWN */
#endif /* F_SETFL */
#ifdef BSD4_1
  if (interrupt_input)
    reset_sigio ();
#endif /* BSD4_1 */
#ifndef HAVE_TCATTR
  while (ioctl (0, TCSETAW, &old_gtty) < 0 && errno == EINTR);
#else
  while (tcsetattr (0, TCSADRAIN, &old_gtty) < 0 && errno == EINTR);
#endif

#ifdef AIX
  hft_reset ();
#endif
#endif	/* not MSDOS */
}

#ifdef HAVE_PTYS

/* Set up the proper status flags for use of a pty.  */

setup_pty (fd)
     int fd;
{
  /* I'm told that TOICREMOTE does not mean control chars
     "can't be sent" but rather that they don't have
     input-editing or signaling effects.
     That should be good, because we have other ways
     to do those things in Emacs.
     However, telnet mode seems not to work on 4.2.
     So TIOCREMOTE is turned off now. */

  /* Under hp-ux, if TIOCREMOTE is turned on, some calls
     will hang.  In particular, the "timeout" feature (which
     causes a read to return if there is no data available)
     does this.  Also it is known that telnet mode will hang
     in such a way that Emacs must be stopped (perhaps this
     is the same problem).
     
     If TIOCREMOTE is turned off, then there is a bug in
     hp-ux which sometimes loses data.  Apparently the
     code which blocks the master process when the internal
     buffer fills up does not work.  Other than this,
     though, everything else seems to work fine.
     
     Since the latter lossage is more benign, we may as well
     lose that way.  -- cph */
#ifdef FIONBIO
#ifdef SYSV_PTYS
  {
    int on = 1;
    ioctl (fd, FIONBIO, &on);
  }
#endif
#endif
#ifdef IBMRTAIX
  /* On AIX, the parent gets SIGHUP when a pty attached child dies.  So, we */
  /* ignore SIGHUP once we've started a child on a pty.  Note that this may */
  /* cause EMACS not to die when it should, i.e., when its own controlling  */
  /* tty goes away.  I've complained to the AIX developers, and they may    */
  /* change this behavior, but I'm not going to hold my breath.             */
  signal (SIGHUP, SIG_IGN);
#endif
}
#endif /* HAVE_PTYS */

/* Note that VMS compiler won't accept defined (CANNOT_DUMP).  */
#ifndef CANNOT_DUMP
#define NEED_STARTS
#endif

#ifndef SYSTEM_MALLOC
#ifndef NEED_STARTS
#define NEED_STARTS
#endif
#endif

#ifdef NEED_STARTS
/* Some systems that cannot dump also cannot implement these.  */

/*
 *	Return the address of the start of the text segment prior to
 *	doing an unexec.  After unexec the return value is undefined.
 *	See crt0.c for further explanation and _start.
 *
 */

#ifndef CANNOT_UNEXEC
char *
start_of_text ()
{
#ifdef TEXT_START
  return ((char *) TEXT_START);
#else
#ifdef GOULD
  extern csrt ();
  return ((char *) csrt);
#else /* not GOULD */
  extern int _start ();
  return ((char *) _start);
#endif /* GOULD */
#endif /* TEXT_START */
}
#endif /* not CANNOT_UNEXEC */

/*
 *	Return the address of the start of the data segment prior to
 *	doing an unexec.  After unexec the return value is undefined.
 *	See crt0.c for further information and definition of data_start.
 *
 *	Apparently, on BSD systems this is etext at startup.  On
 *	USG systems (swapping) this is highly mmu dependent and
 *	is also dependent on whether or not the program is running
 *	with shared text.  Generally there is a (possibly large)
 *	gap between end of text and start of data with shared text.
 *
 *	On Uniplus+ systems with shared text, data starts at a
 *	fixed address.  Each port (from a given oem) is generally
 *	different, and the specific value of the start of data can
 *	be obtained via the UniPlus+ specific "uvar" system call,
 *	however the method outlined in crt0.c seems to be more portable.
 *
 *	Probably what will have to happen when a USG unexec is available,
 *	at least on UniPlus, is temacs will have to be made unshared so
 *	that text and data are contiguous.  Then once loadup is complete,
 *	unexec will produce a shared executable where the data can be
 *	at the normal shared text boundry and the startofdata variable
 *	will be patched by unexec to the correct value.
 *
 */
 
char *
start_of_data ()
{
#ifdef DATA_START
  return ((char *) DATA_START);
#else
  extern int data_start;
  return ((char *) &data_start);
#endif
}
#endif /* NEED_STARTS (not CANNOT_DUMP or not SYSTEM_MALLOC) */

#ifndef CANNOT_DUMP
/* Some systems that cannot dump also cannot implement these.  */

/*
 *	Return the address of the end of the text segment prior to
 *	doing an unexec.  After unexec the return value is undefined.
 */
 
char *
end_of_text ()
{
#ifdef TEXT_END
  return ((char *) TEXT_END);
#else
  extern int etext;
  return ((char *) &etext);
#endif
}
 
/*
 *	Return the address of the end of the data segment prior to
 *	doing an unexec.  After unexec the return value is undefined.
 */

char *
end_of_data ()
{
#ifdef DATA_END
  return ((char *) DATA_END);
#else
  extern int edata;
  return ((char *) &edata);
#endif
}

#endif /* not CANNOT_DUMP */

/* Get_system_name returns as its value
 a string for the Lisp function system-name to return. */

#ifdef BSD4_1
#include <whoami.h>
#endif

/* Can't have this within the function since `static' is #defined to 
 * nothing for some USG systems.
 */
#ifdef USG
#ifdef HAVE_GETHOSTNAME
static char get_system_name_name[256];
#else /* not HAVE_GETHOSTNAME */
static struct utsname get_system_name_name;
#endif /* not HAVE_GETHOSTNAME */
#endif /* USG */

char *
get_system_name ()
{
#ifdef USG
#ifdef HAVE_GETHOSTNAME
  gethostname (get_system_name_name, sizeof (get_system_name_name));
  return get_system_name_name;
#else /* not HAVE_GETHOSTNAME */
  uname (&get_system_name_name);
  return (get_system_name_name.nodename);
#endif /* not HAVE_GETHOSTNAME */
#else /* Not USG */
#ifdef BSD4_1
  return sysname;
#else /* not USG, not 4.1 */
  static char system_name_saved[32];
  gethostname (system_name_saved, sizeof (system_name_saved));
  return system_name_saved;
#endif /* not USG, not 4.1 */
#endif /* not USG */
}

#ifndef MSDOS
#ifndef HAVE_SELECT

/* Emulate as much as select as is possible under 4.1 and needed by Gnu Emacs
 * Only checks read descriptors.
 */
/* How long to wait between checking fds in select */
#define SELECT_PAUSE 1
int select_alarmed;

/* For longjmp'ing back to read_input_waiting.  */

jmp_buf read_alarm_throw;

/* Nonzero if the alarm signal should throw back to read_input_waiting.
   The read_socket_hook function sets this to 1 while it is waiting.  */

int read_alarm_should_throw;

select_alarm ()
{
  select_alarmed = 1;
#ifdef BSD4_1
  sigrelse (SIGALRM);
#else /* not BSD4_1 */
  signal (SIGALRM, SIG_IGN);
#endif /* not BSD4_1 */
  if (read_alarm_should_throw)
    longjmp (read_alarm_throw, 1);
}

/* Only rfds are checked.  */
int
select (nfds, rfds, wfds, efds, timeout)
     int nfds;
     int *rfds, *wfds, *efds, *timeout;
{
  int ravail = 0, orfds = 0, old_alarm;
  int timeoutval = timeout ? *timeout : 100000;
  int *local_timeout = &timeoutval;
  extern int kbd_count;
  extern int proc_buffered_char[];
#ifndef subprocesses
  int process_tick = 0, update_tick = 0;
#else
  extern int process_tick, update_tick;
#endif
  int (*old_trap) ();
  char buf;

  if (rfds)
    {
      orfds = *rfds;
      *rfds = 0;
    }
  if (wfds)
    *wfds = 0;
  if (efds)
    *efds = 0;

  /* If we are looking only for the terminal, with no timeout,
     just read it and wait -- that's more efficient.  */
  if (orfds == 1 && (!timeout || *timeout == 100000)
      && process_tick == update_tick)
    {
      if (!kbd_count)
	read_input_waiting ();
      *rfds = 1;
      return 1;
    }

  /* Once a second, till the timer expires, check all the flagged read
   * descriptors to see if any input is available.  If there is some then
   * set the corresponding bit in the return copy of rfds.
   */ 
  while (1)
    {
      register int to_check, bit, fd;

      if (rfds)
	{
	  for (to_check = nfds, bit = 1, fd = 0; --to_check >= 0; bit <<= 1, fd++)
	    {
	      if (orfds & bit)
		{
		  int avail = 0, status = 0;

		  if (bit == 1)
		    avail = detect_input_pending (); /* Special keyboard handler */
		  else
		    {
#ifdef FIONREAD
		      status = ioctl (fd, FIONREAD, &avail);
#else /* no FIONREAD */
		      /* Hoping it will return -1 if nothing available
			 or 0 if all 0 chars requested are read.  */
		      if (proc_buffered_char[fd] >= 0)
			avail = 1;
		      else
			{
			  avail = read (fd, &buf, 1);
			  if (avail > 0)
			    proc_buffered_char[fd] = buf;
			}
#endif /* no FIONREAD */
		    }
		  if (status >= 0 && avail > 0)
		    {
		      (*rfds) |= bit;
		      ravail++;
		    }
		}
	    }
	}
      if (*local_timeout == 0 || ravail != 0 || process_tick != update_tick)
	break;
      old_alarm = alarm (0);
      old_trap = (int (*)()) signal (SIGALRM, select_alarm);
      select_alarmed = 0;
      alarm (SELECT_PAUSE);
      /* Wait for a SIGALRM (or maybe a SIGTINT) */
      while (select_alarmed == 0 && *local_timeout != 0
	     && process_tick == update_tick)
	{
	  /* If we are interested in terminal input,
	     wait by reading the terminal.
	     That makes instant wakeup for terminal input at least.  */
	  if (orfds & 1)
	    {
	      read_input_waiting ();
	      if (kbd_count)
		select_alarmed = 1;
	    }
	  else
	    pause ();
	}
      (*local_timeout) -= SELECT_PAUSE;
      /* Reset the old alarm if there was one */
      alarm (0);
      signal (SIGALRM, old_trap);
      if (old_alarm != 0)
	{
	  /* Reset or forge an interrupt for the original handler. */
	  old_alarm -= SELECT_PAUSE;
	  if (old_alarm <= 0)
	    kill (getpid (), SIGALRM); /* Fake an alarm with the orig' handler */
	  else
	    alarm (old_alarm);
	}
      if (*local_timeout == 0)  /* Stop on timer being cleared */
	break;
    }
  return ravail;
}

/* Read keyboard input into the standard buffer,
   waiting for at least one character.  */

/* Make all keyboard buffers much bigger when using X windows.  */
#ifdef HAVE_X_WINDOWS
#define BUFFER_SIZE_FACTOR 16
#else
#define BUFFER_SIZE_FACTOR 1
#endif

read_input_waiting ()
{
  extern int kbd_count;
  extern unsigned char kbd_buffer[];
  extern unsigned char *kbd_ptr;
  int val;

  if (read_socket_hook)
    {
      read_alarm_should_throw = 0;
      if (! setjmp (read_alarm_throw))
	val = (*read_socket_hook) (0, kbd_buffer, 256 * BUFFER_SIZE_FACTOR);
      else
	val = -1;
    }
  else
    val = read (fileno (stdin), kbd_buffer, 1);

  if (val > 0)
    {
      kbd_ptr = kbd_buffer;
      kbd_count = val;
    }
}

#endif /* not HAVE_SELECT */
#endif /* not MSDOS */

#ifdef BSD4_1
/* VARARGS */
setpriority ()
{
  return 0;
}

/*
 * Partially emulate 4.2 open call.
 * open is defined as this in 4.1.
 *
 * - added by Michael Bloom @ Citicorp/TTI
 *
 */

int
sys_open (path, oflag, mode)
     char *path;
     int oflag, mode;
{
  if (oflag & O_CREAT) 
    return creat (path, mode);
  else
    return open (path, oflag);
}

init_sigio ()
{
  if (noninteractive)
    return;
  lmode = LINTRUP | lmode;
  ioctl (0, TIOCLSET, &lmode);
}

reset_sigio ()
{
  if (noninteractive)
    return;
  lmode = ~LINTRUP & lmode;
  ioctl (0, TIOCLSET, &lmode);
}

request_sigio ()
{
  sigrelse (SIGTINT);

  interrupts_deferred = 0;
}

unrequest_sigio ()
{
  sighold (SIGTINT);

  interrupts_deferred = 1;
}

/* still inside #ifdef BSD4_1 */
#ifdef subprocesses

int sigheld; /* Mask of held signals */

sigholdx (signum)
     int signum;
{
  sigheld |= sigbit (signum);
  sighold (signum);
}

sigisheld (signum)
     int signum;
{
  sigheld |= sigbit (signum);
}

sigunhold (signum)
     int signum;
{
  sigheld &= ~sigbit (signum);
  sigrelse (signum);
}

sigfree ()    /* Free all held signals */
{
  int i;
  for (i = 0; i < NSIG; i++)
    if (sigheld & sigbit (i))
      sigrelse (i);
  sigheld = 0;
}

sigbit (i)
{
  return 1 << (i - 1);
}
#endif /* subprocesses */
#endif /* BSD4_1 */

/* POSIX signals support - DJB */
/* Anyone with POSIX signals should have ANSI C declarations */

#ifdef POSIX_SIGNALS

sigset_t signal_empty_mask, signal_full_mask;
static struct sigaction new_action, old_action;

init_signals ()
{
#ifdef POSIX_SIGNALS
  sigemptyset (&signal_empty_mask);
  sigfillset (&signal_full_mask);
#endif
}

typedef int (*signal_handler_t) ();

signal_handler_t
sys_signal (int signal_number, signal_handler_t action)
{
#ifdef DGUX
  /* This gets us restartable system calls for efficiency.
     The "else" code will works as well. */
  return (berk_signal (signal_number, action));
#else
  sigemptyset (&new_action.sa_mask);
  new_action.sa_handler = action;
  new_action.sa_flags = NULL;
  sigaction (signal_number, &new_action, &old_action);
  return (old_action.sa_handler);
#endif /* DGUX */
}

int
sys_sigpause (sigset_t new_mask)
{
  /* pause emulating berk sigpause... */
  sigsuspend (&new_mask);
  return (EINTR);
}

/* I'd like to have these guys return pointers to the mask storage in here,
   but there'd be trouble if the code was saving multiple masks.  I'll be
   safe and pass the structure.  It normally won't be more than 2 bytes
   anyhow. - DJB */

sigset_t
sys_sigblock (sigset_t new_mask)
{
  sigset_t old_mask;
  sigprocmask (SIG_BLOCK, &new_mask, &old_mask);
  return (old_mask);
}

sigset_t
sys_sigunblock (sigset_t new_mask)
{
  sigset_t old_mask;
  sigprocmask (SIG_UNBLOCK, &new_mask, &old_mask);
  return (old_mask);
}

sigset_t
sys_sigsetmask (sigset_t new_mask)
{
  sigset_t old_mask;
  sigprocmask (SIG_SETMASK, &new_mask, &old_mask);
  return (old_mask);
}

#endif /* POSIX_SIGNALS */

#ifndef BSTRING

void
bzero (b, length)
     register char *b;
     register int length;
{
  while (length-- > 0)
    *b++ = 0;
}

/* Saying `void' requires a declaration, above, where bcopy is used
   and that declaration causes pain for systems where bcopy is a macro.  */
bcopy (b1, b2, length)
     register char *b1;
     register char *b2;
     register int length;
{
  while (length-- > 0)
    *b2++ = *b1++;
}

int
bcmp (b1, b2, length)	/* This could be a macro! */
     register char *b1;
     register char *b2;
     register int length;
{
  while (length-- > 0)
    if (*b1++ != *b2++)
      return 1;

  return 0;
}
#endif /* not BSTRING */

#ifdef BSD4_1
long random ()
{
  return (rand ());
}

srandom (arg)
     int arg;
{
  srand (arg);
}
#endif /* BSD4_1 */

#ifdef HPUX
#ifdef X11
#define HAVE_RANDOM
#endif
#endif

#ifdef USG
#ifndef HAVE_RANDOM
/*
 *	The BSD random returns numbers in the range of
 *	0 to 2e31 - 1.  The USG rand(3C) returns numbers in the
 *	range of 0 to 2e15 - 1.  This is probably not significant
 *	in this usage.
 */
  
long
random ()
{
  /* Arrange to return a range centered on zero.  */
  return rand () - (1 << 14);
}

srandom (arg)
     int arg;
{
  srand (arg);
}

#endif /* HAVE_RANDOM */
#endif /* USG */


#ifdef INTERRUPTABLE_OPEN

int
/* VARARGS 2 */
sys_open (path, oflag, mode)
     char *path;
     int oflag, mode;
{
  register int rtnval;
  
  while ((rtnval = open (path, oflag, mode)) == -1
	 && (errno == EINTR));
  return (rtnval);
}

#endif /* INTERRUPTABLE_OPEN */

#ifdef INTERRUPTABLE_CLOSE

sys_close (fd)
     int fd;
{
  register int rtnval;

  while ((rtnval = close (fd)) == -1
	 && (errno == EINTR));
  return rtnval;
}

#endif /* INTERRUPTABLE_CLOSE */

#ifdef INTERRUPTABLE_IO

int
sys_read (fildes, buf, nbyte)
     int fildes;
     char *buf;
     unsigned int nbyte;
{
  register int rtnval;
  
  while ((rtnval = read (fildes, buf, nbyte)) == -1
	 && (errno == EINTR));
  return (rtnval);
}

int
sys_write (fildes, buf, nbyte)
     int fildes;
     char *buf;
     unsigned int nbyte;
{
  register int rtnval;

  while ((rtnval = write (fildes, buf, nbyte)) == -1
	 && (errno == EINTR));
  return (rtnval);
}

#endif /* INTERRUPTABLE_IO */

#ifdef USG
/*
 *	All of the following are for USG.
 *
 *	On USG systems the system calls are interruptable by signals
 *	that the user program has elected to catch.  Thus the system call
 *	must be retried in these cases.  To handle this without massive
 *	changes in the source code, we remap the standard system call names
 *	to names for our own functions in sysdep.c that do the system call
 *	with retries.  Actually, for portability reasons, it is good
 *	programming practice, as this example shows, to limit all actual
 *	system calls to a single occurance in the source.  Sure, this
 *	adds an extra level of function call overhead but it is almost
 *	always negligible.   Fred Fish, Unisoft Systems Inc.
 */

char *sys_siglist[NSIG + 1] =
{
#ifdef AIX
/* AIX has changed the signals a bit */
  "bogus signal",			/* 0 */
  "hangup",				/* 1  SIGHUP */
  "interrupt",				/* 2  SIGINT */
  "quit",				/* 3  SIGQUIT */
  "illegal instruction",		/* 4  SIGILL */
  "trace trap",				/* 5  SIGTRAP */
  "IOT instruction",			/* 6  SIGIOT */
  "crash likely",			/* 7  SIGDANGER */
  "floating point exception",		/* 8  SIGFPE */
  "kill",				/* 9  SIGKILL */
  "bus error",				/* 10 SIGBUS */
  "segmentation violation",		/* 11 SIGSEGV */
  "bad argument to system call",	/* 12 SIGSYS */
  "write on a pipe with no one to read it", /* 13 SIGPIPE */
  "alarm clock",			/* 14 SIGALRM */
  "software termination signum",	/* 15 SIGTERM */
  "user defined signal 1",		/* 16 SIGUSR1 */
  "user defined signal 2",		/* 17 SIGUSR2 */
  "death of a child",			/* 18 SIGCLD */
  "power-fail restart",			/* 19 SIGPWR */
  "bogus signal",			/* 20 */
  "bogus signal",			/* 21 */
  "bogus signal",			/* 22 */
  "bogus signal",			/* 23 */
  "bogus signal",			/* 24 */
  "LAN I/O interrupt",			/* 25 SIGAIO */
  "PTY I/O interrupt",			/* 26 SIGPTY */
  "I/O intervention required",		/* 27 SIGIOINT */
  "HFT grant",				/* 28 SIGGRANT */
  "HFT retract",			/* 29 SIGRETRACT */
  "HFT sound done",			/* 30 SIGSOUND */
  "HFT input ready",			/* 31 SIGMSG */
#else /* not AIX */
  "bogus signal",			/* 0 */
  "hangup",				/* 1  SIGHUP */
  "interrupt",				/* 2  SIGINT */
  "quit",				/* 3  SIGQUIT */
  "illegal instruction",		/* 4  SIGILL */
  "trace trap",				/* 5  SIGTRAP */
  "IOT instruction",			/* 6  SIGIOT */
  "EMT instruction",			/* 7  SIGEMT */
  "floating point exception",		/* 8  SIGFPE */
  "kill",				/* 9  SIGKILL */
  "bus error",				/* 10 SIGBUS */
  "segmentation violation",		/* 11 SIGSEGV */
  "bad argument to system call",	/* 12 SIGSYS */
  "write on a pipe with no one to read it", /* 13 SIGPIPE */
  "alarm clock",			/* 14 SIGALRM */
  "software termination signum",	/* 15 SIGTERM */
  "user defined signal 1",		/* 16 SIGUSR1 */
  "user defined signal 2",		/* 17 SIGUSR2 */
  "death of a child",			/* 18 SIGCLD */
  "power-fail restart",			/* 19 SIGPWR */
#endif /* not AIX */
  0
  };

/*
 *	Warning, this function may not duplicate 4.2 action properly
 *	under error conditions.
 */

#ifndef MAXPATHLEN
/* In 4.1, param.h fails to define this.  */
#define MAXPATHLEN 1024
#endif

#ifndef HAVE_GETWD

char *
getwd (pathname)
     char *pathname;
{
  char *npath, *spath;
  extern char *getcwd ();

  spath = npath = getcwd ((char *) 0, MAXPATHLEN);
  /* On Altos 3068, getcwd can return @hostname/dir, so discard
     up to first slash.  Should be harmless on other systems.  */
  while (*npath && *npath != '/')
    npath++;
  strcpy (pathname, npath);
  free (spath);			/* getcwd uses malloc */
  return pathname;
}

#endif /* not HAVE_GETWD */

#ifndef HAVE_RENAME

/*
 *	Emulate rename using unlink/link.  Note that this is
 *	only partially correct.  Also, doesn't enforce restriction
 *	that files be of same type (regular->regular, dir->dir, etc).
 */

rename (from, to)
#ifdef __STDC__ /* Avoid error if system has proper ANSI prototype.  */
     const char *from;
     const char *to;
#else
     char *from;
     char *to;
#endif
{
  if (access (from, 0) == 0)
    {
      unlink (to);
      if (link (from, to) == 0)
	if (unlink (from) == 0)
	  return (0);
    }
  return (-1);
}
#endif /* not HAVE_RENAME */

/* VARARGS */
setpriority ()
{
  return (0);
}

#ifndef HAVE_VFORK

/*
 *	Substitute fork(2) for vfork(2) on USG flavors.
 */

vfork ()
{
  return (fork ());
}

#endif /* not HAVE_VFORK */

#ifdef MISSING_UTIMES

/* HPUX (among others) sets HAVE_TIMEVAL but does not implement utimes.  */

utimes ()
{
}
#endif

#ifdef IRIS_UTIME

/* The IRIS (3.5) has timevals, but uses sys V utime, and doesn't have the
   utimbuf structure defined anywhere but in the man page. */

struct utimbuf
 {
   long actime;
   long modtime;
 };

utimes (name, tvp)
     char *name;
     struct timeval tvp[];
{
  struct utimbuf utb;
  utb.actime  = tvp[0].tv_sec;
  utb.modtime = tvp[1].tv_sec;
  utime (name, &utb);
}
#endif /* IRIS_UTIME */


#if 0
#ifdef HPUX

/* HPUX curses library references perror, but as far as we know
   it won't be called.  Anyway this definition will do for now.  */

perror ()
{
}

#endif /* HPUX */
#endif /* 0 */

#ifndef HAVE_DUP2

/*
 *	Emulate BSD dup2(2).  First close newd if it already exists.
 *	Then, attempt to dup oldd.  If not successful, call dup2 recursively
 *	until we are, then close the unsuccessful ones.
 */

dup2 (oldd, newd)
     int oldd;
     int newd;
{
  register int fd, ret;
  
  sys_close (newd);

#ifdef F_DUPFD
  fd = fcntl (oldd, F_DUPFD, newd);
  if (fd != newd)
    error ("cant dup2 (%i,%i) : %s", oldd, newd, sys_errlist[errno]);
#else
  fd = dup (old);
  if (fd == -1)
    return -1;
  if (fd == new)
    return new;
  ret = dup2 (old,new);
  sys_close (fd);
  return ret;
#endif
}

#endif /* not HAVE_DUP2 */

/*
 *	Gettimeofday.  Simulate as much as possible.  Only accurate
 *	to nearest second.  Emacs doesn't use tzp so ignore it for now.
 *	Only needed when subprocesses are defined.
 */

#ifdef subprocesses
#ifndef HAVE_GETTIMEOFDAY
#ifdef HAVE_TIMEVAL
 
/* ARGSUSED */
gettimeofday (tp, tzp)
     struct timeval *tp;
     struct timezone *tzp;
{
  extern long time ();

  tp->tv_sec = time ((long *)0);    
  tp->tv_usec = 0;
}
 
#endif
#endif
#endif /* subprocess && !HAVE_GETTIMEOFDAY && HAVE_TIMEVAL */
  
/*
 *	This function will go away as soon as all the stubs fixed. (fnf)
 */

croak (badfunc)
     char *badfunc;
{
  printf ("%s not yet implemented\r\n", badfunc);
  reset_sys_modes ();
  exit (1);
}

#endif /* USG */

#ifdef DGUX

char *sys_siglist[NSIG + 1] =
{
  "null signal",			 /*  0 SIGNULL   */
  "hangup",				 /*  1 SIGHUP    */
  "interrupt",		       		 /*  2 SIGINT    */
  "quit",				 /*  3 SIGQUIT   */
  "illegal instruction",		 /*  4 SIGILL    */
  "trace trap",				 /*  5 SIGTRAP   */
  "abort termination",			 /*  6 SIGABRT   */
  "SIGEMT",				 /*  7 SIGEMT    */
  "floating point exception",		 /*  8 SIGFPE    */
  "kill",				 /*  9 SIGKILL   */
  "bus error",				 /* 10 SIGBUS    */
  "segmentation violation",		 /* 11 SIGSEGV   */
  "bad argument to system call",	 /* 12 SIGSYS    */
  "write on a pipe with no reader",	 /* 13 SIGPIPE   */
  "alarm clock",			 /* 14 SIGALRM   */
  "software termination signal",	 /* 15 SIGTERM   */
  "user defined signal 1",		 /* 16 SIGUSR1   */
  "user defined signal 2",		 /* 17 SIGUSR2   */
  "child stopped or terminated",	 /* 18 SIGCLD    */
  "power-fail restart",			 /* 19 SIGPWR    */
  "window size changed",		 /* 20 SIGWINCH  */
  "undefined",				 /* 21           */
  "pollable event occured",		 /* 22 SIGPOLL   */
  "sendable stop signal not from tty",	 /* 23 SIGSTOP   */
  "stop signal from tty",		 /* 24 SIGSTP    */
  "continue a stopped process",		 /* 25 SIGCONT   */
  "attempted background tty read",	 /* 26 SIGTTIN   */
  "attempted background tty write",	 /* 27 SIGTTOU   */
  "undefined",				 /* 28           */
  "undefined",				 /* 29           */
  "undefined",				 /* 30           */
  "undefined",				 /* 31           */
  "undefined",				 /* 32           */
  "socket (TCP/IP) urgent data arrival", /* 33 SIGURG    */
  "I/O is possible",			 /* 34 SIGIO     */
  "exceeded cpu time limit",		 /* 35 SIGXCPU   */
  "exceeded file size limit",		 /* 36 SIGXFSZ   */
  "virtual time alarm",			 /* 37 SIGVTALRM */
  "profiling time alarm",		 /* 38 SIGPROF   */
  "undefined",				 /* 39           */
  "file record locks revoked",		 /* 40 SIGLOST   */
  "undefined",				 /* 41           */
  "undefined",				 /* 42           */
  "undefined",				 /* 43           */
  "undefined",				 /* 44           */
  "undefined",				 /* 45           */
  "undefined",				 /* 46           */
  "undefined",				 /* 47           */
  "undefined",				 /* 48           */
  "undefined",				 /* 49           */
  "undefined",				 /* 50           */
  "undefined",				 /* 51           */
  "undefined",				 /* 52           */
  "undefined",				 /* 53           */
  "undefined",				 /* 54           */
  "undefined",				 /* 55           */
  "undefined",				 /* 56           */
  "undefined",				 /* 57           */
  "undefined",				 /* 58           */
  "undefined",				 /* 59           */
  "undefined",				 /* 60           */
  "undefined",				 /* 61           */
  "undefined",				 /* 62           */
  "undefined",				 /* 63           */
  "notification message in mess. queue", /* 64 SIGDGNOTIFY */
  0
};

#endif /* DGUX */

/* Directory routines for systems that don't have them. */

#ifndef MSDOS
#ifdef SYSV_SYSTEM_DIR

#include <dirent.h>

#ifndef HAVE_CLOSEDIR
int
closedir (dirp)
     register DIR *dirp;              /* stream from opendir */
{
  sys_close (dirp->dd_fd);
  free ((char *) dirp->dd_buf);       /* directory block defined in <dirent.h> */
  free ((char *) dirp);
}
#endif /* not HAVE_CLOSEDIR */

#endif /* SYSV_SYSTEM_DIR */
#endif /* not MSDOS */

#ifdef NONSYSTEM_DIR_LIBRARY

DIR *
opendir (filename)
     char *filename;	/* name of directory */
{
  register DIR *dirp;		/* -> malloc'ed storage */
  register int fd;		/* file descriptor for read */
  struct stat sbuf;		/* result of fstat() */

  fd = sys_open (filename, 0);
  if (fd < 0)
    return 0;

  if (fstat (fd, &sbuf) < 0
      || (sbuf.st_mode & S_IFMT) != S_IFDIR
      || (dirp = (DIR *) malloc (sizeof (DIR))) == 0)
    {
      sys_close (fd);
      return 0;		/* bad luck today */
    }

  dirp->dd_fd = fd;
  dirp->dd_loc = dirp->dd_size = 0;	/* refill needed */

  return dirp;
}

void
closedir (dirp)
     register DIR *dirp;		/* stream from opendir() */
{
  sys_close (dirp->dd_fd);
  free ((char *) dirp);
}


#ifndef VMS
#define DIRSIZ	14
struct olddir
  {
    ino_t od_ino; 		/* inode */
    char od_name[DIRSIZ];	/* filename */
  };
#endif /* not VMS */

struct direct dir_static;	/* simulated directory contents */

/* ARGUSED */
struct direct *
readdir (dirp)
     register DIR *dirp;	/* stream from opendir() */
{
  register struct olddir *dp;	/* -> directory data */

  for (; ;)
    {
      if (dirp->dd_loc >= dirp->dd_size)
	dirp->dd_loc = dirp->dd_size = 0;

      if (dirp->dd_size == 0 	/* refill buffer */
	  && (dirp->dd_size = sys_read (dirp->dd_fd, dirp->dd_buf, DIRBLKSIZ)) <= 0)
	return 0;

      dp = (struct olddir *) &dirp->dd_buf[dirp->dd_loc];
      dirp->dd_loc += sizeof (struct olddir);

      if (dp->od_ino != 0)	/* not deleted entry */
	{
	  dir_static.d_ino = dp->od_ino;
	  strncpy (dir_static.d_name, dp->od_name, DIRSIZ);
	  dir_static.d_name[DIRSIZ] = '\0';
	  dir_static.d_namlen = strlen (dir_static.d_name);
	  dir_static.d_reclen = sizeof (struct direct)
	    - MAXNAMLEN + 3
	      + dir_static.d_namlen - dir_static.d_namlen % 4;
	  return &dir_static;	/* -> simulated structure */
	}
    }
}


#endif /* NONSYSTEM_DIR_LIBRARY */

#ifdef WRONG_NAME_INSQUE

insque(q,p)
     caddr_t q,p;
{
  _insque(q,p);
}

#endif

#ifdef AIX

/* Called from init_sys_modes.  */
hft_init ()
{
  int junk;

  /* If we're not on an HFT we shouldn't do any of this.  We determine
     if we are on an HFT by trying to get an HFT error code.  If this
     call fails, we're not on an HFT. */ 
#ifdef IBMR2AIX
  if (ioctl (0, HFQERROR, &junk) < 0)
    return;
#else /* not IBMR2AIX */
  if (ioctl (0, HFQEIO, 0) < 0)
    return;
#endif /* not IBMR2AIX */

  /* On AIX the default hft keyboard mapping uses backspace rather than delete
     as the rubout key's ASCII code.  Here this is changed.  The bug is that
     there's no way to determine the old mapping, so in reset_sys_modes
     we need to assume that the normal map had been present.  Of course, this
     code also doesn't help if on a terminal emulator which doesn't understand
     HFT VTD's. */
  {
    struct hfbuf buf;
    struct hfkeymap keymap;

    buf.hf_bufp = (char *)&keymap;
    buf.hf_buflen = sizeof (keymap);
    keymap.hf_nkeys = 2;
    keymap.hfkey[0].hf_kpos = 15;
    keymap.hfkey[0].hf_kstate = HFMAPCHAR | HFSHFNONE;
#ifdef IBMR2AIX
    keymap.hfkey[0].hf_keyidh = '<';
#else /* not IBMR2AIX */
    keymap.hfkey[0].hf_page = '<';
#endif /* not IBMR2AIX */
    keymap.hfkey[0].hf_char = 127;
    keymap.hfkey[1].hf_kpos = 15;
    keymap.hfkey[1].hf_kstate = HFMAPCHAR | HFSHFSHFT;
#ifdef IBMR2AIX
    keymap.hfkey[1].hf_keyidh = '<';
#else /* not IBMR2AIX */
    keymap.hfkey[1].hf_page = '<';
#endif /* not IBMR2AIX */
    keymap.hfkey[1].hf_char = 127;
    hftctl (0, HFSKBD, &buf);
  }
  /* The HFT system on AIX doesn't optimize for scrolling, so it's really ugly
     at times. */
  line_ins_del_ok = char_ins_del_ok = 0;
}

/* Reset the rubout key to backspace. */

hft_reset ()
{
  struct hfbuf buf;
  struct hfkeymap keymap;
  int junk;

#ifdef IBMR2AIX
  if (ioctl (0, HFQERROR, &junk) < 0)
    return;
#else /* not IBMR2AIX */
  if (ioctl (0, HFQEIO, 0) < 0)
    return;
#endif /* not IBMR2AIX */

  buf.hf_bufp = (char *)&keymap;
  buf.hf_buflen = sizeof (keymap);
  keymap.hf_nkeys = 2;
  keymap.hfkey[0].hf_kpos = 15;
  keymap.hfkey[0].hf_kstate = HFMAPCHAR | HFSHFNONE;
#ifdef IBMR2AIX
  keymap.hfkey[0].hf_keyidh = '<';
#else /* not IBMR2AIX */
  keymap.hfkey[0].hf_page = '<';
#endif /* not IBMR2AIX */
  keymap.hfkey[0].hf_char = 8;
  keymap.hfkey[1].hf_kpos = 15;
  keymap.hfkey[1].hf_kstate = HFMAPCHAR | HFSHFSHFT;
#ifdef IBMR2AIX
  keymap.hfkey[1].hf_keyidh = '<';
#else /* not IBMR2AIX */
  keymap.hfkey[1].hf_page = '<';
#endif /* not IBMR2AIX */
  keymap.hfkey[1].hf_char = 8;
  hftctl (0, HFSKBD, &buf);
}

#endif /* AIX */

#ifdef MSDOS	/* Demacs 1.1.1 91/10/16 HIRANO Satoshi */
                /* Demacs 1.1.2 91/10/20 Manabu Higashida */
#include <dos.h>
#include "dosfns.h"

#if defined(__WATCOMC__) && defined(__FLAT__)

#include <bios.h>
#include <conio.h>
#include <ctype.h>
#include "dpmi.h"

# define ax	eax
# define bx	ebx
# define cx	ecx
# define dx	edx
# define int86	int386
#endif

#if defined(J3100) || defined(IBMPC)
static short ibmpc_remap_extended_meta_key_code[][2] = {
  /* KEY#: KeyTop CHR. */
  /* 0x00:             */ {-1 , -1 ,},
  /* 0x01:             */ {-1 , -1 ,},
  /* 0x02:             */ {-1 , -1 ,},
  /* 0x03:             */ {-1 , -1 ,},
  /* 0x04:             */ {-1 , -1 ,},
  /* 0x05:             */ {-1 , -1 ,},
  /* 0x06:             */ {-1 , -1 ,},
  /* 0x07:             */ {-1 , -1 ,},
  /* 0x08:             */ {-1 , -1 ,},
  /* 0x09:             */ {-1 , -1 ,},
  /* 0x0a:             */ {-1 , -1 ,},
  /* 0x0b:             */ {-1 , -1 ,},
  /* 0x0c:             */ {-1 , -1 ,},
  /* 0x0d:             */ {-1 , -1 ,},
  /* 0x0e:             */ {-1 , -1 ,},
  /* 0x0f:             */ {-1 , -1 ,},
  /* 0x10: Q           */ {'q', 'Q',},
  /* 0x11: W           */ {'w', 'W',},
  /* 0x12: E           */ {'e', 'E',},
  /* 0x13: R           */ {'r', 'R',},
  /* 0x14: T           */ {'t', 'T',},
  /* 0x15: Y           */ {'y', 'Y',},
  /* 0x16: U           */ {'u', 'U',},
  /* 0x17: I           */ {'i', 'I',},
  /* 0x18: O           */ {'o', 'O',},
  /* 0x19: P           */ {'p', 'P',},
  /* 0x1a:             */ {-1 ,  0, },
  /* 0x1b:             */ {-1 ,  0, },
  /* 0x1c:             */ {-1 ,  0, },
  /* 0x1d: 	       */ {-1 ,  0, },
  /* 0x1e: A           */ {'a', 'A',},
  /* 0x1f: S           */ {'s', 'S',},
  /* 0x20: D           */ {'d', 'D',},
  /* 0x21: F           */ {'f', 'F',},
  /* 0x22: G           */ {'g', 'G',},
  /* 0x23: H           */ {'h', 'H',},
  /* 0x24: J           */ {'j', 'J',},
  /* 0x25: K           */ {'k', 'K',},
  /* 0x26: L           */ {'l', 'L',},
  /* 0x27:             */ {-1 ,  0, },
  /* 0x28:             */ {-1 ,  0, },
  /* 0x29:             */ {-1 ,  0, },
  /* 0x2a:             */ {-1 ,  0, },
  /* 0x2b:             */ {-1 ,  0, },
  /* 0x2c: Z           */ {'z', 'Z',},
  /* 0x2d: X           */ {'x', 'X',},
  /* 0x2e: C           */ {'c', 'C',},
  /* 0x2f: V           */ {'v', 'V',},
  /* 0x30: B           */ {'b', 'B',},
  /* 0x31: N           */ {'n', 'N',},
  /* 0x32: M           */ {'m', 'M',},
  /* 0x33:             */ {-1 , -1 ,},
  /* 0x34:             */ {-1 , -1 ,},
  /* 0x35:             */ {-1 , -1 ,},
  /* 0x36:             */ {-1 , -1 ,},
  /* 0x37:             */ {-1 , -1 ,},
  /* 0x38:             */ {-1 , -1 ,},
  /* 0x39:             */ {-1 , -1 ,},
  /* 0x3a:             */ {-1 , -1 ,},
  /* 0x3b: F1          */ {-1 , -1 ,},
  /* 0x3c: F2          */ {-1 , -1 ,},
  /* 0x3d: F3          */ {-1 , -1 ,},
  /* 0x3e: F4          */ {-1 , -1 ,},
  /* 0x3f: F5          */ {-1 , -1 ,},
  /* 0x40: F6          */ {-1 , -1 ,},
  /* 0x41: F7          */ {-1 , -1 ,},
  /* 0x42: F8          */ {-1 , -1 ,},
  /* 0x43: F9          */ {-1 , -1 ,},
  /* 0x44: F10         */ {-1 , -1 ,},
  /* 0x45:             */ {-1 , -1 ,},
  /* 0x46:             */ {-1 , -1 ,},
  /* 0x47:             */ {-1 , -1 ,},
  /* 0x48:             */ {-1 , -1 ,},
  /* 0x49:             */ {-1 , -1 ,},
  /* 0x4a:             */ {-1 , -1 ,},
  /* 0x4b:             */ {-1 , -1 ,},
  /* 0x4c:             */ {-1 , -1 ,},
  /* 0x4d:             */ {-1 , -1 ,},
  /* 0x4e:             */ {-1 , -1 ,},
  /* 0x4f:             */ {-1 , -1 ,},
  /* 0x50:             */ {-1 , -1 ,},
  /* 0x51:             */ {-1 , -1 ,},
  /* 0x52:             */ {-1 , -1 ,},
  /* 0x53:             */ {-1 , -1 ,},
  /* 0x54:             */ {-1 , -1 ,},
  /* 0x55:             */ {-1 , -1 ,},
  /* 0x56:             */ {-1 , -1 ,},
  /* 0x57:             */ {-1 , -1 ,},
  /* 0x58:             */ {-1 , -1 ,},
  /* 0x59:             */ {-1 , -1 ,},
  /* 0x5a:             */ {-1 , -1 ,},
  /* 0x5b:             */ {-1 , -1 ,},
  /* 0x5c:             */ {-1 , -1 ,},
  /* 0x5d:             */ {-1 , -1 ,},
  /* 0x5e:             */ {-1 , -1 ,},
  /* 0x5f:             */ {-1 , -1 ,},
  /* 0x60:             */ {-1 , -1 ,},
  /* 0x61:             */ {-1 , -1 ,},
  /* 0x62:             */ {-1 , -1 ,},
  /* 0x63:             */ {-1 , -1 ,},
  /* 0x64:             */ {-1 , -1 ,},
  /* 0x65:             */ {-1 , -1 ,},
  /* 0x66:             */ {-1 , -1 ,},
  /* 0x67:             */ {-1 , -1 ,},
  /* 0x68:             */ {-1 , -1 ,},
  /* 0x69:             */ {-1 , -1 ,},
  /* 0x6a:             */ {-1 , -1 ,},
  /* 0x6b:             */ {-1 , -1 ,},
  /* 0x6c:             */ {-1 , -1 ,},
  /* 0x6d:             */ {-1 , -1 ,},
  /* 0x6e:             */ {-1 , -1 ,},
  /* 0x6f:             */ {-1 , -1 ,},
  /* 0x70:             */ {-1 , -1 ,},
  /* 0x71:             */ {-1 , -1 ,},
  /* 0x72:             */ {-1 , -1 ,},
  /* 0x73:             */ {-1 , -1 ,},
  /* 0x74:             */ {-1 , -1 ,},
  /* 0x75:             */ {-1 , -1 ,},
  /* 0x76:             */ {-1 , -1 ,},
  /* 0x77:             */ {-1 , -1 ,},
  /* 0x78: 1/!         */ {'1', '!',},
  /* 0x79: 2/@         */ {'2', '@',},
  /* 0x7a: 3/#         */ {'3', '#',},
  /* 0x7b: 4/$         */ {'4', '$',},
  /* 0x7c: 5/%         */ {'5', '%',},
  /* 0x7d: 6/^         */ {'6', '^',},
  /* 0x7e: 7/&         */ {'7', '&',},
  /* 0x7f: 8/*         */ {'8', '*',},
  /* 0x80: 9/(         */ {'9', '(',},
  /* 0x81: 0/)         */ {'0', ')',},
  /* 0x82: -/_         */ {'-', '_',},
  /* 0x83: =/+         */ {'=', '+',},
};
#endif /* J3100 or IBMPC */

static int dos_version;	/* MS-DOS version number.   */
static int break_stat;	/* BREAK check mode status. */
static int stdin_stat;	/* stdin IOCTRL status.	    */

/*
 * Ng 1.3 90/02/11 S.Yoshida
 * This function sets the Ctrl-C check function off.
 */
static int
dos_ttraw() 
{
  union REGS inregs, outregs;

  inregs.h.ah = 0x30;		/* Check MS-DOS version. */
  intdos (&inregs, &outregs);
  dos_version = outregs.h.al;
	
  if (dos_version > 1)
    {
      inregs.h.ah = 0x33;	/* Get BREAK check status. */
      inregs.h.al = 0x00;
      intdos (&inregs, &outregs);
      break_stat = outregs.h.dl;

      inregs.h.al = 0x01;	/* Set BREAK check status to */
      inregs.h.dl = 0x00;	/* no BREAK checking.	     */
      intdos (&inregs, &outregs);
      if (outregs.h.al == 0xff)
	{
	  return 0;
	}
      
      inregs.h.ah = 0x44;	/* Get IOCTRL status. */
      inregs.h.al = 0x00;
      inregs.x.bx = 0x00;	/* 0 = stdin. */
      intdos (&inregs, &outregs);
      stdin_stat = outregs.h.dl;

      inregs.x.dx = (outregs.x.dx | 0x0020) & 0x0027; /* raw mode */
      inregs.h.al = 0x01;			      /* Set IOCTRL to raw.*/
      intdos (&inregs, &outregs);
      if (outregs.x.cflag != 0x00)
	{
	  return 0;
	}
    }
  else
    {
      return 0;
    }
  return 1;
}

/*
 * Ng 1.3 90/02/11 S.Yoshida
 * This function reset Ctrl-C check function on.
 */
static int
dos_ttcooked() 
{
  union REGS inregs, outregs;

  if (dos_version > 1)
    {
      inregs.h.ah = 0x33;	/* Reset BREAK check status. */
      inregs.h.al = 0x01;
      inregs.h.dl = break_stat;
      intdos (&inregs, &outregs);
      if (outregs.h.al == 0xff)
	{
	  return 0;
	}

      inregs.h.ah = 0x44;	/* Reset IOCTRL status.	*/
      inregs.h.al = 0x01;
      inregs.x.bx = 0x00;	/* 0 = stdin.		*/
      inregs.x.dx = stdin_stat & 0xff;
      intdos (&inregs, &outregs);
      if (outregs.x.cflag != 0x00)
	{
	  return 0;
	}
    }
  return 1;
}

#define M_Shift_L    0x01
#define M_Shift_R    0x02
#define M_Control    0x04
#define M_Alt	     0x08
#define M_ScrollLock 0x10
#define M_NumLock    0x20
#define M_CapsLock   0x40
#define M_Ins        0x80

static int
dos_get_modifiers()
{
#if defined(J3100) || defined(IBMPC)
  if (
#ifdef J3100
      EQ (Vdos_machine_type, Qj3100)
#endif
#if defined(J3100) && defined(IBMPC)
      ||
#endif
#ifdef IBMPC
      EQ (Vdos_machine_type, Qibmpc)
#endif
      )
    {
      union REGS regs;
      regs.h.ah = 0x02; /* get shift status */
      int86 (0x16, &regs, &regs);
      return (int) regs.h.al;
    }
  else
#endif
    return 0;
}

/*
 * direct console I/O  ah = 6h
 */
#if 0
#else
static int meta_modified_char = -1;
#endif

static int
dos_rawgetc ()
{
  union REGS regs;

#if 0
#else
  if (meta_modified_char != -1)
    {
      register int temp = meta_modified_char;
      meta_modified_char = -1;
      return temp;
    }
#endif

#ifdef __WATCOMC__
#if 0
  if (!_bios_keybrd(_KEYBRD_READY))
    {
      return (-1);
    }
  regs.h.al = _bios_keybrd(_KEYBRD_READ);
#else
  {
    DPMIREGS	dregs;

    memset(&dregs, 0, sizeof(dregs));
    dregs.EAX = 0x0600;
    dregs.EDX = 0x00ff;
    dpmi_call_dos(&dregs);
    if (dregs.flags & 0x0040)
      {
	return (-1);
      }
    regs.h.al = dregs.EAX & 0x00ff;
  }
#endif
#else /* not __WATCOMC__ */
  regs.h.ah = 0x06;
  regs.h.dl = 0xff;
  intdos (&regs, &regs);

  if (regs.x.flags & 0x40)
    return (-1);
  else
#endif /* not __WATCOMC__ */
    {
      int c = regs.h.al;
      int modifiers = dos_get_modifiers();
      
      if (meta_key && (modifiers & M_Alt))
	{
#if defined(J3100) || defined(IBMPC)
	  if (
#ifdef J3100
	      EQ (Vdos_machine_type, Qj3100)
#endif
#if defined(J3100) && defined(IBMPC)
	      ||
#endif
#ifdef IBMPC
	      EQ (Vdos_machine_type, Qibmpc)
	      )
#endif
	    if (c >= 0x10 && c <= 0x83)
              {
	        register int s = (modifiers & (M_Shift_L | M_Shift_R) ? 1 : 0);
#if 0
		return ((ibmpc_remap_extended_meta_key_code[c][s] > 0)
			? ibmpc_remap_extended_meta_key_code[c][s] | 0200
		        : -1);
#else
		extern int meta_prefix_char;
		
		meta_modified_char = ibmpc_remap_extended_meta_key_code[c][s];
		return meta_prefix_char;
#endif
	      }
	    else
	      return (-1);
	  else
#endif
	    return (-1);
	}
      else if (c == ' ')
	{
	  if (modifiers & M_Control)
	    return (0);
	  else
	    return (' ');
	}
      else
	return (c);
    }
}

static int prev_get_char = -1;

dos_keysns ()
{
  if (prev_get_char != -1)
    return 1;
  else if ((prev_get_char = dos_rawgetc ()) != -1)
    return 1;
  else
    return 0;
}

dos_keyread ()
{
  int c;

  if (prev_get_char != -1) 
    {
      c = prev_get_char;
      prev_get_char = -1;
    } 
  else 
    {
      c = dos_rawgetc ();
    }
  return c;
}

input_wait_timeout (timeval)
     int timeval;		/* Time to wait, in seconds */
{
  time_t tnow, tthen;

  if (detect_input_pending ())
    {
      return;
    }

  time (&tnow);
  tthen = tnow + timeval;

  /* If already something, avoid doing system calls.  */
  while (!detect_input_pending ())
    {
      time (&tnow);
      if (tnow >= tthen)
        return;
    }
}

gethostname (p, size)
     char *p;
     int size;
{
  char *q;
	
  strcpy(p, "dosmachine");
  if ((q = getenv("HOSTNAME")) != (char *)0)
    strcpy(p, q);
}

dostounix_filename (p)
     register char *p;
{
  while (*p) {
    if (*p == '\\')
      *p = '/';
    p++;
  }
}

int
getdisk ()
{
  union REGS regs;

  regs.h.ah = 0x19;
  regs.x.dx = 0x00;
  intdos (&regs, &regs);
  return (int) regs.h.al;
}

int
setdisk (drv)
     int drv;
{
  union REGS regs;
#if 0
#else
  {
    char *temp = "x:/";
    int s;
    
    temp[0] = 'a' + drv;
    s = sys_access (temp, 0);
    if (s < 0) return -1; /* Caution: DJ's GCC is buggy with optimization. */
  }
#endif

  regs.h.ah = 0x0e;
  regs.x.dx = drv;
  intdos (&regs, &regs);
  return (regs.h.al > 0 ? regs.h.al : 0);
}

int
crlf_to_lf (n, buf)
     register int n;
     register unsigned char *buf;
{
  unsigned char *np = buf;
  unsigned char *startp = buf;
  unsigned char *endp = buf + n;
  unsigned char c;
    
  if (n == 0)
    return n;
  while (buf < endp) {
    if (*buf == 0x0d)
      buf++;
    else
      *np++ = *buf++;
  }
  return(np - startp);
}
     
croak (badfunc)
     char *badfunc;
{
  printf ("%s not yet implemented\r\n", badfunc);
  reset_sys_modes ();
  exit (1);
}

kill (x, y) int x, y; {}
wait (x) int *x; {}
void pause () {}
#if 0
fork () { return 0; }
#endif
unrequest_sigio () {}
request_sigio () {}
setpriority (x,y,z) int x,y,z; { return 0; }
setpgrp () {return 0; }
sigsetmask (x) int x; { return 0; }

/* DJGCC's getwd () forget to set end of string code. */

#ifdef getwd
#undef getwd
#endif

char *
sys_getwd (buf)
    char *buf;
{
  int len;
  char tmp[MAXPATHLEN + 1];
  extern char *getwd ();

  bzero(tmp, MAXPATHLEN + 1);
#ifdef __WATCOMC__
  getcwd(tmp, MAXPATHLEN);
  {
    char *cptr;

    for (cptr = tmp; *cptr != '\0'; ++cptr) {
      if (*cptr == '\\') {
	*cptr = '/';
      } else {
	*cptr = tolower(*cptr);
      }
    }
  }
  strcpy(buf, tmp);
  len = strlen(buf);
  if (buf[len - 1] != '/') {
    buf[len] = '/';
    buf[len + 1] = '\0';
  }
#else
  getwd(tmp);
  len = strlen(tmp);
  buf[0] = 'a' + getdisk ();
  buf[1] = ':';
  strncpy(buf + 2, tmp, len);
  if (buf[len + 1] != '/') {
    buf[len + 2] = '/';
    buf[len + 3] = '\0';
  } else {
    buf[len + 2] = '\0';
  }
#endif
  return buf;
}

/* DJGCC's access() cannot treat directory name with trailing slash. */

#ifdef access
#undef access
#endif

int
sys_access (file, mode)
     const char *file;
     int mode;
{
  int len = strlen (file);
  char *tmp = (char *) alloca (len + 1);
  extern int access ();

  strcpy (tmp, file);
  if (strcmp (file, "/") && strcmp (file + 1, ":/") && (file[len - 1] == '/'))
    tmp[len - 1] = 0;
  return (int) access(tmp, mode);
}

#ifdef chdir
#undef chdir
#endif

int
sys_chdir (path)
     const char* path;
{
  int len = strlen (path);
  char *tmp = (char *) alloca (len + 1);
  extern int chdir ();

  if (!InhibitSetDisk && (path[1] == ':') &&
      (getdisk () != tolower (path[0]) - 'a'))
    {
      setdisk (tolower (path[0]) - 'a');
    }

  strcpy (tmp, path);
  if (strcmp (path, "/") && strcmp (path + 1, ":/") && (path[len - 1] == '/'))
    tmp[len - 1] = 0;
  return chdir (tmp);
}

/* DJGCC's stat () can't get the status of root directory. */
/* We can't redefine stat () to sys_stat () because structure named stat
   is declared in <sys/stat.h>. So we must rewite stat () to sys_stat ()
   in all file it appears. */

int
sys_stat (name, buf)
     char *name;
     struct stat *buf;
{
  extern int stat ();

  if (strcmp (name, "/") && strcmp (name + 1, ":/"))
    {
      int len = strlen (name);
      char *newname;

      newname = (char *) alloca(len + 1);
      strcpy(newname, name);
      if (len > 0 && (newname[len - 1] == '/' ||
		      newname[len - 1] == '\\'))
	{
	  /*
	   * Drop trailing slash or backslash
	   */
	  newname[len - 1] = '\0';
	}
      return (stat(newname, buf));
    }
  else
    {
      buf->st_rdev = buf->st_ino = 0;
      buf->st_dev = 0;
      buf->st_nlink = 1;
      buf->st_uid = buf->st_gid = 0;
      buf->st_size = 0;
      buf->st_atime = buf->st_mtime = buf->st_ctime = 0;
      buf->st_mode = S_IREAD | S_IWRITE | S_IFDIR;
      return 0;
    }
}

#ifdef system
#undef system
#endif

int
sys_system (com)
  const char *com;
{
  extern int system ();
  extern unsigned int malloc_sbrk_unused;

  if (malloc_sbrk_unused > 0)
    return system (com);
  else 
    {
      errno = ENOMEM;
      return -1;
    }
}

#endif /* MSDOS */
