/******************************************************************************
 * NOTE: This file has been modified for use with MSDOS and the WATCOM C/386
 * compiler.  Darryl Okahata, March 1993.
 *****************************************************************************/

/* Demacs 1.1.2 91/10/20 Manabu Higashida	*/
/* Demacs 1.1.7 91/11/28 Manabu Higashida : PC-9801 support.		*/
/* Demacs 1.1.8 91/11/29 Manabu Higashida : FEP Ctontrol support.	*/
/* Demacs 1.1.9 91/11/30 Manabu Higashida 	*/

/* MS-DOS specific Lisp utilities.  Coded by Manabu Higashida, 1991.

   This file is part of Demacs (MS-DOS version of GNU Emacs and Nemacs).

   Demacs is distributed in the forms of patches to GNU
   Emacs under the terms of the GNU EMACS GENERAL PUBLIC
   LICENSE which is distributed along with GNU Emacs by the
   Free Software Foundation.

   Demacs is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU EMACS GENERAL PUBLIC LICENSE for
   more details.

   You should have received a copy of the GNU EMACS GENERAL
   PUBLIC LICENSE along with Demacs; see the file COPYING.
   If not, write to the Free Software Foundation, 675 Mass
   Ave, Cambridge, MA 02139, USA. */

#include "config.h"

#ifdef MSDOS
/* The entire file is within this conditional */

#include <stdio.h>
#include <dos.h>

#if defined(__WATCOMC__) && defined(__FLAT__)

# define __FLAT_WATCOMC__	/* for ease of #ifdef */

# include <malloc.h>
# include <time.h>
# include "dpmi.h"

#endif

#ifdef NULL
#undef NULL
#endif
#include "lisp.h"
#include "buffer.h"
#include "termchar.h"
#include "dosfns.h"

Lisp_Object Vdos_machine_type;

#ifdef IBMPC
Lisp_Object Qibmpc;
#endif
#ifdef J3100
Lisp_Object Qj3100;
#endif
#ifdef PC9801
Lisp_Object Qpc98;
#endif

int InhibitSetDisk;
#ifdef FEPCTRL /* Demacs 1.1.8 91/11/29 Manabu Higashida */
int InhibitFEPCtrl;
static int FEPstat = 0;
#endif

DEFUN ("int86", Fint86, Sint86, 2, 2, 0, "")
  (intno, regs)
  Lisp_Object intno, regs;
{
#if defined(__FLAT_WATCOMC__)
  register int i;
  int size;
  DPMIREGS int_regs;
  Lisp_Object val;

  CHECK_NUMBER (intno, 0);
  CHECK_VECTOR (regs, 0);
  if (XVECTOR (regs)-> size != 8)
    return Qnil;
  for (i = 0; i < 8; i++)
    {
      CHECK_NUMBER (XVECTOR (regs)->contents[i], 0);
    }

  memset(&int_regs, 0, sizeof(int_regs));
  int_regs.EAX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[0]);
  int_regs.EBX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[1]);
  int_regs.ECX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[2]);
  int_regs.EDX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[3]);
  int_regs.ESI    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[4]);
  int_regs.EDI    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[5]);
  int_regs.flags  = (unsigned long) XFASTINT (XVECTOR (regs)->contents[7]);
  if ((unsigned long) XFASTINT (XVECTOR (regs)->contents[6]))
    {
      int_regs.flags |= DPMI_CARRY_FLAG;
    }
  else
    {
      int_regs.flags &= ~DPMI_CARRY_FLAG;
    }


  dpmi_call_int(XFASTINT (intno), &int_regs);

  XVECTOR (regs)->contents[0] = make_number (int_regs.EAX);
  XVECTOR (regs)->contents[1] = make_number (int_regs.EBX);
  XVECTOR (regs)->contents[2] = make_number (int_regs.ECX);
  XVECTOR (regs)->contents[3] = make_number (int_regs.EDX);
  XVECTOR (regs)->contents[4] = make_number (int_regs.ESI);
  XVECTOR (regs)->contents[5] = make_number (int_regs.EDI);
  if (int_regs.flags & DPMI_CARRY_FLAG)
    {
      XVECTOR (regs)->contents[6] = make_number (1);
    }
  else
    {
      XVECTOR (regs)->contents[6] = make_number (0);
    }
  XVECTOR (regs)->contents[7] = make_number (int_regs.flags);
#else	/* not __FLAT_WATCOMC__ */
  register int i;
  int size;
  union REGS inregs, outregs;
  Lisp_Object val;

  CHECK_NUMBER (intno, 0);
  CHECK_VECTOR (regs, 0);
  if (XVECTOR (regs)-> size != 8) return Qnil;
  for (i = 0; i < 8; i++)
    {
      CHECK_NUMBER (XVECTOR (regs)->contents[i], 0);
    }

  inregs.x.ax    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[0]);
  inregs.x.bx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[1]);
  inregs.x.cx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[2]);
  inregs.x.dx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[3]);
  inregs.x.si    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[4]);
  inregs.x.di    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[5]);
  inregs.x.cflag = (unsigned long) XFASTINT (XVECTOR (regs)->contents[6]);
  inregs.x.flags = (unsigned long) XFASTINT (XVECTOR (regs)->contents[7]);

  int86 ((unsigned long) XFASTINT (intno), &inregs, &outregs);

  XVECTOR (regs)->contents[0] = make_number (outregs.x.ax);
  XVECTOR (regs)->contents[1] = make_number (outregs.x.bx);
  XVECTOR (regs)->contents[2] = make_number (outregs.x.cx);
  XVECTOR (regs)->contents[3] = make_number (outregs.x.dx);
  XVECTOR (regs)->contents[4] = make_number (outregs.x.si);
  XVECTOR (regs)->contents[5] = make_number (outregs.x.di);
  XVECTOR (regs)->contents[6] = make_number (outregs.x.cflag);
  XVECTOR (regs)->contents[7] = make_number (outregs.x.flags);
#endif	/* not __FLAT_WATCOMC__ */

  return regs;
}

#if defined(__FLAT_WATCOMC__)

void __interrupt hit_ctrl_break()
{
  /*
   * Reset ctrl-break flag
   */
  *((unsigned char *) 0x00000471) = *((unsigned char *) 0x00000471) & 0x7f;
  /*
   * Set quit flag
   */
  Vquit_flag = Qt;
}

void grab_ctrl_break()
{
  union REGS	regs;
  struct SREGS	sregs;
  void far	*farptr;

  memset(&sregs, 0, sizeof(sregs));
  regs.x.eax = 0x251b;
  farptr = (void far *) hit_ctrl_break;
  sregs.ds = FP_SEG(farptr);
  regs.x.edx = FP_OFF(farptr);
  int386x(0x21, &regs, &regs, &sregs);
}


DEFUN ("emacs-stackavail", Femacs_stack_avail, Semacs_stack_avail, 0, 0, 0,
       "Return the amount of currently unused stack space\n\
Note that this function reports the CURRENTLY available stack space.\n\
A more useful function would be to report the maximum amount of stack space\n\
ever used, but this is currently too difficult.")
  ()
{
  size_t	stack_free;

  stack_free = stackavail();
  return (make_number((int) stack_free));
}


DEFUN ("emacs-dpmi-info", Femacs_dpmi_info, Semacs_dpmi_info, 0, 0, 0,
       "Get current DPMI memory status.\n\
A list of values is returned:\n\
    0. The largest available block, in KB (1 KB=1024 bytes).  This number\n\
       is incorrect if Emacs is running within Windows 3.1.\n\
    1. Maximum unlocked page allocation.\n\
    2. Maximum locked page allocation.\n\
    3. Linear address space size in pages.\n\
    4. Total number of unlocked pages.\n\
    5. Number of free pages.\n\
    6. Total number of physical pages.\n\
    7. Free linear address space in pages.\n\
    8. Size of paging file/partition in pages.\n\
On most systems, a page is 4096 bytes.")
     ()
{
  Lisp_Object	dpmi_values[9];
  DPMI_MEMINFO	meminfo;

  dpmi_get_meminfo(&meminfo);
  dpmi_values[0] = make_number((int) (meminfo.largest_avail_block / 1024));
  dpmi_values[1] = make_number((int) meminfo.max_unlocked_page);
  dpmi_values[2] = make_number((int) meminfo.largest_lockable_page);
  dpmi_values[3] = make_number((int) meminfo.linear_addr_space);
  dpmi_values[4] = make_number((int) meminfo.num_free_pages);
  dpmi_values[5] = make_number((int) meminfo.num_physical_free_pages);
  dpmi_values[6] = make_number((int) meminfo.total_physical_pages);
  dpmi_values[7] = make_number((int) meminfo.free_linear_addr_space);
  dpmi_values[8] = make_number((int) meminfo.pagefile_size);
  return (Flist(9, dpmi_values));
}


DEFUN ("emacs-UTC-time", Femacs_UTC_time, Semacs_UTC_time, 0, 0, 0,
       "Get the current GMT time, in seconds since Jan 1, 1970.\n\
A list of two numbers is returned: the first has the high-order 16 bits,\n\
and the second has the lower 16 bits.")
     ()
{
  Lisp_Object	t[2];
  time_t	current_time;

  current_time = time((time_t *) 0);
  t[0] = make_number(((int) current_time >> 16) & 0xffff);
  t[1] = make_number((int) current_time & 0xffff);
  return (Flist(2, t));
}

#ifdef DEBUG_EMACS

Lisp_Object _get_pair(n)
unsigned long	n;
{
  Lisp_Object		a[2];

  a[0] = make_number((int) ((n >> 16) & 0xffff));
  a[1] = make_number((int) (n & 0xffff));
  return (Flist(2, a));
}


DEFUN ("emacs-debug-get-addresses", Femacs_debug_get_addresses,
       Semacs_debug_get_addresses, 0, 0, 0,
       "")
     ()
{
  Lisp_Object		a[4];
  extern char		data_start;
  extern char		my_edata;
  extern char		bss_start;
  extern char		bss_end;

  a[0] = _get_pair((unsigned long) &data_start);
  a[1] = _get_pair((unsigned long) &my_edata);
  a[2] = _get_pair((unsigned long) &bss_start);
  a[3] = _get_pair((unsigned long) &bss_end);
  return (Flist(4, a));
}

#endif	/* DEBUG_EMACS */
#endif	/* __FLAT_WATCOMC__ */

#ifdef FEPCTRL	/* Demacs 1.1.8 91/11/29 Manabu Higashida */
DEFUN ("fep-init", Ffep_init, Sfep_init, 0, 0, 0, "")
  ()
{
  extern int fep_init (void);
  if (!InhibitFEPCtrl)
    {
      FEPstat = 1;
      return make_number (fep_init ());
    }
  else
    return Qnil;
}

DEFUN ("fep-term", Ffep_term, Sfep_term, 0, 0, 0, "")
  ()
{
  extern void fep_term (void);
  if (!InhibitFEPCtrl)
    {
      FEPstat = 0;
      fep_term ();
    }
  return Qnil;
}

DEFUN ("fep-on", Ffep_on, Sfep_on, 0, 0, 0, "")
  ()
{
  extern void fep_on (void);
  if (!InhibitFEPCtrl && !NULL (bf_cur->fep_mode) && !FEPstat)
    {
      FEPstat = 1;
      fep_on ();
    }
  return Qnil;
}

DEFUN ("fep-off", Ffep_off, Sfep_off, 0, 0, 0, "")
  ()
{
  extern void fep_off (void);
  if (!InhibitFEPCtrl && !NULL (bf_cur->fep_mode) && FEPstat)
    {
      FEPstat = 0;
      fep_off ();
    }
  return Qnil;
}

DEFUN ("fep-force-on", Ffep_force_on, Sfep_force_on, 0, 0, "", "")
  ()
{
  extern void fep_force_on (void);
  if (!InhibitFEPCtrl)
    {
      fep_force_on ();
      bf_cur->fep_mode = Qt;
    }
  return Qnil;
}

DEFUN ("fep-force-off", Ffep_force_off, Sfep_force_off, 0, 0, "", "")
  ()
{
  extern void fep_force_off (void);
  if (!InhibitFEPCtrl)
    {
      fep_force_off ();
      bf_cur->fep_mode = Qnil;
    }
  return Qnil;
}
#endif /* FEPCTRL */

#ifdef PC9801
DEFUN ("pc98-assign-special-key", 
  Fpc98_assign_special_key, Spc98_assign_special_key, 0, 0, 0, "")
  ()
{
  extern int set98FunctionKey (void);
  if (EQ (Vdos_machine_type, Qpc98))
    set98FunctionKey ();
  return Qnil;
}

DEFUN ("pc98-cancel-special-key", 
  Fpc98_cancel_special_key, Spc98_cancel_special_key, 0, 0, 0, "")
  ()
{
  extern int restore98FunctionKey (void);
  if (EQ (Vdos_machine_type, Qpc98))
    restore98FunctionKey ();
  return Qnil;
}
#endif /* PC9801

/*
 *	Define everything
 */
syms_of_dosfns()
{
#ifdef IBMPC
  Qibmpc = intern ("ibmpc");
  staticpro (&Qibmpc);
#endif
#ifdef J3100
  Qj3100 = intern ("j3100");
  staticpro (&Qj3100);
#endif
#ifdef PC9801
  Qpc98 = intern ("pc98");
  staticpro (&Qpc98);
#endif

  defsubr (&Sint86);

#ifdef __FLAT_WATCOMC__
  defsubr (&Semacs_stack_avail);
  defsubr (&Semacs_dpmi_info);
  defsubr (&Semacs_UTC_time);
#endif	/* __FLAT_WATCOMC__ */
#ifdef DEBUG_EMACS
  defsubr (&Semacs_debug_get_addresses);
#endif	/* DEBUG_EMACS */

#ifdef FEPCTRL	/* Demacs 1.1.8 91/11/29 Manabu Higashida */
  defsubr (&Sfep_init);
  defsubr (&Sfep_term);
  defsubr (&Sfep_on);
  defsubr (&Sfep_off);
  defsubr (&Sfep_force_on);
  defsubr (&Sfep_force_off);
#endif /* FEPCTRL */
#ifdef PC9801
  defsubr (&Spc98_assign_special_key);
  defsubr (&Spc98_cancel_special_key);
#endif

  DEFVAR_LISP ("dos-machine-type", &Vdos_machine_type, 
    "A symbol naming the dos-machine-type under which Emacs is running,\n\
\(such as `ibmpc'), or nil means running on dos generic mode.");
  /* Initialize `dos-machine-type'. */
#ifdef CANNOT_DUMP
  if (noninteractive)
#endif
    Vdos_machine_type = Qnil;

  DEFVAR_BOOL ("dos-inhibit-setdisk", &InhibitSetDisk,
    "*Non-nil means that changing current drive is inhibited.");
  InhibitSetDisk = 0;

#ifdef FEPCTRL /* Demacs 1.1.8 91/11/29 Manabu Higashida */
  DEFVAR_BOOL ("inhibit-fep-control", &InhibitFEPCtrl,
    "*Non-nil means that Kana-Kanji FEP control is inhibited.");
  InhibitFEPCtrl = 1;
#endif
}
#endif /* MSDOS */
