;;; On MS-DOS file system, we can't control version of backup file.
(setq version-control 'never)

;;; exec-directory may change by specifing EMACSEXECPATH environment variable.
(setq Info-directory (expand-file-name "../info/" exec-directory))

;;
;; add binary file type
;;
(define-file-name-file-type "\\.arc" 1)
(define-file-name-file-type "\\.zip" 1)
(define-file-name-file-type "\\.lha" 1)
(define-file-name-file-type "\\.arj" 1)
(define-file-name-file-type "\\.lzh" 1)
(define-file-name-file-type "\\.dvi" 1)
(define-file-name-file-type "\\.z" 1)

;;
;; completion
;;
(setq completion-ignored-extensions
      (append completion-ignored-extensions
	      '(".obj" ".exe" ".bin" ".com" ".arc" ".zip" ".lha" ".lzh"
		".arj")))

;;
;; For V19 compatibility
;;
(load "emacs-19" nil t)

;;
;; For new dired
;;
(autoload 'dired "dired"
"`Edit' directory DIRNAME--delete, rename, print, etc. some files in it.
Prefix arg lets you change the buffer local value of dired-actual-switches.
Dired displays a list of files in DIRNAME (which may also have
  shell wildcards appended to select certain files).
You can move around in it with the usual commands.
You can flag files for deletion with C-d and then delete them by
  typing `x'. 
Type `h' after entering dired for more info." t)

;;
;; For the new C++ mode (unfortunately, under MSDOS, the filename is called
;; "cpp-mode.el", instead of "c++-mode.el", which makes this seem like a
;; C preprocessor mode).
;;
(autoload 'c++-mode   "cxx-mode" "C++ Editing Mode" t)
(autoload 'c++-c-mode "cxx-mode" "C Editing Mode" t)
(setq auto-mode-alist
      (append '(("\\.C$"  . c++-mode)
		("\\.cc$" . c++-mode)
		) auto-mode-alist))

(if (and (boundp 'oemacs-want-enhanced-c-edit-mode)
	 oemacs-want-enhanced-c-edit-mode)
    (progn
      (setq auto-mode-alist
	    (append '(("\\.c$"  . c++-c-mode)   ; to edit C code
		      ("\\.h$"  . c++-c-mode)   ; to edit C code
		      ) auto-mode-alist))
      ))

;;
;; Miscellaneous autoloads:
;;
(autoload 'set-c-style "c-style"
	  "Set up the c-mode style variables from STYLE if it is given, or
default-c-style otherwise.  It makes the c indentation style variables
buffer local."
	    t)
