; -*-Emacs-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         ibmpc.el
; RCS:          $Header: $
; Description:  Key definition file for GNU Emacs
; Author:       Darryl Okahata
; Created:      Wed Mar 24 07:40:58 1993
; Modified:     Wed Mar 31 00:17:06 1993 (darrylo@home) darrylo@dosmachine
; Language:     Emacs-Lisp
; Package:      N/A
; Status:       Experimental (Do Not Distribute)
;
; (C) Copyright 1993, Darryl Okahata, all rights reserved.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar ibmpc-extended-map (make-keymap)
  "Keymap for IBM PC extended characters (ones that start with C-@)")

(defun execute-key-sequence (key)
  "Execute the key sequence given by KEY.
The key sequence must be complete, and must not contain multiple key
sequences." 
  (let ( (function (key-binding key)) )
    (if function
	(progn
	  (setq this-command function)
	  (call-interactively function)
	  )
      (progn
	(ding)
	)
      )
    )
  )

(defun key-home ()
  "Execute the function bound to the C-a key."
  (interactive "")
  (execute-key-sequence "\^a")
  )

(defun key-end ()
  "Execute the function bound to the C-e key."
  (interactive "")
  (execute-key-sequence "\^e")
  )

(defun key-left ()
  "Execute the function bound to the C-b key."
  (interactive "")
  (execute-key-sequence "\^b")
  )

(defun key-right ()
  "Execute the function bound to the C-f key."
  (interactive "")
  (execute-key-sequence "\^f")
  )

(defun key-up ()
  "Execute the function bound to the C-p key."
  (interactive "")
  (execute-key-sequence "\^p")
  )

(defun key-down ()
  "Execute the function bound to the C-n key."
  (interactive "")
  (execute-key-sequence "\^n")
  )

(defun key-pgup ()
  "Execute the function bound to the ESC C-v key."
  (interactive "")
  (execute-key-sequence "\ev")
  )

(defun key-pgdn ()
  "Execute the function bound to the C-v key."
  (interactive "")
  (execute-key-sequence "\^v")
  )

(define-key ibmpc-extended-map "G" 'key-home)	; Home
(define-key ibmpc-extended-map "O" 'key-end)	; End
(define-key ibmpc-extended-map "H" 'key-up)	; Up arrow
(define-key ibmpc-extended-map "P" 'key-down)	; Down arrow
(define-key ibmpc-extended-map "K" 'key-left)	; Left arrow
(define-key ibmpc-extended-map "M" 'key-right)	; Right arrow
(define-key ibmpc-extended-map "I" 'key-pgup)	; PgUp
(define-key ibmpc-extended-map "Q" 'key-pgdn)	; PgDn
(define-key ibmpc-extended-map "R" 'overwrite-mode)	; Ins
(define-key ibmpc-extended-map "S" 'delete-char)	; Del
(define-key ibmpc-extended-map "w" 'beginning-of-buffer)	; Ctrl-Home
(define-key ibmpc-extended-map "u" 'end-of-buffer)		; Ctrl-End

;; Gotta assign something useful to these keys:

;(define-key ibmpc-extended-map "\e\C-d" 'help-for-help); Ctrl-PgUp
;(define-key ibmpc-extended-map "v" 'help-for-help)	; Ctrl-PgDn
;(define-key ibmpc-extended-map "s" 'help-for-help)	; Ctrl-left arrow
;(define-key ibmpc-extended-map "t" 'help-for-help)	; Ctrl-right arrow

;(define-key ibmpc-extended-map ";" 'help-for-help)	; F1
;(define-key ibmpc-extended-map "<" 'help-for-help)	; F2
;(define-key ibmpc-extended-map "=" 'help-for-help)	; F3
;(define-key ibmpc-extended-map ">" 'help-for-help)	; F4
;(define-key ibmpc-extended-map "?" 'help-for-help)	; F5
;(define-key ibmpc-extended-map "@" 'help-for-help)	; F6
;(define-key ibmpc-extended-map "A" 'help-for-help)	; F7
;(define-key ibmpc-extended-map "B" 'help-for-help)	; F8
;(define-key ibmpc-extended-map "C" 'help-for-help)	; F9
;(define-key ibmpc-extended-map "D" 'help-for-help)	; F10

;(define-key ibmpc-extended-map "^" 'help-for-help)	; Ctrl-F1
;(define-key ibmpc-extended-map "_" 'help-for-help)	; Ctrl-F2
;(define-key ibmpc-extended-map "`" 'help-for-help)	; Ctrl-F3
;(define-key ibmpc-extended-map "a" 'help-for-help)	; Ctrl-F4
;(define-key ibmpc-extended-map "b" 'help-for-help)	; Ctrl-F5
;(define-key ibmpc-extended-map "c" 'help-for-help)	; Ctrl-F6
;(define-key ibmpc-extended-map "d" 'help-for-help)	; Ctrl-F7
;(define-key ibmpc-extended-map "e" 'help-for-help)	; Ctrl-F8
;(define-key ibmpc-extended-map "f" 'help-for-help)	; Ctrl-F9
;(define-key ibmpc-extended-map "g" 'help-for-help)	; Ctrl-F10

;(define-key ibmpc-extended-map "T" 'help-for-help)	; Shift-F1
;(define-key ibmpc-extended-map "U" 'help-for-help)	; Shift-F2
;(define-key ibmpc-extended-map "V" 'help-for-help)	; Shift-F3
;(define-key ibmpc-extended-map "W" 'help-for-help)	; Shift-F4
;(define-key ibmpc-extended-map "X" 'help-for-help)	; Shift-F5
;(define-key ibmpc-extended-map "Y" 'help-for-help)	; Shift-F6
;(define-key ibmpc-extended-map "Z" 'help-for-help)	; Shift-F7
;(define-key ibmpc-extended-map "[" 'help-for-help)	; Shift-F8
;(define-key ibmpc-extended-map "\\" 'help-for-help)	; Shift-F9
;(define-key ibmpc-extended-map "]" 'help-for-help)	; Shift-F10

(global-unset-key "\C-@")
(define-key (current-global-map) "\C-@" ibmpc-extended-map)

; Yuk!  Small consolation ...
(define-key ibmpc-extended-map "\C-@" 'set-mark-command); Ctrl-space Ctrl-space

(load "term/bobcat" nil t)	; swap DEL and BS keys
