/*  ====================================================================  *
 *				Mined.h					  *
 *  ====================================================================  */

#ifndef minedH
#define minedH

#ifdef __MSDOS__
#undef unix	/* needed for djgcc? */
#define msdos
#define pc
# ifndef __TURBOC__
# define __GCC__
# undef msdos	/* in this queer case, a more specific distinction */
# define unix	/* has to be made everywhere according to the 'pc' flag */
# endif
#endif

#ifdef msdos
/* With Turbo-C, compile with memory model >= Compact */
/* #define conio doesn't work with current combined positioning/output method */
extern far * getenv ();
extern far * getcwd ();
extern void setdisk ();
#  include <stdio.h>
#  undef putchar
#  include <fcntl.h>
#  define FUNcmd	'\000'
extern void sleep ();
extern void delay ();
extern void exit ();
#endif

#ifdef vms
#  include <unixio.h>
#  include <file.h>	/* for the O_... attributes to open () */
#  include <unixlib.h>
#  undef putchar
#  undef FALSE
#  undef TRUE
#  define CURSES
#  define FUNcmd	'\200'
#endif

#ifdef unix

/*#include <stdlib.h> */
#  include <stdio.h>
#  include <string.h>
#  include <fcntl.h>
#  include <unistd.h>
#  undef putchar
#  undef NULL
#  undef EOF
#  define FUNcmd	'\200'

#  ifndef sysV
   extern char * getwd ();
#  define getcwd(dirbuf, buflen)	getwd (dirbuf)
#  else
   extern char * getcwd ();
#  endif

extern void exit ();
extern char * getenv ();
extern int printf ();
extern int vfork ();
#ifdef __GCC__
extern int wait ();
#else
extern pid_t wait ();
#endif
extern int select ();
extern unsigned int sleep ();
extern unsigned int usleep ();

#endif /* unix */


typedef unsigned char uchar;

/*------------------------------------------------------------------------*/

extern void raw_mode ();
extern void clear_screen ();
extern void clear_eol ();
extern void scroll_forward ();
extern void scroll_reverse ();
extern void add_line (/* y */);
extern void delete_line (/* y */);
extern void move_cursor (/* x, y */);
extern void reverse_on ();
extern void reverse_off ();
extern void start_screen_mode ();
extern void end_screen_mode ();
extern void get_term ();
extern void getwinsize ();

#ifdef msdos
extern void set_video_lines ();
extern void set_textmode_height ();
extern void switch_textmode_height ();
extern void set_grafmode_height ();
extern void set_fontbank ();
extern void set_screen_mode ();
extern void resize_screen ();
#endif

extern int inputreadyafter ();
extern int readchar ();
extern int _readchar ();
extern int __readchar ();

extern int find_y_w_o_RD ();
extern int scratch_file ();
extern void suspendmyself ();
extern void catch_signals ();
extern int char_ready_within ();
extern int get_number ();
extern void display ();
extern void reset ();
extern void move_y ();
extern void move_to ();
extern void set_cursor_xy ();
extern void put_line ();
extern void move_address ();
extern int length_of ();
extern int text_length_of ();
extern int insert ();
extern void copy_string ();
extern int get_file ();
extern int get_line ();
extern void bad_write ();
extern void file_status ();
extern int find_x ();
extern void RDwin ();
extern void RD_y ();
extern void panicio ();
extern int panicwrite ();
extern int wrt_text ();
extern void set_font_height ();
extern void changetocode ();

extern uchar grave ();
extern uchar circumflex ();
extern uchar acute ();
extern uchar diaeresis ();
extern uchar tilde ();
extern uchar angstrom ();

/* aux: */
extern void delete_yank_file ();
extern void rd_bottom_line ();
extern void clear_wholeline ();
extern void clear_lastline ();
extern void (* keyproc) ();
extern void catch_interrupt ();
extern int make_number ();

/* from system: */
extern int write ();
extern int read ();
extern int access ();
extern int open ();
extern int close ();
extern int creat ();
extern int chdir ();
extern int system ();
extern int strcmp ();
extern int isatty ();

/*------------------------------------------------------------------------*/

/*
 * Convert cnt to nearest tab position
 */
#define tab(cnt)		(((cnt) + 8) & ~07)
#define is_tab(c)		((c) == '\t')
/*
 * Word definitions
 */
#define white_space(c)	((c) == ' ' || (c) == '\t')
#define alpha(c)	((c) != ' ' && (c) != '\t' && (c) != '\n')

/* Set cursor at coordinates x, y */
#define set_cursor(nx, ny)	move_cursor(nx, ny)

/* Screen size and display definitions. Coordinates start at 0, 0 */
#ifdef pc
#  define maxYMAX		64
#  define maxXMAX		132
#else
#  define maxYMAX		126	/* 73 */
#  define maxXMAX		279	/* 163 */
#endif

extern short YMAX;
extern short XMAX;
#define SCREENMAX	(YMAX - 1)	/* last line displayed (first is 0) */
#define XBREAK		(XMAX)	/* Shift line display at this column */
#define SHIFT_SIZE	(tab (XMAX / 4 + 1))	/* Number of chars to shift */
#define maxLINE_LEN	(maxXMAX + 1)	/* max screen line length */
#define screen_BUFL	(maxXMAX * maxYMAX)	/* Size of I/O buffering */

#define MAX_CHARS	1024		/* max chars on one line of text */
		/* LINE_START must be rounded up to the lowest SHIFT_SIZE */
#define LINE_START	(((-MAX_CHARS - 1) / SHIFT_SIZE) * SHIFT_SIZE \
  				   - SHIFT_SIZE)
#define LINE_END	(MAX_CHARS + 1)	/* Highest x-coordinate for line */

#define BLOCK_SIZE	1024

/* Return values of functions */
#define ERRORS		-1
#define NO_LINE		(ERRORS - 1)	/* Must be < 0 */
#define FINE	 	(ERRORS + 1)
#define NO_INPUT	(ERRORS + 2)

#define STD_IN		0		/* Input file # */
#define STD_OUT	 	1		/* Terminal output file # */
#define STD_ERR		2

#define REPORT	1		/* Report change of lines on # lines */

#ifndef pc
# define O_BINARY 0
#endif

/*
 * Common enum type for all flags used in mined.
 */
typedef enum {
/* General flags */
  FALSE,
  TRUE,
  OFF,
  ON,
/* yank_status and other */
  NOT_VALID,
  VALID,

/* Expression flags */
  FORWARD,
  REVERSE,

/* Yank flags */
  SMALLER,
  BIGGER,
  SAME,
/*  EMPTY, */
  NO_DELETE,
  DELETE,
  READ,
  WRITE
} FLAG;

/*
 * The Line structure. Each line entry contains a pointer to the next line,
 * a pointer to the previous line, a pointer to the text and an unsigned char
 * telling at which offset of the line printing should start (usually 0).
 */
struct Line {
  struct Line * next;
  struct Line * prev;
  char * text;
  unsigned char shift_count;
};

typedef struct Line LINE;

/* Dummy line indicator */
#define DUMMY		0x80
#define DUMMY_MASK	0x7F

/* Expression definitions */
#define NO_MATCH	0
#define MATCH		1
#define REG_ERROR	2

#define BEGIN_LINE	(2 * REG_ERROR)
#define END_LINE	(2 * BEGIN_LINE)

/*
 * For casting functions with int/void results
 */
typedef void (* voidfunc) ();
typedef uchar (* charfunc) ();
typedef int (* intfunc) ();

/*
 * Determine multi-character prefix bytes (Chinese)
 */
#define multichar(c)	((uchar) c > '\177')
extern int inmultichar ();

/*
 * The regex structure. Status can be any of 0, BEGIN_LINE or REG_ERROR. In
 * the last case, the result.err_mess field is assigned. Start_ptr and end_ptr
 * point to the match found. For more details see the documentation file.
 */
struct regex {
  union {
  	char * err_mess;
  	int * expression;
  } result;
  char status;
  char * start_ptr;
  char * end_ptr;
};

typedef struct regex REGEX;

/* NULL definitions */
#define NIL_PTR		((char *) 0)
#define NIL_LINE	((LINE *) 0)
#define NIL_REG		((REGEX *) 0)
#define NIL_INT		((int *) 0)

/*
 * Forward declarations
 */
extern int total_lines;		/* Number of lines in file */
extern long total_chars;	/* Number of characters in file */
extern LINE * header;		/* Head of line list */
extern LINE * tail;		/* Last line in line list */
extern LINE * top_line;		/* First line of screen */
extern LINE * bot_line;		/* Last line of screen */
extern LINE * cur_line;		/* Current line in use */
extern char * cur_text;		/* Pointer to char on current line in use */
extern int last_y;		/* Last y of screen, usually SCREENMAX */

extern int x, y;		/* x, y coordinates on screen */
extern FLAG modified;		/* Set when file is modified */
extern FLAG viewonly;		/* Set when view only mode is selected */
extern FLAG quit;		/* Set when quit character is typed */
extern FLAG intr_char;		/* Set when intr character is typed */
extern FLAG winchg;		/* Set when the window size changes */
extern FLAG waitingforinput;	/* Set while waiting for the next command key */
extern FLAG isscreenmode;	/* Set when screen mode is on */
extern int out_count;		/* Index in output buffer */
extern char text_buffer [MAX_CHARS];	/* Buffer for modifying text */
extern int input_fd;		/* File descriptors for terminal dialog */
extern int output_fd;
extern char SHIFT_MARK;
extern int fprot;		/* To be used for file creatings */
extern int bufprot;		/* To be used for paste buffer file */

extern char yank_file [];	/* Temp. file for buffer */
extern char yankie_file [];	/* Temp. file for inter-window buffer */
extern char panic_file [];	/* file for panic-write-back */
extern FLAG yank_status;	/* Status of yank_file */
extern long chars_saved;	/* # of chars saved in buffer */

extern int hop_flag;		/* set to 2 by HOP key function */
extern FLAG insert_mode;	/* insert or overwrite */
extern uchar control_prefix;	/* ^V/^P character to prefix control chars */
extern FLAG Chinese;		/* set if two-byte characters are enabled */
extern FLAG loading;		/* Loading a file? Init TRUE for error handling */
extern char screen [];		/* I/O buffer for "writes" and "reads" */
extern FLAG proportional;	/* Enable support for proportional fonts? */
extern FLAG controlQS;		/* must respect ^Q/^S handshake ? */
extern int display_delay;	/* delay between display lines */
extern char TABchar;		/* Char to be shown in place of tab chars */
extern char SHIFT_BEG;		/* Char indicating that line continues left */
extern char RET_MARK;		/* Char indicating end of line */
extern char RET_BLANK;		/* Char to fill the end of line with */
extern char RET_BLANK2;		/* Char to fill last position of line with */
extern char TABdefault;		/* Char displayed instead of TABs */
extern char SHIFT_MARK;		/* Char indicating that line continues */
extern uchar ring;		/* Ring accent character */
extern FLAG rpipe;		/* Set if file should be read from stdin */
extern FLAG stat_visible;	/* Set if status_line is visible */

extern void (* key_map [256]) ();
extern void (* ws_key_map [32]) ();
extern void (* pc_key_map [256]) ();

extern FLAG can_scroll_reverse, can_add_line, can_delete_line, can_clear_eol;
extern FLAG page_scroll;	/* use scroll for page up/down */
extern FLAG page_stay;		/* stay at edge of page after page up/down */
extern FLAG cansuspendmyself;
extern char * get_l_err1;
extern char * get_l_err2;
extern char * serror ();
extern char * serrorof ();
extern int geterrno ();

extern LINE * proceed ();
extern LINE * match ();
extern LINE * line_insert ();
extern char * num_out ();
extern int get_digits ();
extern char * basename ();
extern uchar promptyn ();
extern FLAG checkoverwrite ();
extern void delete_file ();
extern char * unnull ();

#define putchar(c)	__putchar (c)
extern void __putchar (); /* do not use _putchar! it may conflict with curses */
extern int writechar ();
extern int writestring ();
extern int flush_buffer ();
extern void putstring ();
extern void flush ();
extern void panic ();
extern char * alloc ();
extern void free_space ();
extern LINE * alloc_header ();
extern void free_header ();

/* The main editing functions */

extern void MUP (), MDN (), MLF (), MRT (), MNW (), MPW ();
extern void SD (), SU (), PD (), PU (), BFILE (), EFILE ();
extern void BLINE (), ELINE (), HIGH (), LOW ();
extern void S (), SNL (), LIB (), DPC (), DCC (), DLN (), DNW (), DPW ();
extern void CTRl (), DLINE (), TOGINS (), ctrlQ (), ctrlK (), ctrlO ();
extern void JUS ();
extern void QUED (), WT (), WTU (), EDIT (), RD (), I (), FS ();
extern void EXED (), VIEW (), GOTO (), GOMA (), REPT (), HELP ();
extern void SFW (), SRV (), RS (), LR (), GR (), REPL ();
extern void MARK (), YA (), DT (), PT (), WB (), INSFILE ();
extern void MARKn (), GOMAn ();
extern void HOP (), CANCEL (), ESCAPE (), BAD (), FUNKEY (), DIRECT ();
extern void CHDI (), PBUF (), CMD (), SH (), SUSP ();
extern void LNCI (), LNSW ();

/*
 * String functions
 */
#define streq(s1, s2)		(strcmp (s1, s2) == 0)
#define strisprefix(s1, s2)	(strncmp (s2, s1, strlen (s1)) == 0)

/*
 * Empty output buffer
 */
#define clear_buffer()		(out_count = 0)

/*
 * Ring bell on terminal
 */
#define ring_bell()		putchar ('\07')

/*
 * Print line on terminal at offset 0 and clear tail of line
 */
#define line_print(line)	put_line (line, 0, TRUE, FALSE)

/*
 * Functions handling status_line. ON means in reverse video.
 */
extern int bottom_line ();
#define status_msg(str)		status_line (str, NIL_PTR)
#define status_line(str1, str2)		\
	(void) bottom_line (ON, (str1), (str2), NIL_PTR, FALSE)
#define status_beg(str)			\
	(void) bottom_line (ON, (str), NIL_PTR, NIL_PTR, TRUE)
#define error(str1, str2)		\
	(void) bottom_line (ON, (str1), (str2), NIL_PTR, FALSE)
#define clear_status()			\
	(void) bottom_line (OFF, NIL_PTR, NIL_PTR, NIL_PTR, FALSE)
#define get_string(str1, str2, fl)	\
	bottom_line (ON, (str1), NIL_PTR, (str2), fl)

/*
 * Print info about current file and buffer.
 */
#define fstatus(mess, cnt)	\
	file_status ((mess), (cnt), file_name, total_lines, TRUE, writable, modified, viewonly)

/*
 * Build formatted string.
 * If this definition is left out, a routine will be defined in mined1.c.
 */
#define build_string sprintf /**/

/*
 * Get real shift value.
 */
#define get_shift(cnt)		((cnt) & DUMMY_MASK)

/*
 * Special character.
 */
#define QUITCHAR '\034' /* ^\ */

/*------------------------------------------------------------------------*/
#endif
/*------------------------------------------------------------------------*/
