@echo off
rem =========================================================================
rem
rem               Man 1.9.xx - copyright (c) Stuart Herbert
rem           Batch file for supporting viewing of compressed entries
rem
rem =========================================================================
rem
rem     Parameters :
rem
rem     %1     - '-e' for expand only, '-c' for compress after use
rem              note that other values of this parameter are reserved
rem              for future use :)
rem     %2     - name of archive
rem     %3     - name of file to extract (file is extracted to %temp%\%3)
rem     %4..%9 - command to invoke editor/reader or whatever
rem
rem =========================================================================
rem
rem     Environments :
rem
rem     ARCHIVER      - ARJ             for ARJ 2.41 support
rem                     INFOZIP         for INFOZIP support
rem                     LHA             for LHA support
rem                     MS              for COMPRESS and EXPAND support
rem                     PKZIP           for PKZip 2.04g support
rem
rem     Defaults to INFO-ZIP because I encourage PD/FreeWare software :-)
rem
rem =========================================================================
rem
rem NOTES
rem
rem     Because command.com makes
rem
rem             set manexp=unzip -p %2 > %temp%\%3
rem
rem     attempt redirection, I have had to use my own program, setenv, which
rem     does the job quite nicely :-)
rem
rem =========================================================================
rem Parameter validation and initialisation
rem =========================================================================

rem ***
rem Debugging code - normally REM'd out
rem ***

rem echo %1 %2 %3 %4 %5 %6 %7 %8 %9
rem pause

rem ***
rem If %1 blank, then not called from Man!
rem ***

if "%1" == "" goto nogo
goto cont

:nogo
echo.
echo Man-Expander - Copyright (c) Stuart Herbert
echo 
echo.
echo   This file is called from within Man, and you SHOULD NOT call this from
echo   DOS yourself.
echo.
echo   This file provides support for the following archivers :
echo.
echo     Jung's           Arj.exe (not tested)          (Shareware - urgh! :)
echo     INFO-Zip's       Zip.exe & Unzip.exe           (FreeWare  - great!)
echo     Microsoft's      Compress.exe & Expand.exe     (Not distributable)
echo     PKWare's         PKZip.exe & PKUnzip.exe       (Shareware - shame)
echo     Yoshi's          Lha.exe                       (FreeWare  - good)
echo.
if "%archiver%" == "" goto noarchiver
echo   Selected archiver is %archiver%
goto :mess2
:noarchiver
echo   You have not indicated which archiver you wish to use - see 'man man'
echo   for details.  In the mean time, INFO-Zip's utilities will be used.
:mess2
goto exit

rem ***
rem if TEMP not set, don't know where to place expanded file :-)
rem ***

:cont

if "%temp%" == "" goto notemp

rem ***
rem now to set up the archiver
rem ***

if "%archiver%" == ""        goto infozip
if "%archiver%" == "ARJ"     goto arj
if "%archiver%" == "INFOZIP" goto infozip
if "%archiver%" == "LHA"     goto lha
if "%archiver%" == "MS"      goto ms
if "%archiver%" == "PKZIP"   goto pkzip

:arj
setenv mancom "arj a -e %2 %temp%\%3"
setenv manexp "arj x -jw%temp%\%3 %2 %3"
goto doit

:infozip
setenv mancom "zip -k9Djm %2 %temp%\%3"
setenv manexp "unzip -p %2 %3 > %temp%\%3"
goto doit

:lha
setenv mancom "lha a %2 %temp%\%3"
setenv manexp "lha p %2 %3 > %temp%\%3"
goto doit

:ms
setenv mancom "compress %temp%\%3 %2 > nul"
setenv manexp "expand %2 %temp%\%3 > nul"
goto doit

:pkzip
setenv mancom "pkzip -aeX %2 %temp%\%3"
setenv manexp "pkunzip -c %2 %3 > %temp%\%3"
goto doit

:doit

rem ***
rem create mancom.bat to compress the expanded file and delete it
rem ***

echo @echo off > %temp%\mancom.bat
if "%1" == "-c" echo cls >> %temp%\mancom.bat
if "%1" == "-c" echo echo Compressing file ... please wait >> %temp%\mancom.bat
if "%1" == "-c" echo if exist %temp%\%3 %mancom% >> %temp%\mancom.bat
echo if exist %temp%\%3 del %temp%\%3 >> %temp%\mancom.bat

rem ***
rem if the file exists, expand it
rem ***

if exist %2 goto expandit
goto filenotfound

:expandit
echo Expanding file ... please wait
%manexp%

rem ***
rem call the viewer, editor, WinHelp, or whatever
rem ***

if errorlevel==1 goto filenotfound

if exist %temp%\%3 goto viewit
goto filenotfound

:viewit
shift
shift
shift
call %1 %2 %3 %4 %5 %6 %7 %8 %9
cls

rem ***
rem if WinHelp called, prompt for keypress before tidying up
rem ***

if "%1" == "winhelp" goto winhelp
goto tidy

:winhelp
echo WARNING -- Reading Compressed Windows Help File
echo Please finish reading file before pressing any key
echo.
pause

rem ***
rem tidy up afterwards
rem ***

:tidy
if exist %temp%\mancom.bat call %temp%\mancom.bat
if exist %temp%\mancom.bat del %temp%\mancom.bat > nul
set mancom=
set manexp=
goto exit

rem ***
rem tell them that TEMP is not set
rem ***

:notemp
echo.
echo The DOS environment variable TEMP is not set
echo.
echo TEMP must be set to point to a directory you can create files in
echo eg SET TEMP=C:\TEMP
echo.
echo Please set TEMP before trying to use compressed entries
pause
goto tidy

:filenotfound
echo.
echo The file
echo.
echo    %2 %3
echo.
echo cannot be found, and therefore you cannot view/edit/run the file.
pause
goto tidy

:exit
