whatis(5)                       FILE FORMATS                         whatis(5)

NAME
  whatis - Format of the whatis database for man

DESCRIPTION

  The 'whatis database' is the traditional name of the database of installed
  man pages used by man(1).  This file contains information about the binary
  format, and content, of that database.

BINARY FORMAT

  (Note : Some CPU's store their integers in the opposite way to the Intel
   i486.  This version of man was developed on the i486.  Future versions
   may provide support for other platforms.)

  struct WhatisEntry
  {
    char           Name[15];
    char           File[64];            /* uppercase!! */
    char           Data[41];
    unsigned short Type;                /* type is 16-bit number */
  };

  unsigned long NoOfEntries;

  A database file starts with NoOfEntries, and then contains NoOfEntries of
  struct WhatisEntry.  These entries are sorted in alphabetical order.

CONTENT

  When Man is executed, it attempts to access the file 'man.ini', which MUST
  reside in the same directory as the man executables and batch files.  If
  man.ini cannot be found, Man assumes that there is no existing database.

  Man.ini, as included in the PCMAN19B.ZIP distribution, contains the
  following entries :

  1     User Commands
    For programs, commands, etc, that a normal user can use.

  2     System Calls
    For low-level programming information.  Imho, Ralf Brown's Interrupt List
    is about the only thing that belongs in here.

  3     Subroutines/Libraries
    C, or Pascal et al, libraries should go in here.

  4     Device Drivers
    Replacements for RAMDRIVE, ANSI et al.  Anything that needs loading inside
    CONFIG.SYS (or system.ini for Windows) belongs in here.

  5     File Formats
    ANY information about the contents of different types of files belongs in
    here.

  6     Games
    Documentation for ALL games goes here.

  7     Miscellaneous
    Something should go into here ONLY if it really doesn't fit anywhere else.

  8     System Administration
    On networks (eg, Novell NetWare), would include commands such as SYSCON,
    RIGHTS et al, which affect users.  On stand-alones, I also put any
    licenses in here (for example, the GNU General Public License).

  9     Manifest
    For every set of manual pages, there should be a manifest giving details
    of all the pages in the set.

  Local Local
    On networks, or anywhere else where Man is likely to be centrally
    installed and controlled, this should point to a menu that JUST the user
    can see, and can edit (ie, somewhere in their own file store).  On
    standalones, probably not used.

  EVEN if you do not use all of these sections, you are advised to leave them.
  People writing installation scripts for manual pages will be expecting these
  sections to exist.

AUTHOR

  Stuart Herbert
  S.Herbert@shef.ac.uk
