manpages(5)                     FILE FORMATS                       manpages(5)

NAME
  manpages - Information about online manual pages

DESCRIPTION

  Unix-like operating systems have a standard way of dealing with online
  manual pages, using a utility called man(1).  These are called manual
  pages because they are online versions of the paper-based manuals
  supplied with the operating system.

  This manual page discusses what a man page contains; section headings,
  those funny colour codes, et al.  It does not discuss the way unix
  man pages are produced from nroff(1) output; instead, it is assumed
  that the reader has a DOS background :-)

GETTING STARTED

  Man pages are text files.  Each man page contains concise information
  about one topic in particular.  For example, this man page tells you
  about man pages, and there are other man pages for other aspects of
  man(1).

  Normally, when writing a man page, you decide which section of man you
  want the page to go into.  Man has the following sections :

                  1             User Commands
                  2             System Calls
                  3             Subroutines / Libraries
                  4             Device Drivers
                  5             File Formats
                  6             Games
                  7             Miscellaneous
                  8             System Administration
                  9             Manifest
                  Local         Local Information

  (Unix users will be aware that I have chosen to drop the sections
   new, old, and public.  There's nothing to stop to prevent anyone
   adding these sections if they so wish.)

  For more detailed information about what belongs in what section, see
  whatis(5).  For information on writing installation scripts, see
  manscripts(5).

  (The (5) after whatis indicates that I am refering to a man page called
   whatis, which is somewhere in section 5 of man.  It is normal to specify
   a man page by its name and section.)

LAYOUT

  A man page should (ideally) be divided into sub-sections (as this one is).
  Although there are no hard and fast rules on what these sections must be,
  the following are normally seen (in this order)

  NAME
        gives the name of the man page, and a short, one line description
        as to what the manual page is about.  (This description should be
        the same as stored in man(1)).

  SYNOPSIS
        for programs, should give a list of command line parameters.  eg

                man [-efhiknpst[r]v+!!] [name] ...

        For library calls (for example, in C), you would indicate the header
        file to include, and the parameters required for the call.  eg

                #include <wibble.h>
                void wibble(int wibblefactor);

        It will often be the case that a SYNOPSIS is not appropriate (eg,
        this man page).

  DESCRIPTION
        This should contain the actual information.  If you have a large
        man page, then this sub-section should contain an overview of the
        information, and be followed by further sub-sections which contain
        a break-down of the information.

  OPTIONS
        should explain in detail the information given in the SYNOPSIS
        section.  Explain what each parameter does, what its valid values
        are, etc.

  ENVIRONMENT
        is normally used only for programs, and should explain what
        environment variables are required (or are optional), and what
        their values mean.

  BUGS
        is a section too many people leave out.  If there is a known
        problem, then have the decency to state it.  (It also saves
        everyone grief - users aren't wondering whether they're fighting
        a bug, and you don't get lots of mail about suspected problems
        which you already know about.)

  SEE ALSO
        A list of other manual pages which contain relevant information.
        This is one of the ways that a user finds information - they go
        to a man page which they know about, and use the SEE ALSO list
        to find the one that they really want.

        This section should come after all other sections, and immediately
        before LICENSE and AUTHOR.

  LICENSE
        should contain the license agreement covering the subject matter,
        eg. The GNU General Public License.  If the license is a long one,
        or is frequently used, then users would doubtless be happier if
        you made the license a separate manual page (which should go in
        Section 8 : System Administration), and included a pointer to the
        relevant manual page instead.

  AUTHOR
        This should give the name of the author(s), and a contact address
        (email addresses should work over the InterNet, surface addresses
        should include the country of origin, telephone numbers should be
        in standard international dialing form).  Just as importantly, and
        nearly ALWAYS overlooked, some indication should be given as to
        how long the address is likely to be valid.

THOSE FUNNY CHARACTERS

  You can tell a unix man page a mile off when looking through the various
  files that come with (esp, but not limited to) freeware, because they have
  funny characters (a solid block with a diamond in) all over the place.

  This is a backspace character \ (type ALT-8 on the keypad), and is used
  in manual pages to produce BOLD and UNDERLINE when printing out.

  BOLD
    is achieved by repeating a character, with a funny character in the
    middle : bb

  UNDERLINE
    is achieved by preceding a character with a _ and a funny character : _b

  On unix, these effects are produced by the typesetting program nroff(1)
  and equivalents.  There are ports of nroff(1) for DOS available.  However,
  you may prefer to write macros for your favourite editor to add these
  effects (as I do).

  The use of bold and underline seems to be a personal preference; some
  people prefer not to use either.  Here are some suggested guidelines :

    use BOLD for titles of sub-sections, and for the name of programs in
      text body.
    use UNDERLINE for parameters, variables and equivalent, and for the name
      of other documents.

  The sparse use of colour in a man page can be far more effective than
  spraying colour everywhere; the consistent use of colour helps provide
  clarity to otherwise ambiguious text, and can draw the eye to important
  information that you really need to get across.

MANIFEST

  Once you've written your manual pages, please take the time to make a
  manifest of all your pages.  Manifests serve two purposes :

  * A user can use a manifest like a quick index, to find documentation about
    a particular software package.

  * A manifest can be used to determine the origin of any man page on the
    system.

  The name of your manifest should be the same as the name of your archive.
  For example, Man is distributed as PCMAN19B.ZIP.  So the manifest for Man is
  called PCMAN19b.

SEE ALSO
  manscripts(5), whatis(5)

AUTHOR

  Stuart Herbert.
