manscripts(5)                   FILE FORMATS                     manscripts(5)

NAME
  manscripts - writing installation scripts for man

DESCRIPTION

  The program man(1) has the built-in capability of parsing installation
  scripts.  These scripts can be supplied with your software, so that the
  user can add your documentation to man.

FORMAT

  An installation script is a DOS text file, and it can have any name DOS
  permits.

  Comments are denoted by the first character of a line being a semi-colon.
  Whitespace before the semi-colon is not permitted.  Blank lines will also
  be ignored by Man.

  The first line of the file MUST contain the number of items to be installed.
  After that, every non-comment line contains (in order)

    Section  Type  File  Name  Description

  Section
    is the name of the sub-menu off of the topics list where you wish to
    install the entry.  If section does not exist, the entry is skipped.

  Type
    indicates the type of entry you are installing :

        0 - Topic
        1 - Manual Page
        2 - Windows Help
        3 - Program
        4 - Compressed Manual Page
        5 - Compressed Windows Help
        6 - Compressed Program

    If type is an invalid number, the result is unpredicable.

  File
    is the filename of whatever you are installing (a menu, a man page, or
    whatever).  Man will, automatically, add the path to the installation
    script to this filename (this behaviour is perhaps undesirable).

    Types 4-6 require two filenames.  If two filenames are not supplied,
    the entry may be installed incorrectly.

  Name
    is the name of the entry, as the user can see using the Browser.  As with
    Man, note that whitespace is not permitted inside a name at all.  This
    installation facility does not yet support long names.  If the name
    already exists, the existing entry will be replaced (this behaviour is
    perhaps undesirable).

  Description
    The rest of the line is taken to be the description of the entry, and is
    added verbatim.  Quotation marks are not required around descriptions that
    contain whitespace.  A description is terminated by end-of-line.

EXAMPLE

  3
  ; First line is number of entries to be installed

  1  0  man.mnu  Man  Online Document Manager (like unix man)
  ; Install Man's menu to section 1 (User commands)

  5  1  manpages.man ManPages Information about man pages
  ; Install Manpages info to section 5 (File formats)

  9  1  PCMAN19b.man PCMAN19b Manifest for man
  ; ALL installations should include a manifest!!!

RECOMMENDATIONS

  * Make sure that manual pages are installed into the correct section.  It is
    very tempting to simply dump all your manual pages into the one section,
    but by doing so, you destroy the structure of man.

  * If you have a number of manual pages, which belong in the same section,
    you may prefer to create a menu with all these pages on, and install the
    menu instead.

  * Test your script!  This is the first release of the installation feature,
    so it's perhaps not as bullet-proof as it should be.

BUGS

  * No way to select an installation script from within the Browser
  * Primitive parser.  If your script is incorrect, man will likely carry on
    regardless.  A problem on one line, however, CANNOT affect another line.

SEE ALSO

  manpages(5), manual(1), whatis(5)

AUTHOR

  Stuart Herbert
  S.Herbert@shef.ac.uk
