                        .data

EXTRN                   V_Xoffset:      WORD
EXTRN                   V_REGELS:       WORD
EXTRN                   V_Error:        BYTE
EXTRN                   Begin_Drive:    BYTE
EXTRN                   ExtDrive:       WORD

                        .code

EXTRN                   VIEW_LOAD:      NEAR
EXTRN                   VIEW_FILE:      NEAR
EXTRN                   VIEW_INIT:      NEAR
EXTRN                   VIEW_UP:        NEAR
EXTRN                   VIEW_DOWN:      NEAR
EXTRN                   VIEW_L_R:       NEAR
EXTRN                   VIEW_INTERN:    NEAR
EXTRN                   VIEW_FREE:      NEAR
EXTRN                   VIEW_GET:       NEAR
EXTRN                   ExtDrive_Nee:   NEAR

@VIEW_GET               MACRO regel,nummer
                        push es
                        push ds
                        pusha
                        mov si,nummer
                        mov di,offset regel
                        call view_get
                        popa
                        pop  ds
                        pop  es
                        ENDM

@VIEW_FREE              MACRO
                        call view_free
                        ENDM

@VIEW_INTERN            MACRO tekst,regels
                        pusha
                        mov dx,offset tekst
                        mov ax,regels*80h
                        CALL VIEW_INTERN
                        popa
                        ENDM

@VIEW_UP                MACRO herhaal
                        PUSHA
                        ifb <herhaal>
                        mov cx,1
                        endif
                        ifnb <herhaal>
                        mov cx,herhaal
                        endif
                        call view_up
                        POPA
                        push ax
                        xor ah,ah
                        mov al,V_error
                        mov di,ax                                       ; di = evt. foutkode TOP/END bestand
                        pop ax
                        ENDM

@VIEW_DOWN              MACRO herhaal
                        PUSHA
                        ifb <herhaal>
                        mov cx,1
                        endif
                        ifnb <herhaal>
                        mov cx,herhaal
                        endif
                        call view_down
                        POPA
                        push ax
                        xor ah,ah
                        mov al,V_error
                        mov di,ax                                       ; di = evt. foutkode TOP/END bestand
                        pop ax
                        ENDM

@VIEW_left              MACRO
                        PUSHA
                        inc V_Xoffset
                        call view_l_r
                        POPA
                        ENDM

@VIEW_right             MACRO
                        PUSHA
                        dec V_Xoffset
                        call view_l_r
                        POPA
                        ENDM

@VIEW_LOAD              MACRO file
                        PUSHA
                        mov dx,offset file
                        call VIEW_LOAD
                        POPA
                        push ax
                        mov ax,V_regels
                        mov si,ax                                       ; si = aantal regels dat tekst lang is
                        xor ah,ah
                        mov al,V_error
                        mov di,ax                                       ; di = evt. foutkode
                        pop ax
                        ENDM

@VIEW_FILE              MACRO file,ATTRIB,Startdrive,ExtDriveRT
                        ; Ŀ
                        ;  File       = ASCIIZ File spec. ; evt. met PATH & WILDCARDS           
                        ;  ATTRIB     = Welke bestand mogen gelist worden ?                     
                        ;  Startdrive = Evt. met welke drive beginnen bij tonen drives          
                        ;  ExtDriveRT = Evt. extra_routine drives in lijst toe te laten         
                        ;                                                                       
                        ;  INT 4E kompatible waarden :                      
                        ;            - 0   =   Enkel normale bestanden tonen                    
                        ;            - 2   =   HIDDEN bestanden ook tonen                       
                        ;            - 4   =   SYSTEM bestanden ook tonen                       
                        ;            - 16  =   [DIR] direktories ook tonen                      
                        ;  @View_File bijkomende waarden :                  
                        ;            - 8   =   Vlag : enkel direktorie of drives tonen          
                        ;            - 1   =   Diskdrive tonen                                  
                        ; ͵
                        ;            Getallen optellen om juiste kombinatie te krijgen !        
                        ; 
                        PUSHA
                        mov dx,offset file
                        ifb  <ExtDriveRT>
                            mov ExtDrive,offset ExtDrive_Nee            ; Lege ext. routine ..
                        endif
                        ifnb  <ExtDriveRT>
                            mov ExtDrive,offset ExtDriveRT              ; offset ext. routine ..
                        endif
                        ifb  <Startdrive>
                            mov Begin_Drive,0                           ; Beginnen met A:
                        endif
                        ifnb <Startdrive>
                            mov begin_drive,startdrive                  ; Beginnen met X:
                        endif
                        ifb  <ATTRIB>
                            xor cx,cx                                   ; Enkel normale bestanden ; geen dir's of drive's
                        endif
                        ifnb <ATTRIB>
                            mov cx,attrib
                        endif
                        call VIEW_FILE
                        POPA
                        push ax
                        mov ax,V_regels
                        mov si,ax                                       ; si = aantal regels dat tekst lang is
                        xor ah,ah
                        mov al,V_error
                        mov di,ax                                       ; di = evt. foutkode
                        pop ax
                        ENDM

@VIEW_INIT              MACRO x1,y1,x2,y2,c1,c2,c3,c4,c5,lengte,c6,hoogte,tekst,c7
                        ; Ŀ
                        ;  x1..y2 = cordinaten box op scherm !! KARAKTERCOORDINATEN !! (0-79,0-30)   
                        ; Ĵ
                        ;  c1     = letter(voorgrond)kleur                                            
                        ;  c2     = achtergrondkleur                                                  
                        ;  c3     = 3D-randkleur1                                                     
                        ;  c4     = 3D-randkleur2                                                     
                        ; Ĵ
                        ;  c5     = Omlijstingkleur           (indien weggelaten ==> geen omlijsting) 
                        ;  lengte = grootte van omlijsting    (indien weggelaten ==> geen omlijsting) 
                        ; Ĵ
                        ;  c6     = Titelbalkkleur            (indien weggelaten ==> geen titelbalk ) 
                        ;  hoogte = hoogte van Titelbalk      (indien weggelaten ==> geen titelbalk ) 
                        ;  tekst  = Eventuele tekst in titelbalk , gebruikt @VGAPRINT(!!!) , dus moet 
                        ;           er opvoorhand met @CHARSET een karakter gedefineerd worden !!!!!! 
                        ;  c7     = Kleur van de tekst in de titelbalk.                               
                        ; 
                        PUSHA
                        IFDEF print_info
                        %out VIEW_INIT          :       Instellingen
                        %out -----------------------------------------------------
                        ENDIF
                        ifb <hoogte>
                        ifb <c6>
                        IFDEF print_info
                        %out VIEW_INIT          :       Titelbalk       : NEE
                        %out VIEW_INIT          :       Titelbalktekst  : NEE
                        ENDIF
                                ifnb <lengte>
                                ifnb <c5>
                        IFDEF print_info
                        %out VIEW_INIT          :       Omlijsting      : JA
                        ENDIF
                                        @box3d x1*8-(4+lengte),y1*16-(4+lengte),x2*8+4+lengte,y2*16+4+lengte,c5,c4,c3
                                endif
                                endif
                        endif
                        endif
                        ifnb <hoogte>
                        ifnb <c6>
                        IFDEF print_info
                        %out VIEW_INIT          :       Titelbalk       : JA
                        ENDIF
                                ifnb <lengte>
                                ifnb <c5>
                        IFDEF print_info
                        %out VIEW_INIT          :       Omlijsting      : JA
                        ENDIF
                                        @box3d x1*8-(4+lengte),y1*16-(4+lengte+hoogte),x2*8+4+lengte,y2*16+4+lengte,c5,c4,c3
                                        @box3d x1*8-4,y1*16-(4+hoogte),x2*8+4,y1*16-5,c6,c3,c4
                                endif
                                endif
                                ifnb <tekst>
                                ifnb <c7>
                        IFDEF print_info
                        %out VIEW_INIT          :       Titelbalktekst  : JA
                        ENDIF
                                        @vgaprint tekst,x1*8,y1*16-(3+hoogte),c7
                                endif
                                endif
                                ifb <tekst>
                                ifb <c7>
                        IFDEF print_info
                        %out VIEW_INIT          :       Titelbalktekst  : NEE
                        ENDIF
                                endif
                                endif
                        endif
                        endif
                        ifb <lengte>
                        ifb <c5>
                        IFDEF print_info
                        %out VIEW_INIT          :       Omlijsting      : NEE
                        ENDIF
                        endif
                        endif
                        @box3d x1*8-4,y1*16-4,x2*8+4,y2*16+4,c2,c3,c4
                        mov al,x1
                        mov ah,x2
                        mov bl,y1
                        mov bh,y2
                        mov cl, (c1 XOR c2) + 128
                        mov ch, c2
                        call view_init
                        POPA
                        IFDEF print_info
                        %out -----------------------------------------------------
                        %out
                        ENDIF
                        ENDM
