;                               ͸
;                                      VIEWBOX : text-bestand-'viewer'           
;                                      Gebruikt toolbox.XXX & vgabox.XXX         
;                                      Gebruikt 80286 instuctieset               
;                                      Men dient in VGA-mode 12h te zijn         
;                               ;
;               Ŀ
;                VIEW_left & VIEW_right : nog zonder scroll-routine's geprogrammeerd. ==> KAN BETER ! 
;               

.MODEL SMALL
.DATA

PUBLIC                  V_ERROR
PUBLIC                  V_Regels
PUBLIC                  V_Xoffset
PUBLIC                  Begin_Drive
PUBLIC                  EXTDRIVE

V_x1                    db 0
V_x2                    db 0
V_y1                    db 0
V_y2                    db 0
V_file_handle           dw 0
V_FIND_FILE             db 13 dup (0)
V_FILE_ATTRIB           db 0
V_drive                 db "[-=-]   :"
V_FIND_DIR              db "[DIR]  "
V_FIND_NOR              db "   "
Begin_drive             db 0
EXTDRIVE                dw 0
V_file_enkel_dir        db 0
V_error                 db 0
V_segment               dw 0
V_offset                dw 0                                            ; Bij view_load altijd 0,enkel van nut bij VIEW_INTERN
V_paragraph             dw 0
V_CHAR                  db 0
V_regel                 dw 0                                            ; offset adres van begin regel bijhouden
crlf255                 db 255,0
V_seg_current           dw 0
V_off_current           dw 0
V_seg_end               dw 0
V_off_end               dw 0
V_attrib                db 0
V_achtergrond           db 0
V_Xoffset               dw 0
V_Regels                dw 0                                            ; View_Load View_File regels van tekst


.CODE
.286
INCLUDE toolbox.inc

regellengte EQU 80h                                                     ; door 80h te gebruiken wordt alles eenvoudiger !

PUBLIC                  VIEW_GET
PUBLIC                  VIEW_LOAD
PUBLIC                  VIEW_FILE
PUBLIC                  VIEW_INIT
PUBLIC                  VIEW_UP
PUBLIC                  VIEW_DOWN
PUBLIC                  VIEW_L_R
PUBLIC                  VIEW_FREE
PUBLIC                  VIEW_INTERN
PUBLIC                  ExtDrive_Nee

ExtDRive_NEE            PROC
                        CLC                                             ; Clear CARRY = Drive is geldig!
                        RET
ExtDRive_NEE            ENDP

VIEW_GET                PROC
                        ; si = nummer
                        ; di = offset regeltekst
                        push ds
                        pop  es                                         ; ES =@DATA ; ==> ES:DI = regeltekst
                        mov ax,si
                        xor dx,dx
                        mov cx,128
                        mul cx
                        mov si,ax                                       ; si = si *128
                        mov ax,dx                                       ; ax = overflow
                        shl ax,12                                       ; Segment addr.
                        add AX,V_segment                                ; Segment addr. + Segment van bezet geheugen .
                        mov ds,ax                                       ; DS:SI = BXste regel
                        mov cx,40h                                      ; Verplaatsen van 40h woorden
                        rep movsw
                        RET
VIEW_GET                ENDP

VIEW_DRIVE              PROC
                        push dx
                        push ax
                        mov ah,19h                                      ; Get default drive .
                        int 21h
                        push ax
                        push cx
                        mov dl,Begin_Drive                              ; dl = drive waarmee te beginnen A:=0 B:=1 - C:=2 D:=3
drive_lus:                                                              ;                                Diskdrive - Harddisk
                        mov dh,dl
                        cmp dh,26
                        jae drive_lus_the_end                           ; drive_nr van 26 of groter kan niet !
                        add dh,"A"                                      ; dh = ASCII 'drive'
                        mov V_drive + 8,dh                              ; Tekst aanpassen voor juiste drive ...
                        xor di,di                                       ; di = 0 voor als lus The End is. (ERRORVLAG)
                        mov ah,0eh                                      ; Selekt default drive .
                        int 21h                                         ; Als drive geldig was dan is 'Default drive' nu = DL !
                        mov ah,19h                                      ; Get default drive .
                        int 21h
                        cmp al,dl                                       ; Is drive geldig ???
                        jne Volgende_drive                              ; Nee ; ga dan naar volgende drive op zoek !
                        call ds:[EXTDRIVE]                              ; Roep extra rout. aan.
                        jc  Volgende_drive                              ; Extra USERspesifik-routine zegt "ONGELIDIG!"
                        mov di,bx                                       ; ES:DI = bestemming
                        mov si,offset V_drive                           ; DS:SI = ascii Bestandsnaam
                        mov cx,5                                        ; 10bytes lang
                        rep movsw                                       ; verplaatsen !
                        call Geheugen_Kontrole
                        jae geheugen_error                              ; Te weinig geheugen !
                        add bx,8+2                                      ; ! geen overflow-controle !
                        ; Drive staat er nu ==> begin aan volgende regel
                        call next_regel
Volgende_drive:
                        inc dl                                          ; Volgende drive ...
                        jmp drive_lus
geheugen_error:
                        mov di,0FFFFh                                   ; 0FFFFh = Mislukt door geheugen fout !
drive_lus_the_end:
                        pop cx
                        pop ax                                          ; al = was huidige drive voor aanroep !
                        mov dl,al                                       ; dl = drive
                        mov ah,0eh
                        int 21h                                         ; Drive staat terug op orig.
                        pop ax
                        pop dx
                        RET
VIEW_DRIVE              ENDP

Next_regel              PROC
                        inc V_Regels                                    ; Regelteller verhogen
                        ; Ŀ
                        ;  Zet de rest van een regel vol moet SPC en past ES:BX aan zodat deze naar de volgende regel wijst   
                        ; 
                        add V_regel,regellengte
next_lus:
                        mov ES:[bx],byte ptr 20h
                        inc bx
                        cmp bx,V_regel
                        jne next_lus
                        cmp bx,0
                        jne next_lus_gedaan                             ; Overflow ???
                        push ax
                        mov ax,es
                        add ax,1000h
                        mov es,ax
                        pop ax
next_lus_gedaan:
                        RET
Next_Regel              ENDP

VIEW_FILE               PROC
                        mov V_Regels,0                                  ; Regelteller = 0
                        mov V_error,0                                   ; error-flag resetten
                        mov V_offset,0                                  ; mem_alloc => offset altijd 0!
                        ; Alle het vrije conv. geheugen bezetten
                        mov ah,48h
                        mov bx,0ffffh                                   ; 0ffffh = vrij geheugen ...
                        int 21h                                         ; ... opvragen.
                        mov V_paragraph,bx                              ; Size bewaren.
                        mov ah,48h
                        int 21h                                         ; Alles bezetten.
                        jnc mem_begin_ok
                        jmp Ferror_mem_begin
mem_begin_ok:
                        mov V_segment,ax                                ; Segment geheugen bewaren
                        ; FILE_List laden in RANDOM-ACCESS formaat
                        mov es,ax                                       ; INIT !
                        xor bx,bx                                       ; ES:BX = ADRES
                        mov V_regel,bx
                        ; DX = ASCIIZ file spec. : viewbox.inc
                        ; CX = ATTRIB            : viewbox.inc
                        mov V_file_enkel_dir,0                          ; Vlaggen speciale attrib resetten
                        test cx,8
                        je  special_8_0
                        mov V_file_enkel_dir,1                          ; enkel drive/dir vlag zetten
special_8_0:
                        test cx,1                                       ; moeten er ook diskdrives in de lijst verschijnen ?
                        je  special_1_0
                        call View_drive                                 ; Zet eerst de DRIVES in de lijst
                        cmp di,0                                        ; IS VORIGE CALL gelukt ?
                        je  special_1_0
                        jmp Ferror_mem                                  ; NEE ! ; Oei dan stoppen !
special_1_0:
                        and cx,16+4+2                                   ; Ongeldige ATTRIB wegfilteren.
                        mov ax,4e00h                                    ; FindFirst
                        int 21h                                         ; [DTA] is met info geladen nu
Find_Lus:
                        jnc file_gevonden
                        jmp No_more_Files                               ; Geen bestanden meer gevonden !
File_gevonden:
                        push es
                        push ds
                        pusha
                        mov ah,2fh                                      ; Get DTA address
                        int 21h                                         ; ES:BX = DTA address
                        mov cl,es:[bx+15h]                              ; cl = Attrib van bestandsnaam (DIR/FILE ?)
                        mov V_FILE_ATTRIB,cl                            ; en onthouden voor straks !
                        add bx,1eh                                      ; ES:BX = ASCIIZ filename+ext.
                        mov cx,13                                       ; 13bytes
                        push ds
                        push es
                        pop  ds                                         ; DS = ES
                        pop  es                                         ; ES = @Data
                        mov di,offset V_Find_file                       ; ES:DI = V_Find_file   ; Bestemming
                        mov si,bx                                       ; DS:SI = ASCIIZ f+ext. ; Bron
                        Rep Movsb                                       ; Verplaats 13Bytes van Bron --> Bestemming
                        popa
                        pop ds
                        pop es
                        ; In V_Find_File staat nu ASCIIZ filename+extension.
                        mov si,offset V_FIND_NOR                        ; Bestands info
                        test v_file_attrib,16                           ; File of dir ?
                        je Naam_is_bestandsnaam
                        mov si,offset V_Find_DIR                        ; DS:SI = ascii info ; DIR info
                        jmp Naam_is_SI
Naam_is_bestandsnaam:
                        cmp V_file_enkel_dir,1                          ; Haha , moet ik bestanden wel tonen of vergeet ik ze ?
                        jne moet_bestand_tonen
                        jmp y1
moet_bestand_tonen:
                        mov V_FIND_NOR,byte ptr ""                     ; REset  flag
                        mov V_FIND_NOR+1,byte ptr ""                   ; REset  flag
                        mov V_FIND_NOR+2,byte ptr ""                   ; REset  flag
                        mov V_FIND_NOR+3,byte ptr ""                   ; REset  flag
                        test v_file_attrib,1                            ; File : Read only
                        je  Read_
                        mov V_FIND_NOR,byte ptr "R"                     ; Zet Read Only R
read_:
                        test v_file_attrib,32                           ; File : Archive flag
                        je  Archive_
                        mov V_FIND_NOR+3,byte ptr "A"                   ; Zet archive flag A
Archive_:
                        test v_file_attrib,2                            ; File : HIDDEN flag
                        je  Hidden_
                        mov V_FIND_NOR+1,byte ptr "H"                   ; Zet archive flag A
Hidden_:
                        test v_file_attrib,4                            ; File : HIDDEN flag
                        je  System_
                        mov V_FIND_NOR+1,byte ptr "S"                   ; Zet archive flag A
System_:
                        ; DS:SI wijst nu naar [DIR] of Attrib.File ...
Naam_is_SI:
                        mov di,bx                                       ; ES:DI = bestemming
                        mov cx,8                                        ; 8bytes lang
                        rep movsb                                       ; verplaatsen !
                        pusha
                        mov di,offset V_Find_File
                        mov si,di
                        add si,13
zero_lus:
                        cmp ds:[di],byte ptr 0
                        je Zero_gevonden
                        inc di
                        cmp di,si
                        jne Zero_lus
                        jmp zero_is_spatie                              ; ok: nul stond op 13de plaats ==> niet vervangen !
zero_gevonden:                                                          ;                   ^ alleen 1ste 12bytes tellen.
                        mov ds:[di],byte ptr " "
                        inc di
                        cmp di,si
                        jne zero_gevonden                               ; V_Find_File = ASCII filename+ext.+spaties (12bytes)
zero_is_spatie:
                        popa
                        mov di,bx                                       ; ES:DI = bestemming
                        add di,8                                        ; DIR/FILE info niet vergeten.
                        mov si,offset V_Find_File                       ; DS:SI = ascii Bestandsnaam
                        mov cx,12                                       ; 12bytes lang
                        rep movsb                                       ; verplaatsen !
                        call Geheugen_Kontrole
                        jae Ferror_mem                                  ; Te weinig geheugen !
                        add bx,12+8                                     ; ! geen overflow-controle !
                        ; File staat er nu ==> begin aan volgende regel
                        call Next_regel
y1:
                        ; Find_Next ...
                        mov ah,4fH                                      ; Find_Next
                        int 21H                                         ; DTA bevat info
                        jmp Find_lus
Ferror_mem_begin:       mov V_error,0fdh
                        jmp No_more_files                               ; error ; niets meer inlezen !
Ferror_mem:
                        mov V_error,0feh                                ; error-flag setten
No_more_files:
                        mov V_seg_end,es                                ; einde bestand in geheugen
                        mov V_off_end,bx                                ; ... bewaren.
                        ret
VIEW_FILE               ENDP

VIEW_INTERN             PROC
                        mov V_ERROR,0
                        mov V_offset,dx
                        add ax,dx
                        mov V_OFF_END,ax
                        mov ax,ds
                        mov V_SEGMENT,ax
                        mov V_SEG_END,ax
                        RET
VIEW_INTERN             ENDP

VIEW_LOAD               PROC
                        mov V_Regels,0                                  ; Regelteller = 0
                        mov V_error,0                                   ; error-flag resetten
                        mov V_offset,0                                  ; mem_alloc => offset altijd 0!
                        ; OPEN file DX = offset file (ZIE VIEWBOX.INC)
                        XOR CX,CX                                       ; ATTRIB ....
                        mov ax,3D00h
                        int 21h                                         ; OPEN file
                        mov V_file_handle,ax
                        jc  error_dsk
                        ; Alle het vrije conv. geheugen bezetten
                        mov ah,48h
                        mov bx,0ffffh                                   ; 0ffffh = vrij geheugen ...
                        int 21h                                         ; ... opvragen.
                        mov V_paragraph,bx                              ; Size bewaren.
                        mov ah,48h
                        int 21h                                         ; Alles bezetten.
                        jc  error_mem_begin
                        mov V_segment,ax                                ; Segment geheugen bewaren
                        ; FILE laden in RANDOM-ACCESS formaat
                        mov es,ax                                       ; INIT !
                        xor bx,bx                                       ; ES:BX = ADRES
                        mov V_regel,bx
lus1:
                        call lees1
                        cmp di,4321h                                    ; EOF bereikt ?
                        je  close
                        push bx
                        mov bx,offset V_CHAR
                        mov al,ds:[bx]                                  ; al = ingelezen CHAR
                        pop bx
                        cmp al,0Dh
                        jb lus1                                         ; illegale karakters
                        je crlf                                         ; CRLF ==> ...
                        call Geheugen_Kontrole
                        jae error_mem                                   ; Te weinig geheugen !
                        mov ES:[bx],al                                  ; char in geheugen plaatsen
                        inc bx                                          ; ! geen overflow-controle !
                        jmp lus1
crlf:
                        call next_regel
                        jmp lus1
error_dsk:
                        mov V_error,0ffh                                ; error-flag setten
                        ret
error_mem_begin:        mov V_error,0fdh
                        jmp close
error_mem:
                        mov V_error,0feh                                ; error-flag setten
close:
                        mov V_seg_end,es                                ; einde bestand in geheugen
                        mov V_off_end,bx                                ; ... bewaren.
                        mov bx,V_file_handle
                        mov ah,3eh
                        int 21h
                        ret
VIEW_LOAD               ENDP

VIEW_FREE               PROC
                        cmp V_error,0fdh                                ; geheugen fout 0fdH ==> niets vrij te geven !
                        jne uitvoeren
                        ret
uitvoeren:
                        push ax
                        push es
                        mov ax,V_segment                                ; Segment geheugen opvragen
                        mov es,ax
                        mov ah,49h                                      ; Free memory
                        int 21h
                        pop es
                        pop ax
                        ret
VIEW_FREE               ENDP

view_init               PROC
                        mov V_Xoffset,0
                        mov V_attrib,cl
                        mov V_achtergrond,ch
                        mov V_x1,al
                        mov V_x2,ah
                        mov V_y1,bl
                        mov V_y2,bh
                        @locate al,bl
                        mov ax,V_segment
                        mov si,V_offset
                        call afdruk_alles
                        ret
view_init               ENDP

afdruk_alles            proc
                        ; ax:si = wijzer naar begin af te drukken gedeelte
                        pusha
                        mov cl,V_x1
                        mov bl,V_y1
                        @locate cl,bl
                        xor ch,ch
                        mov cl,V_y2
                        sub cl,V_y1                                     ; CL = aantal regels
lus2:
                        cmp ax,V_seg_end                                ; Controle of addres wel ...
                        jb  lus_geldig                                  ; ... geldig is !
                        cmp si,V_off_end
                        jae lus_ongeldig
lus_geldig:
                        call afdrukken
                        @print crlf255                                  ; volgende regel
lus_ongeldig:
                        add si,regellengte
                        jnc lus2_
                        add ax,1000h
lus2_:
                        loop lus2
                        mov V_seg_current,ax                            ; = wijzer naar volgende te
                        mov V_off_current,si                            ; printen lijn.
                        popa
                        ret
afdruk_alles            ENDP

view_l_r                proc
                        cmp V_Xoffset,-1
                        jne ok1
                        inc V_Xoffset
                        ret
ok1:
                        xor ah,ah
                        mov al,regellengte
                        sub al,V_X2
                        add al,V_X1
                        cmp V_Xoffset,ax
                        jne ok2
                        dec V_Xoffset
                        ret
ok2:
                        mov ax,0600h
                        mov bh,V_achtergrond
                        mov cl,V_x1
                        mov ch,V_y1
                        mov dl,V_x2
                        dec dl
                        mov dh,V_y2
                        dec dh
                        int 10h                                         ; WIS scherm
                        mov ax,V_seg_current
                        mov si,V_off_current
                        xor ch,ch
                        mov cl,V_y2
                        sub cl,V_y1                                     ; CL = aantal regels
l40:
                        sub si,regellengte
                        jnc l42
                        sub ax,1000h
l42:                                                                    ; Berekenen begin scherm
                        loop l40
                        call afdruk_alles
                        ret
view_l_r                ENDP

view_up                 PROC
                        mov V_error,0                                   ; Reset error_flag
herhaal1:
                        push cx
                        mov ax,V_seg_end
                        cmp V_seg_current,ax
                        jb  up_ok
                        mov ax,V_off_end
                        cmp V_off_current,ax
                        jb  up_ok
                        pop cx
                        mov V_error,1                                   ; TOP/BODEM van bestand
                        ret
up_ok:
                        mov ax,0601h
                        mov bh,V_achtergrond
                        mov cl,V_x1
                        mov ch,V_y1
                        mov dl,V_x2
                        dec dl
                        mov dh,V_y2
                        dec dh
                        int 10h                                         ; Scroll scherm up
                        mov al,V_x1
                        mov ah,V_y2
                        dec ah
                        @locate al,ah
                        mov ax,V_seg_current
                        mov si,V_off_current
                        call afdrukken
                        add si,regellengte
                        cmp si,0
                        jne g1
                        add ax,1000h
g1:
                        mov V_seg_current,ax                            ; = wijzer naar volgende te
                        mov V_off_current,si                            ; printen lijn.
                        pop cx
                        loop herhaal1
                        ret
view_up                 ENDP

view_down               PROC
                        mov V_error,0                                   ; Reset error_flag
herhaal2:
                        push cx
                        mov ax,V_seg_current
                        mov si,V_off_current
                        push ax                                         ; bewaren voor als ...
                        push si                                         ; ... down is ongeldig
                        sub si,regellengte
                        jnc l11
                        sub ax,1000h
                        jc  downst                                      ; ! BUG-FIX
l11:
                        mov V_seg_current,ax                            ; volgende regel is nu n
                        mov V_off_current,si                            ; ... minder
                        xor ch,ch
                        mov cl,V_y2
                        sub cl,V_y1                                     ; CL = aantal regels
l10:
                        sub si,regellengte
                        jnc l12
                        sub ax,1000h
                        jc  downst                                      ; ! BUG-FIX
l12:
                        loop l10
                        cmp ax,V_segment
                        jb  downst
                        jne l13
                        cmp si,V_offset
                        jb  downst
l13:
                        pusha
                        mov ax,0701h
                        mov bh,V_achtergrond
                        mov cl,V_x1
                        mov ch,V_y1
                        mov dl,V_x2
                        dec dl
                        mov dh,V_y2
                        dec dh
                        int 10h                                         ; Scroll scherm down
                        mov al,V_x1
                        mov ah,V_y1
                        @locate al,ah
                        popa
                        call afdrukken
                        pop si                                          ; nog van stack halen
                        pop ax
                        pop cx
                        loop herhaal2
                        ret
downst:
                        pop si                                          ; ongeldig ==> ...
                        pop ax                                          ; oude waarden terugzetten.
                        mov V_seg_current,ax
                        mov V_off_current,si
                        pop cx
                        mov V_error,1                                   ; TOP/BODEM van bestand
                        ret
view_down               ENDP

afdrukken               PROC
                        ; AX:SI = ADDRES van af te drukken string.
                        pusha
                        xor ch,ch
                        mov cl,V_x2
                        sub cl,V_x1                                     ; X-as-lengte
                        push 0
                        pop  es
                        mov dx,es:[0450h]                               ; cursor positie
                        mov es,ax
                        mov bp,si
                        add bp,V_Xoffset
                        xor bh,bh
                        mov bl,V_attrib
                        mov ax,1300h
                        int 10h
                        popa
                        ret
afdrukken               endp

lees1                   PROC
                        mov di,0                                        ; fout-vlag resetten
                        pusha
                        mov dx,offset V_CHAR
                        mov bx,V_file_handle
                        mov cx,1
                        mov ah,3fh
                        int 21H
                        cmp ax,0
                        je  eof
                        popa
                        ret
eof:
                        popa
                        mov di,4321h                                    ; = End Of File
                        ret
lees1                   ENDP

Geheugen_Kontrole       PROC
                        pusha                                           ; GEHEUGEN-KONTROLE !
                        shr bx,4
                        add bx,16                                       ; BUG dKopie V<2.00 : korrektie.
                        mov ax,es
                        sub ax,V_segment
                        add bx,ax
                        cmp bx,V_paragraph
                        popa
                        RET
Geheugen_Kontrole       ENDP

                        END

