.model small
.286
.code
                        ; Ŀ
                        ;  ESC testen d.m.v. INT 15                                                                
                        ;  CS:ESC_FLAG = 1 --> ESC is ingedrukt geweest !                                          
                        ;  Bepaalde toetsen(combinaties) negeren .....                                             
                        ; 
BIOS18                  EQU     byte ptr 11110111b
                        ; Ŀ
                        ;      Bit 0 = Linker Ctrl-toets ingedrukt                                                 
                        ;          1 = Linker Alt-toets ingedrukt                                                  
                        ;          2 = Sys Req ingedrukt                                                           
                        ;          3 = Pause aan                                                                   
                        ;          4 = Scroll Lock ingedrukt                                                       
                        ;          5 = Num Lock ingedrukt                                                          
                        ;          6 = Caps Lock ingedrukt                                                         
                        ;          7 = Insert ingedrukt                                                            
                        ; 
BIOS17                  EQU     byte ptr 11100011b
BIOS17_2                EQU     byte ptr 00010000b
                        ; Ŀ
                        ;      Bit 0 = Rechter Shift-toets ingedrukt                                              
                        ;          1 = Linker Shift-toets ingedrukt                                               
                        ;          2 = Ctrl-Toets ingedrukt                                                       
                        ;          3 = Alt-Toets ingedrukt                                                        
                        ;          4 = Scroll Lock aan                                                            
                        ;          5 = Num Lock aan                                                               
                        ;          6 = Caps Lock aan                                                              
                        ;          7 = Insert aan                                                                 
                        ; 

PUBLIC                  int15esc
PUBLIC                  int15old
PUBLIC                  Esc_Flag
old15                   label   dword
old15_ofs               dw      0
old15_seg               dw      0
Esc_Flag                db      0

int15esc                proc
                        push es
                        push ds
                        push cs
                        pop  ds                                         ; ds = cs
                        mov ax,3515h
                        int 21h
                        mov old15_seg,es
                        mov old15_ofs,bx
                        mov dx,offset entry
                        mov ax,2515h
                        int 21h
                        pop ds
                        pop es
                        ret
int15esc                endp

int15old                proc
                        push ds
                        push dx
                        push ax
                        mov dx,old15_seg
                        mov ds,dx
                        mov dx,old15_ofs
                        mov ax,2515h
                        int 21h
                        pop ax
                        pop dx
                        pop ds
                        ret
int15old                endp

entry                   proc    FAR
                        pushf
                        cmp ah,4fh
                        je int154f                                      ; Is het wel toetsenbord INT 15H ???
                        popf
                        jmp old15                                       ; Originele interrupt 15H routine ...
int154f:
                        push es
                        push cx
                        xor cx,cx                                       ; cx = 0
                        mov es,cx                                       ; es = 0 ; 0000:04xx = BIOS-data
                        mov cx,es:[041Ah]                               ; Toetsenbordbuffer wissen ....
                        mov es:[041Ch],cx
                        and es:[0418h],bios18                           ; Bepaalde vlaggen aanpassen.
                        and es:[0417h],bios17
                        cmp al,1                                        ; Is ESC ingedrukt ?
                        jne Geen_Esc                                    ; NEE !
                        mov cs:Esc_Flag,1                               ; JA ! Zet Esc_Flag
Geen_Esc:
                        cmp cs:Esc_Flag,1
                        jne Toetsen
                        or es:[0417h],bios17_2                          ; Scroll_Lock_LED aan ...
Toetsen:
                        ; Eventueel hier testen op andere toetsen ......
exit:
                        pop cx                                          ; Cx terug op originele waarde
                        pop es                                          ; Es terug op originele waarde ...
                        popf                                            ; Originele flaggen terug ophalen ...
                        stc                                             ; CF = 1 ; = Waarde gebruiken ...
                        iret                                            ; En terug naat INT09 ; Of vanwaar INT 15 ook kwam ....
entry                   endp
                        END
