/*
          Simple configuration program for PG.COM

          April, 1994 by Gary Karnik (g.karnik@att.com)

          To compile using Borland C++ 3.1: bcc pgconfig.c
*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define WRAP_BIT        1
#define ASCII_BIT       2
#define BLANK_BIT       4
#define HEX_BIT         8

void print_colors(void);
void usage(void);
void do_color(char *name);
void do_view_mode(void);
void do_43line(void);
void do_beep(void);
void do_run_table(void);
void do_default_run(void);

FILE *FP;

main(argc,argv)
int argc;
char *argv[];
{
        int i;
        char temp[40];

        printf("Pager configuration program\n");

        if(argc!=2) {
                usage();
                return(-1);
        }

        if((FP = fopen(argv[1],"r+b")) == NULL)  {
                printf("Cannot open file: %s\n\n", argv[1]);
                usage();
                return(-1);
        }

        fseek(FP, 8, SEEK_CUR); /* start of patch area */

        for(i=0; i<10; i++)
                temp[i] = fgetc(FP);
        temp[i]=0;

        if(strcmp(temp, "PATCHSTART")) {
                printf("Cannot find start of patch area\n");
                fclose(FP);
                usage();
                return(-1);
        }

        print_colors();
        do_color("Directory Text");
        do_color("Path Name");
        do_color("Menu Text");
        do_color("Menu Border");
        do_color("High-Lighted Dir Entry");
        do_color("Menu Title Logo Lines");
        do_view_mode();
        do_43line();
        do_beep();
        do_default_run();
        do_run_table();

        printf("%s has been configured!\n", argv[1]);

        fclose(FP);
        return(0);
}


void do_default_run()
{
        long f_pos;
        char temp[40], s[80];
        int j;

        f_pos = ftell(FP);

        fseek(FP, f_pos, SEEK_SET);
        for(j=0; j<20; j++)
                temp[j]=fgetc(FP);
        temp[j]=0;

        printf("Default auto-run program [%s]: ", temp);
        gets(s);
        if(*s) strncpy(temp,s,20);

        fseek(FP, f_pos, SEEK_SET);
        for(j=0; j<20; j++) {
                if(temp[j]==0) temp[j]=' ';
                fputc(temp[j], FP);
        }

        f_pos = ftell(FP);
        fseek(FP, f_pos+4, SEEK_SET); /* skip past file ext & pause flag */

        printf("\n");
}


void do_run_table()
{
        long f_pos;
        char temp[40], s[80];
        int i,j;

        for(i=1; i<=20; i++) {
                /* --------- auto-run program name --------- */
                f_pos = ftell(FP);

                fseek(FP, f_pos, SEEK_SET);
                for(j=0; j<20; j++)
                        temp[j]=fgetc(FP);
                temp[j]=0;

                printf("Auto-run program #%d [%s]: ",i, temp);
                gets(s);
                if(*s) strncpy(temp,s,20);

                fseek(FP, f_pos, SEEK_SET);
                for(j=0; j<20; j++) {
                        if(temp[j]==0) temp[j]=' ';
                        fputc(temp[j], FP);
                }

                /* --------- filename extension --------- */
                f_pos = ftell(FP);

                fseek(FP, f_pos, SEEK_SET);
                for(j=0; j<3; j++)
                        temp[j]=fgetc(FP);
                temp[3]=0;

                printf("Auto-run file extension #%d [%s]: ",i, temp);
                gets(s);
                if(*s) strncpy(temp,s,3);

                fseek(FP, f_pos, SEEK_SET);
                for(j=0; j<3; j++) {
                        if(temp[j]==0) temp[j]=' ';
                        fputc(toupper(temp[j]), FP);
                }

                /* --------- pause flag --------- */
                f_pos = ftell(FP);

                fseek(FP, f_pos, SEEK_SET);
                temp[0]=fgetc(FP);

                printf("Pause after auto-running this command [%s]: ", temp[0]=='P'?"Y":"N");
                j=getche();
                if(toupper(j)=='Y') temp[0]='P';
                if(toupper(j)=='N') temp[0]=' ';

                fseek(FP, f_pos, SEEK_SET);
                fputc(temp[0], FP);

                printf("\n\n");
        }
}


void do_beep()
{
        long f_pos;
        int beepmode, i;

        f_pos = ftell(FP);

        fseek(FP, f_pos, SEEK_SET);
        beepmode = fgetc(FP);

        printf("Allow beeping of the PC speaker on errors [%s]: ", beepmode?"Y":"N");
        i=getche();
        if(toupper(i)=='Y') beepmode=1;
        if(toupper(i)=='N') beepmode=0;

        fseek(FP, f_pos, SEEK_SET);
        fputc(beepmode, FP);

        printf("\n\n");
}


void do_43line()
{
        long f_pos;
        int vgamode, i;

        f_pos = ftell(FP);

        fseek(FP, f_pos, SEEK_SET);
        vgamode = fgetc(FP);

        printf("Force startup in VGA 50-line / EGA 43-line mode [%s]: ", vgamode?"Y":"N");
        i=getche();
        if(toupper(i)=='Y') vgamode=1;
        if(toupper(i)=='N') vgamode=0;

        fseek(FP, f_pos, SEEK_SET);
        fputc(vgamode, FP);

        printf("\n\n");
}


void do_view_mode()
{
        long f_pos;
        int view_mode, i;

        f_pos = ftell(FP);

        fseek(FP, f_pos, SEEK_SET);
        view_mode = fgetc(FP);

        printf("\nDefault File View Mode:\n");
        printf("Wrap around long lines on screen [%s]: ", (view_mode & WRAP_BIT)?"Y":"N");
        i=getche();
        if(toupper(i)=='Y') view_mode |= WRAP_BIT;
        if(toupper(i)=='N') view_mode &= ~WRAP_BIT;

        printf("\nDisplay words with ASCII characters only [%s]: ", (view_mode & ASCII_BIT)?"Y":"N");
        i=getche();
        if(toupper(i)=='Y') view_mode |= ASCII_BIT;
        if(toupper(i)=='N') view_mode &= ~ASCII_BIT;

        printf("\nBlank character with high bit set [%s]: ", (view_mode & BLANK_BIT)?"Y":"N");
        i=getche();
        if(toupper(i)=='Y') view_mode |= BLANK_BIT;
        if(toupper(i)=='N') view_mode &= ~BLANK_BIT;

        printf("\nHexadecimal display of file [%s]: ", (view_mode & HEX_BIT)?"Y":"N");
        i=getche();
        if(toupper(i)=='Y') view_mode |= HEX_BIT;
        if(toupper(i)=='N') view_mode &= ~HEX_BIT;

        fseek(FP, f_pos, SEEK_SET);
        fputc(view_mode, FP);

        printf("\n\n");
}


void do_color(name)
char name[];
{
        unsigned int old_color, new_color;
        long f_pos;
        char s[80];

        f_pos = ftell(FP);

        fseek(FP, f_pos, SEEK_SET);
        old_color = fgetc(FP);

        printf("Color for %s [%d]: ", name, old_color);
        gets(s);
        new_color = atoi(s);
        if(new_color<1 || new_color>127) new_color = old_color;

        fseek(FP, f_pos, SEEK_SET);
        fputc(new_color, FP);
}


void print_colors()
{
        int i,j;

        cprintf("\n");
        printf("Color Guide:\n");
        for(i=0; i<8; i++) {
                for(j=0; j<16; j++) {
                        textattr((i<<4) + j);
                        cprintf("[%3d]", (i<<4) + j);
                }
        }
        textattr(0x7);
        for(i=0; i<80; i++) cprintf(" ");
}


void usage()
{
        printf("USAGE:\n");
        printf("   PGCONFIG pg.com\n\n");
        printf("   Configures PG.COM with user specified values\n");
}

