/*****************************************************************************
 *
 *	ADIR version 0.2b
 *	Sameer Kalidas
 *	5 May 1996
 *
 *	Developed in Borland C++ 4.52
 *
 *****************************************************************************/

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>
#include <time.h>

#define MAX_ARGS 4
#define MAX_BUFFER 256
#define FALSE 0
#define TRUE 1
#define BOOL unsigned char

extern unsigned _stklen = 100000;			/* Adjust stack size to 100kb */

BOOL Debug = FALSE;

struct PathComponents
{
	char Drive[ _MAX_DRIVE ];
	char Dir[ _MAX_DIR ];
	char FileName[ _MAX_FNAME ];
	char Ext[ _MAX_EXT ];
	char FullPath[ _MAX_PATH ];
	char DirPath[ _MAX_DRIVE + _MAX_DIR ];
	char FullDir[ _MAX_DRIVE + _MAX_DIR ];
	char FullName[ _MAX_FNAME + _MAX_EXT ];
	BOOL WildCards;
};

struct PathComponentsCompact
{
	char *Drive;
	char *Dir;
	char *FileName;
	char *Ext;
	char *FullPath;
	char *DirPath;
	char *FullDir;
	char *FullName;
	BOOL WildCards;
};

struct Option
{
	BOOL	DisplayDefaultDirs;
	BOOL	Bare;
	BOOL	Recursive;
	BOOL	Find;
	BOOL	UserFormat;
	char	*FormatStr;
};

struct Option Option = { TRUE, FALSE, FALSE, FALSE, FALSE, NULL };

/*****************************************************************************
 *		sysErrMsg
 *****************************************************************************/
void sysErrMsg(const char *msg)
{
		extern int errno, sys_nerr;
		extern char *sys_errlist[];

		fprintf(stderr, "Error: %d - ",errno);
		if (errno > 0 && errno < sys_nerr)
				perror(msg);
		else
				fprintf(stderr, "%s\n", msg);
}

/*****************************************************************************
 *		AllocString
 *****************************************************************************/
char *AllocString( char *s )
{
	char *temp = ( char * )malloc( ( strlen( s ) + 1 ) * sizeof( unsigned char ) );
	strcpy( temp, s );
	return( temp );
}

/*****************************************************************************
 *		GetPathComponents
 *****************************************************************************/
void GetPathComponents( char *Path,
						char *Drive,
						char *Dir,
						char *FileName,
						char *Ext,
						char *FullPath,
						char *DirPath,
						char *FullDir,
						char *FullName,
						BOOL *WildCards )
{
	struct stat StatBuffer;

	_fullpath( FullPath, Path, _MAX_PATH );
	strupr( FullPath );
	_splitpath( FullPath, Drive, Dir, FileName, Ext );
	sprintf( FullName, "%s%s", FileName, Ext );

	if ( strlen( FullName ) > 0 )
	{
		if ( ( strchr( FullName, '*' ) == NULL ) && ( strchr( FullName, '?' ) == NULL ) )
		{
			if ( stat( FullPath, &StatBuffer ) == -1 )
			{
				sysErrMsg( "GPC(): stat()" );
				exit(1);
			}

			if ( S_IFDIR & StatBuffer.st_mode )
			{
				strcat( Dir, FullName );
				FileName = NULL;
				Ext = NULL;
				FullName = NULL;
			}

			*WildCards = FALSE;
		}
		else
			*WildCards = TRUE;
	}
	else
		*WildCards = FALSE;

	if ( ( strlen( Dir ) > 0 ) && ( Dir[ strlen( Dir ) - 1 ] == '\\' ) )
		Dir[ strlen( Dir ) - 1 ] = '\0';

	sprintf( FullDir, "%s%s", Drive, Dir );
	sprintf( DirPath, "%s%s\\", Drive, Dir );

	if ( ( strlen( FullDir ) > 0 ) &&
		 ( FullDir[ strlen( FullDir ) - 1 ] == ':' ) )
		strcat( FullDir, "\\" );
}

struct EntryData
{
	char		*FullName;
	char		*Drive;
	char		*Dir;
	char		FileName[ _MAX_FNAME ];
	char		Ext[ _MAX_EXT ];
	char		*DirPath;
	char		*FullDir;
	char		FullPath[ _MAX_PATH ];
	char		*RelPath;
	struct stat Stat;
};

struct EntryData ED;

/*****************************************************************************
 *		BuildLine
 *****************************************************************************/
int BuildLine( char *s, char *Output )
{
	int		i, ArgCount;
	struct	tm *TMtime;
	char	Arg[ MAX_ARGS ][ MAX_BUFFER ], Temp0[ MAX_BUFFER ], Temp1[ MAX_BUFFER ];

	Output[ 0 ] = '\0';
	i = 0;
	while ( i < strlen( s ) )
	{
		switch( s[ i ] )
		{
			/*
				Function handling system.
			*/
			case '!':
				i++;
				if ( s[ i ] == '!' )
					strcat( Output, "!" );
				else
				{
					/*
						Store function name in Temp0.
						Function name is from '!' to '('.
					*/
					Temp0[ 0 ] = '\0';
					while ( ( s[ i ] != '\0' ) && ( s[ i ] != '(' ) )
					{
						strncat( Temp0, &s[ i ], 1 );
						i++;
					}
					if ( s[ i ] != '\0' )
						i++;

					/*
						Get function arguments and store them in Arg[].
						ArgCount is the number of arguments.
						An argument is enclosed by ', anything not inside
						' are ignored.
					*/
					ArgCount = 0;
					while ( ( s[ i ] != '\0' ) && ( s[ i ] != ')' ) )
					{
						if ( s[ i ] == '\'' )
						{
							i++;
							i += BuildLine( &s[ i ], Arg[ ArgCount ] );
							ArgCount++;
/*							i += BuildLine( &s[ i ], Temp1 ] );
							if ( ArgCount < MAX_ARGS )
							{
								BuildLine( Temp1, Arg[ ArgCount ] );
								ArgCount++;
							}
*/							if ( s[ i ] != '\0' )
								i++;
						}
						else
							i++;
					}
					if ( s[ i ] != '\0' )
						i++;

					/*
						Function: ctime( arg1 )
						Outputs formated created time.
					*/
					if ( ( strcmp( Temp0, "ctime" ) == 0 ) & ( ArgCount == 1 ) )
					{
						TMtime = localtime( &ED.Stat.st_ctime );
						strftime( Temp0, MAX_BUFFER, Arg[ 0 ], TMtime );
						strcat( Output, Temp0 );
					}
					else
					/*
						Function: ifdir( arg1 arg2 )
						Outputs arg1 if file is a directory else outputs arg2.
					*/
					if ( ( strcmp( Temp0, "ifdir" ) == 0 ) & ( ArgCount == 2 ) )
					{
						if ( S_IFDIR & ED.Stat.st_mode )
							strcat( Output, Arg[ 0 ] );
						else
							strcat( Output, Arg[ 1 ] );
					}
					else
					/*
						Function: ifeq( arg1 arg2 arg3 arg4 )
						if arg1 == arg2 then outputs arg3 else outputs arg4.
					*/
					if ( ( strcmp( Temp0, "ifeq" ) == 0 ) & ( ArgCount == 4 ) )
					{
						if ( strcmp( Arg[ 0 ], Arg[ 1 ] ) == 0 )
							strcat( Output, Arg[ 2 ] );
						else
							strcat( Output,	Arg[ 3 ] );
					}

				}
				break;

			case '#':
				strcpy( Temp0, "%" );
				i++;
				switch( s[ i ] )
				{
					case '#':
						strcat( Output, "#" );
						break;

					case '-':
						strcat( Temp0, "-" );
						i++;

					default:
						if ( ( s[ i ] >= '0' ) && ( s[ i ] <= '9' ) )
						{
							while ( ( s[ i ] >= '0' ) && ( s[ i ] <= '9' ) )
							{
								strncat( Temp0, &s[ i ], 1 );
								i++;
							}
						}

						Temp1[ 0 ] = '\0';

						switch( s[ i ] )
						{
							case 's':
								strcat( Temp0, "u" );
								sprintf( Temp1, Temp0, ED.Stat.st_size );
								break;

							case 'v':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.Drive );
								break;

							case 'd':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.Dir );
								break;

							case 'f':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.FileName );
								break;

							case 'e':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.Ext );
								break;

							case 'F':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.FullName );
								break;

							case 'P':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.FullPath );
								break;

							case 'D':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.FullDir );
								break;

							case 'V':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.DirPath );
								break;

							case 'r':
								strcat( Temp0, "s" );
								sprintf( Temp1, Temp0, ED.RelPath );
								break;
						}
						strcat( Output, Temp1 );
						i++;
				}
				break;

			case '\\':
				i++;
				switch( s[ i ] )
				{
					case 'n':
						strcat( Output, "\n" );
						break;

					case 't':
						strcat( Output, "\t" );
						break;

					default:
						sprintf( Temp0, "%c", s[ i ] );
						strcat( Output, Temp0 );
						break;
				}
				i++;
				break;

			case '\'':
				return( i + 1 );

			default:
				strncat( Output, &s[ i ], 1 );
				i++;
		}
	}
	return( i );
}

/*****************************************************************************
 *		DisplayEntry
 *****************************************************************************/
void DisplayEntry(	char *DFullName, char *DDrive, char *DDir, char *DDirPath, char *DFullDir, char *RelPath )
{
	int i, Part;
	char Output[ MAX_BUFFER ];

	/*
		Before we start, lets first check if should display this name.
		DisplayDefaultDirs is TRUE then we display dirs '.' and '..'
		Otherwise we don't.
	*/
	if ( !Option.DisplayDefaultDirs && ( ( strcmp( DFullName, "." ) == 0 ) || ( strcmp( DFullName, ".." ) == 0 ) ) )
		 return;

	/*
		Set links in working structure.
	*/
	ED.Drive = DDrive;
	ED.Dir = DDir;
	ED.DirPath = DDirPath;
	ED.FullDir = DFullDir;
	ED.FullName = DFullName;
	ED.RelPath = RelPath;

	/*
		Build FullPath from conponents.
	*/
	sprintf( ED.FullPath, "%s%s", ED.DirPath, ED.FullName );

	/*
		Build FileName and Ext from FullName.
	*/
	ED.FileName[ 0 ] = '\0';
	ED.Ext[ 0 ] = '\0';
	Part = 0;
	for ( i = 0; i < strlen( ED.FullName ); i++ )
	{
		if ( ED.FullName[ i ] == '.' )
			Part = i;
		if ( Part == 0 )
		{
			ED.FileName[ i ] = ED.FullName[ i ];
			ED.FileName[ i + 1 ] = '\0';
		}
		else
		{
			ED.Ext[ i - Part ] = ED.FullName[ i ];
			ED.Ext[ i - Part + 1 ] = '\0';
		}
	}

	/*
		Get stat information.
	*/
	if ( stat( ED.FullPath, &ED.Stat ) == -1 )
	{
		sysErrMsg( "DisplayEntry(): stat()" );
		exit(1);
	}

	/*
		Has user given us a string to be used for displaying entries or not.
		If YES then call BuildLine() to build Output string to be displayed.
		Else Use a default format.
	*/
	if ( Option.UserFormat )
		BuildLine( Option.FormatStr, Output );
	else
		BuildLine( "#-13F!ifdir( '     <DIR>' '#10s' )   !ctime( '%d/%m/%y    %I:%M:%S%p' )\n", Output );

	printf( "%s", Output );
}

/*****************************************************************************
 *		ReadDirectoryContents
 *****************************************************************************/
void ReadDirectoryContents( char *Path )
{
	struct ffblk myffblk;
	DIR *dir;
	struct dirent *d;
	BOOL WildCards, done;
	char	DDrive[ _MAX_DRIVE ],
			DDir[ _MAX_DIR ],
			DFileName[ _MAX_FNAME ],
			DExt[ _MAX_EXT ],
			DFullPath[ _MAX_PATH ],
			DDirPath[ _MAX_DRIVE + _MAX_DIR ],
			DFullDir[ _MAX_DRIVE + _MAX_DIR ],
			DFullName[ _MAX_FNAME + _MAX_EXT ],
			RelPath[ _MAX_PATH ],
			Temp[ MAX_BUFFER ];

	GetPathComponents( Path, DDrive, DDir, DFileName, DExt, DFullPath,
				DDirPath, DFullDir, DFullName, &WildCards );

	if ( !WildCards )
	{
		if ( !Option.Bare )
			printf( "\n\tListing Of %s\n\n", DFullDir );

		if ( ( dir = opendir( DFullPath ) ) == NULL )
		{
			sysErrMsg( "open directory" );
			exit(1);
		}

		while ( ( d = readdir( dir ) ) != NULL )
		{
			if ( strcmp( ".", Path ) != 0 )
				strcpy( RelPath, Path );
			else
				strcpy( RelPath, "" );

			DisplayEntry( d->d_name, DDrive, DDir, DDirPath, DFullDir, RelPath );
			if ( Option.Recursive && ( S_IFDIR & ED.Stat.st_mode ) )
				if ( ( strcmp( ".", d->d_name ) != 0 ) & ( strcmp( "..", d->d_name ) != 0 ) )
				{
					if ( strcmp( ".", Path ) != 0 )
						sprintf( RelPath, "%s\\%s", Path, d->d_name );
					else
						strcpy( RelPath, d->d_name );
					ReadDirectoryContents( RelPath );
				}
		}

		closedir(dir);

		if ( !Option.Bare )
			printf( "\n\tEnd of Listing for %s\n\n", DFullDir );
	}
	else
	{
		if ( !Option.Bare )
			printf( "\n\tListing Of %s\n\n", DFullDir );

		done = findfirst( DFullPath, &myffblk, 32767 );
		while ( !done )
		{
			if ( strcmp( ".", Path ) != 0 )
				strcpy( RelPath, Path );
			else
				strcpy( RelPath, "" );

			DisplayEntry( myffblk.ff_name, DDrive, DDir, DDirPath, DFullDir, RelPath );
			if ( Option.Recursive && ( S_IFDIR & ED.Stat.st_mode ) )
				if ( ( strcmp( ".", myffblk.ff_name ) != 0 ) & ( strcmp( "..", myffblk.ff_name ) != 0 ) )
				{
					if ( strcmp( ".", Path ) != 0 )
						sprintf( RelPath, "%s\\%s", Path, d->d_name );
					else
						strcpy( RelPath, d->d_name );
					ReadDirectoryContents( RelPath );
				}
			done = findnext( &myffblk );
		}

		if ( Option.Find )
		{
			if ( ( dir = opendir( DFullDir ) ) == NULL )
			{
				sysErrMsg( "open directory" );
				exit(1);
			}

			while ( ( d = readdir( dir ) ) != NULL )
			{
				strcpy( Temp, DDirPath );
				strcat( Temp, d->d_name );
				if ( stat( Temp, &ED.Stat ) == -1 )
				{
					sysErrMsg( "DisplayEntry(): stat()" );
					exit(1);
				}
				strcat( Temp, "\\" );
				strcat( Temp, DFullName );
				if ( S_IFDIR & ED.Stat.st_mode )
					if ( ( strcmp( ".", d->d_name ) != 0 ) & ( strcmp( "..", d->d_name ) != 0 ) )
						ReadDirectoryContents( Temp );
			}

			closedir(dir);
		}

		if ( !Option.Bare )
			printf( "\n\tEnd of Listing for %s\n\n", DFullDir );
	}
}


/*****************************************************************************
 *		main
 *****************************************************************************/
void main(int argc, char *argv[])
{
	int i, HavePath = 0;
	char c[ 2 ], Buf[ 2048 ];
	FILE *f;
	char *Paths[ 256 ];

	for ( i = 1; i < argc; i++ )
	{
		if ( strcmp( argv[ i ], "/d" ) == 0 )
			Debug = TRUE;
		else if ( strcmp( argv[ i ], "/D" ) == 0 )
			Option.DisplayDefaultDirs = FALSE;
		else if ( strcmp( argv[ i ], "/r" ) == 0 )
			Option.Recursive = TRUE;
		else if ( strcmp( argv[ i ], "/f" ) == 0 )
			Option.Find = TRUE;
		else if ( strcmp( argv[ i ], "/b" ) == 0 )
			Option.Bare = TRUE;
		else if ( strcmp( argv[ i ], "/F" ) == 0 )
		{
			Option.UserFormat = TRUE;
			i++;
			Option.FormatStr = argv[ i ];
		}
		else if ( strcmp( argv[ i ], "/F@" ) == 0 )
		{
			i++;
			f = fopen( argv[ i ], "rt" );
			Buf[ 0 ] = '\0';
			c[ 1 ] = '\0';
			while ( !feof( f ) )
			{
				c[ 0 ] = getc( f );
				if ( ( !feof( f ) ) && ( c[ 0 ] != '\n' ) )
					strcat( Buf, c );
			}
			fclose( f );
			Option.UserFormat = TRUE;
			Option.FormatStr = Buf;
		}
		else
		{
			Paths[ HavePath ] = argv[ i ];
			HavePath++;
		}
	}

	if ( HavePath == 0 )
		ReadDirectoryContents( "." );
	else
	{
		for ( i = 0; i < HavePath; i++ )
		{
				ReadDirectoryContents( Paths[ i ] );
				printf( "\n" );
		}
	}
}

