; Procedure to create a (nearly) unique id from fields :-
;   Surname, Company, Position and Town
;  Ref is created as follows :-
;     Char From-To   Field chars extracted
;        1-2         Owners Id
;        3-6         1st 4 char of Surname   {or if blank, 1st 3 capitals of}
;        7-          1st Initial             {    Position + @@}
;        8-10        1st 3 cap's of Company  { or if blank, 1st 3 chars of }
;                                            {    Town         }
;       11-12        2 digits to make unique (00 to 99).

proc genid(firm)
  private flen,fptr,icount,lastchar,id2
  flen=len(firm)
  if flen=0 then
       return false
  endif
  id=id+substr(firm,1,1)
  fptr=2
  icount=1
  lastchar="@"
  if flen<2  then
      id=id+"@@@"
      icount=4
      return false
  endif
  id2=""
  while( fptr<=flen)
           firstchar=substr(firm,fptr,1)
           if firstchar>="A" and firstchar=upper(firstchar)
             then
               id2=id2+ firstchar
               lastchar=firstchar
               icount=icount+1
               if icount>2
                  then quitloop
               endif
            endif
          fptr=fptr+1
  endwhile

  if icount=1
    then
     id=id+substr(firm,2,2)
    else if icount=2
        then
         id=id+substr(firm,2,1)+lastchar
    else id=id+id2
    endif
  endif
  return true
endproc   ; genid
;**********CHECK NEW REC NOT COMPLETE & delete**************
proc DelNew()
            if refid=NodataId then
                del
                warnmsg("Insufficient data in new record- cancelling...")
                up
                sleep 1500
            endif
endproc
;**********SHOW WARNING MESSAGE*************************
proc warnmsg(strg)

  @msgrow,msgcol ??strg
  paintcanvas attribute 79 msgrow,msgcol,msgrow,len(strg)+msgcol
endproc  ;warnmsg
;**********SHOW Prompt MESSAGE*************************
proc Promptmsg(strg)
  @msgrow,msgcol ??strg
  paintcanvas attribute 47 msgrow,msgcol,msgrow,len(strg)+msgcol
  keycode=chr(getchar())
  if upper(keycode) = "Y" then return true
  else return false
  endif
endproc  ;warnmsg
;************EDITING PROC*************************
proc edmain()
private idc,ExitKey,DummyRecId,name,coy,posn,newrec,refstat,
        msg,delflag
array saverec[nfields(dbname)+1]
array currec[nfields(dbname)+1]
newrec=true
delflag=false
edform="F"
DummyRecId="New"
NodataId=idpfx+"@@@@@00"
mult_image=ismultiform(dbname,edform)
view refidtbl
coedit dbname
pickform edform
NoNextPage=true
while (true)
 if NoNextPage then
  execute get_ref
  if len(rid)<5  ; Check if new record A-add
   then
    refstat="A"
    oldid=DummyRecId
    if ismultiform(dbname,edform) then
        moveto dbname
    else
        if mult_image then
            moveto 1
        endif
    endif
    rid=oldid ; assign rid for put_ref
    execute put_ref
    execute put_cdate
   else              ; Existing record C-change
    refstat="C"
    oldid=rid  ; Ref
  endif
  if newrec then
    if ismultiform(dbname,edform) then
             moveto dbname
    endif
    copytoarray saverec ; save record
    newrec=false
    refid=oldid
  endif
 endif; if nonextpage
  NoNextPage=true
  wait record
        prompt"Keys:- F2=Update, F7=View as columns, F8=Delete, F9=Add, F10=Exit",
              "       Ctrl-D=Copy to new record, Ctrl-U=Undo last change, Ctrl_Z=Search"
  until "F2","PgDn","PgUp","F8","ZoomNext","Zoom","CtrlPgUp","CtrlPgdn",
        "home","end","Undo","F9","F10","F7","Ditto","F3","F4","Enter"
  ExitKey=Retval
  CurrentField=field()
  switch
    case  ExitKey="F7":   ; Form Toggle **************
          colview=true
          formkey
          while colview=true
            wait record
            prompt "Only use movement keys & use F7 or Esc to return to form",""
            until "PgUp","PgDn","Up","Down","Left","Right","F7","Esc"
            colexit=retval
            if colexit="F7" or colexit="Esc" then
             colview=false
            else
             keypress colexit
            endif
          endwhile
          pickform edform ; restore form view
          loop
    case  ExitKey="F8"  : ;delete key    ; DELETE *****************
          if promptmsg("Ok to delete? [Y/N]") then
              delflag=true
              del
              warnmsg("Deleting..         ")
              updatelog(dbname,dblog,dbchanges,"D")
          endif
          loop
    case  ExitKey="Undo":       ; RESTORE LAST CHANGE ***********
          if delflag then
             undo
             delflag=false
             ;newrec=true
          else
            if refid<> Dummyrecid and refid <> Nodataid then
               formkey
               moveto field Ref_no_field
               locate refid
               formkey
               copyfromarray saverec ;saved in an array.
               lockrecord
               unlockrecord
            endif
          endif
          loop
    case  ExitKey="Zoom" :  ;SEARCH *************
          keypress ExitKey
          wait field ; get user reply
            until "Enter","Esc"
          if retval="Esc" then
               loop
          endif
          warnmsg("Searching..        ")
          Enter ; implement zoom
          msg = window() ; find out if successful
          if len(msg)>1 then
             warnmsg(msg)  ; print not found message if unsuccessful
             sleep 2000
          endif
          newrec=true
          loop
    case  ExitKey="ZoomNext":  ;SEARCH NEXT *************
          warnmsg("Searching..        ")
          keypress ExitKey
          msg = window() ; find out if successful
          if len(msg)>1 then
             warnmsg(msg)  ; print not found message if unsuccessful
             sleep 2000
          endif
          newrec=true
          loop
     case ExitKey="F9" :          ; ADD NEW RECORD **************
          ins
          newrec=false     ; set so blank record not saved
          loop
     case ExitKey="Ditto":      ; COPY TO NEW Main RECORD ***********
         if ismultiform(dbname,edform) then
             moveto dbname
         else
            if mult_image then
               moveto 1
            endif
         endif
          copytoarray currec
          ins
          copyfromarray currec
          rid=""
          execute put_ref
          loop
     case ExitKey="PgDn" and npages()>1:
            if pageno()<npages() then
              keypress ExitKey
              NoNextPage=false
              loop
            endif
     case ExitKey="PgUp" and npages()>1:
            if pageno()>1 then
              keypress ExitKey
              NoNextPage=false
              loop
            endif
     case ExitKey="F3" or ExitKey="F4" :
              NoNextPage=false
            keypress ExitKey
            loop
     case  ExitKey="Enter":
            NoNextPage=false
            if field()=last_main_fld then
               beep
            else
               keypress ExitKey
            endif
            loop
  endswitch
  execute get_ref; sets rid to [ref-field]
  refid=rid
  delflag=false
  ; Test for record change or new record
  if recordstatus("Modified") or refstat="A"
       then
         warnmsg("Checking Ref-id... ")
       ; check for valid record
         if ismultiform(dbname,edform) then
             moveto dbname
             CurrentField=field()
         endif
         if refstat="A" then
                execute put_cdate
         endif
       ; Extract standard fields
         execute get_title
         execute get_inits
         execute get_name
         execute get_coy
         execute get_posn
         execute get_town
         ; Set default salutation
         execute put_salut
         execute put_udate
       ; Now create Reference number
         id=""
         if len(name) > 2
           then
             id=id+substr(name,1,4)
             id=id+substr(inits,1,1)
           else
             genid(posn)
         endif
         while (len(id) <5)
           id=id+ "@"
         endwhile
         genid(coy)
         if len(id) < 6 then
              id=id+substr(town,1,3)
         endif
         id=idpfx+upper(id)
         idc=0
         ; Check for change to created part of refno or new record
         if id<>substr(oldid,1,len(id)) or oldid=DummyRecId then
          formkey
          moveto refidtbl
          lockrecord ; Secure record
          while (true)  ; Change to new record id
           rid=id+substr(format("EZ, W5",idc),4,2)
           [ref]=rid
           unlockrecord ; try to post record
           if not recordstatus("Locked") then ;?conflict with an existing id
                refid=rid
                quitloop                  ; and exit while(true)
           endif
           idc=idc+1                      ; Conflict so add one & try again
           if idc=1 then
              warnmsg("Posible duplicate")
              sleep 2000
              ExitKey="F2"  ; Ensure no movement or exit this time
           endif
          endwhile
          moveto dbname
          pickform edform
          execute put_ref   ; set in new id
         endif
   endif ; end of test for record change or new record
 switch
   case  ExitKey="F10" or ExitKey="Esc" :
         if ismultiform(dbname,edform) then
             moveto dbname
         else
           if mult_image then
             moveto 1
           endif
         endif
         quitloop
   case  ExitKey="F2" :
         if ismultiform(dbname,edform) then
             moveto dbname
         endif
          if refid=NodataId then
            warnmsg("No name or position entered")
            rid=""  ;Ref
            execute put_ref
            sleep 1500
            if promptmsg("Ok to delete? [Y/N]") then
                 del
             else
                 loop
              endif
          endif
         if refid<>DummyRecId and len(refid)>6 then
            formkey
            moveto field Ref_no_field
            locate refid
            formkey
            moveto field CurrentField
         endif
         loop
 endswitch
 DelNew()  ; ? only when moving to new record!!!!!!!!!!
 keypress ExitKey
 newrec=true
endwhile ; End of adding records
Delnew()
do_it!
endproc ;edmain

proc edinit()
;array order[12]
systb="sys_tbl"
array tbl_nam[nrecords(systb)]
array tbl_desc[nrecords(systb)]
;Define standard names for stdorder[]
nostd=8
no_flds=10
msgrow=2
msgcol=0

if not istable(systb) then
   warnmsg("Table :- sys_tbls missing")
   sleep 3000
   quit
endif

view systb
count=0
scan for not isblank([Table])   ; get defined tables
    count=count+1
    tbl_nam[count]=[Table]
    tbl_desc[count]=[Description]
endscan

tbl_no=1
if nrecords(systb)>1 then  ; More than one table maintained : Select
    showarray tbl_nam tbl_desc
    to sel_tbl
    if sel_tbl="Esc" then
         quit
    endif
    ; Now find table no
    moveto[table]
    locate sel_tbl
    tbl_no=recno()
endif
warnmsg("Initialising....")

; Read in position of standard fields in select table
moveto record tbl_no

dbname=[Table]
;Title_field=[A_title]
if isblank([A_title]) then
     get_title="titl=\"@\""
else
     get_title="titl=["+dbname+"->"+[a_title]+"]"
endif
if isblank([Surname])then
     get_name="name=\"@\""
else
     get_name="name=["+dbname+"->"+[Surname]+"]"
endif
if isblank([Initials])then
     get_inits="inits=\"@\""
else
     get_inits="inits=["+dbname+"->"+[Initials]+"]"
endif
if isblank([Company/Organisation])then
     get_coy="coy=\"\""
else
     get_coy="coy=["+dbname+"->"+[Company/Organisation]+"]"
endif
if isblank([Position/Job title])then
     get_posn="posn=\"\""
else
     get_posn="posn=["+dbname+"->"+[Position/Job title]+"]"
endif
if isblank([Town])then
     get_town="town=\"\""
else
     get_town="town=["+[Town]+"]"
endif
Ref_no_field=[Ref]
get_ref="rid=["+dbname+"->"+[Ref]+"]"
put_ref="["+dbname+"->"+[Ref]+"]=rid"
if isblank([Date of creation])then
     put_cdate=";"
else
     put_cdate="["+dbname+"->"+[Date of creation]+"]=today()"
endif
if isblank([Update date])then
     put_udate=";"
else
     put_udate="["+dbname+"->"+[Update date]+"]=today()"
endif
if isblank([Salutation])then
     put_salut=";"
else
     put_salut="if isblank(["+dbname+"->"+[Salutation]+"]) then ["
     +dbname+"->"+[Salutation]+"]=titl+\" \"+name endif"
endif
idpfx=[Ref_prefix]
dbstem=substr(dbname,1,4)
refidtbl=[Ref-id table]

; find first & last  fields in main form
view dbname
last_main_fld=0
edform="F"
pickform edform
first_main_fld=field()
execute get_ref
oldid=rid
while oldid=rid
  last_main_fld=field()
  Enter
  execute get_ref
endwhile
endproc ;edinit

writelib TKLibName genid,delnew,edmain,edinit




