;
;The 3.5 version requires that you save a blank screen from WordPerfect and
;name it BLANK.WP.  Either modify the script so it knows where to look for
;it or have it in the current directory.  The reason for it is that 3.5
;cannot PRINT FILE an ASCII 255.  Enjoy but don't sell.

;EXPORT.SC 7/22/92

PROC Introducing()
 CLEARALL
 CLEAR
 @3,0
 STYLE INTENSE
 ?? FORMAT("W80,AC","Denison University Export Script")
 STYLE
 @5,0
 TEXT
              Written by: Charlie Reitsma and Chen Zhao
                          Academic Computing Services
                          Denison University
                          Granville, OH 43050

             Modified by: Andrew Cunningham
                          Manchester Business School (5/5/92)

    Paradox script to export all records and fields of a table to a file.
     Export formats available:
      WordPerfect Secondary Merge - 5.1 format.
        Includes named fields using the Paradox field names.
      Fixed Length - no delimiters, width of each field column
        is determined by the widest entry in that column.
      Delimited - choice of delimiters, no leading spaces except with
        Date fields. Currency fields have "$" prepended.
 ENDTEXT
ENDPROC ;Introducing

PROC MainMenu()
 SHOWMENU
  "WP Merge"     :  "Create a WordPerfect Secondary Merge file",
  "Fixed Length" :  "Output file in fixed length format",
  "Delimited"    :  "Output file in delimited format",
  "Esc"          :  "Quit this script"
 TO choice
 IF choice = "Esc" THEN
  return false
 ENDIF
 return true
ENDPROC ;Main_Menu

PROC SelectTable()
 SHOWTABLES
  DIRECTORY()
  "Highlight the table to export, then press RETURN"
 TO tablename
 if tablename<>"Esc" then
    tablename = FORMAT("CU",tablename)
    SWITCH
     CASE choice = "Fixed Length" : ext = ".DAT"
     CASE choice = "Delimited"    : ext = ".TXT"
     CASE choice = "WP Merge"     : ext = ".SEC"
    ENDSWITCH
    rptname = wp_dir + tablename + ext
    @18,0
    STYLE INTENSE
    ? "The DATA FILE created will be ", rptname
    return false
 else
    return true
 endif
ENDPROC ;SelectTable

PROC Initialize()
 VIEW tablename
 fld_count = NFIELDS(tablename) + 1
 ARRAY fld_name[fld_count]
 ARRAY fld_type[fld_count]
 ARRAY fld_width[fld_count]
 CTRLHOME
 FOR i FROM 1 TO fld_count
  fld_name[i] = FIELD()
  fld_type[i] = FIELDTYPE()
  RIGHT
 ENDFOR
ENDPROC ;Initialize

PROC FindWidth()
 ARRAY fld_width[fld_count]
 ARRAY break_at[fld_count] ;assumes less than fld_count line breaks
 FOR i FROM 1 TO fld_count
  fld_width[i] = 0
  break_at[i]=0
 ENDFOR
 SCAN
  CTRLHOME
  FOR i FROM 1 TO fld_count
   MOVETO FIELD fld_name[i]
   fld_width[i] = MAX(fld_width[i],LEN(FIELDSTR()))
  ENDFOR
 ENDSCAN
 j = 0
 k = 1
 FOR i FROM 1 TO fld_count
  j = j + fld_width[i]
  IF j > line_width THEN
   break_at[k] = i - 1
   j = fld_width[i]
   k = k + 1
  ENDIF
 ENDFOR
ENDPROC ;FindWidth

PROC MakeFormat()
 ARRAY fld_format[fld_count]
 FOR i FROM 1 to fld_count
  SWITCH
   CASE fld_type[i] = "N" :
    fld_format[i] = "W" + STRVAL(fld_width[i]) + ",AR"
   CASE fld_type[i] = "S" :
    fld_format[i] = "W" + STRVAL(fld_width[i]) + ",AR"
   CASE fld_type[i] = "$" :
    fld_format[i] = "W" + STRVAL(fld_width[i]) + ",AR"
   CASE fld_type[i] = "D" :
    fld_format[i] = "D1"
   OTHERWISE :
    fld_format[i] = "W" + STRVAL(fld_width[i]) + ",AL"
  ENDSWITCH
 ENDFOR
ENDPROC ;MakeFormat

PROC FixedLength()
 FOR i FROM 1 TO (fld_count-1)
  PRINT FILE rptname fld_name[i],"=",fld_width[i],","
 ENDFOR
 PRINT FILE rptname fld_name[fld_count],"=",fld_width[fld_count],"\n"
 SCAN
  k = 1
  FOR i FROM 1 TO fld_count
   MOVETO FIELD fld_name[i]
   SWITCH
    CASE fld_type[i] = "N" :
     PRINT FILE rptname FORMAT(fld_format[i], FIELDSTR())
    CASE fld_type[i] = "S" :
     PRINT FILE rptname FORMAT(fld_format[i], FIELDSTR())
    CASE fld_type[i] = "$" :
     PRINT FILE rptname FORMAT(fld_format[i], FIELDSTR())
    CASE fld_type[i] = "D" :
     PRINT FILE rptname FORMAT(fld_format[i], [])
    OTHERWISE :
     PRINT FILE rptname FORMAT(fld_format[i], FIELDSTR())
   ENDSWITCH
   IF break_at[k] > 0 THEN
    IF i = break_at[k] THEN
     k = k + 1;
     PRINT FILE rptname "\n"
    ENDIF
   ENDIF
  ENDFOR
  PRINT FILE rptname "\n"
 ENDSCAN
ENDPROC ;FixedLength

PROC Delimited()
 ? "Enter the delimiter to separate fields: "
 MESSAGE "Hit RETURN when ready..."
 ACCEPT "A1"
  PICTURE "@"
  DEFAULT ","
 TO delimiter
 MESSAGE "Please wait..."
 SCAN
  CTRLHOME
  FOR i FROM 1 TO fld_count
   MOVETO FIELD fld_name[i]
   SWITCH
    CASE fld_type[i] = "N" :
     PRINT FILE rptname FIELDSTR()
    CASE fld_type[i] = "S" :
     PRINT FILE rptname FIELDSTR()
    CASE fld_type[i] = "$" :
     s = "$" + FIELDSTR()
     IF s <> "$" THEN
      PRINT FILE rptname s
     ENDIF
    CASE fld_type[i] = "D" :
     PRINT FILE rptname FORMAT("D5",[])
    OTHERWISE :
     PRINT FILE rptname FIELDSTR()
   ENDSWITCH
   IF i <> fld_count THEN
    PRINT FILE rptname delimiter
   ENDIF
  ENDFOR
  PRINT FILE rptname "\n"
 ENDSCAN
ENDPROC ;Delimited

PROC WPMerge()
 MESSAGE "Please wait..."
 HardReturn = "\140"
 EndField = "\222\049\004\000\004\000\049\222" + HardReturn
 IF fld_count = 10 THEN
  tmp = "\011" ; lie because Paradox cannot PRINT FILE an ASCII 10.
 ELSE
  tmp = CHR(fld_count)
 ENDIF
 EndRecord = "\222\052\006\000" + tmp + "\000\006\000\052\222\012"
 RUN NOREFRESH "copy " + blank_wp + " " + rptname + " >nul"
 PRINT FILE rptname "\222\098\004\000\004\000\098\222" + HardReturn
 FOR i FROM 1 TO fld_count
  PRINT FILE rptname fld_name[i] + "~" + HardReturn
 ENDFOR
 PRINT FILE rptname "~" + EndRecord
 SCAN
  CTRLHOME
  FOR i FROM 1 TO fld_count
   MOVETO FIELD fld_name[i]
   PRINT FILE rptname FIELDSTR(), EndField
  ENDFOR
  PRINT FILE rptname EndRecord
 ENDSCAN
ENDPROC ;WPMerge

CLEARALL
CLEAR
CANVAS OFF
Introducing()
CANVAS ON
if not isassigned(wp_dir) then
     if direxists("c:\\wp51")=1 then
          wp_dir="c:\\wp51\\"
     endif
endif
blank_wp=wp_dir+"blank.wp"
if not isfile(blank_wp)  then
     blank_wp="f:\home\scripts\blank.wp" ; mod for MBS-fs2 server
endif
no_table=true
while (no_table)
   sel_menu=MainMenu()
   if not sel_menu then
       quitloop
   endif
   no_table=SelectTable()
endwhile
if sel_menu then
    Initialize()
    SWITCH
     CASE choice = "Fixed Length" :
      SHOWMENU
       "80 column"   :  "maximum of 80 characters per line",
       "132 column"  :  "maximum of 132 characters per line",
       "Single line" :  "one line maximum per record"
      TO choice1
      SWITCH
       CASE choice1 = "80 column" : line_width=80
       CASE choice1 = "132 column" : line_width=132
       CASE choice1 = "Single line" : line_width=0
      ENDSWITCH
      MESSAGE "Please wait..."
      FindWidth()
      MakeFormat()
      FixedLength()
     CASE choice = "Delimited" :
      Delimited()
     CASE choice = "WP Merge" :
      WPMerge()
    ENDSWITCH
    @22,0
    ?? SPACES(80)
    @19,0
    ? choice + " export complete.  Hit RETURN to go back to Paradox..."
    ACCEPT "A1"
     PICTURE "\r"
    TO x
    CLEAR
    CLEARALL
endif
