;**************************************************************************
;                   Dynamic Menu System                                   *
;                           by                                            *
;                   Andrew Cunningham                                     *
;                Manchester Business School                               *
;                                                                         *
;             Menu display routines developed by:-                        *
;             Harry Goldman, DataBase Designs Inc.                        *
;                                                                         *
;             Paradox script files:-                                      *
;     SY_MENU.SC    Dynamic menu routines by A.C.                         *
;     AU_UTILS.SC   Routines from GOLDUTIL2.SC by H.G., modified by A.C.  *
;     SY_MAKE.SC    Script to create library file                         *
;     MENU.SC       This file                                             *
;                                                                         *
;                                                                         *
;**************************************************************************
;    Created March 1993.                                                  *
; Version 1.4          Last main mod: 19 Jan  1994                        *
; Minor Paradox4.5 edits: 18 may 1994                                     *
; 1. Added search for existing script in current, top level then sys_path *
; 2. Only allow one common password for encrypted tables, will prompt for *
;    password on 1st access.                                              *
;**************************************************************************


;**************************************************************************
;    USER MAY NEED TO MODIFY THE NEXT 3 LINES
;**************************************************************************
menu_title="Paradox Menu System" ; Title to appear on menu screen
sys_path="c:\\menu45\\"            ; Path to menu scripts & library
;top_dir=directory containing top level menu tables sys_*.db etc
;**************************************************************************


;**************************************************************************
;                                                                         *
;        Check that initial menu table present - if not create it         *
;        in the current directory and then start the menu system.         *
;                                                                         *
;**************************************************************************
TKLibName=sys_path+"sys_lib"
readlib TKLibName menuheader.u,Menu.u,Menuctl.u,Message.u,checkprinter.l,
                  checktbl.l,create_menu,Initheader.u,GetTblNames.u
Initheader.u()
canvas on
if not istable("sys_menu") or not istable("sys_medt") then
 readlib TKLibName Init_menu
 Init_menu()        ; create inital menu table (sys_menu)
 release procs Init_menu
endif
readlib TKLibName warnmsg,promptmsg,prompt_box,sho_form,sel_tilde,sho_menu,
setmenu,sho_help,update_tbl_lst
sho_menu()          ; display initial menu
if PW.l then        ;check for password flag
  unpassword PW.a
endif
release procs all
;release vars all
