/****************************************************************************
*
*						  Ultra Long Period Timer
*
*                   Copyright (C) 1993-4 SciTech Software
*							All rights reserved.
*
* Filename:		$RCSfile: ulztimer.c $
* Version:		$Revision: 1.5 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:	Module to interface to the BIOS Timer Tick for timing
*				code that takes up to 24 hours (ray tracing etc). There
*				is a small overhead in calculating the time, this
*				will be negligible for such long periods of time.
*
* $Id: ulztimer.c 1.5 1994/08/22 11:56:13 kjb release $
*
****************************************************************************/

#include "pmode.h"
#include "ztimer.h"

ushort 			_ZTimerBIOS;
static ulong	start,finish;

void ZTimerInit(void)
{ _ZTimerBIOS = PM_getBIOSSelector(); }

void ULZTimerOn(void)
{ start = ULZReadTime(); }

void ULZTimerOff(void)
{ finish = ULZReadTime(); }

ulong ULZTimerLap(void)
{ return ULZElapsedTime(start,ULZReadTime()); }

ulong ULZTimerCount(void)
{ return ULZElapsedTime(start,finish); }

ulong ULZReadTime(void)
/****************************************************************************
*
* Function:		ULZReadTime
* Returns:		Current timer tick count.
*
* Description:	We turn of interrupts while we
*				get the value from the BIOS data area since it is stored
*				as two bytes and an interrupt COULD stuff up our reading.
*
****************************************************************************/
{
	ulong	ticks;

	_disable();				/* Turn of interrupts 				*/
	ticks = PM_getLong(_ZTimerBIOS,0x6C);
	_enable();				/* Turn on interrupts again 		*/

	return ticks;
}

ulong ULZElapsedTime(ulong start,ulong finish)
/****************************************************************************
*
* Function:		ULZElapsedTime
* Parameters:	start	- Starting timer tick value
*				finish	- Ending timer tick value
*
* Returns:		Elapsed timer between starting time and ending time in
*				1/18 ths of a second.
*
****************************************************************************/
{
	/* Check to see whether a midnight boundary has passed, and if so
	 * adjust the finish time to account for this. We cannot detect if
	 * more that one midnight boundary has passed, so if this happens
	 * we will be generating erronous results.
	 */

	if (finish < start)
		finish += 1573040L;			/* Number of ticks in 24 hours		*/

	return finish - start;
}
