#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               DJGPP port of GNU C/C++ to DOS with go32 DOS Extender.
#
# $Id: DJ32.MK 1.1 1994/08/22 11:08:20 kjb Exp $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .a     # Libraries
   E            := .exe   # Executables
   O            := .o     # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT SHW BETA

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := gcc      # C-compiler and flags
   CFLAGS       += -Wall
   COMPILE_ONLY := -c       # Only compile the C source, dont link
   AS           := tasm     # Assembler and flags
   ASFLAGS      += /MX /m /D__FLAT__ /i$(SCITECH)\INCLUDE
   LD           := dj_ld    # Loader and flags
   LDFLAGS      += $(CFLAGS)
   LIB          := ar       # Librarian
   LIBFLAGS     += rs

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -g       # Turn on debugging for C compiler
   ASFLAGS      += /ZI      # Turn on debugging for assembler
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += -O2
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# DOS extender dependant flags
   DX_CFLAGS    += -DDJGPP
   DX_ASFLAGS   += -DDJGPP

# Define where to install library files
   LIB_DEST     := $(SCITECH)\$(LIB_DIR)\DJ32

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; $(CC) $(CFLAGS) -c $<
   %$O: %$P ; $(CC) $(CFLAGS) -c $<
   %$O: %$A ;
@[
    $(AS) $(ASFLAGS) $(<:s,/,\);
    emxaout -u $*.obj
]


# Implicit rule for building a library file using response file
   %$L:      ; $(LIB) $(LIBFLAGS) $@ @$(mktmp $?\n))

# Implicit rule for building an executable file using response file
   %$E:      ; $(LD) $(LDFLAGS) $@ @$(mktmp $& $(EXELIBS) -lm -lpc)

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

