#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               Borland C++ 4.0 32 bit version. Supports Borland's DOS Power
#               Pack DPMI32 DOS extender and Phar Lap's TNT DOS Extender.
#
# $Id: BC32.MK 1.1 1994/08/22 11:08:20 kjb Exp $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .lib   # Libraries
   E            := .exe   # Executables
   O            := .obj   # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT SHW BETA TNTX

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := bcc32    # C-compiler and flags
   CFLAGS       += -5 -H=bcc32.sym -D__MSDOS__
   COMPILE_ONLY := -c       # Only compile the C source, dont link
   AS           := tasm     # Assembler and flags
   ASFLAGS      += /MX /m /D__FLAT__ /i$(SCITECH)\INCLUDE
   LD           := bcc32    # Loader and flags
   LDFLAGS      += $(CFLAGS)
   LIB          := tlib     # Librarian
   LIBFLAGS     += /C

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -v       # Turn on debugging for C compiler
   ASFLAGS      += /ZI      # Turn on debugging for assembler
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += -O -Obegilmptv -k- -a4 -ff -Z -d
.END

# Optionally turn on direct i387 FPU instructions

.IF $(FPU)
   ASFLAGS      += -DFPU387
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# Optionally use Phar Lap's TNT DOS Extender, otherwise use the DOS Power Pack
.IF $(TNTX)
   DX_CFLAGS    += -DTNT
   DX_ASFLAGS   += -DTNT
.ELSE
   DX_CFLAGS    += -WX -DDPMI32
   DX_ASFLAGS   += -DDPMI32
.END

# Define where to install library files
   LIB_DEST     := $(SCITECH)\$(LIB_DIR)\BC32

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; $(CC) $(CFLAGS) -c $<
   %$O: %$P ; $(CC) $(CFLAGS) -c $<
   %$O: %$A ; $(AS) $(ASFLAGS) $(<:s,/,\);

# Implicit rule for building a library file using response file
   %$L:      ; $(LIB) $(LIBFLAGS) $@ @$(mktmp -+$(?:t" &\n-+")\n)

# Implicit rule for building an executable file using response file

.IF $(TNTX)
   %$E: ;
@[
    @cp $(mktmp stub 'gotnt.exe') $*.def
    $(LD) $(LDFLAGS) -e$@ @$(mktmp $& $(EXELIBS) dosx32.lib)
    @rm $*.def
]
.ELSE
   %$E:      ; $(LD) $(LDFLAGS) -e$@ @$(mktmp $& $(EXELIBS))
.END

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

