@echo off
rem
rem Generic batch file to build a version of the library. This batch file
rem assumes that the correct batch files exist to setup the appropriate
rem compilation environments, and that the DMAKE.EXE (renamed to MAKE.EXE)
rem program is available somewhere on the path.
rem
rem $Id$
rem

set _SHW=%SHW%
set _BETA=%BETA%
set _TNTX=%TNTX%
if %2==SHW set SHW=1
if %2==BETA set BETA=1
if %2==TNTX set TNTX=1
if %3==TNTX set TNTX=1

if %1==all goto doall
if %1==bc3 goto bc3
if %1==bc16 goto bc16
if %1==bc32 goto bc32
if %1==vc16 goto vc16
if %1==vc32 goto vc32
if %1==sc16 goto sc16
if %1==sc32 goto sc32
if %1==wc16 goto wc16
if %1==wc32 goto wc32
if %1==hc32 goto hc32
if %1==dj32 goto dj32
if %1==em32 goto em32

echo Usage: BUILD compiler_name [SHW] [BETA] [TNTX]
echo Current compilers:
echo    bc3     - Borland C++ 3.1 16 bit library
echo    bc16    - Borland C++ 4.0 16 bit library
echo    bc32    - Borland C++ 4.0 32 bit library
echo    vc16    - Microsoft Visual C++ 1.5 16 bit library
echo    vc32    - Microsoft Visual C++ 1.5 32 bit library
echo    sc16    - Symantec C++ 6.1 16 bit library
echo    sc32    - Symantec C++ 6.1 32 bit library
echo    wc16    - Watcom C++ 10.0 16 bit library
echo    wc32    - Watcom C++ 10.0 32 bit library
echo    hc32    - Metaware High C++ 3.21 32 bit library
echo    dj32    - DJGPP port of GNU C++ 32 bit library
echo    em32    - EMX port of GNU C++ 32 bit library
echo This batch file will build all libraries with full optimisations
echo turned on. If you specify the 'all' compiler all compiler versions
echo will be built. If you specify 'SHW' after the compiler name, a shareware
echo version will be built, or if you specify 'BETA' a beta release version
echo will be built. If you specify 'TNTX', the Phar Lap TNTX DOS Extender will
echo be used to build executable files.
goto end

:doall

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 3.1 16 bit library

:bc3
call bc3-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 4.0 16 bit library

:bc16
call bc16-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 4.0 32 bit library

:bc32
call bc32-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Microsoft Visual C++ 1.5 16 bit library

:vc16
rem call vc16-vars.bat
rem make cleanexe
rem make OPT=1 install
rem if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Mircosoft Visual C++ 1.5 32 bit library

:vc32
rem call vc32-vars.bat
rem make cleanexe
rem make OPT=1 install
rem if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Symantec C++ 6.1 16 bit library

:sc16
call sc16-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Symantec C++ 6.1 32 bit library

:sc32
call sc32-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Watcom C++ 10.0 16 bit library

:wc16
call wc16-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Watcom C++ 10.0 32 bit library

:wc32
call wc32-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Metaware High C++ 3.21 32 bit library

:hc32
call hc32-vars.bat
make cleanexe
make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for DJGPP port of GNU C++ 32 bit library

:dj32
rem call dj32-vars.bat
rem make cleanexe
rem make OPT=1 install
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for EMX port of GNU C++ 32 bit library

:em32
rem call em32-vars.bat
rem make cleanexe
rem make OPT=1 install
rem if errorlevel 1 goto errorend
if not %1==all goto done

call bc3-vars.bat

:done
make clean
echo Done!
goto end
:errorend
echo *************************************************
echo * An error occurred while building the library. *
echo *************************************************
set SHW=%_SHW%
set BETA=%_BETA%
set TNTX=%_TNTX%
unset /Q _SHW
unset /Q _BETA
unset /Q _TNTX
:end

