/****************************************************************************
*
*							  The MegaToolbox
*
*                   Copyright (C) 1993 SciTech Software
*							All rights reserved.
*
* Filename:		$RCSfile: mouse.h $
* Version:		$Revision: 1.3 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:	Header file for the mouse interface module.
*
*	For full compatibility with this module, you must have one of the
*	following mice:
*
*		-	Microsoft Mouse version 6.1 or later, or any mouse compatible
*			with this mouse.
*		-	Logitech Mouse version 3.4 or later.
*		-	Mouse Systems' PC Mouse version 6.22 or later.
*		-	IMSI mouse version 6.11 or later.
*
* $Id: mouse.h 1.3 1994/03/06 07:53:13 kjb release $
*
****************************************************************************/

#ifndef	__MOUSE_H
#define	__MOUSE_H

#ifndef __DEBUG_H
#include "debug.h"
#endif

/*--------------------- Macros and type definitions -----------------------*/

#define leftBut		0			/* Button types for MS_pressed() etc	*/
#define	rightBut	1
#define middleBut	2

#define	SOFTWARE	0			/* Text cursor types					*/
#define HARDWARE	1

typedef struct {				/* Mouse status structure				*/
	int			but_status;		/* Which buttons are currently down		*/
	int			but_count;		/* Number of presses for button			*/
	int			x;				/* Position of last button press h		*/
	int			y;				/* Position of last button press v		*/
	} ms_status;

typedef struct {				/* Interrupt subroutine info structure	*/
	void		*addr;			/* Address of interrupt subroutine		*/
	int			mask;			/* Mask for subroutine					*/
	} intsub;

typedef	unsigned int bits16[16];

typedef	struct {				/* Graphical cursor structure			*/
	bits16		screenmask;
	bits16		cursormask;
	int			hotspot_x;
	int			hotspot_y;
	} cursor;

/*------------------------- Function Prototypes ---------------------------*/

#ifdef	__cplusplus
extern "C" {			/* Use "C" linkage when in C++ mode	*/
#endif

int		PUBAPI MS_init(void);
void	PUBAPI MS_exit(void);
void	PUBAPI MS_suspend(void);
void	PUBAPI MS_resume(void);
int		PUBAPI MS_hardReset(void);
void	PUBAPI MS_show(void);
void	PUBAPI MS_hide(void);
void	PUBAPI MS_pos(ms_status *stat);
void	PUBAPI MS_moveTo(int h,int v);
void	PUBAPI MS_pressed(int which,ms_status *stat);
void	PUBAPI MS_released(int which,ms_status *stat);
void	PUBAPI MS_constrain(int left,int top,int right,int bottom);
void	PUBAPI MS_setCursor(cursor *curs);
void	PUBAPI MS_setTextCursor(int type,int screenMask,int cursorMask);
void	PUBAPI MS_motion(int *h,int *v);
void	PUBAPI MS_speed(int hratio,int vratio);
void	PUBAPI MS_dblSpeed(int threshold);
void 	PUBAPI MS_swapIntSub(int num,intsub *newSub,intsub *oldSub);
int 	PUBAPI MS_stateSize(void);
void	PUBAPI MS_saveState(void *theState);
void	PUBAPI MS_restoreState(void *theState);
void	PUBAPI MS_setCrtPage(int page);
int		PUBAPI MS_getCrtPage(void);
int		PUBAPI MS_softReset(void);

#ifdef	__cplusplus
}						/* End of "C" linkage for C++	*/
#endif

#endif  /* __MOUSE_H */
