/****************************************************************************
*
*					Demo - Demonstration Program for the
*						MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: titlwind.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Member functions for the class TitleWindow, a class
*				providing information about the current demo in progress.
*
* $Id: titlwind.cpp 1.2 1994/03/09 11:29:38 kjb release $
*
****************************************************************************/

#include "demo.hpp"

#pragma	hdrstop

#include "titlwind.hpp"

/*----------------------------- Implementation ----------------------------*/

TitleWindow::TitleWindow(const TRect& bounds)
	: TDialog(bounds,NULL,wfFramed),
	  TWindowInit(TWindow::initFrame,TWindow::initTitleBar)
/****************************************************************************
*
* Function:		TitleWindow::TitleWindow
* Parameters:	bounds		- Bounding box for the window
*
* Description:	Constructor for the TitleWindow class. The window will
*				be placed at the top of the bounding box passed to
*				this routine.
*
****************************************************************************/
{
	options &= ~(ofSelectable | ofFirstClick);

	fontManager.useFont(fmSystemFont);

	// Adjust the bounds for the entire window

	TRect	r(innerBounds());
	int		borderH = r.left() - bounds.left();
	int		borderV = r.top() - bounds.top();

	r.bottom() = r.top() + MGL_textHeight();
	title = new TStaticText(r,"",0);
	insert(title);

	r.inset(-borderH,-borderV);
	setBounds(r);
}

void TitleWindow::handleEvent(TEvent& event,phaseType)
/****************************************************************************
*
* Function:		TitleWindow::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TitleWindow class. Here
*				we handle events that change the text in the window.
*
****************************************************************************/
{
	if (event.what == evBroadcast) {
		if (event.message.command == cmSetDemoTitle) {
			title->setText((const char *)event.message.infoPtr);
			clearEvent(event);
			}
		}
}
