/****************************************************************************
*
*					Demo - Demonstration Program for the
*						MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: demo.cpp $
* Version:		$Revision: 1.3 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Implementation for the demo program.
*
* $Id: demo.cpp 1.3 1994/03/09 11:29:32 kjb release $
*
****************************************************************************/

#include "demo.hpp"

#pragma	hdrstop

#include "msgbox.hpp"
#include "tmodesel.hpp"
#include "explwind.hpp"
#include "titlwind.hpp"
#include "demowind.hpp"

/*---------------------------- Global Variables ---------------------------*/

PRIVATE	int		newMode = -1;
PUBLIC	int		forcedriver = grDETECT;
PUBLIC	int		snowlevel = -1;

/*------------------------------ Implementation ---------------------------*/

Demo::Demo()
//	  : TProgram("drivers"),
	  : TProgram("..\\mgraph"),
	  TProgInit(NULL,
				Demo::initMenuBar,
				Demo::initDeskTop,
				Demo::initVideoMode)
/****************************************************************************
*
* Function:		Demo::Demo
*
* Description:	Constructor for the demo application.
*
****************************************************************************/
{
	// Modify the way the MGL works according to the command line options.

	if (snowlevel != -1) MGL_setPaletteSnowLevel(snowlevel);

	// Set up the default windows on the desktop

	lock();

	TRect	extent,r;

	deskTop->getExtent(extent);
	ExplanationWindow *ew = new ExplanationWindow(extent);
	TitleWindow *tw = new TitleWindow(extent);

	r.left() = 0;
	r.right() = extent.right();
	r.top() = tw->getBounds().bottom();
	r.bottom() = ew->getBounds().top();
	DemoWindow *dw = new DemoWindow(r);

	deskTop->insert(tw);
	deskTop->insert(ew);
	deskTop->insert(dw);

	unlock();
}

Demo::~Demo()
/****************************************************************************
*
* Function:		Demo::~Demo
*
* Description:	Destructor for the Demo class.
*
****************************************************************************/
{
}

void Demo::initVideoMode(int& driver,int& mode)
/****************************************************************************
*
* Function:		Demo::initVideoMode
* Parameters:	driver	- Video device driver number
*				mode	- Video mode number
*
* Description:	Changes the default video mode if this was changed via the
*				change video mode dialog box.
*
****************************************************************************/
{
	if (forcedriver != grDETECT) {
		switch (forcedriver) {
			case grEGA:
				if (driver > grEGA) {
					driver = grEGA;
					mode = grEGA_640x350x16;
					}
				break;
			case grVGA:
				if (driver > grVGA)
					driver = grVGA;
				break;
			case grSVGA:
				if (driver > grSVGA)
					driver = grSVGA;
				break;
			}
		}
	if (newMode != -1)
		mode = newMode;
}

TMenuBar* Demo::initMenuBar(const TRect& bounds)
/****************************************************************************
*
* Function:		Demo::initMenuBar
* Parameters:	bounds	- Bounding box for the entire application
* Returns:		Pointer to the newly created menu bar.
*
* Description:	Creates the menu bar definition for the application.
*
****************************************************************************/
{
	TMenu *fileMenu = new TMenu();
	TMenu *demoMenu = new TMenu();
	TMenu *optionsMenu = new TMenu();

	*fileMenu
		+ new TMenuItem("~A~bout this demo...",cmAbout)
		+ new TMenuItemSeparator()
		+ new TMenuItem("~Q~uit",cmQuit,HotKey(kbX,mdAlt),hcNoContext,"Alt+X");
	fileMenu->doneDefinition();

	*demoMenu
		+ new TMenuItem("Lines",cmLineDemo)
		+ new TMenuItem("Ellipses",cmEllipseDemo)
		+ new TMenuItem("Elliptical Arcs",cmArcDemo)
		+ new TMenuItem("Rectangles",cmRectangleDemo)
		+ new TMenuItem("Polygons",cmPolygonDemo)
		+ new TMenuItem("Color control",cmColorDemo)
		+ new TMenuItem("Markers",cmMarkerDemo)
		+ new TMenuItem("Patterns",cmPatternDemo)
		+ new TMenuItem("Flood fill",cmFloodFillDemo)
		+ new TMenuItem("Animation",cmAnimationDemo);
	demoMenu->doneDefinition();

	*optionsMenu
		+ new TMenuItem("~V~ideo mode...",cmVideoMode);
	optionsMenu->doneDefinition();

	TMenuBar	*menuBar = new TMenuBar(bounds);

	*menuBar
		+ new TSubMenuItem("~F~ile",fileMenu)
		+ new TSubMenuItem("~D~emo",demoMenu)
		+ new TSubMenuItem("~O~ptions",optionsMenu);
	menuBar->doneDefinition();

	return (TMenuBar*)validView(menuBar);
}

TDeskTop *Demo::initDeskTop(const TRect& bounds)
/****************************************************************************
*
* Function:		Demo::initDeskTop
* Parameters:	bounds	- bounding rectangle for entire program view
* Returns:		Pointer to created desktop.
*
* Description:	For this application, the entire desktop is always
*				covered by the application windows, so the desktop is
*				created with an empty background to save time during
*				redraws.
*
****************************************************************************/
{
	return (TDeskTop*)validView(new TDeskTop(bounds,NULL));
}

void Demo::handleEvent(TEvent& event,phaseType phase)
/****************************************************************************
*
* Function:		Demo::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Phase of focused events
*
* Description:	Main event handling routine for the application. We first
*				let the TProgram class take care of the events for us, then
*				we check for application specific commands.
*
****************************************************************************/
{
	TProgram::handleEvent(event,phase);

	// Now check for application commands and dispatch them

	if (event.what == evCommand) {
		switch (event.message.command) {
			case cmAbout:
				messageBox(
					"MegaGraph Graphics Library Demo\n"
					"Copyright (C) 1994 SciTech Software\n\n"
					"Written by Kendall Bennett\n\n"
					"Version 1.1"
                    ,mfInformation | mfOKButton | mfOKDefault | mfCenterText);
				break;
			case cmVideoMode:
				changeVideoMode();
				break;
			case cmLineDemo:
			case cmEllipseDemo:
			case cmArcDemo:
			case cmPolygonDemo:
			case cmRectangleDemo:
			case cmColorDemo:
			case cmMarkerDemo:
			case cmPatternDemo:
			case cmFloodFillDemo:
			case cmAnimationDemo:
				// Broadcast these messages to be handled by the DemoArea.

				event.what = evBroadcast;
				putEvent(event);
				break;
			default:
				return;					// Don't clear unhandled events
			}
		clearEvent(event);
		}
}

void Demo::changeVideoMode()
/****************************************************************************
*
* Function:		Demo::changeVideoMode
*
* Description:	Pops up a dialog box to allow the user to change the
*				current video mode, and changes to the new mode if
*				requested.
*
****************************************************************************/
{
	TModeSelector *d = new TModeSelector("Change Video Mode",graphDriver,
		graphMode,MGL_availableModes(graphDriver));
	if (deskTop->execView(d) == cmOk) {
		// Change to the newly selected video mode
		//
		// Post a cmRestart event to restart the application with the new
		// video mode.

		if ((newMode = d->getMode()) != graphMode) {
			TEvent event;
			event.what = evCommand;
			event.message.command = cmRestart;
			event.message.infoPtr = NULL;
			putEvent(event);
			}
		}
	delete d;
}
