/****************************************************************************

۰
۰
۰
۰                                                                     
۰                           
۰                                                   
۰                                             
۰                                                  
۰                                                   
۰                                   
۰                                                                     
۰ BOY! 
۰ SOFT!!! 
۰ Copy Right. Mxico 1993.


   ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ
ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͻ
       THIS SOFTWARE IS DISTRIBUTED FREE AND WITH *NO* WARRANTIES.        
    THIS SOFTWARE IS NOT GUARANTEED TO WORK UNDER ALL CIRCUNSTANCES.      
    I SHALL NOT BE RESPONSIBLE FOR ANY HARM OR DAMAGE CAUSED BY THIS      
     PROGRAMS. I APOLOGIZE FOR NOT DISTRIBUTING A BUG FREE SOFTWARE       
                 BUT THIS IS NOT A COMMERCIAL PACKAGE.                    
ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͼ
   ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ

ͻ                                                                 ͻ
                                                                         
ͼ
       WARNING:                                                       
       THERE ARE A LOT OF GRAMMATH AND SPELLING ERRORS BECAUSE MY     
       NATIVE LANGUAJE IS SPANISH NOT ENGLISH. BECAUSE OF THAT IT     
       IS VERY PROBABLY THAT SOME OF THE COMMENTS OR TEXT TALKS       
       ABOUT SOMETHING THAT I DID NOT WANT TO SAY EXACTLY OR ALMOST   
       IN THAT WAY. SO ANY CORRECTIONS ARE WELCOME.                   
       I AM NOT RESPONSIBLE OF HARM ,LOSE OR DAMAGE CAUSED BY THIS    
       ERRORS OR SOFTWARE BUGS (YOU ARE WARNED THAT BOTH MAY EXIST).  
ͻ
                                                                         
ͼ                                                                 ͼ

ͻ
ͻ
͹ W                                                                        
͹ A                          T H I S     S O F T W A R E     I S    N O T  
͹ R               G U A R A N T E E D     T O     W O R K    N O R    I T  
͹ N                             W I L L     W O R K    U N D E R    A L L  
͹ N                                            C I R C U N S T A N C E S.  
͹ ING !!!                                                                  
ͼ
ͼ
****************************************************************************/


/****************************************************************************
*    Program Name:      FDSCURSR.C                                          *
*    Author:            Federico de la Mora Salazar                         *
*    Date:              June, 1993. (Mxico)                                *
*    Compiler(s):       Turbo C 2.0                                         *
*    Description:       This program has two main routines:                 *
*                       getcursor_size_bios() and setcursor_size_bios().    *
*                       The first one return the screen's cursor size in    *
*                       scan lines. The second sets a new size. The Rom Bios*
*                       doesn't use all the posible sizes so experimenting  *
*                       will show you the possiblities of this program.     *
*                       When the program is runned without parameters, it   *
*                       will display some info reported by the bios and     *
*                       some other readed directly from low memory          *
*                       addresses. Take a look on the functions used to     *
*                       get that information. Some of them are very simple  *
*                       but useful. They can be converted to macros to save *
*                       the time used in a function call.                   *
*                       You can turn on or off the emulation of the CGA     *
*                       cursor on vga's, the command line is:               *
*                       CGA followed by ON or OFF.                          *
*                       The program makes a demostration of how to disable  *
*                       the video refresh, try the REFRESH option.          *
*                                                                           *
*    How to compile:                                                        *
*                                                                           *
*            tcc -mt -lt fdscursr.c     (Instructs TLINK to build  .com)    *
*                                                                           *
*    Especial Note:     The functions used by this program are located in   *
*                       the program <fds_crt.c>. They were copied to this   *
*                       program because including <conio.h> in the program  *
*                       will change the video mode at run time to CO80.     *
*                                                                           *
****************************************************************************/

#include <bios.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

char    far *vid_address;
#define VIDEO_INT	0x10

/****************************************************************************
************ FUNCTIONS PROTOTYPES *******************************************
****************************************************************************/

void get_video_address (void);
void setcursor_size_bios (int start, int end);
void getcursor_size_bios (int *page,
	 int *row,
	 int *column,
	 int *start,
	 int *end);
int getcursor_size (int *start, int *end);
int setvideo_page_bios (int page);
int getvideo_page_bios (int *vidmode, int *width);
int getvideo_mode (void);
int getvideo_width (void);
int getvideo_screensize (void);
int getvideo_memoffset (void);
int getvideo_pagenum (void);
int getvideo_rows_vga(void);
void emucga_cursor_vga(int al);
void setvideo_refresh_vga(int al);

/****************************************************************************
************ FUNCTIONS ******************************************************
****************************************************************************/

void get_video_address() {
     int vid_mode;

     vid_mode = *((char far *) 0x449);
     if(vid_mode==0x07)
	vid_address = (char far *) 0xB0000000L;
     else
	vid_address = (char far *) 0xB8000000L;
     return;
}

void setcursor_size_bios(int start, int end) {
    union REGS r_in, r_out;

     r_in.h.ch = start;                     /* Starting scan line          */
     r_in.h.cl = end;                       /* Ending   scan line          */
     r_in.h.ah = 0x01;                      /* Rom BIOS function:
					     *   Set cursor size
					     */
					    /* The cursor will dissapear   */
					    /* if CH=0x20. Bit 5 of CH on. */

     int86(VIDEO_INT,&r_in,&r_out);
     return;
}

void getcursor_size_bios(int *page, int *row, int *column,
			 int *start, int *end) {
    union REGS r_in, r_out;

     r_in.h.bh = getvideo_pagenum();         /* BH must contain the number of
					      * the page that we want to get
					      * the information of so we past
					      * the current (active) video
					      * page number
					      */
     r_in.h.ah = 0x03;                       /* Rom BIOS function:
					      *   Get cursor size
					      */
     int86(VIDEO_INT,&r_in,&r_out);
     *page   = r_out.h.bh;                   /* Active video page          */
     *row    = r_out.h.dh;                   /* y cursor position          */
     *column = r_out.h.dl;                   /* x cursor position          */
     *start  = r_out.h.ch;                   /* starting scan line of crsor*/
     *end    = r_out.h.cl;                   /* ending scan line of cursor */

     return;
}

int getcursor_size(int *start, int *end) {

     *start = (int) *((char far*) 0x0461);  /* Adresses where the BIOS     */
     *end   = (int) *((char far*) 0x0460);  /* stores cursor begin and end.*/

     /*  The easiest way to now the number of scan lines that builds the   */
     /*  cursor is looking for the height in scan lines of the current     */
     /*  character type in text mode.                                      */
     /*  The scan lines are numbered from the top of the cursor to the     */
     /*  bottom, in other words, the highest scan line is the number 0.    */

     return ((int) *( (char far*) 0x0485)); /* Adresses where the BIOS     */
					    /* stores character's height.  */
}

int setvideo_page_bios(int page) {
    union REGS r_in, r_out;

     r_in.h.ah = 0x05;                      /* Rom BIOS function:
					     *   Set video page
					     */
     r_in.h.al = page;                      /* New active video page       */
     int86(VIDEO_INT,&r_in,&r_out);

     return;
}

int getvideo_page_bios(int *vidmode, int *width) {
    union REGS r_in, r_out;

     r_in.h.ah = 0x0F;                      /* Rom BIOS function:
					     *   Get current video mode
					     */
     int86(VIDEO_INT,&r_in,&r_out);
     *vidmode = r_out.h.al;                 /* Current video mode          */
     *width   = r_out.h.ah;                 /* Number of text columns      */

     return r_out.h.bh;                     /* Active display page number  */
}

int getvideo_mode(void) {
     /* Video mode currently being used by the BIOS                        */
     return ((int) *( (char far*) 0x0449));
}

int getvideo_width(void) {
     /* Number of text columns on the screen                                                                   */
     return ((int) *( (int far*) 0x044A));
}

int getvideo_screensize(void) {
     /* Bytes required to represent a screenful of video data              */
     return ((int) *( (int far*) 0x044C));
}

int getvideo_memoffset(void) {
     /* Offset in the video mem to the active page                         */
     return ((int) *( (int far*) 0x044E));
}

int getvideo_pagenum(void) {
     /* Current video page being used by the BIOS                          */
     return ((int) *( (char far*) 0x0462));
}

int getvideo_rows_vga(void) {
     /* Return the number of rows that can be displayed on the screen      */
     return ((int) *( (char far*) 0x0484)) + 1;
}

void emucga_cursor_vga(int al) {
    union REGS r_in, r_out;


     r_in.h.al = al;                       /* Emulate cga cursor on vga   */
					   /* al: Enable   0
					    *     Disable  1
					    */
     r_in.h.bl = 0x34;
     r_in.h.ah = 0x12;                     /* Rom BIOS function 0x12,
					    * subfunction 0x34:
					    *   Enable/Disable BIOS cursor
					    *   emulation.
					    */
     int86(VIDEO_INT,&r_in,&r_out);
     return;
}

void setvideo_refresh_vga(int al) {
    union REGS r_in, r_out;


     r_in.h.al = al;                       /* Turn on or off video refresh
					    * on vga's. If off the screen
					    * will become blank until you
					    * turn in on. However writiting
					    * directly to the video buffer
					    * will be faster.
					    */
					   /* al: Enable   0
					    *     Disable  1
					    */
     r_in.h.bl = 0x36;
     r_in.h.ah = 0x12;                     /* Rom BIOS function 0x12,
					    * subfunction 0x36:
					    *   Enable/Disable video refresh.
					    */
     int86(VIDEO_INT,&r_in,&r_out);
     return;
}

void main (int argc, char *argv[]) {
     int start, end, row, column, page, vidmode, width, height;

     printf("Program to change cursor's size and get some info.\n");
     printf("Author: FEDERICO DE LA MORA SALAZAR.\n\n");
     if( !strcmp(argv[1],"/?")                ||
	 !strcmp(strupr(argv[1]),"?")         ||
	 !strcmp(strupr(argv[1]),"/H")        ||
	 !strcmp(strupr(argv[1]),"/HELP") ) {
	     printf("<Sintax: %s start end> Gives info if no params specified.\n", argv[0]);
	     printf("or <%s CGA [ON|OF]> to change cga cursor emulation on vga's.", argv[0]);
     }
     else if( !strcmp(strupr(argv[1]),"CGA")       &&
	      !strcmp(strupr(argv[2]),"ON") ) {
		emucga_cursor_vga(0);
		printf("Cursor CGA emulation *ON*.\n");
     }
     else if( !strcmp(strupr(argv[1]),"CGA")       &&
	      !strcmp(strupr(argv[2]),"OFF") ) {
		emucga_cursor_vga(1);
		printf("Cursor CGA emulation *OFF*.\n");
     }
     else if( !strcmp(strupr(argv[1]),"REFRESH") ) {
		setvideo_refresh_vga(1);
		printf("***********************************************.\n");
                printf("***********************************************.\n");
		printf("***********************************************.\n");
		printf("********** WRITE SOMETHING AND COMEBACK. ******.\n");
		printf("***********************************************.\n");
		printf("***********************************************.\n");
		printf("***********************************************.\n");
		setvideo_refresh_vga(0);
     }
     else if (argc < 3) {                   /*Display some info            */

	getcursor_size_bios(&page, &row, &column, &start, &end);
	printf("*  The asterisk is the cursor position reported. Press a key...");
	bioskey(0);
	printf("\nBIOS info...\n");
	printf("getcursor_size_bios result...\n");
	printf("Cursor start and end: (%2d,%2d)\n",start, end);
	printf("Active video page: %10d\n",page);
	printf("Cursor position (*):  (%2d,%2d)\n",column, row);

	printf("getvideo_page_bios result...\n");
	getvideo_page_bios(&vidmode, &width);
	printf("Current video mode: %9d\n",vidmode);
	printf("Number of text columns: %5d\n",width);

	printf("\nLow memory addresses info...\n");
	height = getcursor_size(&start, &end);
	printf("Cursor start and end: (%2d,%2d)\n",start, end);
	printf("Characters height: %10d\n",height);
	printf("Active video page: %10d\n",getvideo_pagenum());
	printf("Current video mode: %9d\n",getvideo_mode());
	printf("Number of text columns: %5d\n",getvideo_width());
	printf("Screen size in bytes: %7d\n",getvideo_screensize());
	printf("Offset to active page: %6p\n",getvideo_memoffset());
	printf("Number of rows (vga): %7d\n",getvideo_rows_vga());

     }
     else
	{
	   start = atoi(argv[1]);
	   end   = atoi(argv[2]);
	   setcursor_size_bios(start, end); /*Changing cursor shape        */
	   getcursor_size(&start, &end);
	   printf("New cursor start and end: (%2d,%2d)\n",start, end);
	}
     return;
}

