/***********************************************************************

                       CSA Library, Free Evaluation Version 2.2.0 
                                           Release: June 9th 1997 

       Preprocessor commands to replace all memory
       allocation functions with new ones to log
       and check the use of the heap.

       It also contains the QALLOC class.


                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSMALLOC_H
#define __CSMALLOC_H

#include "csalloc.h"
#include "stdlib.h"
#include "cstypes.h"
#include "cscopton.h"


////////////////////////////////////////////////////////////////////////////////
//
//				   QALLOC
//
//	 Quick Allocation.
//	 A class to do dynamic memory allocations.
//
//


class QALLOC
{
 public:
   void *p;

 public:

   QALLOC(unsigned int n);
  ~QALLOC(void);

   void free(void);

#ifndef _CP_002
   operator void*()	 { return p; }
#endif
   operator csCHAR*()	 { return (csCHAR *)p; }


};






#if defined(CS_DEBUG)

// Special allocation functions during debugging.

  #define  csmalloc(x)	     cs_malloc(x,      __FILE__,__LINE__)
  #define  cscalloc(x,y)     cs_calloc(x,y,    __FILE__,__LINE__)
  #define  csrealloc(x,y)    cs_realloc(x,y,   __FILE__,__LINE__)
  #define  csfree(x)	     cs_free(x,        __FILE__,__LINE__)
#ifndef _CP_100
  #define  csfarmalloc(x)    cs_farmalloc(x,   __FILE__,__LINE__)
  #define  csfarcalloc(x,y)  cs_farcalloc(x,y, __FILE__,__LINE__)
  #define  csfarrealloc(x,y) cs_farrealloc(x,y,__FILE__,__LINE__)
  #define  csfarfree(x)      cs_farfree(x,     __FILE__,__LINE__)
#endif

#else
  #define  csmalloc(x)	      ::malloc(x)
  #define  cscalloc(x,y)      ::calloc(x,y)
  #define  csrealloc(x,y)     ::realloc(x,y)
  #define  csfree(x)	      ::free(x)
#ifndef _CP_100
  #define  csfarmalloc(x)     ::farmalloc(x)
  #define  csfarcalloc(x,y)   ::farcalloc(x,y)
  #define  csfarrealloc(x,y)  ::farrealloc(x,y)
  #define  csfarfree(x)       ::farfree(x)
#endif

#endif


void   alloc_test(csCHAR *fname,long line);

void   alloc_logging(int TrueFalse,csCHAR *name);
inline void  alloc_logging(int TrueFalse)
       { alloc_logging(TrueFalse,(csCHAR *)"malloc.log"); }


void  *  cs_realloc(void  *ptr, size_t __size,csCHAR *fname,long line);
void  *  cs_calloc(size_t __nitems, size_t __size,csCHAR *fname,long line);
void	 cs_free(void *__block,csCHAR *fname,long line);
void  *  cs_malloc(size_t __size,csCHAR *fname,long line);

#ifndef _CP_100
// Flat memory model

void far  * cs_farcalloc(unsigned long __nunits, unsigned long __unitsz,csCHAR *fname,long line);
void far  * cs_farrealloc(void far * ptr,unsigned long __nunits,csCHAR *fname,long line);
void	    cs_farfree(void far *__block,csCHAR *fname,long line);
void far  * cs_farmalloc(unsigned long __nbytes,csCHAR *fname,long line);

#endif




#include "cscoptof.h"

#endif
