/***********************************************************************

                      CSDB Library, Free Evaluation Version 2.2.0 
                                           Release: June 9th 1997 

       Definition of a virtual array class with
       boundary checking.

                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSARRAY_H
#define __CSARRAY_H

#include "stdlib.h"
#include "stdio.h"
#include "csstr.h"
#include "cscopton.h"


#ifdef CS_DEBUG
  #define  TEST_IN(key) test_index(key);
#else
  #define  TEST_IN(key)
#endif


class ARRAY
{


 protected:


     typedef union
     {
       void * p;
       long   l;
     } dat;



      U16    nr_lin;
      dat   *lbuf;
      csSTR  d_name;

      void test_index(long key);


  public:

      ARRAY(void);
      virtual ~ARRAY(void);
      void zap(void);
      void debug_name(csCHAR *s);
      void size(size_t nr);
      void insert(long key,void *d)	 { TEST_IN(key)  lbuf[key].p=d;    }
      void insert(long key,long  d)	 { TEST_IN(key)  lbuf[key].l=d;    }
      void delet(long key)		 { TEST_IN(key)  lbuf[key].p=NULL; }
      void *locate(long key)		 { TEST_IN(key)  return lbuf+key;  }
      void *locate(size_t key)		 { TEST_IN(key)  return lbuf+key;  }
      void search(long key,void *&d)	 { TEST_IN(key)  d=lbuf[key].p; }
      void search(long key,long  &d)	 { TEST_IN(key)  d=lbuf[key].l; }
      void search(long key,void *&d,void** &add)
					 { TEST_IN(key)  d=*(add=&lbuf[key].p); }
      void search(long key,long  &d,long * &add)
					 { TEST_IN(key)  d=*(add=&lbuf[key].l); }
      void insert(int key,dat  d)	 { TEST_IN(key)  lbuf[key]=d;  }
      void insert(int key,void *d)	 { TEST_IN(key)  lbuf[key].p=d;  }
      void insert(int key,void *d,void ** &add)
					 { TEST_IN(key)  add=&(lbuf[key].p=d); }
      void insert(int key,long	d)	 { TEST_IN(key)  lbuf[key].l=d;    }
      void insert(int key,long	d,long * &add)
					 { TEST_IN(key)  add=&(lbuf[key].l=d); }
      void delet(int key)		 { TEST_IN(key)  lbuf[key].p=NULL; }
      void search(int key,void *&d)	 { TEST_IN(key)  d=lbuf[key].p; }
      void search(int key,long	&d)	 { TEST_IN(key)  d=lbuf[key].l; }

      int  report(csCHAR *name,int sub=10);
      void report(FILE *fipo,int sub=10);

      long export(FILE *fp,U32 nr);
      long export(FILE *fp)		 { return export(fp,nr_lin+1); }
      long import(FILE *fp,long number);
      void empty(void);


};





#include "cscoptof.h"

#endif
