// MYPROG.CPP - An example of how to integrate CRCLock v2.4 into your own
// programs. Usage couldn't be simpler, just add the "crclock.h" header
// file to your program and CRCLock is ready to be used in either C or C++
// mode.
// To compile this program use "tcc -ml -2 myprog.cpp clcodel.obj"
// The "-ml" option on the command line specifies the memory model that you
// wish to use with CRCLock. The the terminating later on the Mobile Code
// name is the memory model that, that specific piece of code was created
// with. e.g. For the example above the terminating letter is "l', therefore
// that mobile code is in the Large memory model.
// If you wanted to compile in the small memory model, then you would type
// "tcc -ms myprog.cpp clcodes.obj"
// Remember to include the correct model code in your project file, if you
// are using Turbo C++ or other compiler project modes.

#include <stdio.h>
#include <process.h>
#include "crclock.h"

int main(int argc, char *argv[])
{
 int status=0, i=0;

 if(argc>1) printf("Ignoring Extra Parameters.\n");

 // CRCLock Runs here as the FIRST function in the file.
 printf("Scanning File Integrity.... ");
 status=CRCLock(argv[0]);
 if(status==0x00) printf("OK.\n");
 if(status==0x01) {printf("Failed. Internal Tampering Detected.\n"); exit(1);}
 if(status==0x02) {printf("Failed. Filename Changed.\nCosmetic Tampering Detected.\n"); exit(1);}
 // CRCLock has finished, if the code reaches here then there are no problems.

 // Your program can now run quite happily.
 printf("\nMYPROG.EXE - Example usage of CRCLock v2.4. (C) NE Body.\n");
 for(i=0; i<=1000; i++) printf("MyProg is running: %03d.\r",i);
 printf("\n");

 return 0;
}