/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * v1.5 August 1996
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
#include        <stdio.h>
#include        "expr.h"
#include        "c.h"
#include        "gen386.h"
#include        "cglbdec.h"
#include 				"diag.h"

int skipsize = 0;
int addsize = 0;

typedef struct muldiv {
		struct muldiv * link;
		long value;
		double floatvalue;
		int size;
		int label;
} MULDIV;
/*      variable initialization         */
extern HASHREC **globalhash;
extern int phiused;

enum e_gt { nogen, bytegen, wordgen, longgen, floatgen, doublegen, longdoublegen, storagegen,srrefgen };
enum e_sg { noseg, codeseg, dataseg,bssxseg,startupxseg,rundownxseg,cppxseg };

extern int	prm_asmfile;
extern int prm_lines,prm_nasm;

MULDIV *muldivlink = 0;
int	       gentype = nogen;		/* Current DC type */
int	       curseg = noseg;		/* Current seg */
int        outcol = 0;				/* Curront col (roughly) */
int newlabel;
int needpointer;
static int nosize = 0;
static int phiput;
/* Init module */
void outcodeini(void)
{
	gentype = nogen;
	curseg = noseg;
	outcol = 0;
	newlabel = FALSE;
	phiput = FALSE;
}
/* List of opcodes
 * This list MUST be in the same order as the op_ enums 
 */
char * oplst[] = { "LINE#", "LABEL","SEQ@","DB",
	"ADD", "AND", "CALL", "CLD", "CMP", "CMPSB", "CMPSW", "CMPSD",
	"CWD", "CBW", "CBD", "DEC",
	"DIV", "IDIV", "IMUL", "INC", "JB", "JBE","JE", "JL",
	"JLE", "JNC", "JA", "JNE", "JGE", "JG", "JMP", "LEA", "LODSB",
	"LODSW", "LODSD", "ENTER", "LEAVE",
	"MOV", "MOVSB", "MOVSW", "MOVSD", "MOVSX", "MOVZX", "MUL", 
	"NEG", "NOT", "OR", "POP", "PUSH", "REP", "REPNZ", "REPZ", 
	"RET", "SAHF", "SAL", "SAR", "SCASB", "SCASW", "SCASD",
	"SHR", "SHL", "STD", "STOSB", "STOSW", "STOSD", "SUB",
	"TEST", "XCHG", "XOR", "DD", "PUSHFD", "IRETD", "PUSHAD", "POPAD",
	"FADD", "FIADD", "FCHS", "FCOM", "FCOMP", "FCOMPP",
	"FDIV", "FIDIV", "FICOM", "FICOMP", "FILD", "FIST", "FISTP",
	"FLD", "FLDZ", "FMUL", "FIMUL", "FPREM", "FSCALE", "FST", "FSTP",
	"FSTCW", "FSTSW", "FSUB", "FISUB", "FTST", "FXCH", "FWAIT"
	};
/*
 * Register a fixup 
 */
/* Put an opcode
 */
void putop(int op)
{    
	if (prm_nasm) {   
  	skipsize =  (op == op_lea);
  	addsize = (op == op_push);
		if (op == op_fwait) {
			/* NASM uses WAIT instead of FWAIT */
  		fprintf(outputFile,"\t%s",oplst[op_fwait]+1);
			return;
		}
	}
	if (op > op_fwait)
    DIAG("illegal opcode.");
	else
  	fprintf(outputFile,"\t%s",oplst[op]);
}

void putconst(ENODE *offset)
/*
 *      put a constant to the outputFile file.
 */
{       switch( offset->nodetype )
                {
								case en_autoreg:
                case en_autocon:
                case en_icon:
                case en_lcon:
                case en_iucon:
                case en_lucon:
                case en_ccon:
								case en_acon:
                        fprintf(outputFile,"0%lXH",offset->v.i);
                        break;
								case en_rcon:
								case en_fcon:
								case en_lrcon:
												fprintf(outputFile,"%f",offset->v.f);
												break;
								case en_nalabcon:
                        fprintf(outputFile,"L_%d",offset->v.i);
                        break;
                case en_labcon:
												if (!prm_nasm)
													fprintf(outputFile,"CS:");
                        fprintf(outputFile,"L_%d",offset->v.i);
                        break;
								case en_napccon:
                case en_nacon:
                        fprintf(outputFile,"%s",offset->v.p[0]);
                        break;
                case en_add:
                        putconst(offset->v.p[0]);
                        fprintf(outputFile,"+");
                        putconst(offset->v.p[1]);
                        break;
                case en_sub:
                        putconst(offset->v.p[0]);
                        fprintf(outputFile,"-");
                        putconst(offset->v.p[1]);
                        break;
                case en_uminus:
                        fprintf(outputFile,"-");
                        putconst(offset->v.p[0]);
                        break;
                default:
                        DIAG("illegal constant node.");
                        break;
                }
}
void putlen(int l)
/*
 *      append the length field to an instruction.
 */
{ 
	if (l!= 10 && l != 8 && l != 6 && l != 4 && l != 1 && l != 2 && l != 0)
     DIAG("illegal length field.");
}
void putsizedreg(char *string, int reg, int size)
{
	static char *byteregs[] = { "AL","CL","DL","BL","*A","*C","*D","*B" };
	static char *wordregs[] = { "AX", "CX", "DX","BX","SP","BP","SI","DI"  };
	static char *longregs[] = { "EAX", "ECX", "EDX","EBX","ESP","EBP","ESI","EDI" };
  if (size == 4)
		fprintf(outputFile,string,longregs[reg]);
	else if (size == 1)
		fprintf(outputFile,string,byteregs[reg]);
		else
			fprintf(outputFile,string,wordregs[reg]);
}
void pointersize(int size)
{
	if (prm_nasm && skipsize)
		return;
/*	if (needpointer)
*/		switch (size) {		
			case 10:
				fprintf(outputFile,"TWORD ");
				break;
			case 8:                      
       	fprintf(outputFile,"QWORD ");
				break;
			case 6:
			case 4:                      
				fprintf(outputFile,"DWORD ");
				break;
			case 2:
				fprintf(outputFile,"WORD ");
				break;
			case 1:
				fprintf(outputFile,"BYTE ");
				break;
			default:
				DIAG("Bad pointer");
		}	
		if (!prm_nasm)
			fprintf(outputFile,"PTR ");
}
void putamode(AMODE *ap,int size)
/*
 *      outputFile a general addressing mode.
 */
{       switch( ap->mode )
                {
								case am_cs:
												fprintf(outputFile,"CS");
												break;
                case am_immed:
												if (size && (ap->offset->nodetype == en_labcon 
														|| ap->offset->nodetype == en_nacon
														|| ap->offset->nodetype == en_napccon
														|| ap->offset->nodetype == en_nalabcon)) {
													if (!prm_nasm)
														fprintf(outputFile,"OFFSET ");
												  else
														if (!nosize) 
															fprintf(outputFile,"DWORD ");
												}
												else
													if (prm_nasm && addsize)
														pointersize(size);
                        putconst(ap->offset);
												break;
                case am_direct:
												pointersize(size);
												fputc('[',outputFile);
                        putconst(ap->offset);
												fputc(']',outputFile);
                        break;
                case am_dreg:
												putsizedreg("%s",ap->preg,size);
												break;
								case am_freg:
												fprintf(outputFile,"ST(%d)",ap->preg);
												break;
								case am_indisp:
												pointersize(size);
												putsizedreg("[%s",ap->preg,4);
												if (ap->offset) {
													fputc('+',outputFile);
													putconst(ap->offset);
												}
												fputc(']',outputFile);
												break;
								case am_indispscale:
													pointersize(size);
												putsizedreg("[%s+",ap->preg,4);
												putsizedreg("%s",ap->sreg,4);
												if (ap->scale != 1)
													fprintf(outputFile,"*0%XH",ap->scale);
												if (ap->offset) {
													fputc('+',outputFile);
													putconst(ap->offset);
												}
												fputc(']',outputFile);
												break;
                default:
                        DIAG("illegal address mode.");
                        break;
                }
}

void put_code(int op,int len,int len2,AMODE *aps,AMODE *apd)
/*
 *      outputFile a generic instruction.
 */
{       
		if (!prm_asmfile)	
			return;
		if (op == op_line) {
			if (!prm_lines)
				return;
			fprintf(outputFile,";\n; Line %d:\t%s\n;\n",len,(char *)aps);
			return;
		}
		needpointer = (len != len2) || ((!aps || aps->mode !=am_dreg) && (!apd || apd->mode !=am_dreg));
		putop(op);
		if (prm_nasm && op >=op_jb && op <= op_jg)
			fprintf(outputFile,"\tNEAR");
		if (op == op_rep) {
			return;
		}
    putlen(len);
        if( aps != 0 )
                {
                fprintf(outputFile,"\t");
		if (op == op_dd)
			nosize = TRUE;
		putamode(aps,len);
		nosize = FALSE;
                if( apd != 0 )
                        {
                        fprintf(outputFile,",");
                        putamode(apd,len2);
                        }
                }
  fprintf(outputFile,"\n");
}

void gen_strlab(char *s)
/*
 *      generate a named label.
 */
{
		if (prm_asmfile)
			if (curseg == dataseg || curseg == bssxseg) {
				newlabel = TRUE;
			 	fprintf(outputFile,"\n%s",s);
				outcol = strlen(s)+1;
			}
			else
        fprintf(outputFile,"%s:\n",s);
}

void put_label(int lab)
/*
 *      outputFile a compiler generated label.
 */
{
       if (prm_asmfile)
					fprintf(outputFile,"L_%d:\n",lab);
}

void genfloat(float val)
/*
 * Output a float value
 */
{ 		if (prm_asmfile)
        if( gentype == floatgen && outcol < 60) {
                fprintf(outputFile,",%f",val);
                outcol += 8;
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDD\t%f",val);
                gentype = floatgen;
                outcol = 19;
                }
}

void gendouble(double val)
/*
 * Output a double value
 */
{ 		if (prm_asmfile)
        if( gentype == doublegen && outcol < 60) {
                fprintf(outputFile,",%f",val);
                outcol += 8;
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDQ\t%f",val);
                gentype = doublegen;
                outcol = 19;
                }
}
void genlongdouble(double val)
/*
 * Output a double value
 */
{ 		if (prm_asmfile)
        if( gentype == longdoublegen && outcol < 60) {
                fprintf(outputFile,",%f",val);
                outcol += 8;
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDT\t%f",val);
                gentype = longdoublegen;
                outcol = 19;
                }
}
int genstring(char *str, int uselong)
/*
 * Generate a string literal
 */
{
	if (uselong) {
		while  (*(short *)str)
			genword(*((short *)str)++);
		genword(0);
		return strlen(str)+1;
	}
	else {
		while (*str)
			genbyte(*str++);
		genbyte(0);
		return pstrlen(str)*2+1;
	}
}
void genbyte(long val)
/*
 * Output a byte value
 */
{ 		if (prm_asmfile)
        if( gentype == bytegen && outcol < 60) {
                fprintf(outputFile,",0%XH",val & 0x00ff);
                outcol += 4;
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDB\t0%XH",val & 0x00ff);
                gentype = bytegen;
                outcol = 19;
                }
}

void genword(long val)
/*
 * Output a word value
 */
{     if (prm_asmfile)
        if( gentype == wordgen && outcol < 58) {
                fprintf(outputFile,",0%XH",val & 0x0ffff);
                outcol += 6;
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDW\t0%XH",val & 0x0ffff);
                gentype = wordgen;
                outcol = 21;
                }
}

void genlong(long val)
/*
 * Output a long value
 */
{     if (prm_asmfile)
        if( gentype == longgen && outcol < 56) {
                fprintf(outputFile,",0%lXH",val);
                outcol += 10;
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDD\t0%lXH",val);
                gentype = longgen;
                outcol = 25;
                }
}

void gensrref(char *name, int val)
{
			if (prm_asmfile)
        if( gentype == srrefgen && outcol < 56) {
                fprintf(outputFile,",%s,%d",name,val);
                outcol += strlen(name)+1;
                }
        else    {
                nl();
                fprintf(outputFile,"\tDD\t%s,%d",name,val);
                gentype = srrefgen;
                outcol = 25;
                }
}
void genref(SYM *sp,int offset)
/*
 * Output a reference to the data area (also gens fixups )
 */
{       char    sign;
			char buf[40];
        if( offset < 0) {
                sign = '-';
                offset = -offset;
                }
        else
                sign = '+';
			if (sp->storage_class == sc_static)
				sprintf(buf,"L_%d%c%d",sp->value.i,sign,offset);
			else
				sprintf(buf,"%s%c%d",sp->name,sign,offset);
			if (prm_asmfile) {
        if( gentype == longgen && outcol < 55 - strlen(sp->name)) {
                fprintf(outputFile,",%s",buf);
                outcol += (11 + strlen(sp->name));
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDD\t%s",buf);
                outcol = 26 + strlen(sp->name);
                gentype = longgen;
                }
			}
}
void genpcref(SYM *sp,int offset)
/*
 * Output a reference to the code area (also gens fixups )
 */
{
	genref(sp,offset);
}
void genstorage(int nbytes)
/*
 * Output bytes of storage
 */
{			if (prm_asmfile) {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
				if (prm_nasm)
        	fprintf(outputFile,"\tRESB\t0%XH",nbytes);
				else
        	fprintf(outputFile,"\tDB\t0%XH DUP (?)",nbytes);
				outcol = 28;
				gentype = storagegen;
			}
}

void gen_labref(int n)
/*
 * Generate a reference to a label
 */
{			if (prm_asmfile)
        if( gentype == longgen && outcol < 58) {
                fprintf(outputFile,",L_%d",n);
                outcol += 6;
                }
        else    {
								if (!newlabel)
									nl();
								else newlabel = FALSE;
                fprintf(outputFile,"\tDD\tL_%d",n);
                outcol = 22;
                gentype = longgen;
                }
}

int     stringlit(char *s, int uselong)
/*
 *      make s a string literal and return it's label number.
 */
{       struct slit     *lp;
        ++global_flag;          /* always allocate from global space. */
        lp = xalloc(sizeof(struct slit));
        lp->label = nextlabel++;
				if (uselong) 
					lp->str = plitlate(s);
				else
        	lp->str = litlate(s);
        lp->next = strtab;
				lp->type = uselong;
        strtab = lp;
        --global_flag;
        return lp->label;
}

void dumplits(void)
/*
 *      dump the string literal pool.
 */
{
        while( strtab != 0) {
                cseg();
                nl();
                put_label(strtab->label);
								genstring(strtab->str,strtab->type);
                strtab = strtab->next;
                }
        nl();
}

void nl(void)
/*
 * New line
 */
{    if (prm_asmfile) {
       if(outcol > 0) {
                fputc('\n',outputFile);
                outcol = 0;
                gentype = nogen;
                }
			 if (phiused && !phiput)
								fputc(0x1f,outputFile);
		 }
}
/*
 * Exit if from a special segment
 */
void exitseg(void)
{
	if (!prm_nasm) {
		if (curseg == startupxseg) {
			curseg = noseg;
			fprintf(outputFile,"cstartup\tENDS\n");
		}
		else if (curseg == rundownxseg) {
			curseg = noseg;
			fprintf(outputFile,"crundown\tENDS\n");
		}
		else if (curseg == cppxseg) {
			curseg = noseg;
			fprintf(outputFile,"cppinit\tENDS\n");
		}
	}
}
/*
 * Switch to cseg 
 */
void cseg(void)
{			if (prm_asmfile)
       	if( curseg != codeseg) {
                nl();
								exitseg();
								if (prm_nasm)
                	fprintf(outputFile,"[SECTION .text]\n");
								else
                	fprintf(outputFile,"\t.CODE\n");
                curseg = codeseg;
                }
}
/*
 * Switch to deseg
 */
void dseg(void)
{     if (prm_asmfile)  
				if( curseg != dataseg) {
                nl();
								exitseg();
								if (prm_nasm)
                	fprintf(outputFile,"[SECTION .data]\n");
								else
                	fprintf(outputFile,"\t.DATA\n");
                curseg = dataseg;
                }
}
/*
 * Switch to bssseg
 */
void bssseg(void)
{     if (prm_asmfile)  
				if( curseg != bssxseg) {
                nl();
								exitseg();
								if (prm_nasm)
                	fprintf(outputFile,"[SECTION .bss]\n");
								else
                	fprintf(outputFile,"\t.DATA?\n");
                curseg = bssxseg;
                }
}
/*
 * Switch to startupseg
 */
void startupseg(void)
{     if (prm_asmfile)  
				if( curseg != startupxseg) {
                nl();
								exitseg();	
								if (prm_nasm)
                	fprintf(outputFile,"[SECTION cstartup]\n");
								else
                	fprintf(outputFile,"cstartup\tSEGMENT USE32 PUBLIC DWORD \042INITDATA\042\n");
                curseg = startupxseg;
                }
}
/*
 * Switch to rundownseg
 */
void rundownseg(void)
{     if (prm_asmfile)  
				if( curseg != rundownxseg) {
                nl();
								exitseg();
								if (prm_nasm)
	                fprintf(outputFile,"[SECTION crundown]\n");
								else
  	              fprintf(outputFile,"crundown\tSEGMENT USE32 PUBLIC DWORD \042EXITDATA\042\n");
                curseg = rundownxseg;
                }
}
void cppseg(void)
{     if (prm_asmfile)  
				if( curseg != cppxseg) {
                nl();
								exitseg();
								if (prm_nasm)
                	fprintf(outputFile,"[SECTION cppinit]\n");
								else
                	fprintf(outputFile,"cppinit\tSEGMENT USE32 PUBLIC DWORD \042CPPDATA\042\n");
                curseg = cppxseg;
                }
}
void gen_virtual(char *name)
{
	if (prm_asmfile) {
		nl();
		fprintf(outputFile,"@%s\tSEGMENT VIRTUAL",name);
	}
}
void gen_endvirtual(char *name)
{
	if (prm_asmfile) {
		nl();
		fprintf(outputFile,"@%s\tENDS",name);
	}
}
/*
 * Align
 */
void align(int size)
{
			if (prm_asmfile) {
				nl();
				if (prm_nasm)
/* NASM 0.91 wouldn't let me use parenthesis but this should work
 * according to the documented precedence levels
 */
					fprintf(outputFile,"\tTIMES $$-$ & %d NOP\n",3);
				else
					fprintf(outputFile,"\tALIGN\t%d\n",4);
			}
}
/* muldiv val init
 */
void init_muldivval(void)
{
	muldivlink = 0;
}
/*
 * queue muldiv val
 */
void queue_muldivval(int label, long number)
{
	MULDIV *p = xalloc(sizeof(MULDIV));
	p->link = muldivlink;
	p->value = number;
	p->label = label;
	p->size = 0;
	muldivlink = p;
}
void queue_floatval(int label, double number, int size)
{
	MULDIV *p = xalloc(sizeof(MULDIV));
	p->link = muldivlink;
	p->floatvalue = number;
	p->label = label;
	p->size = size;
	muldivlink = p;
}
void dump_muldivval(void)
{
	int tag = FALSE;
	if (prm_asmfile) {
		fprintf(outputFile,"\n");
		if (muldivlink) {
			tag = TRUE;
			align(4);
		}
		while (muldivlink) {
			put_label(muldivlink->label);
			if (muldivlink->size == 0)
				fprintf(outputFile,"\tDD\t0%xH\n",muldivlink->value);
			else if (muldivlink->size == 6)
				fprintf(outputFile,"\tDD\t%f\n",muldivlink->floatvalue);
			else
				fprintf(outputFile,"\tDQ\t%f\n",muldivlink->floatvalue);
			muldivlink = muldivlink->link;
		}
		if (tag)
			fprintf(outputFile,"\n");
	}
}
void asm_header(void)
{
	nl();
	if (prm_nasm)
				fprintf(outputFile,"[BITS 32]\n\n");
	else
				fprintf(outputFile,"\t.386\n\t.MODEL SMALL\n\n");
}
void globaldef(char *string)
{
	if (prm_nasm)
      fprintf(outputFile,"[GLOBAL\t%s]\n",string);
	else
      fprintf(outputFile,"\tPUBLIC\t%s\n",string);
}			
void putexterns(void)
/*
 * Output the fixup tables and the global/external list
 */
{       SYM     *sp;
			int i;
			if (prm_asmfile){
				nl();
				exitseg();
				for (i=0; i < HASHTABLESIZE; i++) {
					if ((sp=(SYM *) globalhash[i]) != 0) {
						while (sp) {
							if (prm_nasm) {
	        			if( sp->storage_class == sc_external && sp->extflag)
  	              fprintf(outputFile,"[EXTERN\t%s]\n",sp->name);
    	    			else if( sp->storage_class == sc_externalfunc && sp->extflag)
      	          fprintf(outputFile,"[EXTERN\t%s]\n",sp->name);
							}
							else {
	        			if( sp->storage_class == sc_external && sp->extflag)
  	              fprintf(outputFile,"\tEXTRN\t%s\n",sp->name);
    	    			else if( sp->storage_class == sc_externalfunc && sp->extflag)
      	          fprintf(outputFile,"\tEXTRN\t%s:PROC\n",sp->name);
							}
         			sp = sp->next;
						}
					}
				}
				if (!prm_nasm)
					fprintf(outputFile,"\tEND\n");
			}
}