/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * v1.5 August 1996
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
/*
 *memmgt.c
 *
 * memory management
 */
#include        <stdio.h>
#include				<malloc.h>
#include        "expr.h"
#include        "c.h"
#include        "cglbdec.h"

extern TABLE oldlsym;

typedef struct _blk_ {
        struct _blk_      *next;
				long blksize;
        char            m[1];           /* memory area */
        } BLK;

int      glbsize = 0,    /* size left in current global block */
                locsize = 0,    /* size left in current local block */
                glbindx = 0,    /* global index */
                locindx = 0;    /* local index */

BLK       *locblk = 0,    /* pointer to local block */
                        *glbblk = 0;    /* pointer to global block */

static int optsize,optindx;
static BLK *optblk;
static long maxopt,maxglb,maxloc;
void memini(void)
{
	glbsize = 0;
	locsize = 0;
	glbindx = 0;
	locindx = 0;
	locblk = 0;
	glbblk = 0;
	optsize = 0;
	optblk = 0;
	optindx = 0;
  maxopt = maxglb = maxloc = 0;
}
static char *palloc(int *sizepos,int size,int *indxpos,BLK **blk)
/*
 * main allocation routine
 */
{
  BLK      *bp;
  char            *rv;
	if( size & 1 )		/* if odd size */
		size += 1;	/* make it even */
	/* if anything left, try to allocate from it */
  if( *sizepos >= size ) {
    rv = &((*blk)->m[*indxpos]);
    *sizepos -= size;
    *indxpos += size;
    return rv;
  }
  else    {
		long allocsize;
		/* else check for size > normal blcok size */
		if (size > 2048) {
			/* this is going to fragment memory!!! I'd fix it except
			 * the fragmentation is partially dependent on the calloc 
			 * implementation 
			 */
			allocsize = size - 1;
			*sizepos = 0;
		}
		else {
			/* as long as we stick to normal blocks, fragmentation
			 * won't be an issue because as long as all blocks are the
			 * same size calloc is guaranteed to find one if there are any
			 */
			allocsize = 2047;
			*sizepos = 2048 - size;
		}
		/* allocate mem */
    bp = calloc(1,sizeof(BLK) + allocsize);
		if( bp == NULL ) {
			release_global();
			release_local();
			release_opt();
			mem_summary();
			fatal(" not enough memory.");
		}
		bp->blksize = allocsize;
		/* link the block and return the base */
    bp->next = *blk;
    *blk = bp;
    *indxpos = size;
    return (*blk)->m;
	}
}

char    *xalloc(int siz)
/*
 * user-level allocation.  Global symbols are never deallocated; local
 * symbols are deallocated all at once by deallocating the local symbol
 * blocks
 */
{
        if( global_flag ) 
						return palloc(&glbsize,siz,&glbindx,&glbblk);
				else
						return palloc(&locsize,siz,&locindx,&locblk);
}
char    *oalloc(int siz)
/*
 * allocation for optimizer temps
 */
{
/*	return xalloc(siz); */
						return palloc(&optsize,siz,&optindx,&optblk);
}
static long release(int *sizepos, BLK ** blk)
/*
 * msin memory free routine
 * frees all blocks from a list at once
 *
 * This memory management scheme reduces fragmentation, however
 * temps hang around for a while...
 *
 */
{       BLK      *bp1, *bp2;
				long blkcnt = 0;
        bp1 = *blk;
        while( bp1 != 0 ) {
								blkcnt+=bp1->blksize;
                bp2 = bp1->next;
                free( bp1 );
                bp1 = bp2;
                }
        *blk = 0;
        *sizepos = 0;
				return blkcnt;
}
void release_local(void )
/*
 * release all local allocations
 */
{
	long temp = release(&locsize,&locblk);       
	if (temp > maxloc)
		maxloc = temp;
  lsyms.head = 0;
	oldlsym.head = oldlsym.tail = 0;
}

void release_global(void)
/*
 * release all global allocations
 */
{ 
	long temp = release(&glbsize,&glbblk);       
	if (temp > maxglb)
		maxglb = temp;
        gsyms.head = 0;         /* clear global symbol table */
        strtab = 0;             /* clear literal table */
}
void release_opt(void)
/*
 * release optimizer temps
 */
{
	long temp = release(&optsize,&optblk);       
	if (temp > maxopt)
		maxopt = temp;
}
void mem_summary(void)
{
	printf("Memory usage:\n");
	if (maxglb)
		printf("  Globals:        %ld\n",maxglb);
	if (maxloc)
		printf("  Local peak:     %ld\n",maxloc);
	if (maxopt)
		printf("  Optimizer peak: %ld\n",maxopt);

}	