/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * v1.5 August 1996
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
#include	"expr.h"
#include 	"c.h"
extern int prm_packing;
extern long lc_maxauto, framedepth;
extern int prm_linkreg;
extern SYM *currentfunc;

int linkreg;
int basereg;
int prm_phiform=0;
int prm_largedata = FALSE;
int prm_68020 = FALSE;
int cf_maxaddress =21;
int cf_maxdata=8;
int cf_maxfloat = 40;
int cf_freeaddress =2;
int cf_freedata=3;
int cf_freefloat=3;
int stackadd = 3;
int stackmod = -4;
int strucadd = 3;
int strucmod = -4;
int stdretblocksize = 8;
int stdinttype = bt_long;
int stdunstype = bt_unsigned;
int stdintsize = 4;
int stdldoublesize = 10;
int stdaddrsize = 4;
int regdsize = 4;
int regasize = 4;
int regfsize = 10;

extern TYP stdchar;
TYP             stdconst = { bt_long, 1, UF_DEFINED, 0, 0, -1, -1, 4, {0, 0}, 0, "stdconst",0};
TYP             stdstring = {bt_pointer, 0, 0,0,0,-1, -1, 4, {0, 0}, &stdchar, 0,0};
TYP             stdint = { bt_long, 0, UF_DEFINED | UF_USED,0, 0,-1, -1, 4, {0, 0}, 0, 0,0 };
TYP							stdlongdouble = {bt_longdouble,0,0,0,0,-1,-1,10,{0,0},0,0,0 };
TYP             stduns = { bt_unsigned, 0, 0,0, 0,-1, -1, 4, {0, 0}, 0, 0,0 };
KEYWORDS prockeywords[] = {
				{0,"_trap", kw__trap}, {0,"_interrupt", kw__interrupt},
				{0,"_abs", kw__abs }, {0,"_genword", kw__genword },
				{0,"_D0",kw_D0},{0,"_D1",kw_D1},{0,"_D2",kw_D2},{0,"_D3",kw_D3},
				{0,"_D4",kw_D4},{0,"_D5",kw_D5},{0,"_D6",kw_D6},{0,"_D7",kw_D7},
				{0,"_A0",kw_A0},{0,"_A1",kw_A1},{0,"_A2",kw_A2},{0,"_A3",kw_A3},
				{0,"_A4",kw_A4},{0,"_A5",kw_A5},{0,"_A6",kw_A6},{0,"_A7",kw_A7},
				{0,"_FP0",kw_F0},{0,"_FP1",kw_F1},{0,"_FP2",kw_F2},{0,"_FP3",kw_F3},
				{0,"_FP4",kw_F4},{0,"_FP5",kw_F5},{0,"_FP6",kw_F6},{0,"_FP7",kw_F7},
        {0, 0, 0} };

int confcodegen(char s, int bool)
{
	switch (s) {
					case 'L':		/* 68000 specific */
						prm_largedata = bool;
						break;
					case '2':   /* 68020 specific */
						prm_68020 = bool;
						break;
					case 'P':
						prm_phiform = bool;
						break;
					default:
						return 0;
	}
	return 1;
}
void confsetup(void)
{
	if (prm_68020)
		prm_largedata = FALSE;
	if (prm_phiform)
		prm_linkreg = FALSE;
	if (prm_phiform || prm_linkreg) {
		linkreg = 6;
		basereg = 5;
		cf_maxaddress=21;
	}
	else {
		basereg=6;
		linkreg = 5;		/* must assign in case of trap call.. otherwise is unused */
		cf_maxaddress=22;
	}
}
static int     alignment(int type, TYP *tp)
{       switch(tp->type) {
                case bt_char: case bt_unsignedchar:  return 1;
                case bt_short: case bt_unsignedshort: return 2;
                case bt_long: case bt_unsigned: return 4;
                case bt_enum:           return 2;
                case bt_pointer:
								case bt_matchall:
                        if(tp->val_flag)
                                return alignment(type,tp->btp);
                        else
                                return 4;
                case bt_float:          return 4;
                case bt_double:         return 4;
								case bt_longdouble:				return 4;
                case bt_struct:
                case bt_union:          return 4;
                default:                return 1;
                }
}
int getalign(int sc, TYP *tp)
{
   int align = alignment(sc,tp);
												if (sc != sc_auto) 
													if (prm_packing) 
														if (!prm_68020)
															align = 1;
														else
															if (align > 2) align = 2;
	return align;
}

long getautoval(long val)
{

	if (prm_linkreg && !currentfunc->intflag)
		return val;
	if (val >= 0) 
		if (prm_phiform || currentfunc->intflag)
			return framedepth+val;
		else
			return val;
	else
		return lc_maxauto + val;
}

int funcvaluesize(int size)
{
		return 4 - size;						
}