#ifndef VLIR_STORAGE_H
#define VLIR_STORAGE_H

/*
	storage.h
	VLIR Library Release 1.0

	Copyright (c) 1997 Falvosoft
	All Rights Reserved.
*/

struct VLIRStorageObject;
typedef struct VLIRStorageObject *HSTORAGE;

typedef struct VLIRStorageInterface {
	int (*ReadBlock)(	HSTORAGE self, unsigned long blk, void *pbuf );

	/*	ReadBlock() is used to read one 512-byte block into memory from the
		storage device or file.  This function returns non-zero on success,
		or zero of failure. */

	int (*WriteBlock)( HSTORAGE self, unsigned long blk, void *pbuf );

	/*	WriteBlock() is used to store one 512-byte block from memory to the
		storage device or file.  This function returns non-zero on success,
		or zero for failure. */

	int (*BlockExists)( HSTORAGE self, unsigned long blk );

	/* BlockExists() is used to spot check whether or not a certain block
		exists or not.  For files, it is often used to extend a VLIR file
		when necessary.  For devices, extension isn't possible; in this case,
		BlockExists() simply checks to see that the supplied block is in the
		range of storage space available. */

	unsigned long (*HighestBlock)( HSTORAGE self );

	/* For files, HighestBlock() is used to return the current size of the
		VLIR file (it does *NOT* consider header blocks, etc -- just raw
		storage space).  For devices, it returns the highest possible block
		that can be addressed on the device.  A value of zero is returned
		if there is some kind of error with the storage medium. */
} VLIRStorageInterface;

typedef struct VLIRStorageObject {
	VLIRStorageInterface *			Interface;
	/* derived-object data goes here. */
} VLIRStorageObject;		/* HSTORAGE is defined above */

/* PROTOTYPES */

int VLIRReadFromStorage( HSTORAGE, unsigned long, void * );
int VLIRWriteToStorage( HSTORAGE, unsigned long, void * );
int VLIRStorageBlockExists( HSTORAGE, unsigned long );
unsigned long VLIRGetHighestBlock( HSTORAGE );

#endif
