#include "storage.h"

/*
	storage.c
	VLIR Library Release 1.0
	
	Copyright (c) 1997 Falvosoft
	All Rights Reserved
*/

int VLIRReadFromStorage( HSTORAGE hstr, unsigned long blk, void *pbuf ) {
	VLIRStorageInterface *pInterface = hstr->Interface;
	if( pInterface -> ReadBlock )
		return pInterface -> ReadBlock( hstr, blk, pbuf );

	return 0;
}

int VLIRWriteToStorage( HSTORAGE hstr, unsigned long blk, void *pbuf ) {
	VLIRStorageInterface *pInterface = hstr -> Interface;
	if( pInterface -> WriteBlock )
		return pInterface -> WriteBlock( hstr, blk, pbuf );

	return 0;
}

int VLIRStorageBlockExists( HSTORAGE hstr, unsigned long blk ) {
	VLIRStorageInterface *pInterface = hstr -> Interface;
	if( pInterface -> BlockExists )
		return pInterface -> BlockExists( hstr, blk );

	return 0;
}

unsigned long VLIRGetHighestBlock( HSTORAGE hstr ) {
	VLIRStorageInterface *pInterface = hstr -> Interface;
	if( pInterface -> HighestBlock )
		return pInterface -> HighestBlock( hstr );

	return 0;
}