
typedef long time_t;
#define NULL 0
#define X_SIZE 11
#define Y_SIZE 11

int grid[12][12] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

int scratch[12][12];

void inits()
{
   int counter1 = 0, counter2 = 0;
   
   for(counter1 = 0; counter1 <= X_SIZE; counter1++)
   {
      for(counter2 = 0; counter2 <= Y_SIZE; counter2++)
      {
         scratch[counter1][counter2] = 0;
      }
   }
}

void showgrid()
{
   int counter1 = 0, counter2 = 0;

   for(counter1 = 1; counter1 <= (X_SIZE - 1); counter1++)
   {
      for(counter2 = 1; counter2 <= (Y_SIZE - 1); counter2++)
      {
         if(grid[counter1][counter2] == 0)
	 {
            printf("__");
         } else
         {
            printf("[]");
	 }
      }
      printf("\n");
   }
}

void dolife()
{
   int counter1 = 0, counter2 = 0, counter3 = 0, counter4 = 0, numNeighbors = 0;

   inits();
   for(counter1 = 1; counter1 <= (X_SIZE - 1); counter1++)
   {
      for(counter2 = 1; counter2 <= (Y_SIZE - 1); counter2++)
      {
         numNeighbors = 0;
         for(counter3 = (counter1 - 1); counter3 <= (counter1 + 1); counter3++)
         {
            for(counter4 = (counter2 - 1); counter4 <= (counter2 + 1); counter4++)
	    {
               numNeighbors = numNeighbors + grid[counter3][counter4];
	    }
         }
         numNeighbors = numNeighbors - grid[counter1][counter2];  
         if((numNeighbors < 2) || (numNeighbors > 3)) /* Lonely or overcrowded... */
         {
	    scratch[counter1][counter2] = 0;
	 } else /* No change */
	 {
            if(numNeighbors == 3) 
	    {
               scratch[counter1][counter2] = 1;
	    } else 
            {
	       scratch[counter1][counter2] = grid[counter1][counter2];
	    }
         }
      }
   }
   for(counter1 = 1; counter1 <= (X_SIZE - 1); counter1++)
   {
      for(counter2 = 1; counter2 <= (Y_SIZE - 1); counter2++)
      {
         grid[counter1][counter2] = scratch[counter1][counter2];
      }
   }
}

int main()
{
   int counter;
   time_t x = time(NULL);
   time_t y;

   for(counter = 1; counter <= 100000; counter++)
   {
      dolife();
   }
   y = time(NULL);
   printf("The final grid is:\n");
   showgrid();
   printf("The elapsed time is %f.\n", difftime(y, x));

}