/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * v1.5 August 1996
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
/*
 *      code generation structures and constants
 */

/* address mode specifications */
#define F_DREG  1       /* data register direct mode allowed */
#define F_AREG  2       /* address register direct mode allowed */
#define F_MEM   4       /* memory alterable modes allowed */
#define F_IMMED 8       /* immediate mode allowed */
#define F_ALT   7       /* alterable modes */
#define F_DALT  5       /* data alterable modes */
#define F_FREG  16  	/* FP register */
#define F_INDX  32	/* indexed memory alterable mode allowed */
#define F_ALL   31      /* all modes allowed */
#define F_VOL   64      /* need volitile operand */
#define F_NOVALUE 128    /* dont need result value */
#define F_NOBIT 256	/* Don't get the bit val, get the address */

/*      addressing mode structure       */

struct amode {
        char            mode;
        char            preg;
        char            sreg;
        char            tempflag;
        struct enode    *offset;
        };

/*      output code structure   */

struct ocode {
        struct ocode    *fwd, *back;
        short           opcode;
        short           length;
        struct amode    *oper1, *oper2,*oper3;
	int addr;
	int size;
	char diag;
        };

/* Used for fixup gen */
typedef struct dl {
		struct dl *next;
		char *string;
		int offset;
		short type;
} DATALINK;

#define AMODE struct amode
#define OCODE struct ocode

enum e_op {
        op_line, op_seq, op_genword, op_move, op_moveq, op_add, op_addi, op_addq, op_sub, op_subi,
        op_subq, op_muls, op_mulu, op_divs, op_divu, op_and, op_andi,
        op_or, op_ori, op_eor, op_asl, op_asr, op_jmp, op_jsr, op_movem,
        op_rts, op_rte, op_bra, op_beq, op_bne, op_blt, op_ble, op_bgt, op_bge,
        op_bhi, op_bhs, op_blo, op_bls, op_tst, op_ext, op_lea, op_swap,
        op_neg, op_not, op_cmp, op_clr, op_link, op_unlk, op_label,
        op_pea, op_cmpi, op_dcl, op_dcr, op_bsr, op_divsl, op_divul, op_exg,
	op_trap, op_lsl, op_lsr, op_bset,op_bclr,op_btst,
	op_bfins, op_bfextu, op_bfexts, op_bfclr, op_bftst,
	op_fmove, op_fmovem, op_fadd, op_fsub, op_fmul, op_fdiv, op_fmod,
	op_fcmp, op_ftst, op_fneg, op_fbeq, op_fbne, op_fbgt, op_fbge,op_fblt,op_fble
};

enum e_am {
        am_dreg, am_areg, am_freg, am_ind, am_ainc, am_adec, am_indx, am_indx2,
        am_xpc, am_direct, am_immed, am_mask, am_fmask, am_none, am_indx3, am_pcindx,
	am_divsl, am_bf, am_sr };

#include "cc68.p"