/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * v1.5 August 1996
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
/*
 *      code generation structures and constants
 */

/* address mode specifications */
#define F_DREG  1       /* data register direct mode allowed */
#define F_AREG  2       /* address register direct mode allowed */
#define F_MEM   4       /* memory alterable modes allowed */
#define F_IMMED 8       /* immediate mode allowed */
#define F_ALT   7       /* alterable modes */
#define F_DALT  5       /* data alterable modes */
#define F_FREG  16  	/* FP register */
#define F_INDX  32	/* indexed memory alterable mode allowed */
#define F_ALL   31      /* all modes allowed */
#define F_VOL   64      /* need volitile operand */
#define F_NOVALUE 128    /* dont need result value */
#define F_NOBIT 256	/* Don't get the bit val, get the address */

/*      addressing mode structure       */

struct amode {
        char            mode;
        char            preg;
        char            sreg;
        char            tempflag;
	char		scale;
        struct enode    *offset;
        };

/*      output code structure   */

struct ocode {
        struct ocode    *fwd, *back;
        short           opcode;
        short           length;
	char		length2;
        struct amode    *oper1, *oper2,*oper3;
	int addr;
	int size;
	char diag;
        };

/* Used for fixup gen */
typedef struct dl {
		struct dl *next;
		char *string;
		int offset;
		short type;
} DATALINK;

#define AMODE struct amode
#define OCODE struct ocode

#define FLOAT printf("codegen-Floating point not implemented in push/pop\n");
/* 386 register set */
#define EAX 0
#define ECX 1
#define EDX 2
#define EBX 3
#define ESP 4
#define EBP 5
#define ESI 6
#define EDI 7
#define AL 0
#define CL 1
#define DL 2
#define BL 3
#define ES 0
#define CS 1
#define SS 2
#define DS 3

enum e_op { op_line, op_label, op_seq,op_genword,
	op_add, op_and, op_call, op_cld, op_cmp, op_cmpsb, op_cmpsw, op_cmpsd,
	op_cwd, op_cbw, op_cbd, op_dec,
	op_div, op_idiv, op_imul, op_inc, op_jb, op_jbe,op_je, op_jl,
	op_jle, op_jnc, op_ja, op_jne, op_jge, op_jg, op_jmp, op_lea, op_lodsb,
	op_lodsw, op_lodsd, op_enter, op_leave,
	op_mov, op_movsb, op_movsw, op_movsd, op_movsx, op_movzx, op_mul, 
	op_neg, op_not, op_or, op_pop, op_push, op_rep, op_repnz, op_repz, 
	op_ret, op_sahf, op_sal, op_sar, op_scasb, op_scasw, op_scasd,
	op_shr, op_shl, op_std, op_stosb, op_stosw, op_stosd, op_sub,
	op_test, op_xchg, op_xor, op_dd, op_pushfd, op_iretd, op_pushad, op_popad,
	op_fadd, op_fiadd, op_fchs, op_fcom, op_fcomp, op_fcompp,
	op_fdiv, op_fidiv, op_ficom, op_ficomp, op_fild, op_fist, op_fistp,
	op_fld, op_fldz, op_fmul, op_fimul, op_fprem, op_fscale, op_fst, op_fstp,
	op_fstcw, op_fstsw, op_fsub, op_fisub, op_ftst, op_fxch, op_fwait
	};
enum e_am {
        am_dreg, am_freg, am_indisp, am_indispscale,
        am_direct, am_immed, am_none, am_cs };

#include "cc386.p"