/*  stdio.h

    Definitions for stream input/output.

*/

#ifndef __STDIO_H
#define __STDIO_H

#ifndef NULL
#define NULL 0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

typedef long    fpos_t;

#define FILTOK	0x444c
#define STACKPAD 512

/*  "flags" bits definitions
*/
#define _F_RDWR 0x0003                  /* Read/write flag       */
#define _F_READ 0x0001                  /* Read only file        */
#define _F_WRIT 0x0002                  /* Write only file       */
#define _F_BUF  0x0004                  /* Malloc'ed Buffer data */
#define _F_LBUF 0x0008                  /* line-buffered file    */
#define _F_ERR  0x0010                  /* Error indicator       */
#define _F_EOF  0x0020                  /* End of file indicator */
#define _F_BIN  0x0040                  /* Binary file indicator */
#define _F_IN   0x0080                  /* Data is incoming      */
#define _F_OUT  0x0100                  /* Data is outgoing      */
#define _F_TERM 0x0200                  /* File is a terminal    */

/* End-of-file constant definition
*/
#define EOF (-1)            /* End of file indicator */

/* Default buffer size use by "setbuf" function
*/
#define BUFSIZ  512         /* Buffer size for stdio */

/* Size of an arry large enough to hold a temporary file name string
*/
#define L_ctermid   5       /* CON: plus null byte */
#define P_tmpdir    ""      /* temporary directory */
#define L_tmpnam    13      /* tmpnam buffer size */

/* Constants to be used as 3rd argument for "fseek" function
*/
#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0

/* Number of unique file names that shall be generated by "tmpnam" function
*/
#define TMP_MAX     0xFFFF

#define _NFILE_ 20
/* Definition of the control structure for streams
*/
typedef struct  {
        int             level;          /* fill/empty level of buffer */
        unsigned        flags;          /* File status flags          */
        char            fd;             /* File descriptor            */
        unsigned char   hold;           /* Ungetc char if no buffer   */
        int             bsize;          /* Buffer size                */
        unsigned char   *buffer;   /* Data transfer buffer       */
        unsigned char   *curp;     /* Current active pointer     */
        unsigned        istemp;         /* Temporary file indicator   */
        short           token;          /* Used for validity checking */
}       FILE;                           /* This is the FILE object    */

/* Number of files that can be open simultaneously
*/
#define FOPEN_MAX (_NFILE_ - 2) /* (_NFILE_ - stdaux & stdprn) */

#define FILENAME_MAX 80

/* Standard I/O predefined streams
*/

extern  FILE     *_pstreams[];  /* Oops! Something ain't right! */
extern  unsigned     _nfile;

#define _IOFBF  1
#define _IOLBF  2
#define _IONBF  4

#define stdin   (_pstreams[0])
#define stdout  (_pstreams[1])
#define stderr  (_pstreams[2])
#define stdaux  (_pstreams[3])
#define stdprn  (_pstreams[4])

void              clearerr(FILE *__stream);
int       fclose(FILE *__stream);
int       fflush(FILE *__stream);
int       fgetc(FILE *__stream);
int               fgetpos(FILE *__stream, fpos_t *__pos);
char   *  fgets(char *__s, int __n, FILE *__stream);
FILE   *  fopen(const char *__path, const char *__mode);
int       fprintf(FILE *__stream, const char *__format, ...);
int       fputc(int __c, FILE *__stream);
int       fputs(const char *__s, FILE *__stream);
size_t    fread(void *__ptr, size_t __size, size_t __n,
                     FILE *__stream);
FILE   *  freopen(const char *__path, const char *__mode,
                            FILE *__stream);
int       fscanf(FILE *__stream, const char *__format, ...);
int       fseek(FILE *__stream, long __offset, int __whence);
int               fsetpos(FILE *__stream, const fpos_t *__pos);
long      ftell(FILE *__stream);
size_t    fwrite(const void *__ptr, size_t __size, size_t __n,
                      FILE *__stream);
char   *     gets(char *__s);
void              perror(const char *__s);
int               printf(const char *__format, ...);
int               puts(const char *__s);
int              remove(const char *__path);
int       rename(const char *__oldname,const char *__newname);
void      rewind(FILE *__stream);
int               scanf(const char *__format, ...);
void              setbuf(FILE *__stream, char *__buf);
int       setvbuf(FILE *__stream, char *__buf,
                                   int __type, size_t __size);
int       sprintf(char *__buffer, const char *__format, ...);
int       sscanf(const char *__buffer,
                                  const char *__format, ...);
char   *  strerror(int __errnum);
FILE   *  tmpfile(void);
char   *  tmpnam(char *__s);
int       ungetc(int __c, FILE *__stream);
int       vfprintf(FILE *__stream, const char *__format,
                                    void *__arglist);
int       vfscanf(FILE *__stream, const char *__format,
                                   void *__arglist);
int              vprintf(const char *__format, void *__arglist);
int               vscanf(const char *__format, void *__arglist);
int       vsprintf(char *__buffer, const char *__format,
                                    void *__arglist);
int       vsscanf(const char *__buffer, const char *__format,
                                   void *__arglist);
int              unlink(const char *__path);
int               getc(FILE *__fp);

int               getchar(void);
int               putchar(const int __c);

int               putc(const int __c, FILE *__fp);
int               feof(FILE *__fp);
int               ferror(FILE *__fp);

int       fcloseall(void);
FILE    *  fdopen(int __handle, char *__type);
int       fgetchar(void);
int       flushall(void);
int       fputchar(int __c);
FILE    *    _fsopen (const char *__path, const char *__mode,
                  int __shflag);
int               getw(FILE *__stream);
int               putw(int __w, FILE *__stream);
int               rmtmp(void);
char    *   _strerror(const char *__s);
char    *   tempnam(char *__dir, char *__pfx);

#define fileno(f)       ((f)->fd)

int        _fgetc(FILE *__stream);           /* used by getc() macro */
int        _fputc(char __c, FILE *__stream); /* used by putc() macro */
void      _InitEasyWin(void);  /* Initialization call for Easy Windows */

/*  The following macros provide for common functions */

#define ferror(f)   ((f)->flags & _F_ERR)
#define feof(f)     ((f)->flags & _F_EOF)

/* These two macros donn't work yet... I have to rewrite the 
 * low level I/O to handle the CR/LF thing.  Meanwhile they are written
 * as functions	
#define getc(f) \
  ((--((f)->level) >= 0) ? (unsigned char)(*(f)->curp++) : \
    _fgetc (f))

#define putc(c,f) \
  ((++((f)->level) < 0) ? (unsigned char)(*(f)->curp++=(c)) : \
    _fputc ((c),f))
*/
#define getchar()  getc(stdin)
#define putchar(c) putc((c), stdout)

#define ungetc(c,f) ungetc((c),f)   /* traditionally a macro */


#endif  /* __STDIO_H */