#include <stdio.h>
#include <time.h>
#include <libp.h>

int _baseputc(int c, FILE *stream)
{
	unsigned char rv = (unsigned char) c;
	if (stream->bsize) {
		if (_writebuf(stream)) {
			stream->flags |= _F_ERR;
			return EOF;
		}
		stream->flags |= _F_OUT;
		*stream->curp++ = (char)c;
		stream->level++;
		if (c == '\n' && (stream->flags & _F_LBUF))
			fflush(stream);
		return c;
	}
	else {
		if (_ll_write(stream->fd,&rv,1)) {
			stream->flags |= _F_ERR;
			return EOF;
		}
	}
	return c;
}
int fputc(int c, FILE *stream)
{
	if (stream->token != FILTOK)
		return EOF;
	if (!(stream->flags & _F_WRIT)) {
		stream->flags |= _F_ERR;
		return EOF;
	}
	if (!(stream->flags & _F_BIN) && c == '\n') {
		if (_baseputc('\r',stream) == EOF)
			return EOF;
		return _baseputc('\n',stream);
	}
	return _baseputc(c,stream);
}
#undef putc
#undef putchar
int putc(int c, FILE *stream)
{
	return fputc(c,stream);
}
int putchar(int c)
{
	return fputc(c,stdout);
}