#include <stdio.h>
#include <time.h>
#include <libp.h>

int _basegetc(FILE *stream)
{
	unsigned char rv;
	if (stream->bsize) {
		if (_readbuf(stream))
			return EOF;
		stream->level--;
		return(*stream->curp++);
	}
	else if (stream->hold) {
		rv = stream->hold;
		stream->hold = 0;
	}
	else {
		if (!_ll_read(stream->fd,&rv,1)) {
			stream->flags |= _F_EOF;
			return EOF;
		}
	}
	return(rv);
}
int fgetc(FILE *stream)
{
	int rv;
	if (stream->token != FILTOK)
		return EOF;
	if (!(stream->flags & _F_READ)) {
		stream->flags |= _F_ERR;
		return EOF;
	}
	rv = _basegetc(stream);
	if (!(stream->flags & _F_BIN) && rv == '\r')
		return _basegetc(stream);
	return rv;
}
#undef getc
#undef getchar
int getc(FILE *stream)
{
	return fgetc(stream);
}
int getchar(void)
{
	return fgetc(stdin);
}
		







